/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.access.binary.asm.AbstractBinarySignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeParameter;
import org.eclipse.xtext.common.types.access.binary.asm.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMethodSignature
extends AbstractBinarySignature {
    BinaryMethodSignature(String signature) {
        super(signature);
    }

    public BinaryGenericTypeSignature getReturnType() {
        int paren = this.chars.lastIndexOf(41);
        if (paren == -1) {
            throw new IllegalArgumentException();
        }
        int last = SignatureUtil.scanTypeSignature(this.chars, paren + 1);
        return new BinaryGenericTypeSignature(this.chars, paren + 1, last - paren);
    }

    public List<BinaryGenericTypeSignature> getExceptionTypes() {
        int exceptionStart = this.chars.indexOf(94, this.offset);
        if (exceptionStart == -1) {
            int length;
            int paren = this.chars.lastIndexOf(41);
            if (paren == -1) {
                throw new IllegalArgumentException();
            }
            exceptionStart = SignatureUtil.scanTypeSignature(this.chars, paren + 1) + 1;
            if (exceptionStart == (length = this.offset + this.length)) {
                return Collections.emptyList();
            }
        }
        int length = this.offset + this.length;
        int i = exceptionStart;
        ArrayList<BinaryGenericTypeSignature> result = Lists.newArrayListWithCapacity(2);
        while (i < length) {
            if (this.chars.charAt(i) == '^') {
                ++i;
            } else {
                throw new IllegalArgumentException();
            }
            i = SignatureUtil.scanTypeSignature(this.chars, i) + 1;
            result.add(new BinaryGenericTypeSignature(this.chars, ++exceptionStart, i - exceptionStart));
            exceptionStart = i;
        }
        return result;
    }

    public List<BinaryGenericTypeSignature> getParameterTypes() {
        try {
            int i = this.chars.indexOf(40, this.offset);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            if (this.chars.charAt(++i) == ')') {
                return Collections.emptyList();
            }
            ArrayList<BinaryGenericTypeSignature> result = Lists.newArrayListWithExpectedSize(3);
            while (true) {
                if (this.chars.charAt(i) == ')') {
                    return result;
                }
                int e = SignatureUtil.scanTypeSignature(this.chars, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                result.add(new BinaryGenericTypeSignature(this.chars, i, e - i + 1));
                i = e + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public List<BinaryTypeParameter> getTypeParameters() {
        return this.doGetTypeParameters();
    }
}

