/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.builder.builderState.BuilderStateFactory;
import org.eclipse.xtext.builder.builderState.impl.EObjectDescriptionImpl;
import org.eclipse.xtext.builder.builderState.impl.ReferenceDescriptionImpl;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;

public class BuilderStateUtil {
    public static ResourceDescriptionImpl create(IResourceDescription desc) {
        if (desc instanceof ResourceDescriptionImpl) {
            return (ResourceDescriptionImpl)desc;
        }
        ResourceDescriptionImpl result = (ResourceDescriptionImpl)BuilderStateFactory.eINSTANCE.createResourceDescription();
        result.setURI(desc.getURI());
        BuilderStateUtil.copyExportedObject(desc, result);
        BuilderStateUtil.copyReferenceDescriptions(desc, result);
        BuilderStateUtil.copyImportedNames(desc, result);
        return result;
    }

    public static void copyImportedNames(IResourceDescription from, ResourceDescriptionImpl result) {
        Iterable<QualifiedName> importedNames = from.getImportedNames();
        if (importedNames instanceof Collection) {
            Collection sourceImportedNames = (Collection)importedNames;
            if (!sourceImportedNames.isEmpty()) {
                InternalEList targetImportedNames = (InternalEList)result.getImportedNames();
                targetImportedNames.addAllUnique(sourceImportedNames);
            }
        } else {
            Iterator<QualifiedName> importedNamesIterator = importedNames.iterator();
            if (importedNamesIterator.hasNext()) {
                InternalEList targetImportedNames = (InternalEList)result.getImportedNames();
                do {
                    targetImportedNames.addUnique(importedNamesIterator.next());
                } while (importedNamesIterator.hasNext());
            }
        }
    }

    public static void copyReferenceDescriptions(IResourceDescription from, ResourceDescriptionImpl result) {
        Iterator<IReferenceDescription> sourceReferenceDescriptions = from.getReferenceDescriptions().iterator();
        if (sourceReferenceDescriptions.hasNext()) {
            InternalEList targetReferenceDescriptions = (InternalEList)result.getReferenceDescriptions();
            do {
                targetReferenceDescriptions.addUnique(BuilderStateUtil.create(sourceReferenceDescriptions.next()));
            } while (sourceReferenceDescriptions.hasNext());
        }
    }

    public static void copyExportedObject(IResourceDescription from, ResourceDescriptionImpl result) {
        Iterator<IEObjectDescription> sourceExportedObjects = from.getExportedObjects().iterator();
        if (sourceExportedObjects.hasNext()) {
            InternalEList targetExportedObjects = (InternalEList)result.getExportedObjects();
            do {
                targetExportedObjects.addUnique(BuilderStateUtil.create(sourceExportedObjects.next()));
            } while (sourceExportedObjects.hasNext());
        }
    }

    public static ReferenceDescriptionImpl create(IReferenceDescription desc) {
        ReferenceDescriptionImpl description = (ReferenceDescriptionImpl)BuilderStateFactory.eINSTANCE.createReferenceDescription();
        description.setIndexInList(desc.getIndexInList());
        description.setSourceEObjectUri(desc.getSourceEObjectUri());
        description.setTargetEObjectUri(desc.getTargetEObjectUri());
        description.setReference(desc.getEReference());
        description.setContainerEObjectURI(desc.getContainerEObjectURI());
        return description;
    }

    public static EObjectDescriptionImpl create(IEObjectDescription desc) {
        EObjectDescriptionImpl objectDescription = (EObjectDescriptionImpl)BuilderStateFactory.eINSTANCE.createEObjectDescription();
        objectDescription.setEClass(desc.getEClass());
        objectDescription.setFragment(desc.getEObjectURI().fragment());
        objectDescription.setName(desc.getName());
        String[] stringArray = desc.getUserDataKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            objectDescription.getUserData().put(key, desc.getUserData(key));
            ++n2;
        }
        return objectDescription;
    }
}

