/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.KeyAssistDialog;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.keys.KeyAssistMessages;

public class GlobalKeyAssistDialog
extends KeyAssistDialog {
    private IEclipseContext context;
    private final String keysPageId = "org.eclipse.ui.preferencePages.Keys";
    private boolean isOpen;

    public GlobalKeyAssistDialog(IEclipseContext context, KeyBindingDispatcher associatedKeyboard) {
        super(context, associatedKeyboard);
        this.context = context;
        this.setInfoText(this.getInfoText());
    }

    public int open() {
        if (this.isOpen) {
            return this.openPreferencePage();
        }
        this.isOpen = true;
        return super.open();
    }

    public boolean close() {
        this.isOpen = false;
        return super.close();
    }

    private String getInfoText() {
        EBindingService bindingService;
        TriggerSequence keySeq;
        ECommandService commandService = (ECommandService)this.context.getActiveLeaf().get(ECommandService.class);
        Command cmd = commandService.getCommand("org.eclipse.ui.window.showKeyAssist");
        if (cmd != null && (keySeq = (bindingService = (EBindingService)this.context.getActiveLeaf().get(EBindingService.class)).getBestSequenceFor(new ParameterizedCommand(cmd, null))) != null) {
            return NLS.bind(KeyAssistMessages.openPreferencePage, keySeq.format());
        }
        return "";
    }

    private int openPreferencePage() {
        Shell shell = this.getShell();
        if (shell.getParent() != null) {
            shell = shell.getParent().getShell();
        }
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(shell, "org.eclipse.ui.preferencePages.Keys", null, this.getSelectedBinding());
        this.close();
        return dialog.open();
    }
}

