/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.connector;

import io.tesla.aether.connector.AetherRepositoryConnector;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.SSLSocketFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.sisu.Nullable;

@Named
@Component(role=RepositoryConnectorFactory.class, hint="okhttp")
public final class AetherRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    private FileProcessor fileProcessor;
    private SSLSocketFactory sslSocketFactory;

    @Inject
    public AetherRepositoryConnectorFactory(FileProcessor fileProcessor, @Nullable SSLSocketFactory sslSocketFactory) {
        this.fileProcessor = fileProcessor;
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public float getPriority() {
        return Float.MAX_VALUE;
    }

    @Override
    public RepositoryConnector newInstance(RepositorySystemSession repositorySystemSession, RemoteRepository remoteRepository) throws NoRepositoryConnectorException {
        if (this.sslSocketFactory != null) {
            return new AetherRepositoryConnector(remoteRepository, repositorySystemSession, this.fileProcessor, this.sslSocketFactory);
        }
        return new AetherRepositoryConnector(remoteRepository, repositorySystemSession, this.fileProcessor);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
    }

    public void setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = fileProcessor;
    }
}

