/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.python;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.python.ProtectedAreaHL;
import fr.esrf.tango.pogo.generator.python.PyUtils;
import fr.esrf.tango.pogo.generator.python.PythonTypeDefinitions;
import fr.esrf.tango.pogo.generator.python.PythonUtils;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.Type;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class PythonHlProjectUtils {
    @Inject
    @Extension
    private StringUtils _stringUtils;
    @Inject
    @Extension
    private ProtectedAreaHL _protectedAreaHL;
    @Inject
    @Extension
    private PythonTypeDefinitions _pythonTypeDefinitions;
    @Inject
    @Extension
    private PyUtils _pyUtils;
    @Inject
    @Extension
    private PythonUtils _pythonUtils;

    public CharSequence generatePythonHlProjectReadme(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("## ");
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        _builder.append((Object)_title, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        ClassDescription _description_1 = cls.getDescription();
        String _description_2 = _description_1.getDescription();
        _builder.append((Object)_description_2, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("## Requirement");
        _builder.newLine();
        _builder.newLine();
        _builder.append("- PyTango >= 8.1.6");
        _builder.newLine();
        _builder.append("- devicetest (for using tests)");
        _builder.newLine();
        _builder.append("- sphinx (for building sphinx documentation)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("## Installation");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Run python setup.py install");
        _builder.newLine();
        _builder.newLine();
        _builder.append("If you want to build sphinx documentation,");
        _builder.newLine();
        _builder.append("run python setup.py build_sphinx");
        _builder.newLine();
        _builder.newLine();
        _builder.append("If you want to pass the tests, ");
        _builder.newLine();
        _builder.append("run python setup.py test");
        _builder.newLine();
        _builder.newLine();
        _builder.append("## Usage");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Now you can start your device server in any");
        _builder.newLine();
        _builder.append("Terminal or console by calling it :");
        _builder.newLine();
        _builder.newLine();
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" instance_name");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generatePythonHlProjectRelease(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\"\"\"Release information for Python Package\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("name = \"\"\"tangods-");
        String _name_1 = cls.getName();
        String _lowerCase = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append("\"\"\"");
        _builder.newLineIfNotEmpty();
        _builder.append("version = \"1.0.0\"");
        _builder.newLine();
        _builder.append("version_info = version.split(\".\")");
        _builder.newLine();
        _builder.append("description = \"\"\"");
        ClassDescription _description_3 = cls.getDescription();
        String _description_4 = _description_3.getDescription();
        _builder.append((Object)_description_4, "");
        _builder.append("\"\"\"");
        _builder.newLineIfNotEmpty();
        _builder.append("author = \"");
        ClassDescription _description_5 = cls.getDescription();
        ClassIdentification _identification = _description_5.getIdentification();
        String _author = _identification.getAuthor();
        _builder.append((Object)_author, "");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("author_email = \"");
        ClassDescription _description_6 = cls.getDescription();
        ClassIdentification _identification_1 = _description_6.getIdentification();
        String _author_1 = _identification_1.getAuthor();
        _builder.append((Object)_author_1, "");
        _builder.append(" at ");
        ClassDescription _description_7 = cls.getDescription();
        ClassIdentification _identification_2 = _description_7.getIdentification();
        String _emailDomain = _identification_2.getEmailDomain();
        _builder.append((Object)_emailDomain, "");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("license = \"\"\"");
        ClassDescription _description_8 = cls.getDescription();
        String _license_1 = _description_8.getLicense();
        _builder.append((Object)_license_1, "");
        _builder.append("\"\"\"");
        _builder.newLineIfNotEmpty();
        _builder.append("url = \"\"\"www.tango-controls.org\"\"\"");
        _builder.newLine();
        _builder.append("copyright = \"\"\"");
        ClassDescription _description_9 = cls.getDescription();
        String _copyright_2 = _description_9.getCopyright();
        String _commentMultiLinesPythonStr_1 = this._pythonUtils.commentMultiLinesPythonStr(_copyright_2);
        _builder.append((Object)_commentMultiLinesPythonStr_1, "");
        _builder.append("\"\"\"");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generatePythonHlProjectInit(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\"\"\"");
        ClassDescription _description_3 = cls.getDescription();
        String _title = _description_3.getTitle();
        _builder.append((Object)_title, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        ClassDescription _description_4 = cls.getDescription();
        String _description_5 = _description_4.getDescription();
        _builder.append((Object)_description_5, "");
        _builder.newLineIfNotEmpty();
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("from . import release");
        _builder.newLine();
        _builder.append("from .");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(" import ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append(", main");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("__version__ = release.version");
        _builder.newLine();
        _builder.append("__version_info__ = release.version_info");
        _builder.newLine();
        _builder.append("__author__ = release.author");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectScript(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/usr/bin/env python");
        _builder.newLine();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("try:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("from ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append(" import main");
        _builder.newLineIfNotEmpty();
        _builder.append("except ImportError:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("import os, sys");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("__this_dir = os.path.dirname(os.path.abspath(__file__))");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("__package_dir = os.path.join(__this_dir, os.path.pardir)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("sys.path.append(__package_dir)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("from ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "    ");
        _builder.append(" import main");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("if __name__ == \"__main__\":");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("main()");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectLicenseGPL(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("                    ");
        _builder.append("GNU GENERAL PUBLIC LICENSE");
        _builder.newLine();
        _builder.append("                       ");
        _builder.append("Version 2, June 1991");
        _builder.newLine();
        _builder.newLine();
        _builder.append(" ");
        _builder.append("Copyright (C) 1989, 1991 Free Software Foundation, Inc.,");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("Everyone is permitted to copy and distribute verbatim copies");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("of this license document, but changing it is not allowed.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("Preamble");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("The licenses for most software are designed to take away your");
        _builder.newLine();
        _builder.append("freedom to share and change it.  By contrast, the GNU General Public");
        _builder.newLine();
        _builder.append("License is intended to guarantee your freedom to share and change free");
        _builder.newLine();
        _builder.append("software--to make sure the software is free for all its users.  This");
        _builder.newLine();
        _builder.append("General Public License applies to most of the Free Software");
        _builder.newLine();
        _builder.append("Foundation's software and to any other program whose authors commit to");
        _builder.newLine();
        _builder.append("using it.  (Some other Free Software Foundation software is covered by");
        _builder.newLine();
        _builder.append("the GNU Lesser General Public License instead.)  You can apply it to");
        _builder.newLine();
        _builder.append("your programs, too.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("When we speak of free software, we are referring to freedom, not");
        _builder.newLine();
        _builder.append("price.  Our General Public Licenses are designed to make sure that you");
        _builder.newLine();
        _builder.append("have the freedom to distribute copies of free software (and charge for");
        _builder.newLine();
        _builder.append("this service if you wish), that you receive source code or can get it");
        _builder.newLine();
        _builder.append("if you want it, that you can change the software or use pieces of it");
        _builder.newLine();
        _builder.append("in new free programs; and that you know you can do these things.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("To protect your rights, we need to make restrictions that forbid");
        _builder.newLine();
        _builder.append("anyone to deny you these rights or to ask you to surrender the rights.");
        _builder.newLine();
        _builder.append("These restrictions translate to certain responsibilities for you if you");
        _builder.newLine();
        _builder.append("distribute copies of the software, or if you modify it.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("For example, if you distribute copies of such a program, whether");
        _builder.newLine();
        _builder.append("gratis or for a fee, you must give the recipients all the rights that");
        _builder.newLine();
        _builder.append("you have.  You must make sure that they, too, receive or can get the");
        _builder.newLine();
        _builder.append("source code.  And you must show them these terms so they know their");
        _builder.newLine();
        _builder.append("rights.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("We protect your rights with two steps: (1) copyright the software, and");
        _builder.newLine();
        _builder.append("(2) offer you this license which gives you legal permission to copy,");
        _builder.newLine();
        _builder.append("distribute and/or modify the software.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("Also, for each author's protection and ours, we want to make certain");
        _builder.newLine();
        _builder.append("that everyone understands that there is no warranty for this free");
        _builder.newLine();
        _builder.append("software.  If the software is modified by someone else and passed on, we");
        _builder.newLine();
        _builder.append("want its recipients to know that what they have is not the original, so");
        _builder.newLine();
        _builder.append("that any problems introduced by others will not reflect on the original");
        _builder.newLine();
        _builder.append("authors' reputations.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("Finally, any free program is threatened constantly by software");
        _builder.newLine();
        _builder.append("patents.  We wish to avoid the danger that redistributors of a free");
        _builder.newLine();
        _builder.append("program will individually obtain patent licenses, in effect making the");
        _builder.newLine();
        _builder.append("program proprietary.  To prevent this, we have made it clear that any");
        _builder.newLine();
        _builder.append("patent must be licensed for everyone's free use or not licensed at all.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("The precise terms and conditions for copying, distribution and");
        _builder.newLine();
        _builder.append("modification follow.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("GNU GENERAL PUBLIC LICENSE");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("0. This License applies to any program or other work which contains");
        _builder.newLine();
        _builder.append("a notice placed by the copyright holder saying it may be distributed");
        _builder.newLine();
        _builder.append("under the terms of this General Public License.  The \"Program\", below,");
        _builder.newLine();
        _builder.append("refers to any such program or work, and a \"work based on the Program\"");
        _builder.newLine();
        _builder.append("means either the Program or any derivative work under copyright law:");
        _builder.newLine();
        _builder.append("that is to say, a work containing the Program or a portion of it,");
        _builder.newLine();
        _builder.append("either verbatim or with modifications and/or translated into another");
        _builder.newLine();
        _builder.append("language.  (Hereinafter, translation is included without limitation in");
        _builder.newLine();
        _builder.append("the term \"modification\".)  Each licensee is addressed as \"you\".");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Activities other than copying, distribution and modification are not");
        _builder.newLine();
        _builder.append("covered by this License; they are outside its scope.  The act of");
        _builder.newLine();
        _builder.append("running the Program is not restricted, and the output from the Program");
        _builder.newLine();
        _builder.append("is covered only if its contents constitute a work based on the");
        _builder.newLine();
        _builder.append("Program (independent of having been made by running the Program).");
        _builder.newLine();
        _builder.append("Whether that is true depends on what the Program does.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("1. You may copy and distribute verbatim copies of the Program's");
        _builder.newLine();
        _builder.append("source code as you receive it, in any medium, provided that you");
        _builder.newLine();
        _builder.append("conspicuously and appropriately publish on each copy an appropriate");
        _builder.newLine();
        _builder.append("copyright notice and disclaimer of warranty; keep intact all the");
        _builder.newLine();
        _builder.append("notices that refer to this License and to the absence of any warranty;");
        _builder.newLine();
        _builder.append("and give any other recipients of the Program a copy of this License");
        _builder.newLine();
        _builder.append("along with the Program.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("You may charge a fee for the physical act of transferring a copy, and");
        _builder.newLine();
        _builder.append("you may at your option offer warranty protection in exchange for a fee.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("2. You may modify your copy or copies of the Program or any portion");
        _builder.newLine();
        _builder.append("of it, thus forming a work based on the Program, and copy and");
        _builder.newLine();
        _builder.append("distribute such modifications or work under the terms of Section 1");
        _builder.newLine();
        _builder.append("above, provided that you also meet all of these conditions:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("a) You must cause the modified files to carry prominent notices");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("stating that you changed the files and the date of any change.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("b) You must cause any work that you distribute or publish, that in");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("whole or in part contains or is derived from the Program or any");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("part thereof, to be licensed as a whole at no charge to all third");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("parties under the terms of this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("c) If the modified program normally reads commands interactively");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("when run, you must cause it, when started running for such");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("interactive use in the most ordinary way, to print or display an");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("announcement including an appropriate copyright notice and a");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("notice that there is no warranty (or else, saying that you provide");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("a warranty) and that users may redistribute the program under");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("these conditions, and telling the user how to view a copy of this");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("License.  (Exception: if the Program itself is interactive but");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("does not normally print such an announcement, your work based on");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("the Program is not required to print an announcement.)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("These requirements apply to the modified work as a whole.  If");
        _builder.newLine();
        _builder.append("identifiable sections of that work are not derived from the Program,");
        _builder.newLine();
        _builder.append("and can be reasonably considered independent and separate works in");
        _builder.newLine();
        _builder.append("themselves, then this License, and its terms, do not apply to those");
        _builder.newLine();
        _builder.append("sections when you distribute them as separate works.  But when you");
        _builder.newLine();
        _builder.append("distribute the same sections as part of a whole which is a work based");
        _builder.newLine();
        _builder.append("on the Program, the distribution of the whole must be on the terms of");
        _builder.newLine();
        _builder.append("this License, whose permissions for other licensees extend to the");
        _builder.newLine();
        _builder.append("entire whole, and thus to each and every part regardless of who wrote it.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Thus, it is not the intent of this section to claim rights or contest");
        _builder.newLine();
        _builder.append("your rights to work written entirely by you; rather, the intent is to");
        _builder.newLine();
        _builder.append("exercise the right to control the distribution of derivative or");
        _builder.newLine();
        _builder.append("collective works based on the Program.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("In addition, mere aggregation of another work not based on the Program");
        _builder.newLine();
        _builder.append("with the Program (or with a work based on the Program) on a volume of");
        _builder.newLine();
        _builder.append("a storage or distribution medium does not bring the other work under");
        _builder.newLine();
        _builder.append("the scope of this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("3. You may copy and distribute the Program (or a work based on it,");
        _builder.newLine();
        _builder.append("under Section 2) in object code or executable form under the terms of");
        _builder.newLine();
        _builder.append("Sections 1 and 2 above provided that you also do one of the following:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("a) Accompany it with the complete corresponding machine-readable");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("source code, which must be distributed under the terms of Sections");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("1 and 2 above on a medium customarily used for software interchange; or,");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("b) Accompany it with a written offer, valid for at least three");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("years, to give any third party, for a charge no more than your");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("cost of physically performing source distribution, a complete");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("machine-readable copy of the corresponding source code, to be");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("distributed under the terms of Sections 1 and 2 above on a medium");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("customarily used for software interchange; or,");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("c) Accompany it with the information you received as to the offer");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("to distribute corresponding source code.  (This alternative is");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("allowed only for noncommercial distribution and only if you");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("received the program in object code or executable form with such");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("an offer, in accord with Subsection b above.)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("The source code for a work means the preferred form of the work for");
        _builder.newLine();
        _builder.append("making modifications to it.  For an executable work, complete source");
        _builder.newLine();
        _builder.append("code means all the source code for all modules it contains, plus any");
        _builder.newLine();
        _builder.append("associated interface definition files, plus the scripts used to");
        _builder.newLine();
        _builder.append("control compilation and installation of the executable.  However, as a");
        _builder.newLine();
        _builder.append("special exception, the source code distributed need not include");
        _builder.newLine();
        _builder.append("anything that is normally distributed (in either source or binary");
        _builder.newLine();
        _builder.append("form) with the major components (compiler, kernel, and so on) of the");
        _builder.newLine();
        _builder.append("operating system on which the executable runs, unless that component");
        _builder.newLine();
        _builder.append("itself accompanies the executable.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("If distribution of executable or object code is made by offering");
        _builder.newLine();
        _builder.append("access to copy from a designated place, then offering equivalent");
        _builder.newLine();
        _builder.append("access to copy the source code from the same place counts as");
        _builder.newLine();
        _builder.append("distribution of the source code, even though third parties are not");
        _builder.newLine();
        _builder.append("compelled to copy the source along with the object code.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("4. You may not copy, modify, sublicense, or distribute the Program");
        _builder.newLine();
        _builder.append("except as expressly provided under this License.  Any attempt");
        _builder.newLine();
        _builder.append("otherwise to copy, modify, sublicense or distribute the Program is");
        _builder.newLine();
        _builder.append("void, and will automatically terminate your rights under this License.");
        _builder.newLine();
        _builder.append("However, parties who have received copies, or rights, from you under");
        _builder.newLine();
        _builder.append("this License will not have their licenses terminated so long as such");
        _builder.newLine();
        _builder.append("parties remain in full compliance.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("5. You are not required to accept this License, since you have not");
        _builder.newLine();
        _builder.append("signed it.  However, nothing else grants you permission to modify or");
        _builder.newLine();
        _builder.append("distribute the Program or its derivative works.  These actions are");
        _builder.newLine();
        _builder.append("prohibited by law if you do not accept this License.  Therefore, by");
        _builder.newLine();
        _builder.append("modifying or distributing the Program (or any work based on the");
        _builder.newLine();
        _builder.append("Program), you indicate your acceptance of this License to do so, and");
        _builder.newLine();
        _builder.append("all its terms and conditions for copying, distributing or modifying");
        _builder.newLine();
        _builder.append("the Program or works based on it.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("6. Each time you redistribute the Program (or any work based on the");
        _builder.newLine();
        _builder.append("Program), the recipient automatically receives a license from the");
        _builder.newLine();
        _builder.append("original licensor to copy, distribute or modify the Program subject to");
        _builder.newLine();
        _builder.append("these terms and conditions.  You may not impose any further");
        _builder.newLine();
        _builder.append("restrictions on the recipients' exercise of the rights granted herein.");
        _builder.newLine();
        _builder.append("You are not responsible for enforcing compliance by third parties to");
        _builder.newLine();
        _builder.append("this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("7. If, as a consequence of a court judgment or allegation of patent");
        _builder.newLine();
        _builder.append("infringement or for any other reason (not limited to patent issues),");
        _builder.newLine();
        _builder.append("conditions are imposed on you (whether by court order, agreement or");
        _builder.newLine();
        _builder.append("otherwise) that contradict the conditions of this License, they do not");
        _builder.newLine();
        _builder.append("excuse you from the conditions of this License.  If you cannot");
        _builder.newLine();
        _builder.append("distribute so as to satisfy simultaneously your obligations under this");
        _builder.newLine();
        _builder.append("License and any other pertinent obligations, then as a consequence you");
        _builder.newLine();
        _builder.append("may not distribute the Program at all.  For example, if a patent");
        _builder.newLine();
        _builder.append("license would not permit royalty-free redistribution of the Program by");
        _builder.newLine();
        _builder.append("all those who receive copies directly or indirectly through you, then");
        _builder.newLine();
        _builder.append("the only way you could satisfy both it and this License would be to");
        _builder.newLine();
        _builder.append("refrain entirely from distribution of the Program.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("If any portion of this section is held invalid or unenforceable under");
        _builder.newLine();
        _builder.append("any particular circumstance, the balance of the section is intended to");
        _builder.newLine();
        _builder.append("apply and the section as a whole is intended to apply in other");
        _builder.newLine();
        _builder.append("circumstances.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("It is not the purpose of this section to induce you to infringe any");
        _builder.newLine();
        _builder.append("patents or other property right claims or to contest validity of any");
        _builder.newLine();
        _builder.append("such claims; this section has the sole purpose of protecting the");
        _builder.newLine();
        _builder.append("integrity of the free software distribution system, which is");
        _builder.newLine();
        _builder.append("implemented by public license practices.  Many people have made");
        _builder.newLine();
        _builder.append("generous contributions to the wide range of software distributed");
        _builder.newLine();
        _builder.append("through that system in reliance on consistent application of that");
        _builder.newLine();
        _builder.append("system; it is up to the author/donor to decide if he or she is willing");
        _builder.newLine();
        _builder.append("to distribute software through any other system and a licensee cannot");
        _builder.newLine();
        _builder.append("impose that choice.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("This section is intended to make thoroughly clear what is believed to");
        _builder.newLine();
        _builder.append("be a consequence of the rest of this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("8. If the distribution and/or use of the Program is restricted in");
        _builder.newLine();
        _builder.append("certain countries either by patents or by copyrighted interfaces, the");
        _builder.newLine();
        _builder.append("original copyright holder who places the Program under this License");
        _builder.newLine();
        _builder.append("may add an explicit geographical distribution limitation excluding");
        _builder.newLine();
        _builder.append("those countries, so that distribution is permitted only in or among");
        _builder.newLine();
        _builder.append("countries not thus excluded.  In such case, this License incorporates");
        _builder.newLine();
        _builder.append("the limitation as if written in the body of this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("9. The Free Software Foundation may publish revised and/or new versions");
        _builder.newLine();
        _builder.append("of the General Public License from time to time.  Such new versions will");
        _builder.newLine();
        _builder.append("be similar in spirit to the present version, but may differ in detail to");
        _builder.newLine();
        _builder.append("address new problems or concerns.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Each version is given a distinguishing version number.  If the Program");
        _builder.newLine();
        _builder.append("specifies a version number of this License which applies to it and \"any");
        _builder.newLine();
        _builder.append("later version\", you have the option of following the terms and conditions");
        _builder.newLine();
        _builder.append("either of that version or of any later version published by the Free");
        _builder.newLine();
        _builder.append("Software Foundation.  If the Program does not specify a version number of");
        _builder.newLine();
        _builder.append("this License, you may choose any version ever published by the Free Software");
        _builder.newLine();
        _builder.append("Foundation.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("10. If you wish to incorporate parts of the Program into other free");
        _builder.newLine();
        _builder.append("programs whose distribution conditions are different, write to the author");
        _builder.newLine();
        _builder.append("to ask for permission.  For software which is copyrighted by the Free");
        _builder.newLine();
        _builder.append("Software Foundation, write to the Free Software Foundation; we sometimes");
        _builder.newLine();
        _builder.append("make exceptions for this.  Our decision will be guided by the two goals");
        _builder.newLine();
        _builder.append("of preserving the free status of all derivatives of our free software and");
        _builder.newLine();
        _builder.append("of promoting the sharing and reuse of software generally.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("NO WARRANTY");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY");
        _builder.newLine();
        _builder.append("FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN");
        _builder.newLine();
        _builder.append("OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES");
        _builder.newLine();
        _builder.append("PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED");
        _builder.newLine();
        _builder.append("OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF");
        _builder.newLine();
        _builder.append("MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS");
        _builder.newLine();
        _builder.append("TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE");
        _builder.newLine();
        _builder.append("PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,");
        _builder.newLine();
        _builder.append("REPAIR OR CORRECTION.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING");
        _builder.newLine();
        _builder.append("WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR");
        _builder.newLine();
        _builder.append("REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,");
        _builder.newLine();
        _builder.append("INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING");
        _builder.newLine();
        _builder.append("OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED");
        _builder.newLine();
        _builder.append("TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY");
        _builder.newLine();
        _builder.append("YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER");
        _builder.newLine();
        _builder.append("PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE");
        _builder.newLine();
        _builder.append("POSSIBILITY OF SUCH DAMAGES.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("                     ");
        _builder.append("END OF TERMS AND CONDITIONS");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("How to Apply These Terms to Your New Programs");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("If you develop a new program, and you want it to be of the greatest");
        _builder.newLine();
        _builder.append("possible use to the public, the best way to achieve this is to make it");
        _builder.newLine();
        _builder.append("free software which everyone can redistribute and change under these terms.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("To do so, attach the following notices to the program.  It is safest");
        _builder.newLine();
        _builder.append("to attach them to the start of each source file to most effectively");
        _builder.newLine();
        _builder.append("convey the exclusion of warranty; and each file should have at least");
        _builder.newLine();
        _builder.append("the \"copyright\" line and a pointer to where the full notice is found.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<one line to give the program's name and a brief idea of what it does.>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Copyright (C) <year>  <name of author>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("This program is free software; you can redistribute it and/or modify");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("it under the terms of the GNU General Public License as published by");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("the Free Software Foundation; either version 2 of the License, or");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("(at your option) any later version.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("This program is distributed in the hope that it will be useful,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("but WITHOUT ANY WARRANTY; without even the implied warranty of");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("GNU General Public License for more details.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("You should have received a copy of the GNU General Public License along");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("with this program; if not, write to the Free Software Foundation, Inc.,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Also add information on how to contact you by electronic and paper mail.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("If the program is interactive, make it output a short notice like this");
        _builder.newLine();
        _builder.append("when it starts in an interactive mode:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Gnomovision version 69, Copyright (C) year name of author");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("This is free software, and you are welcome to redistribute it");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("under certain conditions; type `show c' for details.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("The hypothetical commands `show w' and `show c' should show the appropriate");
        _builder.newLine();
        _builder.append("parts of the General Public License.  Of course, the commands you use may");
        _builder.newLine();
        _builder.append("be called something other than `show w' and `show c'; they could even be");
        _builder.newLine();
        _builder.append("mouse-clicks or menu items--whatever suits your program.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("You should also get your employer (if you work as a programmer) or your");
        _builder.newLine();
        _builder.append("school, if any, to sign a \"copyright disclaimer\" for the program, if");
        _builder.newLine();
        _builder.append("necessary.  Here is a sample; alter the names:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("Yoyodyne, Inc., hereby disclaims all copyright interest in the program");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("`Gnomovision' (which makes passes at compilers) written by James Hacker.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<signature of Ty Coon>, 1 April 1989");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("Ty Coon, President of Vice");
        _builder.newLine();
        _builder.newLine();
        _builder.append("This General Public License does not permit incorporating your program into");
        _builder.newLine();
        _builder.append("proprietary programs.  If your program is a subroutine library, you may");
        _builder.newLine();
        _builder.append("consider it more useful to permit linking proprietary applications with the");
        _builder.newLine();
        _builder.append("library.  If this is what you want to do, use the GNU Lesser General");
        _builder.newLine();
        _builder.append("Public License instead of this License.");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectLicenseLGPL(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.append("GNU LESSER GENERAL PUBLIC LICENSE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Version 3, 29 June 2007");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Copyright \u00a9 2007 Free Software Foundation, Inc. <http://fsf.org/>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Everyone is permitted to copy and distribute verbatim copies of this ");
        _builder.newLine();
        _builder.append("license document, but changing it is not allowed.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("This version of the GNU Lesser General Public License incorporates the ");
        _builder.newLine();
        _builder.append("terms and conditions of version 3 of the GNU General Public License, ");
        _builder.newLine();
        _builder.append("supplemented by the additional permissions listed below.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("0. Additional Definitions.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("As used herein, \u201cthis License\u201d refers to version 3 of the GNU Lesser ");
        _builder.newLine();
        _builder.append("General Public License, and the \u201cGNU GPL\u201d refers to version 3 of the ");
        _builder.newLine();
        _builder.append("GNU General Public License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\u201cThe Library\u201d refers to a covered work governed by this License, other ");
        _builder.newLine();
        _builder.append("than an Application or a Combined Work as defined below.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("An \u201cApplication\u201d is any work that makes use of an interface provided by ");
        _builder.newLine();
        _builder.append("the Library, but which is not otherwise based on the Library. Defining a ");
        _builder.newLine();
        _builder.append("subclass of a class defined by the Library is deemed a mode of using an ");
        _builder.newLine();
        _builder.append("interface provided by the Library.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("A \u201cCombined Work\u201d is a work produced by combining or linking an Application ");
        _builder.newLine();
        _builder.append("with the Library. The particular version of the Library with which the ");
        _builder.newLine();
        _builder.append("Combined Work was made is also called the \u201cLinked Version\u201d.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("The \u201cMinimal Corresponding Source\u201d for a Combined Work means the ");
        _builder.newLine();
        _builder.append("Corresponding Source for the Combined Work, excluding any source code for ");
        _builder.newLine();
        _builder.append("portions of the Combined Work that, considered in isolation, are based on ");
        _builder.newLine();
        _builder.append("the Application, and not on the Linked Version.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("The \u201cCorresponding Application Code\u201d for a Combined Work means the object ");
        _builder.newLine();
        _builder.append("code and/or source code for the Application, including any data and utility ");
        _builder.newLine();
        _builder.append("programs needed for reproducing the Combined Work from the Application, but ");
        _builder.newLine();
        _builder.append("excluding the System Libraries of the Combined Work.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("1. Exception to Section 3 of the GNU GPL.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("You may convey a covered work under sections 3 and 4 of this License without");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("being bound by section 3 of the GNU GPL.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("2. Conveying Modified Versions.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("If you modify a copy of the Library, and, in your modifications, a facility ");
        _builder.newLine();
        _builder.append("refers to a function or data to be supplied by an Application that uses the ");
        _builder.newLine();
        _builder.append("facility (other than as an argument passed when the facility is invoked), ");
        _builder.newLine();
        _builder.append("then you may convey a copy of the modified version:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("a) under this License, provided that you make a good faith effort to ensure that, ");
        _builder.newLine();
        _builder.append("in the event an Application does not supply the function or data, the facility still ");
        _builder.newLine();
        _builder.append("operates, and performs whatever part of its purpose remains meaningful, or");
        _builder.newLine();
        _builder.append("b) under the GNU GPL, with none of the additional permissions of this License ");
        _builder.newLine();
        _builder.append("applicable to that copy.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("3. Object Code Incorporating Material from Library Header Files.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("The object code form of an Application may incorporate material from a header file ");
        _builder.newLine();
        _builder.append("that is part of the Library. You may convey such object code under terms of your ");
        _builder.newLine();
        _builder.append("choice, provided that, if the incorporated material is not limited to numerical ");
        _builder.newLine();
        _builder.append("parameters, data structure layouts and accessors, or small macros, inline functions ");
        _builder.newLine();
        _builder.append("and templates (ten or fewer lines in length), you do both of the following:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("a) Give prominent notice with each copy of the object code that the Library is used ");
        _builder.newLine();
        _builder.append("in it and that the Library and its use are covered by this License.");
        _builder.newLine();
        _builder.append("b) Accompany the object code with a copy of the GNU GPL and this license document.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("4. Combined Works.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("You may convey a Combined Work under terms of your choice that, taken together, ");
        _builder.newLine();
        _builder.append("effectively do not restrict modification of the portions of the Library contained ");
        _builder.newLine();
        _builder.append("in the Combined Work and reverse engineering for debugging such modifications, if ");
        _builder.newLine();
        _builder.append("you also do each of the following:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("a) Give prominent notice with each copy of the Combined Work that the Library is used ");
        _builder.newLine();
        _builder.append("in it and that the Library and its use are covered by this License.");
        _builder.newLine();
        _builder.append("b) Accompany the Combined Work with a copy of the GNU GPL and this license document.");
        _builder.newLine();
        _builder.append("c) For a Combined Work that displays copyright notices during execution, include the ");
        _builder.newLine();
        _builder.append("copyright notice for the Library among these notices, as well as a reference directing ");
        _builder.newLine();
        _builder.append("the user to the copies of the GNU GPL and this license document.");
        _builder.newLine();
        _builder.append("d) Do one of the following:");
        _builder.newLine();
        _builder.append("0) Convey the Minimal Corresponding Source under the terms of this License, and the ");
        _builder.newLine();
        _builder.append("Corresponding Application Code in a form suitable for, and under terms that permit, ");
        _builder.newLine();
        _builder.append("the user to recombine or relink the Application with a modified version of the Linked ");
        _builder.newLine();
        _builder.append("Version to produce a modified Combined Work, in the manner specified by section 6 of ");
        _builder.newLine();
        _builder.append("the GNU GPL for conveying Corresponding Source.");
        _builder.newLine();
        _builder.append("1) Use a suitable shared library mechanism for linking with the Library. A suitable ");
        _builder.newLine();
        _builder.append("mechanism is one that (a) uses at run time a copy of the Library already present on ");
        _builder.newLine();
        _builder.append("the user's computer system, and (b) will operate properly with a modified version of ");
        _builder.newLine();
        _builder.append("the Library that is interface-compatible with the Linked Version.");
        _builder.newLine();
        _builder.append("e) Provide Installation Information, but only if you would otherwise be required to ");
        _builder.newLine();
        _builder.append("provide such information under section 6 of the GNU GPL, and only to the extent that ");
        _builder.newLine();
        _builder.append("such information is necessary to install and execute a modified version of the Combined ");
        _builder.newLine();
        _builder.append("Work produced by recombining or relinking the Application with a modified version of the ");
        _builder.newLine();
        _builder.append("Linked Version. (If you use option 4d0, the Installation Information must accompany the ");
        _builder.newLine();
        _builder.append("Minimal Corresponding Source and Corresponding Application Code. If you use option 4d1, ");
        _builder.newLine();
        _builder.append("you must provide the Installation Information in the manner specified by section 6 of ");
        _builder.newLine();
        _builder.append("the GNU GPL for conveying Corresponding Source.)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("5. Combined Libraries.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("You may place library facilities that are a work based on the Library side by side in a ");
        _builder.newLine();
        _builder.append("single library together with other library facilities that are not Applications and are ");
        _builder.newLine();
        _builder.append("not covered by this License, and convey such a combined library under terms of your choice, ");
        _builder.newLine();
        _builder.append("if you do both of the following:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("a) Accompany the combined library with a copy of the same work based on the Library, ");
        _builder.newLine();
        _builder.append("uncombined with any other library facilities, conveyed under the terms of this License.");
        _builder.newLine();
        _builder.append("b) Give prominent notice with the combined library that part of it is a work based on ");
        _builder.newLine();
        _builder.append("the Library, and explaining where to find the accompanying uncombined form of the same work.");
        _builder.newLine();
        _builder.append("6. Revised Versions of the GNU Lesser General Public License.");
        _builder.newLine();
        _builder.append("The Free Software Foundation may publish revised and/or new versions of the GNU Lesser ");
        _builder.newLine();
        _builder.append("General Public License from time to time. Such new versions will be similar in spirit ");
        _builder.newLine();
        _builder.append("to the present version, but may differ in detail to address new problems or concerns.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Each version is given a distinguishing version number. If the Library as you received ");
        _builder.newLine();
        _builder.append("it specifies that a certain numbered version of the GNU Lesser General Public License ");
        _builder.newLine();
        _builder.append("\u201cor any later version\u201d applies to it, you have the option of following the terms and ");
        _builder.newLine();
        _builder.append("conditions either of that published version or of any later version published by the ");
        _builder.newLine();
        _builder.append("Free Software Foundation. If the Library as you received it does not specify a version ");
        _builder.newLine();
        _builder.append("number of the GNU Lesser General Public License, you may choose any version of the GNU ");
        _builder.newLine();
        _builder.append("Lesser General Public License ever published by the Free Software Foundation.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("If the Library as you received it specifies that a proxy can decide whether future versions");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("of the GNU Lesser General Public License shall apply, that proxy's public statement of acceptance");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("of any version is permanent authorization for you to choose that version for the Library.");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectLicenseMIT(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.append("The MIT License");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Copyright (c) 2006-2010 Stephen M. McKamey");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Permission is hereby granted, free of charge, to any person obtaining a copy");
        _builder.newLine();
        _builder.append("of this software and associated documentation files (the \"Software\"), to deal");
        _builder.newLine();
        _builder.append("in the Software without restriction, including without limitation the rights");
        _builder.newLine();
        _builder.append("to use, copy, modify, merge, publish, distribute, sublicense, and/or sell");
        _builder.newLine();
        _builder.append("copies of the Software, and to permit persons to whom the Software is");
        _builder.newLine();
        _builder.append("furnished to do so, subject to the following conditions:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("The above copyright notice and this permission notice shall be included in");
        _builder.newLine();
        _builder.append("all copies or substantial portions of the Software.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR");
        _builder.newLine();
        _builder.append("IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,");
        _builder.newLine();
        _builder.append("FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE");
        _builder.newLine();
        _builder.append("AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER");
        _builder.newLine();
        _builder.append("LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,");
        _builder.newLine();
        _builder.append("OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN");
        _builder.newLine();
        _builder.append("THE SOFTWARE.");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectLicenseAPACHE(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("                              ");
        _builder.append("Apache License");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("Version 2.0, January 2004");
        _builder.newLine();
        _builder.append("                     ");
        _builder.append("http://www.apache.org/licenses/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION");
        _builder.newLine();
        _builder.newLine();
        _builder.append("1. Definitions.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"License\" shall mean the terms and conditions for use, reproduction,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("and distribution as defined by Sections 1 through 9 of this document.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Licensor\" shall mean the copyright owner or entity authorized by");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the copyright owner that is granting the License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Legal Entity\" shall mean the union of the acting entity and all");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("other entities that control, are controlled by, or are under common");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("control with that entity. For the purposes of this definition,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"control\" means (i) the power, direct or indirect, to cause the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("direction or management of such entity, whether by contract or");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("otherwise, or (ii) ownership of fifty percent (50%) or more of the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("outstanding shares, or (iii) beneficial ownership of such entity.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"You\" (or \"Your\") shall mean an individual or Legal Entity");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("exercising permissions granted by this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Source\" form shall mean the preferred form for making modifications,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("including but not limited to software source code, documentation");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("source, and configuration files.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Object\" form shall mean any form resulting from mechanical");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("transformation or translation of a Source form, including but");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("not limited to compiled object code, generated documentation,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("and conversions to other media types.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Work\" shall mean the work of authorship, whether in Source or");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Object form, made available under the License, as indicated by a");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("copyright notice that is included in or attached to the work");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("(an example is provided in the Appendix below).");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Derivative Works\" shall mean any work, whether in Source or Object");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("form, that is based on (or derived from) the Work and for which the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("editorial revisions, annotations, elaborations, or other modifications");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("represent, as a whole, an original work of authorship. For the purposes");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("of this License, Derivative Works shall not include works that remain");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("separable from, or merely link (or bind by name) to the interfaces of,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the Work and Derivative Works thereof.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Contribution\" shall mean any work of authorship, including");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the original version of the Work and any modifications or additions");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("to that Work or Derivative Works thereof, that is intentionally");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("submitted to Licensor for inclusion in the Work by the copyright owner");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("or by an individual or Legal Entity authorized to submit on behalf of");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the copyright owner. For the purposes of this definition, \"submitted\"");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("means any form of electronic, verbal, or written communication sent");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("to the Licensor or its representatives, including but not limited to");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("communication on electronic mailing lists, source code control systems,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("and issue tracking systems that are managed by, or on behalf of, the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Licensor for the purpose of discussing and improving the Work, but");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("excluding communication that is conspicuously marked or otherwise");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("designated in writing by the copyright owner as \"Not a Contribution.\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("\"Contributor\" shall mean Licensor and any individual or Legal Entity");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("on behalf of whom a Contribution has been received by Licensor and");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("subsequently incorporated within the Work.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("2. Grant of Copyright License. Subject to the terms and conditions of");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("this License, each Contributor hereby grants to You a perpetual,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("worldwide, non-exclusive, no-charge, royalty-free, irrevocable");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("copyright license to reproduce, prepare Derivative Works of,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("publicly display, publicly perform, sublicense, and distribute the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Work and such Derivative Works in Source or Object form.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("3. Grant of Patent License. Subject to the terms and conditions of");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("this License, each Contributor hereby grants to You a perpetual,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("worldwide, non-exclusive, no-charge, royalty-free, irrevocable");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("(except as stated in this section) patent license to make, have made,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("use, offer to sell, sell, import, and otherwise transfer the Work,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("where such license applies only to those patent claims licensable");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("by such Contributor that are necessarily infringed by their");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Contribution(s) alone or by combination of their Contribution(s)");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("with the Work to which such Contribution(s) was submitted. If You");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("institute patent litigation against any entity (including a");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("cross-claim or counterclaim in a lawsuit) alleging that the Work");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("or a Contribution incorporated within the Work constitutes direct");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("or contributory patent infringement, then any patent licenses");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("granted to You under this License for that Work shall terminate");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("as of the date such litigation is filed.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("4. Redistribution. You may reproduce and distribute copies of the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Work or Derivative Works thereof in any medium, with or without");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("modifications, and in Source or Object form, provided that You");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("meet the following conditions:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("(a) You must give any other recipients of the Work or");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("Derivative Works a copy of this License; and");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("(b) You must cause any modified files to carry prominent notices");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("stating that You changed the files; and");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("(c) You must retain, in the Source form of any Derivative Works");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("that You distribute, all copyright, patent, trademark, and");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("attribution notices from the Source form of the Work,");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("excluding those notices that do not pertain to any part of");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("the Derivative Works; and");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("(d) If the Work includes a \"NOTICE\" text file as part of its");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("distribution, then any Derivative Works that You distribute must");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("include a readable copy of the attribution notices contained");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("within such NOTICE file, excluding those notices that do not");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("pertain to any part of the Derivative Works, in at least one");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("of the following places: within a NOTICE text file distributed");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("as part of the Derivative Works; within the Source form or");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("documentation, if provided along with the Derivative Works; or,");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("within a display generated by the Derivative Works, if and");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("wherever such third-party notices normally appear. The contents");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("of the NOTICE file are for informational purposes only and");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("do not modify the License. You may add Your own attribution");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("notices within Derivative Works that You distribute, alongside");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("or as an addendum to the NOTICE text from the Work, provided");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("that such additional attribution notices cannot be construed");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("as modifying the License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("You may add Your own copyright statement to Your modifications and");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("may provide additional or different license terms and conditions");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("for use, reproduction, or distribution of Your modifications, or");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("for any such Derivative Works as a whole, provided Your use,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("reproduction, and distribution of the Work otherwise complies with");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the conditions stated in this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("5. Submission of Contributions. Unless You explicitly state otherwise,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("any Contribution intentionally submitted for inclusion in the Work");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("by You to the Licensor shall be under the terms and conditions of");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("this License, without any additional terms or conditions.");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Notwithstanding the above, nothing herein shall supersede or modify");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the terms of any separate license agreement you may have executed");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("with Licensor regarding such Contributions.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("6. Trademarks. This License does not grant permission to use the trade");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("names, trademarks, service marks, or product names of the Licensor,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("except as required for reasonable and customary use in describing the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("origin of the Work and reproducing the content of the NOTICE file.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("7. Disclaimer of Warranty. Unless required by applicable law or");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("agreed to in writing, Licensor provides the Work (and each");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Contributor provides its Contributions) on an \"AS IS\" BASIS,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("implied, including, without limitation, any warranties or conditions");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("PARTICULAR PURPOSE. You are solely responsible for determining the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("appropriateness of using or redistributing the Work and assume any");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("risks associated with Your exercise of permissions under this License.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("8. Limitation of Liability. In no event and under no legal theory,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("whether in tort (including negligence), contract, or otherwise,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("unless required by applicable law (such as deliberate and grossly");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("negligent acts) or agreed to in writing, shall any Contributor be");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("liable to You for damages, including any direct, indirect, special,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("incidental, or consequential damages of any character arising as a");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("result of this License or out of the use or inability to use the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("Work (including but not limited to damages for loss of goodwill,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("work stoppage, computer failure or malfunction, or any and all");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("other commercial damages or losses), even if such Contributor");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("has been advised of the possibility of such damages.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("9. Accepting Warranty or Additional Liability. While redistributing");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the Work or Derivative Works thereof, You may choose to offer,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("and charge a fee for, acceptance of support, warranty, indemnity,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("or other liability obligations and/or rights consistent with this");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("License. However, in accepting such obligations, You may act only");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("on Your own behalf and on Your sole responsibility, not on behalf");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("of any other Contributor, and only if You agree to indemnify,");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("defend, and hold each Contributor harmless for any liability");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("incurred by, or claims asserted against, such Contributor by reason");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("of your accepting any such warranty or additional liability.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("END OF TERMS AND CONDITIONS");
        _builder.newLine();
        _builder.newLine();
        _builder.append("APPENDIX: How to apply the Apache License to your work.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("To apply the Apache License to your work, attach the following");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("boilerplate notice, with the fields enclosed by brackets \"[]\"");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("replaced with your own identifying information. (Don't include");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("the brackets!)  The text should be enclosed in the appropriate");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("comment syntax for the file format. We also recommend that a");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("file or class name and description of purpose be included on the");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("same \"printed page\" as the copyright notice for easier");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("identification within third-party archives.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Copyright [yyyy] [name of copyright owner]");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Licensed under the Apache License, Version 2.0 (the \"License\");");
        _builder.newLine();
        _builder.append("you may not use this file except in compliance with the License.");
        _builder.newLine();
        _builder.append("You may obtain a copy of the License at");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("http://www.apache.org/licenses/LICENSE-2.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Unless required by applicable law or agreed to in writing, software");
        _builder.newLine();
        _builder.append("distributed under the License is distributed on an \"AS IS\" BASIS,");
        _builder.newLine();
        _builder.append("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        _builder.newLine();
        _builder.append("See the License for the specific language governing permissions and");
        _builder.newLine();
        _builder.append("limitations under the License.");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectManifest(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("recursive-include ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" *.py");
        _builder.newLineIfNotEmpty();
        _builder.append("recursive-include test *.py");
        _builder.newLine();
        _builder.append("include *.rst");
        _builder.newLine();
        _builder.append("include ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(".xmi");
        _builder.newLineIfNotEmpty();
        _builder.append("include *.txt");
        _builder.newLine();
        _builder.append("graft docs");
        _builder.newLine();
        _builder.newLine();
        _builder.append("global-exclude *.pyc");
        _builder.newLine();
        _builder.append("global-exclude *.pyo");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlSphinxConf(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Imports");
        _builder.newLine();
        _builder.append("import sys");
        _builder.newLine();
        _builder.append("import os");
        _builder.newLine();
        _builder.append("# Path handling");
        _builder.newLine();
        _builder.append("conf_dir = os.path.dirname(os.path.abspath(__file__))");
        _builder.newLine();
        _builder.append("sys.path.insert(0, os.path.join(conf_dir, os.path.pardir))");
        _builder.newLine();
        _builder.append("sys.path.insert(0, os.path.join(conf_dir, os.path.pardir, os.path.pardir))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Configuration");
        _builder.newLine();
        _builder.append("extensions = ['sphinx.ext.autodoc', 'devicedoc']");
        _builder.newLine();
        _builder.append("master_doc = 'index'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Data");
        _builder.newLine();
        _builder.append("project = u'");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("copyright = u\"\"\"");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright);
        _builder.append((Object)_commentMultiLinesPythonStr, "");
        _builder.append("\"\"\"");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generatePythonHlSphinxIndex(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".. automodule:: ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append(":members: ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generatePythonHlSetupCfg(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[bdist_rpm]");
        _builder.newLine();
        _builder.append("release = 1%{?dist}.");
        _builder.newLine();
        _builder.append("requires = python-pytango");
        _builder.newLine();
        _builder.append("build_requires = python-setuptools");
        _builder.newLine();
        _builder.append("[build_sphinx]");
        _builder.newLine();
        _builder.append("source-dir = docs/source");
        _builder.newLine();
        _builder.append("build-dir  = docs/build");
        _builder.newLine();
        _builder.append("all_files  = 1");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectSetupOld(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import os");
        _builder.newLine();
        _builder.append("import sys");
        _builder.newLine();
        _builder.newLine();
        _builder.append("setup_dir = os.path.dirname(os.path.abspath(__file__))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# make sure we use latest info from local code");
        _builder.newLine();
        _builder.append("sys.path.insert(0, setup_dir)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("from ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(" import release");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("from distutils.core import setup");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("def main():");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("packages = ['");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "    ");
        _builder.append("']");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("opts = dict(");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("name=Release.name,");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("version=Release.version,");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("description=Release.description,");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("url=Release.url,");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("packages=packages,");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("scripts=['scripts/");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "        ");
        _builder.append("'],");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("test_suite=\"test\",");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(")");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("setup(**opts)");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("if __name__ == \"__main__\":");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("main()");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlProjectSetup(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/usr/bin/env python");
        _builder.newLine();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import os");
        _builder.newLine();
        _builder.append("import sys");
        _builder.newLine();
        _builder.append("from setuptools import setup");
        _builder.newLine();
        _builder.newLine();
        _builder.append("setup_dir = os.path.dirname(os.path.abspath(__file__))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# make sure we use latest info from local code");
        _builder.newLine();
        _builder.append("sys.path.insert(0, setup_dir)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("readme_filename = os.path.join(setup_dir, 'README.rst')");
        _builder.newLine();
        _builder.append("with open(readme_filename) as file:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("long_description = file.read()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("release_filename = os.path.join(setup_dir, '");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("', 'release.py')");
        _builder.newLineIfNotEmpty();
        _builder.append("exec(open(release_filename).read())");
        _builder.newLine();
        _builder.newLine();
        _builder.append("pack = ['");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("']");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("setup(name=name,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("version=version,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description='");
        ClassDescription _description_3 = cls.getDescription();
        String _description_4 = _description_3.getDescription();
        String _oneLineString = this._stringUtils.oneLineString(_description_4);
        _builder.append((Object)_oneLineString, "      ");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("packages=pack,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("include_package_data=True,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("test_suite=\"test\",");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("entry_points={'console_scripts':['");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "      ");
        _builder.append(" = ");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "      ");
        _builder.append(":main']},");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("author='");
        ClassDescription _description_5 = cls.getDescription();
        ClassIdentification _identification = _description_5.getIdentification();
        String _author = _identification.getAuthor();
        _builder.append((Object)_author, "      ");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("author_email='");
        ClassDescription _description_6 = cls.getDescription();
        ClassIdentification _identification_1 = _description_6.getIdentification();
        String _author_1 = _identification_1.getAuthor();
        _builder.append((Object)_author_1, "      ");
        _builder.append(" at ");
        ClassDescription _description_7 = cls.getDescription();
        ClassIdentification _identification_2 = _description_7.getIdentification();
        String _emailDomain = _identification_2.getEmailDomain();
        _builder.append((Object)_emailDomain, "      ");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("license='");
        ClassDescription _description_8 = cls.getDescription();
        String _license_1 = _description_8.getLicense();
        _builder.append((Object)_license_1, "      ");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("long_description=long_description,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("url='www.tango-controls.org',");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("platforms=\"");
        ClassDescription _description_9 = cls.getDescription();
        ClassIdentification _identification_3 = _description_9.getIdentification();
        String _platform = _identification_3.getPlatform();
        _builder.append((Object)_platform, "      ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append(")");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlTestGwt(PogoDeviceClass cls) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/usr/bin/env python");
        _builder.newLine();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.append("\"\"\"Contain the tests for the ");
        ClassDescription _description_3 = cls.getDescription();
        String _title = _description_3.getTitle();
        _builder.append((Object)_title, "");
        _builder.append(".\"\"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Path");
        _builder.newLine();
        _builder.append("import sys");
        _builder.newLine();
        _builder.append("import os");
        _builder.newLine();
        _builder.append("path = os.path.join(os.path.dirname(__file__), os.pardir)");
        _builder.newLine();
        _builder.append("sys.path.insert(0, os.path.abspath(path))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Imports");
        _builder.newLine();
        _builder.append("from time import sleep");
        _builder.newLine();
        _builder.append("from mock import MagicMock");
        _builder.newLine();
        _builder.append("from PyTango import DevFailed, DevState");
        _builder.newLine();
        _builder.append("from devicetest import DeviceTestCase, main");
        _builder.newLine();
        _builder.append("from ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(" import ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Note:");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Since the device uses an inner thread, it is necessary to");
        _builder.newLine();
        _builder.append("# wait during the tests in order the let the device update itself.");
        _builder.newLine();
        _builder.append("# Hence, the sleep calls have to be secured enough not to produce");
        _builder.newLine();
        _builder.append("# any inconsistent behavior. However, the unittests need to run fast.");
        _builder.newLine();
        _builder.append("# Here, we use a factor 3 between the read period and the sleep calls.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Look at devicetest examples for more advanced testing");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Scenario example");
        _builder.newLine();
        _builder.append("# Scenario(");
        _builder.newLine();
        _builder.append("#     \"Simple read in STANDBY state\",");
        _builder.newLine();
        _builder.append("#     Given(state=DevState.STANDBY),");
        _builder.newLine();
        _builder.append("#     When(read=True),");
        _builder.newLine();
        _builder.append("#     Then(expected=0)),");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Scenario class");
        _builder.newLine();
        _builder.append("class Scenario:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def __init__(self, desc, given, when, then):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("self.desc = desc");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("self.given, self.when, self.then = given, when, then");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def __iter__(self):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("list = [self.given.kwargs, self.when.kwargs, self.then.kwargs]");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return iter(list)");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# GWT base class");
        _builder.newLine();
        _builder.append("class GwtBase:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def __init__(self, **kwargs):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("self.kwargs = kwargs");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Given class");
        _builder.newLine();
        _builder.append("class Given(GwtBase):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("pass");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# When class");
        _builder.newLine();
        _builder.append("class When(GwtBase):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("pass");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Then class");
        _builder.newLine();
        _builder.append("class Then(GwtBase):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("pass");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Device test case");
        _builder.newLine();
        _builder.append("class ");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("DeviceTestCase(DeviceTestCase):");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("\"\"\"Test case for packet generation.\"\"\"");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("device = ");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("properties = {");
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        for (Property property : _deviceProperties) {
            _builder.append("'");
            String _name_5 = property.getName();
            _builder.append((Object)_name_5, "    ");
            _builder.append("': '");
            EList<String> _defaultPropValue = property.getDefaultPropValue();
            String _get = (String)_defaultPropValue.get(0);
            _builder.append((Object)_get, "    ");
            _builder.append("',");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("                  ");
        EList<Property> _classProperties = cls.getClassProperties();
        boolean _isEmpty = _classProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<Property> _classProperties_1 = cls.getClassProperties();
            for (Property property_1 : _classProperties_1) {
                _builder.append("'");
                String _name_6 = property_1.getName();
                _builder.append((Object)_name_6, "                  ");
                _builder.append("': '");
                EList<String> _defaultPropValue_1 = property_1.getDefaultPropValue();
                String _get_1 = (String)_defaultPropValue_1.get(0);
                _builder.append((Object)_get_1, "                  ");
                _builder.append("'");
            }
        }
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("empty = None  # Should be []");
        _builder.newLine();
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attr : _attributes) {
            _builder.append("    ");
            String _name_7 = attr.getName();
            _builder.append((Object)_name_7, "    ");
            _builder.append("_scenari = [");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_4 = cls.getDescription();
            String _filestogenerate = _description_4.getFilestogenerate();
            String _lowerCase = _filestogenerate.toLowerCase();
            boolean _contains = _lowerCase.contains("protected regions");
            if (_contains) {
                String _name_8 = attr.getName();
                String _plus = String.valueOf(_name_8) + "_scn";
                String _protectedAreaHL = this._protectedAreaHL.protectedAreaHL(cls, _plus);
                _builder.append((Object)_protectedAreaHL, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("]");
            _builder.newLine();
        }
        _builder.newLine();
        EList<Command> _commands = cls.getCommands();
        for (Command cmd : _commands) {
            _builder.append("    ");
            String _name_9 = cmd.getName();
            _builder.append((Object)_name_9, "    ");
            _builder.append("_scenari = [");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_5 = cls.getDescription();
            String _filestogenerate_1 = _description_5.getFilestogenerate();
            String _lowerCase_1 = _filestogenerate_1.toLowerCase();
            boolean _contains_1 = _lowerCase_1.contains("protected regions");
            if (_contains_1) {
                String _name_10 = cmd.getName();
                String _plus_1 = String.valueOf(_name_10) + "_scn";
                String _protectedAreaHL_1 = this._protectedAreaHL.protectedAreaHL(cls, _plus_1);
                _builder.append((Object)_protectedAreaHL_1, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("]");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@classmethod");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def mocking(cls):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("\"\"\"Mock external libraries.\"\"\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("# Example : Mock numpy");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("# cls.numpy = ");
        String _name_11 = cls.getName();
        _builder.append((Object)_name_11, "        ");
        _builder.append(".numpy = MagicMock()");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        ClassDescription _description_6 = cls.getDescription();
        String _filestogenerate_2 = _description_6.getFilestogenerate();
        String _lowerCase_2 = _filestogenerate_2.toLowerCase();
        boolean _contains_2 = _lowerCase_2.contains("protected regions");
        if (_contains_2) {
            String _protectedAreaHL_2 = this._protectedAreaHL.protectedAreaHL(cls, "mocking");
            _builder.append((Object)_protectedAreaHL_2, "        ");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def test_properties(self):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("# test the properties");
        _builder.newLine();
        _builder.append("        ");
        ClassDescription _description_7 = cls.getDescription();
        String _filestogenerate_3 = _description_7.getFilestogenerate();
        String _lowerCase_3 = _filestogenerate_3.toLowerCase();
        boolean _contains_3 = _lowerCase_3.contains("protected regions");
        if (_contains_3) {
            String _protectedAreaHL_3 = this._protectedAreaHL.protectedAreaHL(cls, "test_properties");
            _builder.append((Object)_protectedAreaHL_3, "        ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("pass");
        _builder.newLine();
        _builder.newLine();
        EList<Attribute> _attributes_1 = cls.getAttributes();
        for (Attribute attr_1 : _attributes_1) {
            _builder.append("    ");
            _builder.append("def given_");
            String _name_12 = attr_1.getName();
            _builder.append((Object)_name_12, "    ");
            _builder.append("(self, state=DevState.STANDBY, **kwargs):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"'Given' statement for ");
            String _name_13 = attr_1.getName();
            _builder.append((Object)_name_13, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_8 = cls.getDescription();
            String _filestogenerate_4 = _description_8.getFilestogenerate();
            String _lowerCase_4 = _filestogenerate_4.toLowerCase();
            boolean _contains_4 = _lowerCase_4.contains("protected regions");
            if (_contains_4) {
                String _name_14 = attr_1.getName();
                String _plus_2 = "given_" + _name_14;
                String _protectedAreaHL_4 = this._protectedAreaHL.protectedAreaHL(cls, _plus_2);
                _builder.append((Object)_protectedAreaHL_4, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("self.assertEqual(self.device.State(), state)");
            _builder.newLine();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("def when_");
            String _name_15 = attr_1.getName();
            _builder.append((Object)_name_15, "    ");
            _builder.append("(self, read=True, write=False, value=None, **kwargs):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"'When' statement for ");
            String _name_16 = attr_1.getName();
            _builder.append((Object)_name_16, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_9 = cls.getDescription();
            String _filestogenerate_5 = _description_9.getFilestogenerate();
            String _lowerCase_5 = _filestogenerate_5.toLowerCase();
            boolean _contains_5 = _lowerCase_5.contains("protected regions");
            if (_contains_5) {
                String _name_17 = attr_1.getName();
                String _plus_3 = "when_" + _name_17;
                String _protectedAreaHL_5 = this._protectedAreaHL.protectedAreaHL(cls, _plus_3);
                _builder.append((Object)_protectedAreaHL_5, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("if write:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("self.device.");
            String _name_18 = attr_1.getName();
            _builder.append((Object)_name_18, "            ");
            _builder.append(" = value");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("if read:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("return self.device.");
            String _name_19 = attr_1.getName();
            _builder.append((Object)_name_19, "            ");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("def then_");
            String _name_20 = attr_1.getName();
            _builder.append((Object)_name_20, "    ");
            _builder.append("(self, result=None, expected=None, **kwargs):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"'Then' statement for ");
            String _name_21 = attr_1.getName();
            _builder.append((Object)_name_21, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("self.assertEqual(result, expected)");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_10 = cls.getDescription();
            String _filestogenerate_6 = _description_10.getFilestogenerate();
            String _lowerCase_6 = _filestogenerate_6.toLowerCase();
            boolean _contains_6 = _lowerCase_6.contains("protected regions");
            if (_contains_6) {
                String _name_22 = attr_1.getName();
                String _plus_4 = "then_" + _name_22;
                String _protectedAreaHL_6 = this._protectedAreaHL.protectedAreaHL(cls, _plus_4);
                _builder.append((Object)_protectedAreaHL_6, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("def test_");
            String _name_23 = attr_1.getName();
            _builder.append((Object)_name_23, "    ");
            _builder.append("(self):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"Test for ");
            String _name_24 = attr_1.getName();
            _builder.append((Object)_name_24, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("for given, when, then in self.");
            String _name_25 = attr_1.getName();
            _builder.append((Object)_name_25, "        ");
            _builder.append("_scenari:");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("self.given_");
            String _name_26 = attr_1.getName();
            _builder.append((Object)_name_26, "            ");
            _builder.append("(**given)");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("try:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("            ");
            _builder.append("result = self.when_");
            String _name_27 = attr_1.getName();
            _builder.append((Object)_name_27, "                ");
            _builder.append("(**when)");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("except Exception as exc:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("            ");
            _builder.append("result = exc");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("self.then_");
            String _name_28 = attr_1.getName();
            _builder.append((Object)_name_28, "            ");
            _builder.append("(result=result, **then)");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        EList<Command> _commands_1 = cls.getCommands();
        for (Command command : _commands_1) {
            boolean _not_1;
            InheritanceStatus _status = command.getStatus();
            String _concreteHere = _status.getConcreteHere();
            boolean _isTrue = StringUtils.isTrue(_concreteHere);
            if (!_isTrue) continue;
            _builder.append("    ");
            _builder.append("def given_");
            String _name_29 = command.getName();
            _builder.append((Object)_name_29, "    ");
            _builder.append("(self, state=DevState.STANDBY, **kwargs):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"'Given' statement for ");
            String _name_30 = command.getName();
            _builder.append((Object)_name_30, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_11 = cls.getDescription();
            String _filestogenerate_7 = _description_11.getFilestogenerate();
            String _lowerCase_7 = _filestogenerate_7.toLowerCase();
            boolean _contains_7 = _lowerCase_7.contains("protected regions");
            if (_contains_7) {
                String _name_31 = command.getName();
                String _plus_5 = "given_" + _name_31;
                String _protectedAreaHL_7 = this._protectedAreaHL.protectedAreaHL(cls, _plus_5);
                _builder.append((Object)_protectedAreaHL_7, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("self.assertEqual(self.device.State(), state)");
            _builder.newLine();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("def when_");
            String _name_32 = command.getName();
            _builder.append((Object)_name_32, "    ");
            _builder.append("(self, value=None, **kwargs):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"'When' statement for ");
            String _name_33 = command.getName();
            _builder.append((Object)_name_33, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_12 = cls.getDescription();
            String _filestogenerate_8 = _description_12.getFilestogenerate();
            String _lowerCase_8 = _filestogenerate_8.toLowerCase();
            boolean _contains_8 = _lowerCase_8.contains("protected regions");
            if (_contains_8) {
                String _name_34 = command.getName();
                String _plus_6 = "when_" + _name_34;
                String _protectedAreaHL_8 = this._protectedAreaHL.protectedAreaHL(cls, _plus_6);
                _builder.append((Object)_protectedAreaHL_8, "        ");
            }
            _builder.newLineIfNotEmpty();
            Argument _argin = command.getArgin();
            Type _type = _argin.getType();
            boolean _isVoidType = this._pythonTypeDefinitions.isVoidType(_type);
            boolean bl2 = _not_1 = !_isVoidType;
            if (_not_1) {
                boolean _not_2;
                Argument _argout = command.getArgout();
                Type _type_1 = _argout.getType();
                boolean _isVoidType_1 = this._pythonTypeDefinitions.isVoidType(_type_1);
                boolean bl3 = _not_2 = !_isVoidType_1;
                if (_not_2) {
                    _builder.append("        return self.device.");
                    String _name_35 = command.getName();
                    _builder.append((Object)_name_35, "");
                    _builder.append("(value)");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("        self.device.");
                    String _name_36 = command.getName();
                    _builder.append((Object)_name_36, "");
                    _builder.append("(value)");
                }
                _builder.newLineIfNotEmpty();
            } else {
                boolean _not_3;
                Argument _argout_1 = command.getArgout();
                Type _type_2 = _argout_1.getType();
                boolean _isVoidType_2 = this._pythonTypeDefinitions.isVoidType(_type_2);
                boolean bl4 = _not_3 = !_isVoidType_2;
                if (_not_3) {
                    _builder.append("        self.device.");
                    String _name_37 = command.getName();
                    _builder.append((Object)_name_37, "");
                    _builder.append("()");
                } else {
                    _builder.append("        return self.device.");
                    String _name_38 = command.getName();
                    _builder.append((Object)_name_38, "");
                    _builder.append("()");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("    ");
            _builder.append("def then_");
            String _name_39 = command.getName();
            _builder.append((Object)_name_39, "    ");
            _builder.append("(self, result=None, expected=None, **kwargs):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"'Then' statement for ");
            String _name_40 = command.getName();
            _builder.append((Object)_name_40, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("self.assertEqual(result, expected)");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_13 = cls.getDescription();
            String _filestogenerate_9 = _description_13.getFilestogenerate();
            String _lowerCase_9 = _filestogenerate_9.toLowerCase();
            boolean _contains_9 = _lowerCase_9.contains("protected regions");
            if (_contains_9) {
                String _name_41 = command.getName();
                String _plus_7 = "then_" + _name_41;
                String _protectedAreaHL_9 = this._protectedAreaHL.protectedAreaHL(cls, _plus_7);
                _builder.append((Object)_protectedAreaHL_9, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("def test_");
            String _name_42 = command.getName();
            _builder.append((Object)_name_42, "    ");
            _builder.append("(self):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"Test for ");
            String _name_43 = command.getName();
            _builder.append((Object)_name_43, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("for given, when, then in self.");
            String _name_44 = command.getName();
            _builder.append((Object)_name_44, "        ");
            _builder.append("_scenari:");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("self.given_");
            String _name_45 = command.getName();
            _builder.append((Object)_name_45, "            ");
            _builder.append("(**given)");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("try:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("            ");
            _builder.append("result = self.when_");
            String _name_46 = command.getName();
            _builder.append((Object)_name_46, "                ");
            _builder.append("(**when)");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("except Exception as exc:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("            ");
            _builder.append("result = exc");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("        ");
            _builder.append("self.then_");
            String _name_47 = command.getName();
            _builder.append((Object)_name_47, "            ");
            _builder.append("(result=result, **then)");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("# Main execution");
        _builder.newLine();
        _builder.append("if __name__ == \"__main__\":");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("main()");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlTestInit(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence generatePythonHlProjectMain(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("from ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(" import main");
        _builder.newLineIfNotEmpty();
        _builder.append("main()");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePythonHlTest(PogoDeviceClass cls) {
        boolean _not_2;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/usr/bin/env python");
        _builder.newLine();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.append("\"\"\"Contain the tests for the ");
        ClassDescription _description_3 = cls.getDescription();
        String _title = _description_3.getTitle();
        _builder.append((Object)_title, "");
        _builder.append(".\"\"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Path");
        _builder.newLine();
        _builder.append("import sys");
        _builder.newLine();
        _builder.append("import os");
        _builder.newLine();
        _builder.append("path = os.path.join(os.path.dirname(__file__), os.pardir)");
        _builder.newLine();
        _builder.append("sys.path.insert(0, os.path.abspath(path))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Imports");
        _builder.newLine();
        _builder.append("from time import sleep");
        _builder.newLine();
        _builder.append("from mock import MagicMock");
        _builder.newLine();
        _builder.append("from PyTango import DevFailed, DevState");
        _builder.newLine();
        _builder.append("from devicetest import DeviceTestCase, main");
        _builder.newLine();
        _builder.append("from ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(" import ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Note:");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Since the device uses an inner thread, it is necessary to");
        _builder.newLine();
        _builder.append("# wait during the tests in order the let the device update itself.");
        _builder.newLine();
        _builder.append("# Hence, the sleep calls have to be secured enough not to produce");
        _builder.newLine();
        _builder.append("# any inconsistent behavior. However, the unittests need to run fast.");
        _builder.newLine();
        _builder.append("# Here, we use a factor 3 between the read period and the sleep calls.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Look at devicetest examples for more advanced testing");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Device test case");
        _builder.newLine();
        _builder.append("class ");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("DeviceTestCase(DeviceTestCase):");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("\"\"\"Test case for packet generation.\"\"\"");
        _builder.newLine();
        _builder.append("    ");
        ClassDescription _description_4 = cls.getDescription();
        String _filestogenerate = _description_4.getFilestogenerate();
        String _lowerCase = _filestogenerate.toLowerCase();
        boolean _contains = _lowerCase.contains("protected regions");
        if (_contains) {
            String _protectedAreaHL = this._protectedAreaHL.protectedAreaHL(cls, "test_additionnal_import");
            _builder.append((Object)_protectedAreaHL, "    ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("device = ");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("properties = {");
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        boolean _isEmpty = _deviceProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<Property> _deviceProperties_1 = cls.getDeviceProperties();
            for (Property property : _deviceProperties_1) {
                boolean _not_1;
                _builder.append("'");
                String _name_5 = property.getName();
                _builder.append((Object)_name_5, "    ");
                _builder.append("': '");
                EList<String> _defaultPropValue = property.getDefaultPropValue();
                boolean _isEmpty_1 = _defaultPropValue.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    EList<String> _defaultPropValue_1 = property.getDefaultPropValue();
                    String _get = (String)_defaultPropValue_1.get(0);
                    _builder.append((Object)_get, "    ");
                }
                _builder.append("', ");
            }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("                  ");
        EList<Property> _classProperties = cls.getClassProperties();
        boolean _isEmpty_2 = _classProperties.isEmpty();
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            EList<Property> _classProperties_1 = cls.getClassProperties();
            for (Property property_1 : _classProperties_1) {
                boolean _not_3;
                _builder.append("'");
                String _name_6 = property_1.getName();
                _builder.append((Object)_name_6, "                  ");
                _builder.append("': '");
                EList<String> _defaultPropValue_2 = property_1.getDefaultPropValue();
                boolean _isEmpty_3 = _defaultPropValue_2.isEmpty();
                boolean bl4 = _not_3 = !_isEmpty_3;
                if (_not_3) {
                    EList<String> _defaultPropValue_3 = property_1.getDefaultPropValue();
                    String _get_1 = (String)_defaultPropValue_3.get(0);
                    _builder.append((Object)_get_1, "                  ");
                }
                _builder.append("', ");
            }
        }
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("empty = None  # Should be []");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@classmethod");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def mocking(cls):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("\"\"\"Mock external libraries.\"\"\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("# Example : Mock numpy");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("# cls.numpy = ");
        String _name_7 = cls.getName();
        _builder.append((Object)_name_7, "        ");
        _builder.append(".numpy = MagicMock()");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        ClassDescription _description_5 = cls.getDescription();
        String _filestogenerate_1 = _description_5.getFilestogenerate();
        String _lowerCase_1 = _filestogenerate_1.toLowerCase();
        boolean _contains_1 = _lowerCase_1.contains("protected regions");
        if (_contains_1) {
            String _protectedAreaHL_1 = this._protectedAreaHL.protectedAreaHL(cls, "test_mocking");
            _builder.append((Object)_protectedAreaHL_1, "        ");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def test_properties(self):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("# test the properties");
        _builder.newLine();
        _builder.append("        ");
        ClassDescription _description_6 = cls.getDescription();
        String _filestogenerate_2 = _description_6.getFilestogenerate();
        String _lowerCase_2 = _filestogenerate_2.toLowerCase();
        boolean _contains_2 = _lowerCase_2.contains("protected regions");
        if (_contains_2) {
            String _protectedAreaHL_2 = this._protectedAreaHL.protectedAreaHL(cls, "test_properties");
            _builder.append((Object)_protectedAreaHL_2, "        ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("pass");
        _builder.newLine();
        _builder.newLine();
        EList<Command> _commands = cls.getCommands();
        for (Command command : _commands) {
            _builder.append("    ");
            _builder.append("def test_");
            String _name_8 = command.getName();
            _builder.append((Object)_name_8, "    ");
            _builder.append("(self):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"Test for ");
            String _name_9 = command.getName();
            _builder.append((Object)_name_9, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_7 = cls.getDescription();
            String _filestogenerate_3 = _description_7.getFilestogenerate();
            String _lowerCase_3 = _filestogenerate_3.toLowerCase();
            boolean _contains_3 = _lowerCase_3.contains("protected regions");
            if (_contains_3) {
                String _name_10 = command.getName();
                String _plus = "test_" + _name_10;
                Argument _argin = command.getArgin();
                Type _type = _argin.getType();
                String _defaultValueTestHL = PythonTypeDefinitions.defaultValueTestHL(_type);
                String _methodTest = this._pyUtils.methodTest(command, _defaultValueTestHL);
                String _protectedAreaHL_3 = this._protectedAreaHL.protectedAreaHL(cls, _plus, _methodTest, false);
                _builder.append((Object)_protectedAreaHL_3, "        ");
            } else {
                Argument _argin_1 = command.getArgin();
                Type _type_1 = _argin_1.getType();
                String _defaultValueTestHL_1 = PythonTypeDefinitions.defaultValueTestHL(_type_1);
                String _methodTest_1 = this._pyUtils.methodTest(command, _defaultValueTestHL_1);
                _builder.append((Object)_methodTest_1, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attr : _attributes) {
            _builder.append("    ");
            _builder.append("def test_");
            String _name_11 = attr.getName();
            _builder.append((Object)_name_11, "    ");
            _builder.append("(self):");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("\"\"\"Test for ");
            String _name_12 = attr.getName();
            _builder.append((Object)_name_12, "        ");
            _builder.append("\"\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ClassDescription _description_8 = cls.getDescription();
            String _filestogenerate_4 = _description_8.getFilestogenerate();
            String _lowerCase_4 = _filestogenerate_4.toLowerCase();
            boolean _contains_4 = _lowerCase_4.contains("protected regions");
            if (_contains_4) {
                String _name_13 = attr.getName();
                String _plus_1 = "test_" + _name_13;
                String _name_14 = attr.getName();
                String _plus_2 = "self.device." + _name_14;
                String _protectedAreaHL_4 = this._protectedAreaHL.protectedAreaHL(cls, _plus_1, _plus_2, false);
                _builder.append((Object)_protectedAreaHL_4, "        ");
            } else {
                _builder.append("self.device.");
                String _name_15 = attr.getName();
                _builder.append((Object)_name_15, "        ");
            }
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("# Main execution");
        _builder.newLine();
        _builder.append("if __name__ == \"__main__\":");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("main()");
        _builder.newLine();
        return _builder;
    }
}

