/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java.projects;

import com.google.common.collect.Iterables;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.java.JavaUtils;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class IdeaProject
implements IGenerator {
    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description_1;
            String _filestogenerate;
            boolean _contains;
            ClassDescription _description = cls.getDescription();
            String _language = _description.getLanguage();
            String _lowerCase = _language.toLowerCase();
            boolean _equals = _lowerCase.equals("java");
            if (!_equals || !(_contains = (_filestogenerate = (_description_1 = cls.getDescription()).getFilestogenerate()).contains("pom.xml"))) continue;
            StringUtils.printTrace("Generating ../../../pom.xml");
            CharSequence _generatePomXmlMain = this.generatePomXmlMain(cls);
            fsa.generateFile("../../../pom.xml", _generatePomXmlMain);
        }
    }

    public CharSequence generatePomXmlMain(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<modelVersion>4.0.0</modelVersion>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<groupId>org.tango.server</groupId>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<artifactId>");
        String _name = cls.getName();
        _builder.append((Object)_name, "    ");
        _builder.append("</artifactId>");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("<version>1.0</version>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<packaging>jar</packaging>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<name>");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append(" Tango server</name>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<developers>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<developer>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<name>");
        String _user = JavaUtils.getUser();
        _builder.append((Object)_user, "            ");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append("<email>");
        ClassDescription _description = cls.getDescription();
        ClassIdentification _identification = _description.getIdentification();
        String _author = _identification.getAuthor();
        _builder.append((Object)_author, "            ");
        _builder.append("@");
        ClassDescription _description_1 = cls.getDescription();
        ClassIdentification _identification_1 = _description_1.getIdentification();
        String _emailDomain = _identification_1.getEmailDomain();
        _builder.append((Object)_emailDomain, "            ");
        _builder.append("</email>");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append("<organizationUrl>");
        String _institute = cls.getInstitute();
        _builder.append((Object)_institute, "            ");
        _builder.append("</organizationUrl>");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append("<roles>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<role>Developer</role>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</roles>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("</developer>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</developers>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<scm>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<connection>scm:git:git@github.com:tango-controls/${project.artifactId}.git</connection>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<developerConnection>scm:git:git@github.com:tango-controls/${project.artifactId}.git</developerConnection>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<url>https://github.com/tango-controls/${project.artifactId}</url>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<tag>HEAD</tag>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</scm>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<distributionManagement>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<repository>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<id>bintray-tango-controls</id>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<url>https://api.bintray.com/maven/tango-controls/maven/${project.artifactId}/;publish=1</url>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("</repository>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</distributionManagement>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<dependencies>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<dependency>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<groupId>org.tango</groupId>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<artifactId>JTangoServer</artifactId>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<version>RELEASE</version>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("</dependency>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</dependencies>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<build>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<plugins>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<plugin>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<groupId>org.apache.maven.plugins</groupId>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<artifactId>maven-compiler-plugin</artifactId>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<configuration>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<source>1.7</source>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<target>1.7</target>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<encoding>UTF-8</encoding>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("</configuration>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</plugin>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<plugin>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<artifactId>maven-release-plugin</artifactId>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<version>2.5.3</version>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<configuration>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<useReleaseProfile>false</useReleaseProfile>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<releaseProfiles>release</releaseProfiles>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<autoVersionSubmodules>true</autoVersionSubmodules>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("</configuration>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</plugin>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<plugin>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<groupId>org.apache.maven.plugins</groupId>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<artifactId>maven-jar-plugin</artifactId>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<configuration>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<archive>");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("<manifest>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<mainClass>org.tango.");
        String _name_2 = cls.getName();
        String _lowerCase = _name_2.toLowerCase();
        _builder.append((Object)_lowerCase, "                            ");
        _builder.append(".");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "                            ");
        _builder.append("</mainClass>");
        _builder.newLineIfNotEmpty();
        _builder.append("                            ");
        _builder.append("<addDefaultImplementationEntries>true</addDefaultImplementationEntries>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<addDefaultSpecificationEntries>true</addDefaultSpecificationEntries>");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("</manifest>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("</archive>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("</configuration>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</plugin>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("</plugins>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</build>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<repositories>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<repository>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<snapshots>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<enabled>false</enabled>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</snapshots>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<id>bintray-tango-controls</id>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<name>bintray</name>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<url>http://dl.bintray.com/tango-controls/maven</url>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("</repository>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</repositories>");
        _builder.newLine();
        _builder.append("</project>");
        _builder.newLine();
        return _builder;
    }
}

