/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java;

import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.java.JavaTypeDefinitions;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

public class JavaUtils
extends StringUtils {
    public static String getUser() {
        String str = System.getProperty("user.name");
        if (str != null) {
            return str;
        }
        return "";
    }

    public String javaDevicePackage(PogoDeviceClass cls) {
        return "org.tango." + cls.getName().toLowerCase();
    }

    public String javaDeviceSourceFile(PogoDeviceClass cls) {
        String pack = this.javaDevicePackage(cls);
        return pack.replaceAll("\\.", "/");
    }

    public String fullQualifiedJavaDeviceClassName(PogoDeviceClass cls) {
        return this.fullQualifiedJavaDeviceClassName(cls, cls.getName());
    }

    public String fullQualifiedJavaDeviceClassName(PogoDeviceClass cls, String className) {
        return String.valueOf(this.javaDevicePackage(cls)) + "." + className;
    }

    public String javaDeviceClassFileName(PogoDeviceClass cls, boolean full) {
        if (full) {
            String fullName = this.fullQualifiedJavaDeviceClassName(cls);
            return String.valueOf(fullName.replaceAll("\\.", "/")) + ".java";
        }
        return String.valueOf(cls.getName()) + ".java";
    }

    public String javaDynamicObjectFileName(PogoDeviceClass cls, String objectName) {
        String fullName = this.fullQualifiedJavaDeviceClassName(cls, objectName);
        return String.valueOf(fullName.replaceAll("\\.", "/")) + ".java";
    }

    public String strJavaType(Attribute attribute) {
        if (attribute.getDataType().toString().contains("Enum")) {
            return String.valueOf(attribute.getName()) + "Enum";
        }
        return JavaTypeDefinitions.javaType(attribute.getDataType());
    }

    public String strFullJavaType(Attribute attribute) {
        if (this.isScalar(attribute)) {
            return this.strJavaType(attribute);
        }
        if (this.isSpectrum(attribute)) {
            return String.valueOf(this.strJavaType(attribute)) + "[]";
        }
        return String.valueOf(this.strJavaType(attribute)) + "[][]";
    }

    public String strJavaType(Property property) {
        return JavaTypeDefinitions.javaPropType(property.getType());
    }

    public String strArginType(Command command) {
        return JavaTypeDefinitions.javaType(command.getArgin().getType());
    }

    public String strArgoutType(Command command) {
        return JavaTypeDefinitions.javaType(command.getArgout().getType());
    }

    public String allocation(Attribute attribute) {
        if (attribute.getAttType().equals("Spectrum")) {
            return " = new " + this.strJavaType(attribute) + "[" + attribute.getMaxX() + "]";
        }
        if (attribute.getAttType().equals("Image")) {
            return " = new " + this.strJavaType(attribute) + "[" + attribute.getMaxX() + "][" + attribute.getMaxY() + "]";
        }
        if (attribute.getDataType().toString().contains("String")) {
            return " = \"\"";
        }
        return "";
    }

    public String buildEnum(Attribute attribute) {
        String s = "";
        if (attribute.getDataType().toString().contains("Enum") && attribute.getEnumLabels() != null && attribute.getEnumLabels().size() > 0) {
            s = String.valueOf(s) + "public enum " + attribute.getName() + "Enum { \n";
            for (String label : attribute.getEnumLabels()) {
                String item = label.toUpperCase();
                item = item.replaceAll(" ", "_");
                s = String.valueOf(s) + "\t" + item + ",\n";
            }
            s = String.valueOf(s) + "};";
        }
        return s;
    }

    public String defaultValue(Property property) {
        EList<String> defaultValues = property.getDefaultPropValue();
        if (defaultValues == null || defaultValues.isEmpty()) {
            return "";
        }
        String str = ",\n        defaultValue={ ";
        int i = 0;
        while (i < defaultValues.size()) {
            str = String.valueOf(str) + "\"" + (String)defaultValues.get(i) + "\"";
            if (i < defaultValues.size() - 1) {
                str = String.valueOf(str) + ", ";
            }
            ++i;
        }
        str = String.valueOf(str) + " }";
        return str;
    }

    public String isMandatory(Property property) {
        if (JavaUtils.isTrue(property.getMandatory())) {
            return ", isMandatory=true";
        }
        return "";
    }

    public String declareParameters(Command command) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=\"" + command.getName() + "\"");
        list.add("inTypeDesc=\"" + this.oneLineString(command.getArgin().getDescription()) + "\"");
        list.add("outTypeDesc=\"" + this.oneLineString(command.getArgout().getDescription()) + "\"");
        if (JavaUtils.isSet(command.getDisplayLevel()) && command.getDisplayLevel().equals("EXPERT")) {
            list.add("displayLevel=DispLevel._" + command.getDisplayLevel());
        }
        if (JavaUtils.isSet(command.getPolledPeriod()) && !command.getPolledPeriod().equals("0")) {
            list.add("isPolled=true");
            list.add("pollingPeriod=" + command.getPolledPeriod());
        }
        return this.propertiesInOneLine("@Command(", list, ")");
    }

    public String stateMachine(Command command) {
        ArrayList<String> list = new ArrayList<String>();
        for (String state : command.getExcludedStates()) {
            list.add("DeviceState." + state);
        }
        if (list.isEmpty()) {
            return "";
        }
        return this.propertiesInOneLine("@StateMachine(deniedStates={", list, "})");
    }

    public String declareParameters(Attribute attribute) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=\"" + attribute.getName() + "\"");
        if (JavaUtils.isTrue(attribute.getMemorized())) {
            list.add("isMemorized=true");
            if (JavaUtils.isTrue(attribute.getMemorizedAtInit())) {
                list.add("isMemorizedAtInit=true");
            }
        }
        if (JavaUtils.isSet(attribute.getDisplayLevel()) && attribute.getDisplayLevel().equals("EXPERT")) {
            list.add("displayLevel=DispLevel._" + attribute.getDisplayLevel());
        }
        if (JavaUtils.isSet(attribute.getPolledPeriod()) && !attribute.getPolledPeriod().equals("0")) {
            list.add("isPolled=true");
            list.add("pollingPeriod=" + attribute.getPolledPeriod());
        }
        if (attribute.getDataReadyEvent() != null && JavaUtils.isTrue(attribute.getDataReadyEvent().getFire())) {
            list.add("pushDataReady=true");
        }
        if (attribute.getArchiveEvent() != null && JavaUtils.isTrue(attribute.getArchiveEvent().getFire())) {
            list.add("pushArchiveEvent=true");
            if (JavaUtils.isTrue(attribute.getArchiveEvent().getLibCheckCriteria())) {
                list.add("checkArchivingEvent=true");
            } else {
                list.add("checkArchivingEvent=false");
            }
        }
        if (attribute.getChangeEvent() != null && JavaUtils.isTrue(attribute.getChangeEvent().getFire())) {
            list.add("pushChangeEvent=true");
            if (JavaUtils.isTrue(attribute.getChangeEvent().getLibCheckCriteria())) {
                list.add("checkChangeEvent=true");
            } else {
                list.add("checkChangeEvent=false");
            }
        }
        return this.propertiesInOneLine("@Attribute(", list, ")");
    }

    public String declareProperties(Attribute attribute) {
        ArrayList<String> list = new ArrayList<String>();
        if (JavaUtils.isSet(attribute.getProperties().getDescription())) {
            list.add("description=\"" + this.oneLineString(attribute.getProperties().getDescription()) + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getLabel())) {
            list.add("label=\"" + attribute.getProperties().getLabel() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getUnit())) {
            list.add("unit=\"" + attribute.getProperties().getUnit() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getStandardUnit())) {
            list.add("standardUnit=\"" + attribute.getProperties().getStandardUnit() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getDisplayUnit())) {
            list.add("displayUnit=\"" + attribute.getProperties().getDisplayUnit() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getFormat())) {
            list.add("format=\"" + attribute.getProperties().getFormat() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getMaxValue())) {
            list.add("maxValue=\"" + attribute.getProperties().getMaxValue() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getMinValue())) {
            list.add("minValue=\"" + attribute.getProperties().getMinValue() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getMaxAlarm())) {
            list.add("maxAlarm=\"" + attribute.getProperties().getMaxAlarm() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getMinAlarm())) {
            list.add("minAlarm=\"" + attribute.getProperties().getMinAlarm() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getMaxWarning())) {
            list.add("maxWarning=\"" + attribute.getProperties().getMaxWarning() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getMinWarning())) {
            list.add("minWarning=\"" + attribute.getProperties().getMinWarning() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getDeltaTime())) {
            list.add("deltaTime=\"" + attribute.getProperties().getDeltaTime() + "\"");
        }
        if (JavaUtils.isSet(attribute.getProperties().getDeltaValue())) {
            list.add("deltaValue=\"" + attribute.getProperties().getDeltaValue() + "\"");
        }
        if (attribute.getEventCriteria() != null) {
            if (JavaUtils.isSet(attribute.getEventCriteria().getPeriod())) {
                list.add("periodicEvent=\"" + attribute.getEventCriteria().getPeriod() + "\"");
            }
            if (JavaUtils.isSet(attribute.getEventCriteria().getAbsChange())) {
                list.add("changeEventAbsolute=\"" + attribute.getEventCriteria().getAbsChange() + "\"");
            }
            if (JavaUtils.isSet(attribute.getEventCriteria().getRelChange())) {
                list.add("changeEventRelative=\"" + attribute.getEventCriteria().getRelChange() + "\"");
            }
        }
        if (attribute.getEvArchiveCriteria() != null) {
            if (JavaUtils.isSet(attribute.getEvArchiveCriteria().getPeriod())) {
                list.add("archiveEventPeriod=\"" + attribute.getEvArchiveCriteria().getPeriod() + "\"");
            }
            if (JavaUtils.isSet(attribute.getEvArchiveCriteria().getAbsChange())) {
                list.add("archiveEventAbsolute=\"" + attribute.getEvArchiveCriteria().getAbsChange() + "\"");
            }
            if (JavaUtils.isSet(attribute.getEvArchiveCriteria().getRelChange())) {
                list.add("archiveEventRelative=\"" + attribute.getEvArchiveCriteria().getRelChange() + "\"");
            }
        }
        if (list.isEmpty()) {
            return "";
        }
        return this.propertiesInOneLine("@AttributeProperties(", list, ")");
    }

    public String stateMachine(Attribute attribute) {
        ArrayList<String> list = new ArrayList<String>();
        for (String state : attribute.getReadExcludedStates()) {
            list.add("DeviceState." + state);
        }
        if (list.isEmpty()) {
            return "";
        }
        return this.propertiesInOneLine("@StateMachine(deniedStates={", list, "})");
    }

    public String stateMachineForDynamic(Attribute attribute) {
        ArrayList<String> list = new ArrayList<String>();
        for (String state : attribute.getReadExcludedStates()) {
            list.add("DeviceState." + state);
        }
        if (list.isEmpty()) {
            return "";
        }
        return this.propertiesInOneLine("stateMachine.setDeniedStates(", list, ");");
    }

    public String stateMachineForDynamic(Command command) {
        ArrayList<String> list = new ArrayList<String>();
        for (String state : command.getExcludedStates()) {
            list.add("DeviceState." + state);
        }
        if (list.isEmpty()) {
            return "";
        }
        return this.propertiesInOneLine("stateMachine.setDeniedStates(", list, ");");
    }

    public String propertiesInOneLine(String header, ArrayList<String> list, String ending) {
        StringBuffer sb = new StringBuffer(header);
        int length = header.length();
        int i = 0;
        while (i < list.size()) {
            sb.append(list.get(i));
            length += list.get(i).length();
            if (i < list.size() - 1) {
                sb.append(",");
                if (++length < 76) {
                    sb.append(" ");
                    ++length;
                } else {
                    sb.append("\n");
                    int x = 0;
                    while (x < header.length()) {
                        sb.append(" ");
                        ++x;
                    }
                    length = header.length();
                }
            }
            ++i;
        }
        sb.append(ending);
        return sb.toString();
    }

    public String headerParameters(Command command) {
        String params = "";
        if (!JavaTypeDefinitions.javaType(command.getArgin().getType()).equals("void")) {
            params = String.valueOf(params) + "* @param " + this.parameter(command, "In") + " " + StringUtils.comments(command.getArgin().getDescription(), "*" + this.parameterInBlanks(command)) + "\n";
        }
        if (!JavaTypeDefinitions.javaType(command.getArgout().getType()).equals("void")) {
            params = String.valueOf(params) + "* @return " + StringUtils.comments(command.getArgout().getDescription(), "*         ") + "\n";
        }
        return params;
    }

    public String strArginTypeDeclare(Command command) {
        String type = JavaTypeDefinitions.javaType(command.getArgin().getType());
        if (type.equals("void")) {
            return "";
        }
        return String.valueOf(type) + " " + this.parameter(command, "In");
    }

    public String strArgoutTypeDeclare(Command command) {
        String type = JavaTypeDefinitions.javaType(command.getArgout().getType());
        if (type.equals("void")) {
            return "";
        }
        return String.valueOf(type) + " " + this.parameter(command, "Out;");
    }

    public String strArgoutTypeReturn(Command command) {
        String type = JavaTypeDefinitions.javaType(command.getArgout().getType());
        if (type.equals("void")) {
            return "";
        }
        return "return " + this.parameter(command, "Out;");
    }

    public String parameter(Command command, String inout) {
        return String.valueOf(new StringUtils().dataMemberName(command.getName())) + inout;
    }

    public String parameterInBlanks(Command command) {
        String param = " @param " + this.parameter(command, "In ");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < param.length()) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    String setDynamicAttributeConfig(String setWhat, String strValue) {
        return this.setDynamicAttributeConfig(setWhat, strValue, "");
    }

    String setDynamicAttributeConfig(String setWhat, String strValue, String valueHeader) {
        if (JavaUtils.isSet(strValue)) {
            return "config.set" + setWhat + "(" + valueHeader + strValue + ");";
        }
        return "";
    }

    String setDynamicAttributePropertyConfig(String setWhat, String strValue) {
        if (JavaUtils.isSet(strValue)) {
            return "properties.set" + setWhat + "(\"" + this.oneLineString(strValue) + "\");";
        }
        return "";
    }

    public static String getJserverJarFile() {
        String jarFile = System.getenv("JSERVER_JAR_FILE");
        if (jarFile != null) {
            return jarFile;
        }
        String tangoRoot = System.getenv("TANGO_ROOT");
        if (tangoRoot == null) {
            return "%TANGO_ROOT%/share/tango/java/JTangoServer.jar";
        }
        return String.valueOf(tangoRoot) + "/share/tango/java/JTangoServer.jar";
    }

    public static String attributeMethodName(Attribute attribute, Boolean read) {
        String attName = String.valueOf(attribute.getName().substring(0, 1).toUpperCase()) + attribute.getName().substring(1);
        String s = read.booleanValue() ? (attribute.getDataType().toString().contains("Boolean") ? "is" : "get") : "set";
        return String.valueOf(s) + attName;
    }

    public boolean isConcreteClass(PogoDeviceClass cls) {
        return CppStringUtils.isFalse(cls.getDescription().getHasAbstractAttribute()) && CppStringUtils.isFalse(cls.getDescription().getHasAbstractCommand());
    }

    private boolean isDefaultDeviceImpl(String className) {
        return className.startsWith("Device_") && className.endsWith("Impl");
    }

    public boolean isInheritanceClass(Inheritance inheritance) {
        if (CppStringUtils.isSet(inheritance.getClassname())) {
            return !this.isDefaultDeviceImpl(inheritance.getClassname());
        }
        return false;
    }

    public boolean hasInheritanceClass(PogoDeviceClass cls) {
        int inherSize = cls.getDescription().getInheritances().size();
        return inherSize > 0 && this.isInheritanceClass((Inheritance)cls.getDescription().getInheritances().get(inherSize - 1));
    }

    public String getInheritance(PogoDeviceClass cls) {
        EList<Inheritance> inheritances = cls.getDescription().getInheritances();
        if (inheritances == null || inheritances.size() == 0) {
            return "";
        }
        int last = inheritances.size() - 1;
        String className = ((Inheritance)inheritances.get(last)).getClassname();
        if (this.isDefaultDeviceImpl(className)) {
            return "";
        }
        return " extends " + className;
    }

    public boolean isConcreteHere(Property property) {
        return property.getStatus() != null && property.getStatus().getConcreteHere() != null && property.getStatus().getConcreteHere().equals("true");
    }

    public boolean isConcreteHere(Attribute attribute) {
        return attribute.getStatus() != null && attribute.getStatus().getConcreteHere() != null && attribute.getStatus().getConcreteHere().equals("true");
    }

    public boolean isConcreteHere(Command command) {
        return command.getStatus() != null && command.getStatus().getConcreteHere() != null && command.getStatus().getConcreteHere().equals("true");
    }

    public String inheritancePackage(PogoDeviceClass cls) {
        if (this.hasInheritanceClass(cls)) {
            EList<Inheritance> inheritances = cls.getDescription().getInheritances();
            int last = inheritances.size() - 1;
            String className = ((Inheritance)inheritances.get(last)).getClassname();
            return "\n\nimport org.tango." + className.toLowerCase() + ".*;";
        }
        return "";
    }
}

