/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.logviewer.ControlPanel;
import fr.esrf.logviewer.DetailPanel;
import fr.esrf.logviewer.DeviceNode;
import fr.esrf.logviewer.ExitAction;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.LoadXMLAction;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.logviewer.RootNode;
import fr.esrf.logviewer.TangoLoggingReceiver;
import fr.esrf.logviewer.TangoNode;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main
extends JFrame {
    private static final String APP_RELEASE = "2.0.1";
    private static final Logger LOG = Logger.getLogger(Main.class);
    private static TangoLoggingReceiver loggingReceiver = null;
    private JTree devTree;
    private DefaultTreeModel treeModel;
    private JScrollPane treeView;
    private TangoNode root;
    private JPopupMenu mMemberPopup;
    private ButtonGroup mMemberLevelGroup1;
    private ButtonGroup mMemberLevelGroup2;
    private JMenuItem mMemberNameItem;
    private CustomLabel mLabel;
    private HistoryArea mHistoryArea;
    private boolean mPopupTrigger = false;
    private Database db;
    static JFrame self = null;
    static boolean inited = false;
    private boolean closeOnExit = false;

    public Main(JFrame parent) {
        this(new String[0], true);
    }

    public Main(String[] aArgs, boolean closeOnExit) {
        super("Tango LogViewer (exported as ...)");
        Main.initLog4J();
        this.closeOnExit = closeOnExit;
        self = this;
        try {
            this.db = ApiUtil.get_db_obj();
        }
        catch (DevFailed e) {
            Main.showTangoError(e);
            this.db = null;
            this.exitForm();
        }
        Splash splash = new Splash();
        splash.setTitle("TANGO LogViewer");
        splash.setCopyright("(c) TANGO Team 2002-2010 / (c) Apache Project 2002");
        splash.setMaxProgress(10);
        splash.setMessage("Setting up UI...");
        int splashProgression = 1;
        splash.progress(splashProgression++);
        Font font = new Font("terminal", 0, 12);
        UIManager.put("Label.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("Button.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableColumn.font", font);
        UIManager.put("TextArea.font", font);
        MyTableModel model = new MyTableModel();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        try {
            LoadXMLAction lxa = new LoadXMLAction(this, model);
            JMenuItem loadMenuItem = new JMenuItem("Load file...");
            loadMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            menu.add(loadMenuItem);
            loadMenuItem.addActionListener(lxa);
        }
        catch (NoClassDefFoundError e) {
            LOG.info((Object)"Missing classes for XML parser", (Throwable)e);
            JOptionPane.showMessageDialog(this, "XML parser not in classpath - unable to load XML events.", "Tango LogViewer", 0);
        }
        catch (Exception e) {
            LOG.info((Object)"Unable to create the action to load XML files", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Unable to create a XML parser - unable to load XML events.", "Tango LogViewer", 0);
        }
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        menu.add(exitMenuItem);
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.exitBtnActionPerformed();
            }
        });
        JMenu actionMenu = new JMenu("Actions");
        menuBar.add(actionMenu);
        JMenuItem anItem = new JMenuItem("Refresh Device Tree");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.mLabel.setText("Refreshing the device tree... ");
                Main.this.refreshTree();
                Main.this.mLabel.setText(" ");
            }
        });
        actionMenu.add(anItem);
        actionMenu.add(new JSeparator());
        anItem = new JMenuItem("Logging Source List");
        anItem.addActionListener(new SourceListActionListener());
        actionMenu.add(anItem);
        actionMenu.add(new JSeparator());
        anItem = new JMenuItem("Remove All Logging Source");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.mLabel.setText("Removing all logging source... ");
                if (!loggingReceiver.removeAllSources()) {
                    Main.this.mHistoryArea.write("Removed all sources");
                }
                Main.this.mLabel.setText(" ");
            }
        });
        actionMenu.add(anItem);
        actionMenu.add(new JSeparator());
        anItem = new JMenuItem("Clear history");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.mHistoryArea.clear();
            }
        });
        actionMenu.add(anItem);
        splash.progress(splashProgression++);
        ControlPanel controlPanel = new ControlPanel(model, this);
        this.getContentPane().add((Component)controlPanel, "North");
        splash.progress(splashProgression++);
        JTable table = new JTable(model);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(true);
        table.setDragEnabled(true);
        table.setSelectionMode(0);
        Enumeration<TableColumn> cenum = table.getColumnModel().getColumns();
        LogTableRowRenderer dtcr = new LogTableRowRenderer();
        int i = 0;
        int[] col_width = new int[]{50, 160, 75, 160, 500};
        int width = 0;
        while (cenum.hasMoreElements()) {
            width += col_width[i];
            TableColumn tc = cenum.nextElement();
            tc.setCellRenderer(dtcr);
            tc.setPreferredWidth(col_width[i++]);
        }
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(BorderFactory.createTitledBorder("Logs"));
        scrollPane.setMinimumSize(new Dimension(150, 150));
        scrollPane.setPreferredSize(new Dimension(width, 450));
        splash.progress(splashProgression++);
        DetailPanel details = new DetailPanel(table, model);
        details.setMinimumSize(new Dimension(0, 0));
        details.setPreferredSize(new Dimension(790, 0));
        splash.progress(splashProgression++);
        JSplitPane jsp1 = new JSplitPane(0, scrollPane, details);
        jsp1.setOneTouchExpandable(true);
        jsp1.setDividerSize(9);
        this.treeView = new JScrollPane();
        this.treeView.setPreferredSize(new Dimension(170, 0));
        this.initTree();
        splash.progress(splashProgression++);
        this.mMemberPopup = new JPopupMenu();
        this.mMemberNameItem = new JMenuItem("dev/name/goes.here");
        this.mMemberNameItem.setEnabled(false);
        this.mMemberPopup.add(this.mMemberNameItem);
        this.mMemberPopup.add(new JSeparator());
        anItem = new JMenuItem("Add");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.addLoggingSource();
            }
        });
        this.mMemberPopup.add(anItem);
        anItem = new JMenuItem("Add Colocated");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.addCoLocatedSources();
            }
        });
        this.mMemberPopup.add(anItem);
        this.mMemberLevelGroup1 = new ButtonGroup();
        this.mMemberPopup.add(new LoggingLevelMenu("Add/Set Logging Level", this.mMemberLevelGroup1, true));
        this.mMemberPopup.add(new JSeparator());
        anItem = new JMenuItem("Remove");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.removeLoggingSource();
            }
        });
        this.mMemberPopup.add(anItem);
        anItem = new JMenuItem("Remove Colocated");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.removeCoLocatedSources();
            }
        });
        this.mMemberPopup.add(anItem);
        this.mMemberPopup.add(anItem);
        this.mMemberPopup.add(new JSeparator());
        this.mMemberLevelGroup2 = new ButtonGroup();
        this.mMemberPopup.add(new LoggingLevelMenu("Set Logging Level", this.mMemberLevelGroup2, false));
        this.mMemberPopup.add(new BasicLoggingLevelMenu("Set Logging Level (colocated)"));
        JSplitPane jsp2 = new JSplitPane(1, this.treeView, jsp1);
        jsp2.setOneTouchExpandable(true);
        jsp2.setDividerSize(9);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent aEvent) {
                Main.this.windowClosingPerformed();
            }
        });
        splash.progress(splashProgression++);
        scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createTitledBorder("History"));
        this.mHistoryArea = new HistoryArea(scrollPane);
        this.mHistoryArea.setMinimumSize(new Dimension(0, 0));
        Date today = new Date(System.currentTimeMillis());
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        this.mHistoryArea.write("Welcome to the TANGO LogViewer (started on " + df.format(today) + ")");
        scrollPane.setViewportView(this.mHistoryArea);
        JSplitPane jsp3 = new JSplitPane(0, jsp2, scrollPane);
        jsp3.setOneTouchExpandable(true);
        jsp3.setDividerSize(9);
        this.getContentPane().add((Component)jsp3, "Center");
        splash.progress(splashProgression++);
        this.mLabel = new CustomLabel();
        this.mLabel.setBorder(new SoftBevelBorder(1));
        this.getContentPane().add((Component)this.mLabel, "South");
        splash.setMessage("Starting up the LogConsumer device...");
        this.setupReceiver(aArgs, model);
        splash.progress(splashProgression++);
        if (loggingReceiver.isRunningInStaticMode()) {
            actionMenu.add(new JSeparator());
            menu = new JMenu("Logging Sources Property");
            anItem = new JMenuItem("Save");
            anItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.mLabel.setText("Saving logging source list into the TANGO database...");
                    loggingReceiver.setLoggingSourceProperty();
                    Main.this.mLabel.setText(" ");
                }
            });
            menu.add(anItem);
            anItem = new JMenuItem("Delete");
            anItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.mLabel.setText("Deleting logging source list from the TANGO database...");
                    loggingReceiver.deleteLoggingSourceProperty();
                    Main.this.mLabel.setText(" ");
                }
            });
            menu.add(anItem);
            anItem = new JMenuItem("Restore");
            anItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.mLabel.setText("Restoring logging sources from the TANGO database...");
                    loggingReceiver.removeAllSources();
                    loggingReceiver.getLoggingSourceProperty();
                    Main.this.mLabel.setText(" ");
                }
            });
            menu.add(anItem);
            actionMenu.add(menu);
        }
        String dev_name = loggingReceiver.getDeviceName();
        this.setTitle("Tango Log Viewer 2.0.1 [" + dev_name + "]");
        this.pack();
        this.setLocationRelativeTo((Component)splash);
        splash.setVisible(false);
        this.setVisible(true);
        splash.toFront();
        splash.setVisible(true);
        this.mLabel.setText(" ");
        splash.progress(splashProgression);
        splash.setVisible(false);
        splash.dispose();
        this.devTree.setVisible(true);
        if (!inited) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Main.cleanup();
                }
            });
            inited = true;
        }
    }

    private void exitBtnActionPerformed() {
        this.exitForm();
    }

    private void windowClosingPerformed() {
        this.exitForm();
    }

    public void exitForm() {
        if (this.closeOnExit) {
            this.setVisible(false);
            if (loggingReceiver != null) {
                loggingReceiver.removeAllSources();
            }
        } else {
            ExitAction.INSTANCE.actionPerformed(null);
        }
    }

    private void setupReceiver(String[] aArgs, MyTableModel aModel) {
        try {
            if (loggingReceiver == null) {
                loggingReceiver = new TangoLoggingReceiver(aArgs, aModel, this.mHistoryArea);
                loggingReceiver.start();
            } else {
                loggingReceiver.setTableModel(aModel);
                loggingReceiver.setHistoryArea(this.mHistoryArea);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"Unable to do an instance of TANGO log consumer device. Quiting", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Unable to do an instance of TANGO log consumer device. Quiting", "Tango Log Viewer", 0);
            this.exitForm();
        }
    }

    private void addLoggingSource() {
        Object n = this.devTree.getLastSelectedPathComponent();
        if (n == null) {
            return;
        }
        if (n instanceof DeviceNode) {
            String devname = ((DeviceNode)n).devName;
            this.mLabel.setText("Contacting " + devname + "...");
            if (loggingReceiver.addLoggingSource(devname) != -1) {
                this.mHistoryArea.write("Added " + devname);
            }
        }
        this.mLabel.reset();
    }

    private void addCoLocatedSources() {
        Object n = this.devTree.getLastSelectedPathComponent();
        if (n == null) {
            return;
        }
        if (n instanceof DeviceNode) {
            String deviceName = ((DeviceNode)n).devName;
            this.mLabel.setText("Adding  " + deviceName + " and colocated devices...");
            if (loggingReceiver.addCoLocatedSources(deviceName) != -1) {
                this.mHistoryArea.write("Added  " + deviceName + " and colocated devices");
            }
        }
        this.mLabel.reset();
    }

    private void removeLoggingSource() {
        Object n = this.devTree.getLastSelectedPathComponent();
        if (n == null) {
            return;
        }
        if (n instanceof DeviceNode) {
            String deviceName = ((DeviceNode)n).devName;
            this.mLabel.setText("Contacting " + deviceName + "...");
            if (loggingReceiver.removeLoggingSource(deviceName) != -1) {
                this.mHistoryArea.write("Removed " + deviceName);
            }
        }
        this.mLabel.reset();
    }

    private void removeCoLocatedSources() {
        Object n = this.devTree.getLastSelectedPathComponent();
        if (n == null) {
            return;
        }
        if (n instanceof DeviceNode) {
            String deviceName = ((DeviceNode)n).devName;
            this.mLabel.setText("Removing  " + deviceName + " and colocated devices...");
            if (loggingReceiver.removeCoLocatedSources(deviceName) != -1) {
                this.mHistoryArea.write("Removed  " + deviceName + " and colocated devices");
            }
        }
        this.mLabel.reset();
    }

    public void deviceTreeMousePressed(MouseEvent evt) {
        int selectedRow = this.devTree.getRowForLocation(evt.getX(), evt.getY());
        if (selectedRow != -1) {
            this.mPopupTrigger = evt.isPopupTrigger();
            this.devTree.setSelectionRow(selectedRow);
            Object n = this.devTree.getLastSelectedPathComponent();
            if (n == null) {
                return;
            }
            if (n instanceof DeviceNode) {
                LoggingLevelMenuItem item;
                this.mLabel.setText("Contacting " + ((DeviceNode)n).devName);
                int level = loggingReceiver.getDeviceLoggingLevel(((DeviceNode)n).devName);
                this.mLabel.reset();
                if (level == -1) {
                    return;
                }
                Enumeration<AbstractButton> enuma = this.mMemberLevelGroup1.getElements();
                while (enuma.hasMoreElements()) {
                    item = (LoggingLevelMenuItem)enuma.nextElement();
                    if (item.getLevel() != level) continue;
                    item.setSelected(true);
                    break;
                }
                enuma = this.mMemberLevelGroup2.getElements();
                while (enuma.hasMoreElements()) {
                    item = (LoggingLevelMenuItem)enuma.nextElement();
                    if (item.getLevel() != level) continue;
                    item.setSelected(true);
                    break;
                }
            }
        }
    }

    public void deviceTreeMouseReleased(MouseEvent evt) {
        int selectedRow = this.devTree.getRowForLocation(evt.getX(), evt.getY());
        if (selectedRow != -1 && (evt.isPopupTrigger() || this.mPopupTrigger)) {
            this.devTree.setSelectionRow(selectedRow);
            Object n = this.devTree.getLastSelectedPathComponent();
            if (n == null) {
                return;
            }
            LOG.debug((Object)("n is a " + n.getClass().getName()));
            if (n instanceof DeviceNode) {
                this.mMemberNameItem.setText(((DeviceNode)n).devName);
                this.mMemberPopup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private void initTree() {
        this.root = new RootNode(this.db);
        this.treeModel = new DefaultTreeModel(this.root);
        this.devTree = new JTree(this.treeModel);
        this.devTree.getSelectionModel().setSelectionMode(1);
        this.devTree.setMinimumSize(new Dimension(0, 0));
        this.devTree.setDragEnabled(true);
        this.devTree.setRootVisible(false);
        this.devTree.setShowsRootHandles(true);
        this.devTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Main.this.deviceTreeMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.deviceTreeMouseReleased(evt);
            }
        });
        this.treeView.getViewport().removeAll();
        this.treeView.getViewport().add(this.devTree);
    }

    public TangoNode searchNode(TangoNode startNode, String value) {
        int numChild = this.treeModel.getChildCount(startNode);
        int i = 0;
        boolean found = false;
        TangoNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoNode)this.treeModel.getChild(startNode, i);
            found = elem.toString().compareToIgnoreCase(value) == 0;
            if (found) continue;
            ++i;
        }
        if (found) {
            return elem;
        }
        return null;
    }

    public void refreshTree() {
        this.treeView.getViewport().removeAll();
        TreePath oldPath = this.devTree.getSelectionPath();
        if (this.db != null) {
            this.initTree();
        }
        if (oldPath != null) {
            TreePath newPath = new TreePath(this.root);
            TangoNode node = this.root;
            boolean found = true;
            int i = 1;
            while (found && i < oldPath.getPathCount()) {
                String item = oldPath.getPathComponent(i).toString();
                if ((node = this.searchNode(node, item)) != null) {
                    newPath = newPath.pathByAddingChild(node);
                    ++i;
                    continue;
                }
                found = false;
            }
            this.devTree.setSelectionPath(newPath);
            this.devTree.expandPath(newPath);
            this.devTree.makeVisible(newPath);
            this.devTree.scrollPathToVisible(newPath);
        }
    }

    public void selectDevice(String devName) {
        int bslash = devName.indexOf(47);
        int lslash = devName.lastIndexOf(47);
        String domain = devName.substring(0, bslash);
        String family = devName.substring(bslash + 1, lslash);
        String member = devName.substring(lslash + 1);
        TangoNode domainNode = this.searchNode(this.root, domain);
        if (domainNode == null) {
            return;
        }
        TangoNode familyNode = this.searchNode(domainNode, family);
        if (familyNode == null) {
            return;
        }
        TangoNode memberNode = this.searchNode(familyNode, member);
        if (memberNode == null) {
            return;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(domainNode);
        selPath = selPath.pathByAddingChild(familyNode);
        selPath = selPath.pathByAddingChild(memberNode);
        this.devTree.setSelectionPath(selPath);
        this.devTree.scrollPathToVisible(selPath);
    }

    public static void showTangoError(DevFailed e) {
        String result = "";
        if (e != null) {
            for (int i = 0; i < e.errors.length; ++i) {
                result = result + "Desc -> " + e.errors[i].desc + "\n";
                result = result + "Reason -> " + e.errors[i].reason + "\n";
                result = result + "Origin -> " + e.errors[i].origin + "\n";
            }
            if (result.length() > 0) {
                JOptionPane.showMessageDialog(self, result, "Tango error", 0);
            }
        }
    }

    private static void initLog4J() {
        Properties props = new Properties();
        props.setProperty("log4j.rootCategory", "ERROR, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)props);
    }

    public static void cleanup() {
        if (loggingReceiver != null) {
            loggingReceiver.cleanup();
            loggingReceiver = null;
        }
    }

    public static void main(String[] aArgs) {
        new Main(aArgs, false);
    }

    public class LogTableRowRenderer
    extends DefaultTableCellRenderer {
        private final Color _scolor = new Color(204, 204, 255);
        private final Color _color = new Color(230, 230, 230);
        private final JCheckBox _true = new JCheckBox("", true);
        private final JCheckBox _false = new JCheckBox("", false);

        LogTableRowRenderer() {
            this.setHorizontalAlignment(0);
            this._true.setHorizontalAlignment(0);
            this._false.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String col_header = (String)table.getColumnModel().getColumn(col).getHeaderValue();
            if (isSelected) {
                this.setBackground(this._scolor);
            } else if (col_header.equals("Level")) {
                Level level = (Level)value;
                if (level == Level.FATAL) {
                    this.setBackground(Color.black);
                    this.setForeground(Color.white);
                } else if (level == Level.ERROR) {
                    this.setBackground(Color.red);
                    this.setForeground(Color.black);
                } else if (level == Level.WARN) {
                    this.setBackground(Color.orange);
                    this.setForeground(Color.black);
                } else if (level == Level.INFO) {
                    this.setBackground(Color.green);
                    this.setForeground(Color.black);
                } else if (level == Level.DEBUG) {
                    this.setBackground(Color.cyan);
                    this.setForeground(Color.black);
                }
            } else {
                if (row % 2 == 0) {
                    this.setBackground(this._color);
                } else {
                    this.setBackground(Color.white);
                }
                this.setForeground(Color.black);
            }
            if (col_header.equals("Trace")) {
                return value == Boolean.TRUE ? this._true : this._false;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }

    private class CustomLabel
    extends JLabel {
        public CustomLabel() {
            super.setText(" ");
        }

        @Override
        public void setText(String txt) {
            super.setText(txt);
            this.update(this.getGraphics());
        }

        public void reset() {
            this.setText(" ");
        }
    }

    private class LoggingLevelMenu
    extends JMenu {
        public LoggingLevelMenu(String title, ButtonGroup _group, boolean add_before) {
            super(title);
            ButtonGroup group = _group != null ? _group : new ButtonGroup();
            LoggingLevelMenuItem lItem = new LoggingLevelMenuItem("OFF", 0);
            lItem.addActionListener(new LevelActionListener(add_before));
            lItem.setSelected(true);
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("FATAL", 1);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("ERROR", 2);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("WARN", 3);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("INFO", 4);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("DEBUG", 5);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
        }
    }

    private class LoggingLevelMenuItem
    extends JRadioButtonMenuItem {
        private int mLevel;

        public LoggingLevelMenuItem(String iText, int iLevel) {
            super(iText);
            this.mLevel = iLevel;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class LevelActionListener
    implements ActionListener {
        private boolean mAddBefore = false;

        public LevelActionListener(boolean add_before) {
            this.mAddBefore = add_before;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String levelStr = ((JMenuItem)e.getSource()).getText();
            Object n = Main.this.devTree.getLastSelectedPathComponent();
            if (n == null) {
                return;
            }
            if (n instanceof DeviceNode) {
                int level = ((LoggingLevelMenuItem)e.getSource()).getLevel();
                String devname = ((DeviceNode)n).devName;
                Main.this.mLabel.setText("Contacting " + devname + "...");
                if (loggingReceiver.setDeviceLoggingLevel(devname, level, this.mAddBefore) != -1) {
                    if (this.mAddBefore) {
                        Main.this.mHistoryArea.write("Added " + devname);
                    }
                    Main.this.mHistoryArea.write("Changed " + devname + " logging level to " + levelStr);
                }
            }
            Main.this.mLabel.reset();
        }
    }

    private class BasicLoggingLevelMenu
    extends JMenu {
        public BasicLoggingLevelMenu(String title) {
            super(title);
            BasicLoggingLevelMenuItem anItem = new BasicLoggingLevelMenuItem("OFF", 0);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("FATAL", 1);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("ERROR", 2);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("WARN", 3);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("INFO", 4);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("DEBUG", 5);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
        }
    }

    private class BasicLoggingLevelMenuItem
    extends JMenuItem {
        private int mLevel;

        public BasicLoggingLevelMenuItem(String iText, int iLevel) {
            super(iText);
            this.mLevel = iLevel;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class BasicLevelActionListener
    implements ActionListener {
        private BasicLevelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String levelStr = ((JMenuItem)e.getSource()).getText();
            Object n = Main.this.devTree.getLastSelectedPathComponent();
            if (n == null) {
                return;
            }
            if (n instanceof DeviceNode) {
                int level = ((BasicLoggingLevelMenuItem)e.getSource()).getLevel();
                String suffix = "logging level for colocated devices matching " + ((DeviceNode)n).devName + " to " + levelStr;
                Main.this.mLabel.setText("Changing " + suffix);
                if (loggingReceiver.setCoLocatedDevicesLoggingLevel(((DeviceNode)n).devName, level) != -1) {
                    Main.this.mHistoryArea.write("Changed " + suffix);
                }
            }
            Main.this.mLabel.reset();
        }
    }

    private class SourceListActionListener
    implements ActionListener {
        private SourceListActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.mHistoryArea.write("Current source list:");
            List<String> sources = loggingReceiver.getLoggingSources();
            if (sources.size() == 0) {
                Main.this.mHistoryArea.write("\t- none");
            } else {
                for (String source : sources) {
                    Main.this.mHistoryArea.write("\t- " + source);
                }
            }
        }
    }
}

