/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jive.DevWizard;
import jive.JiveUtils;
import jive.ServerDlg;
import jive3.IServerAction;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPipeNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelServer
extends TreePanel {
    String serverFilterString = "*";
    Pattern serverPattern = null;
    String[] serverList;

    public TreePanelServer(MainPanel parent) {
        this.invoker = parent;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    public void selectDevice(String className, String serverName, String devName) {
        int slash = serverName.indexOf(47);
        String server = serverName.substring(0, slash);
        String instance = serverName.substring(slash + 1);
        TangoNode srvNode = this.searchNode(this.root, server);
        if (srvNode == null) {
            return;
        }
        TangoNode instNode = this.searchNode(srvNode, instance);
        if (instNode == null) {
            return;
        }
        TangoNode classNode = this.searchNode(instNode, className);
        if (classNode == null) {
            return;
        }
        TangoNode devNode = this.searchNode(classNode, devName);
        if (devNode == null) {
            return;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(srvNode);
        selPath = selPath.pathByAddingChild(instNode);
        selPath = selPath.pathByAddingChild(classNode);
        selPath = selPath.pathByAddingChild(devNode);
        this.tree.setSelectionPath(selPath);
    }

    public void selectClass(String className, String serverName) {
        int slash = serverName.indexOf(47);
        String server = serverName.substring(0, slash);
        String instance = serverName.substring(slash + 1);
        TangoNode srvNode = this.searchNode(this.root, server);
        if (srvNode == null) {
            return;
        }
        TangoNode instNode = this.searchNode(srvNode, instance);
        if (instNode == null) {
            return;
        }
        TangoNode classNode = this.searchNode(instNode, className);
        if (classNode == null) {
            return;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(srvNode);
        selPath = selPath.pathByAddingChild(instNode);
        selPath = selPath.pathByAddingChild(classNode);
        this.tree.setSelectionPath(selPath);
    }

    public boolean isServer(String exeName) {
        TangoNode srvNode = this.searchNode(this.root, exeName);
        return srvNode != null;
    }

    public TangoNode selectFullServer(String serverName) {
        int slash = serverName.indexOf(47);
        String server = serverName.substring(0, slash);
        String instance = serverName.substring(slash + 1);
        TangoNode srvNode = this.searchNode(this.root, server);
        if (srvNode == null) {
            return null;
        }
        TangoNode instNode = this.searchNode(srvNode, instance);
        if (instNode == null) {
            return null;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(srvNode);
        selPath = selPath.pathByAddingChild(instNode);
        this.tree.setSelectionPath(selPath);
        return instNode;
    }

    public TangoNode selectServerRoot(String serverName) {
        TangoNode srvNode = this.searchNode(this.root, serverName);
        if (srvNode == null) {
            return null;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(srvNode);
        this.tree.setSelectionPath(selPath);
        return srvNode;
    }

    public void applyFilter(String filter) {
        this.serverFilterString = filter;
        if (filter.equals("*")) {
            this.serverPattern = null;
        } else if (filter.length() == 0) {
            this.serverPattern = null;
        } else {
            try {
                String f = this.filterToRegExp(this.serverFilterString);
                this.serverPattern = Pattern.compile(f);
            }
            catch (PatternSyntaxException e) {
                JOptionPane.showMessageDialog(this.invoker, e.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.serverFilterString;
    }

    public String[] getServerList() {
        return this.serverList;
    }

    class DeviceServerNode
    extends TangoNode {
        private String server;
        private String instance;
        private String className;
        private String devName;

        DeviceServerNode(String server, String instance, String className, String devName) {
            this.server = server;
            this.instance = instance;
            this.className = className;
            this.devName = devName;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelServer.this.self, TreePanelServer.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelServer.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelServer.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelServer.this.db, this.devName));
            this.add(new TaskPipeNode(TreePanelServer.this.db, this.devName));
            this.add(new AttributeNode(this.devName));
            this.add(new TaskLoggingNode(TreePanelServer.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.devName;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        String getValue() {
            return TreePanelServer.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }

        @Override
        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{10, 11, 13};
            }
            return new int[]{0, 1, 2, 3, 10, 11, 12, 13, 14, 15, 25};
        }

        @Override
        void execAction(int actionNumber) {
            switch (actionNumber) {
                case 0: {
                    JiveUtils.the_clipboard.clear();
                    JiveUtils.copyDeviceProperties(TreePanelServer.this.db, this.devName);
                    break;
                }
                case 1: {
                    TreePanelServer.this.pasteDeviceProperty(TreePanelServer.this.db, this.devName);
                    break;
                }
                case 2: {
                    String newName = JOptionPane.showInputDialog(null, "Rename device", this.devName);
                    if (newName == null) {
                        return;
                    }
                    if (!this.renameDevice(newName)) break;
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectDevice(this.className, this.server + "/" + this.instance, newName);
                    break;
                }
                case 3: {
                    int ok = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Delete device " + this.devName + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelServer.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelServer.this.refresh();
                    break;
                }
                case 10: {
                    new atkpanel.MainPanel(this.devName, false, true, !JiveUtils.readOnly);
                    break;
                }
                case 11: {
                    TreePanelServer.this.testDevice(this.devName);
                    break;
                }
                case 12: {
                    String alias = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (alias == null) {
                        return;
                    }
                    try {
                        TreePanelServer.this.db.put_device_alias(this.devName, alias);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 13: {
                    TreePanelServer.this.invoker.goToDeviceNode(this.devName);
                    break;
                }
                case 14: {
                    try {
                        DeviceProxy ds = new DeviceProxy("dserver/" + this.server + "/" + this.instance);
                        DeviceData in = new DeviceData();
                        in.insert(this.devName);
                        ds.command_inout("DevRestart", in);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 15: {
                    DevWizard dwdlg = new DevWizard(TreePanelServer.this.invoker);
                    dwdlg.showDeviceWizard(this.server + "/" + this.instance, this.className, this.devName);
                    break;
                }
                case 25: {
                    TreePanelServer.this.launchLogViewer(this.devName);
                }
            }
        }

        boolean renameDevice(String nDevName) {
            boolean isAlive = false;
            boolean success = false;
            try {
                DbDevImportInfo ii = TreePanelServer.this.db.import_device(nDevName);
                JiveUtils.showJiveError("The device " + nDevName + " already exits.\nServer: " + ii.server);
            }
            catch (DevFailed e1) {
                try {
                    TreePanelServer.this.db.add_device(nDevName, this.className, this.server + "/" + this.instance);
                    success = true;
                    DeviceProxy ds = null;
                    try {
                        ds = new DeviceProxy(this.devName);
                        ds.ping();
                        isAlive = true;
                    }
                    catch (DevFailed e2) {
                        // empty catch block
                    }
                    int ok = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Do you want to copy propeties of " + this.devName + " to " + nDevName + " ?", "Confirm propety move", 0);
                    if (ok == 0) {
                        String[] propList = TreePanelServer.this.db.get_device_property_list(this.devName, "*");
                        if (propList.length > 0) {
                            DbDatum[] data = TreePanelServer.this.db.get_device_property(this.devName, propList);
                            TreePanelServer.this.db.put_device_property(nDevName, data);
                        }
                        try {
                            String[] attList = TreePanelServer.this.db.get_device_attribute_list(this.devName);
                            if (attList.length > 0) {
                                DbAttribute[] adata = TreePanelServer.this.db.get_device_attribute_property(this.devName, attList);
                                TreePanelServer.this.db.put_device_attribute_property(nDevName, adata);
                            }
                        }
                        catch (DevFailed e3) {
                            JiveUtils.showJiveError("Failed to copy attribute properties of " + this.devName + "\n" + e3.errors[0].desc);
                        }
                    }
                    if (isAlive) {
                        JiveUtils.showJiveWarning("The old device " + this.devName + " is still alive and should be removed by hand.");
                    } else {
                        TreePanelServer.this.db.delete_device(this.devName);
                    }
                }
                catch (DevFailed e4) {
                    JiveUtils.showTangoError(e4);
                }
            }
            return success;
        }
    }

    class AttributeNode
    extends TangoNode {
        private String devName;

        AttributeNode(String devName) {
            this.devName = devName;
        }

        @Override
        void populateNode() throws DevFailed {
            int i;
            String[] list = new String[]{};
            String[] devList = new String[]{};
            String[] dbList = new String[]{};
            int idl = 0;
            DeviceProxy ds = new DeviceProxy(this.devName);
            try {
                devList = ds.get_attribute_list();
                idl = ds.get_idl_version();
            }
            catch (DevFailed e) {
                // empty catch block
            }
            dbList = TreePanelServer.this.db.get_device_attribute_list(this.devName);
            JiveUtils.sortList(list);
            for (i = 0; i < devList.length; ++i) {
                this.add(new TaskDeviceAttributePropertyNode(TreePanelServer.this.self, TreePanelServer.this.db, this.devName, devList[i], idl, false));
            }
            for (i = 0; i < dbList.length; ++i) {
                if (JiveUtils.contains(devList, dbList[i])) continue;
                this.add(new TaskDeviceAttributePropertyNode(TreePanelServer.this.self, TreePanelServer.this.db, this.devName, dbList[i], idl, true));
            }
        }

        @Override
        public int[] getAction() {
            return new int[]{0, 1, 30};
        }

        @Override
        public void execAction(int actionNumber) {
            switch (actionNumber) {
                case 30: {
                    TreePanelServer.this.createEmptyAttributeProperty(this.devName);
                    break;
                }
                case 0: {
                    int nbAtt = this.getChildCount();
                    JiveUtils.the_clipboard.clear();
                    for (int i = 0; i < nbAtt; ++i) {
                        TaskDeviceAttributePropertyNode node = (TaskDeviceAttributePropertyNode)this.getChildAt(i);
                        String[][] props = node.getProperties();
                        for (int j = 0; j < props.length; ++j) {
                            JiveUtils.the_clipboard.add(props[j][0], node.getAttributeName(), props[j][1]);
                        }
                    }
                    break;
                }
                case 1: {
                    JiveUtils.the_clipboard.parse();
                    for (int i = 0; i < JiveUtils.the_clipboard.getAttPropertyLength(); ++i) {
                        TreePanelServer.this.putAttributeProperty(this.devName, JiveUtils.the_clipboard.getAttName(i), JiveUtils.the_clipboard.getAttPropertyName(i), JiveUtils.the_clipboard.getAttPropertyValue(i));
                    }
                    break;
                }
            }
        }

        @Override
        public String toString() {
            return "Attribute properties";
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }
    }

    class ClassNode
    extends TangoNode
    implements IServerAction {
        private String server;
        private String instance;
        private String className;
        private String[] devList = new String[0];

        ClassNode(String server, String instance, String className) {
            this.server = server;
            this.instance = instance;
            this.className = className;
            try {
                this.devList = TreePanelServer.this.db.get_device_name(server + "/" + instance, className);
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }

        @Override
        void populateNode() throws DevFailed {
            for (int i = 0; i < this.devList.length; ++i) {
                this.add(new DeviceServerNode(this.server, this.instance, this.className, this.devList[i]));
            }
        }

        @Override
        public boolean isLeaf() {
            return this.devList.length == 0;
        }

        @Override
        ImageIcon getIcon() {
            if (this.devList.length == 0) {
                return TangoNodeRenderer.uclassicon;
            }
            return TangoNodeRenderer.classicon;
        }

        @Override
        public String toString() {
            return this.className;
        }

        @Override
        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[0];
            }
            return new int[]{2, 3, 8, 9};
        }

        @Override
        void execAction(int actionNumber) {
            switch (actionNumber) {
                case 2: {
                    String newName = JOptionPane.showInputDialog(null, "Rename class", this.className);
                    if (newName == null) {
                        return;
                    }
                    if (TreePanelServer.this.searchNode((TangoNode)this.getParent(), newName) != null) {
                        JiveUtils.showJiveError("Name already exists.");
                        return;
                    }
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode n0 = (TangoNode)this.getChildAt(i);
                        try {
                            TreePanelServer.this.db.add_device(n0.toString(), newName, this.server + "/" + this.instance);
                            continue;
                        }
                        catch (DevFailed e) {
                            JiveUtils.showTangoError(e);
                        }
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectClass(newName, this.server + "/" + this.instance);
                    break;
                }
                case 3: {
                    int ok = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Delete class " + this.className + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode n0 = (TangoNode)this.getChildAt(i);
                        try {
                            TreePanelServer.this.db.delete_device(n0.toString());
                            continue;
                        }
                        catch (DevFailed e) {
                            JiveUtils.showTangoError(e);
                        }
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectFullServer(this.server + "/" + this.instance);
                    break;
                }
                case 8: {
                    ServerDlg sdlg = new ServerDlg(this);
                    sdlg.setValidFields(false, false);
                    sdlg.setDefaults(this.server + "/" + this.instance, this.className);
                    ATKGraphicsUtils.centerFrame((JComponent)TreePanelServer.this.invoker.innerPanel, (Frame)sdlg);
                    sdlg.setVisible(true);
                    break;
                }
                case 9: {
                    DevWizard dswdlg = new DevWizard(TreePanelServer.this.invoker);
                    dswdlg.showDevicesWizard(this.server + "/" + this.instance, this.className);
                    TreePanelServer.this.refresh();
                }
            }
        }

        @Override
        public void doJob(String server, String classname, String[] devices) {
            try {
                for (int i = 0; i < devices.length; ++i) {
                    TreePanelServer.this.db.add_device(devices[i], classname, server);
                }
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
            TreePanelServer.this.refresh();
            TreePanelServer.this.selectClass(classname, server);
        }
    }

    class InstanceNode
    extends TangoNode
    implements IServerAction {
        private String server;
        private String instance;

        InstanceNode(String server, String instance) {
            this.server = server;
            this.instance = instance;
        }

        @Override
        void populateNode() throws DevFailed {
            String[] srvList = null;
            String[] dbList = null;
            try {
                String admName = "dserver/" + this.server + "/" + this.instance;
                DeviceProxy adm = new DeviceProxy(admName);
                DeviceData datum = adm.command_inout("QueryClass");
                srvList = datum.extractStringArray();
            }
            catch (DevFailed e) {
                // empty catch block
            }
            dbList = TreePanelServer.this.db.get_server_class_list(this.server + "/" + this.instance);
            if (srvList != null) {
                int i;
                for (i = 0; i < srvList.length; ++i) {
                    this.add(new ClassNode(this.server, this.instance, srvList[i]));
                }
                for (i = 0; i < dbList.length; ++i) {
                    if (JiveUtils.contains(srvList, dbList[i])) continue;
                    this.add(new ClassNode(this.server, this.instance, dbList[i]));
                }
            } else {
                for (int i = 0; i < dbList.length; ++i) {
                    this.add(new ClassNode(this.server, this.instance, dbList[i]));
                }
            }
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.srvicon;
        }

        @Override
        public String toString() {
            return this.instance;
        }

        @Override
        String getValue() {
            String result = "";
            try {
                DbServInfo info = TreePanelServer.this.db.get_server_info(this.server + "/" + this.instance);
                result = info.toString();
            }
            catch (DevFailed e) {
                for (int i = 0; i < e.errors.length; ++i) {
                    result = result + "Desc -> " + e.errors[i].desc + "\n";
                    result = result + "Reason -> " + e.errors[i].reason + "\n";
                    result = result + "Origin -> " + e.errors[i].origin + "\n";
                }
            }
            return result;
        }

        @Override
        String getTitle() {
            return "Server Info";
        }

        @Override
        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{5, 6};
            }
            return new int[]{2, 3, 4, 5, 6, 7, 19, 26, 27, 29};
        }

        @Override
        void execAction(int actionNumber) {
            switch (actionNumber) {
                case 2: {
                    String newName = JOptionPane.showInputDialog(null, "Rename instance", this.instance);
                    if (newName == null) {
                        return;
                    }
                    if (TreePanelServer.this.searchNode((TangoNode)this.getParent(), newName) != null) {
                        JiveUtils.showJiveError("Name already exists.");
                        return;
                    }
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode n0 = (TangoNode)this.getChildAt(i);
                        for (int j = 0; j < n0.getChildCount(); ++j) {
                            TangoNode n1 = (TangoNode)n0.getChildAt(j);
                            try {
                                TreePanelServer.this.db.add_device(n1.toString(), n0.toString(), this.server + "/" + newName);
                                continue;
                            }
                            catch (DevFailed e) {
                                JiveUtils.showTangoError(e);
                            }
                        }
                    }
                    try {
                        TreePanelServer.this.db.delete_server(this.server + "/" + this.instance);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectFullServer(this.server + "/" + newName);
                    break;
                }
                case 3: {
                    int ok = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Delete server " + this.server + "/" + this.instance + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelServer.this.db.delete_server(this.server + "/" + this.instance);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectServerRoot(this.server);
                    break;
                }
                case 4: {
                    ServerDlg sdlg = new ServerDlg(this);
                    sdlg.setClassList(TreePanelServer.this.invoker.getClassTreePanel().getClassList());
                    sdlg.setValidFields(false, true);
                    sdlg.setDefaults(this.server + "/" + this.instance, "");
                    ATKGraphicsUtils.centerFrame((JComponent)TreePanelServer.this.invoker.innerPanel, (Frame)sdlg);
                    sdlg.setVisible(true);
                    break;
                }
                case 5: {
                    TreePanelServer.this.testDevice("dserver/" + this.server + "/" + this.instance);
                    break;
                }
                case 6: {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser(".");
                    int ok = 0;
                    if (TreePanel.lastFile != null) {
                        chooser.setSelectedFile(TreePanel.lastFile);
                    }
                    if ((returnVal = chooser.showSaveDialog(TreePanelServer.this.invoker)) != 0 || (TreePanel.lastFile = chooser.getSelectedFile()) == null) break;
                    if (TreePanel.lastFile.exists()) {
                        ok = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "Do you want to overwrite " + TreePanel.lastFile.getName() + " ?", "Confirm overwrite", 0);
                    }
                    if (ok != 0) break;
                    try {
                        FileWriter resFile = new FileWriter(TreePanel.lastFile.getAbsolutePath());
                        Date date = new Date(System.currentTimeMillis());
                        resFile.write("#\n# Resource backup , created " + date + "\n#\n\n");
                        TreePanelServer.this.saveServerData(resFile, this.server + "/" + this.instance);
                        resFile.close();
                    }
                    catch (IOException e) {
                        JiveUtils.showJiveError("Failed to create resource file !\n" + e.getMessage());
                    }
                    break;
                }
                case 7: {
                    DevWizard cwdlg = new DevWizard(TreePanelServer.this.invoker);
                    cwdlg.showClassesWizard(this.server + "/" + this.instance);
                    TreePanelServer.this.refresh();
                    break;
                }
                case 19: {
                    String srvName = this.server + "/" + this.instance;
                    int ok = JOptionPane.showConfirmDialog(TreePanelServer.this.invoker, "This will unexport all devices of " + srvName + "\n Do you want to continue ?", "Confirm unexport device", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelServer.this.db.unexport_server(srvName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 26: {
                    TreePanelServer.this.launchDevDepend(this.server + "/" + this.instance);
                    break;
                }
                case 27: {
                    TreePanelServer.this.launchPollingThreadsManager(this.server + "/" + this.instance);
                    break;
                }
                case 29: {
                    String newSName = JOptionPane.showInputDialog(null, "Rename server", this.server + "/" + this.instance);
                    if (newSName == null) {
                        return;
                    }
                    try {
                        TreePanelServer.this.db.rename_server(this.server + "/" + this.instance, newSName);
                        TreePanelServer.this.refresh();
                        TreePanelServer.this.selectFullServer(newSName);
                        break;
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                }
            }
        }

        @Override
        public void doJob(String server, String classname, String[] devices) {
            try {
                for (int i = 0; i < devices.length; ++i) {
                    TreePanelServer.this.db.add_device(devices[i], classname, server);
                }
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
            TreePanelServer.this.refresh();
            TreePanelServer.this.selectClass(classname, server);
        }
    }

    class ServerNode
    extends TangoNode {
        private String server;

        ServerNode(String server) {
            this.server = server;
        }

        @Override
        void populateNode() throws DevFailed {
            String[] list = TreePanelServer.this.db.get_instance_name_list(this.server);
            for (int i = 0; i < list.length; ++i) {
                this.add(new InstanceNode(this.server, list[i]));
            }
        }

        @Override
        public String toString() {
            return this.server;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.srvicon;
        }

        @Override
        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[0];
            }
            return new int[]{2};
        }

        @Override
        void execAction(int actionNumber) {
            switch (actionNumber) {
                case 2: {
                    String newName = JOptionPane.showInputDialog(null, "Rename server", this.server);
                    if (newName == null) {
                        return;
                    }
                    if (TreePanelServer.this.searchNodeCaseSensitive(TreePanelServer.this.root, newName) != null) {
                        JiveUtils.showJiveError("Name already exists.");
                        return;
                    }
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode n0 = (TangoNode)this.getChildAt(i);
                        for (int j = 0; j < n0.getChildCount(); ++j) {
                            TangoNode n1 = (TangoNode)n0.getChildAt(j);
                            for (int k = 0; k < n1.getChildCount(); ++k) {
                                TangoNode n2 = (TangoNode)n1.getChildAt(k);
                                try {
                                    TreePanelServer.this.db.add_device(n2.toString(), n1.toString(), newName + "/" + n0.toString());
                                    continue;
                                }
                                catch (DevFailed e) {
                                    JiveUtils.showTangoError(e);
                                }
                            }
                        }
                        if (newName.equalsIgnoreCase(this.server)) continue;
                        try {
                            TreePanelServer.this.db.delete_server(this.server + "/" + n0.toString());
                            continue;
                        }
                        catch (DevFailed e) {
                            JiveUtils.showTangoError(e);
                        }
                    }
                    TreePanelServer.this.refresh();
                    TreePanelServer.this.selectServerRoot(newName);
                }
            }
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            TreePanelServer.this.serverList = TreePanelServer.this.db.get_server_name_list();
            for (int i = 0; i < TreePanelServer.this.serverList.length; ++i) {
                if (TreePanelServer.this.serverPattern != null) {
                    Matcher matcher = TreePanelServer.this.serverPattern.matcher(TreePanelServer.this.serverList[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != TreePanelServer.this.serverList[i].length()) continue;
                    this.add(new ServerNode(TreePanelServer.this.serverList[i]));
                    continue;
                }
                this.add(new ServerNode(TreePanelServer.this.serverList[i]));
            }
        }

        @Override
        public String toString() {
            return "Server:";
        }

        @Override
        void execAction(int number) {
        }
    }
}

