/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskClassAttributePropertyNode;
import jive3.TaskClassPropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelClass
extends TreePanel {
    String classFilterString = "*";
    Pattern classPattern = null;
    String[] classList;

    public TreePanelClass(MainPanel parent) {
        this.invoker = parent;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    void addAttribute(TangoNode attNode, String className, String attName) {
        if (this.searchNode(attNode, attName) != null) {
            JOptionPane.showMessageDialog(null, "Attribute already exists", "Error", 0);
            return;
        }
        this.treeModel.insertNodeInto(new TaskClassAttributePropertyNode(this.self, this.db, className, attName), attNode, 0);
    }

    public void applyFilter(String filter) {
        this.classFilterString = filter;
        if (filter.equals("*")) {
            this.classPattern = null;
        } else if (filter.length() == 0) {
            this.classPattern = null;
        } else {
            try {
                String f = this.filterToRegExp(this.classFilterString);
                this.classPattern = Pattern.compile(f);
            }
            catch (PatternSyntaxException e) {
                JOptionPane.showMessageDialog(this.invoker, e.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.classFilterString;
    }

    public String[] getClassList() {
        return this.classList;
    }

    class DeviceNode
    extends TangoNode {
        private String devName;

        DeviceNode(String devName) {
            this.devName = devName;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelClass.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelClass.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelClass.this.db, this.devName));
            this.add(new AttributeNode(this.devName));
            this.add(new TaskLoggingNode(TreePanelClass.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.devName;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        String getValue() {
            return TreePanelClass.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }

        @Override
        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{10, 11, 16};
            }
            return new int[]{0, 1, 3, 10, 11, 12, 16, 14, 25};
        }

        @Override
        void execAction(int actionNumber) {
            switch (actionNumber) {
                case 0: {
                    JiveUtils.the_clipboard.clear();
                    JiveUtils.copyDeviceProperties(TreePanelClass.this.db, this.devName);
                    break;
                }
                case 1: {
                    TreePanelClass.this.pasteDeviceProperty(TreePanelClass.this.db, this.devName);
                    break;
                }
                case 3: {
                    int ok = JOptionPane.showConfirmDialog(TreePanelClass.this.invoker, "Delete device " + this.devName + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelClass.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelClass.this.refresh();
                    break;
                }
                case 10: {
                    new atkpanel.MainPanel(this.devName, false, true, !JiveUtils.readOnly);
                    break;
                }
                case 11: {
                    TreePanelClass.this.testDevice(this.devName);
                    break;
                }
                case 12: {
                    String alias = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (alias == null) {
                        return;
                    }
                    try {
                        TreePanelClass.this.db.put_device_alias(this.devName, alias);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 16: {
                    try {
                        DbDevImportInfo info = TreePanelClass.this.db.import_device(this.devName);
                        TreePanelClass.this.invoker.goToServerFullNode(info.server);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 14: {
                    try {
                        DbDevImportInfo info = TreePanelClass.this.db.import_device(this.devName);
                        DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
                        DeviceData in = new DeviceData();
                        in.insert(this.devName);
                        ds.command_inout("DevRestart", in);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 25: {
                    TreePanelClass.this.launchLogViewer(this.devName);
                }
            }
        }
    }

    class DevicesNode
    extends TangoNode {
        private String className;

        DevicesNode(String className) {
            this.className = className;
        }

        @Override
        void populateNode() throws DevFailed {
            DeviceData argin = new DeviceData();
            String request = "select name from device where class='" + this.className + "' order by name";
            argin.insert(request);
            DeviceData argout = TreePanelClass.this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            for (int i = 0; i < arg.svalue.length; ++i) {
                this.add(new DeviceNode(arg.svalue[i]));
            }
        }

        @Override
        public String toString() {
            return "Devices";
        }

        @Override
        public int[] getAction() {
            return new int[0];
        }

        @Override
        public void execAction(int action) {
        }
    }

    class AttributeNode
    extends TangoNode {
        private String className;

        AttributeNode(String className) {
            this.className = className;
        }

        @Override
        void populateNode() throws DevFailed {
            String[] list = TreePanelClass.this.db.get_class_attribute_list(this.getParent().toString(), "*");
            for (int i = 0; i < list.length; ++i) {
                this.add(new TaskClassAttributePropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.className, list[i]));
            }
        }

        @Override
        public String toString() {
            return "Attribute properties";
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }

        @Override
        public int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[0];
            }
            return new int[]{18};
        }

        @Override
        public void execAction(int action) {
            switch (action) {
                case 18: {
                    String newName = JOptionPane.showInputDialog(null, "Add class attribute", "");
                    if (newName == null) {
                        return;
                    }
                    TreePanelClass.this.addAttribute(this, this.className, newName);
                }
            }
        }
    }

    class ClassNode
    extends TangoNode {
        private String className;

        ClassNode(String className) {
            this.className = className;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskClassPropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.className));
            this.add(new AttributeNode(this.className));
            this.add(new DevicesNode(this.className));
        }

        @Override
        public String toString() {
            return this.className;
        }

        @Override
        void execAction(int number) {
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            TreePanelClass.this.classList = TreePanelClass.this.db.get_class_list("*");
            for (int i = 0; i < TreePanelClass.this.classList.length; ++i) {
                if (TreePanelClass.this.classPattern != null) {
                    Matcher matcher = TreePanelClass.this.classPattern.matcher(TreePanelClass.this.classList[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != TreePanelClass.this.classList[i].length()) continue;
                    this.add(new ClassNode(TreePanelClass.this.classList[i]));
                    continue;
                }
                this.add(new ClassNode(TreePanelClass.this.classList[i]));
            }
        }

        @Override
        public String toString() {
            return "Class:";
        }

        @Override
        void execAction(int number) {
        }
    }
}

