/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPipeNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelAlias
extends TreePanel {
    String aliasFilterString = "*";
    Pattern aliasPattern = null;

    public TreePanelAlias(MainPanel parent) {
        this.invoker = parent;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    public void applyFilter(String filter) {
        this.aliasFilterString = filter;
        if (filter.equals("*")) {
            this.aliasPattern = null;
        } else if (filter.length() == 0) {
            this.aliasPattern = null;
        } else {
            try {
                String f = this.filterToRegExp(this.aliasFilterString);
                this.aliasPattern = Pattern.compile(f);
            }
            catch (PatternSyntaxException e) {
                JOptionPane.showMessageDialog(this.invoker, e.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.aliasFilterString;
    }

    class AliasNode
    extends TangoNode {
        private String aliasName = null;
        private String devName = null;

        AliasNode(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        void populateNode() throws DevFailed {
            this.devName = TreePanelAlias.this.db.get_device_from_alias(this.aliasName);
            this.add(new TaskDevicePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskPipeNode(TreePanelAlias.this.db, this.devName));
            this.add(new AttributeNode(this.devName));
            this.add(new TaskLoggingNode(TreePanelAlias.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.aliasName;
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        public int[] getAction() {
            return new int[]{11, 13, 3};
        }

        public void goToDeviceNode() {
            try {
                if (this.devName == null) {
                    this.devName = TreePanelAlias.this.db.get_device_from_alias(this.aliasName);
                }
                TreePanelAlias.this.invoker.goToDeviceNode(this.devName);
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
        }

        @Override
        public void execAction(int actionNumber) {
            switch (actionNumber) {
                case 3: {
                    int ok = JOptionPane.showConfirmDialog(TreePanelAlias.this.invoker, "Delete alias " + this.aliasName + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelAlias.this.db.delete_device_alias(this.aliasName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelAlias.this.refresh();
                    break;
                }
                case 11: {
                    TreePanelAlias.this.testDevice(this.aliasName);
                    break;
                }
                case 13: {
                    this.goToDeviceNode();
                }
            }
        }

        @Override
        String getValue() {
            if (this.devName == null) {
                try {
                    this.devName = TreePanelAlias.this.db.get_device_from_alias(this.aliasName);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
            }
            return TreePanelAlias.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }
    }

    class AttributeNode
    extends TangoNode {
        private String devName;

        AttributeNode(String devName) {
            this.devName = devName;
        }

        @Override
        void populateNode() throws DevFailed {
            int i;
            String[] list = new String[]{};
            String[] devList = new String[]{};
            String[] dbList = new String[]{};
            int idl = 0;
            DeviceProxy ds = new DeviceProxy(this.devName);
            try {
                devList = ds.get_attribute_list();
                idl = ds.get_idl_version();
            }
            catch (DevFailed e) {
                // empty catch block
            }
            dbList = TreePanelAlias.this.db.get_device_attribute_list(this.devName);
            JiveUtils.sortList(list);
            for (i = 0; i < devList.length; ++i) {
                this.add(new TaskDeviceAttributePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName, devList[i], idl, false));
            }
            for (i = 0; i < dbList.length; ++i) {
                if (JiveUtils.contains(devList, dbList[i])) continue;
                this.add(new TaskDeviceAttributePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName, dbList[i], idl, true));
            }
        }

        @Override
        public String toString() {
            return "Attribute properties";
        }

        @Override
        public int[] getAction() {
            return new int[]{30};
        }

        @Override
        public void execAction(int actionNumber) {
            switch (actionNumber) {
                case 30: {
                    TreePanelAlias.this.createEmptyAttributeProperty(this.devName);
                }
            }
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            String[] list = TreePanelAlias.this.db.get_device_alias_list("*");
            for (int i = 0; i < list.length; ++i) {
                if (TreePanelAlias.this.aliasPattern != null) {
                    Matcher matcher = TreePanelAlias.this.aliasPattern.matcher(list[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != list[i].length()) continue;
                    this.add(new AliasNode(list[i]));
                    continue;
                }
                this.add(new AliasNode(list[i]));
            }
        }

        @Override
        public String toString() {
            return "Alias:";
        }

        @Override
        void execAction(int number) {
        }
    }
}

