/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.PoolThreadsManager;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.ExecDev;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoClassSelector;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public abstract class TreePanel
extends JPanel
implements TreeSelectionListener,
MouseListener,
TreeExpansionListener {
    protected JTree tree;
    protected JScrollPane treeView = null;
    protected DefaultTreeModel treeModel;
    protected TangoNode root;
    protected Database db;
    MainPanel invoker;
    TreePanel self;
    private boolean updateOnChange;
    public static final int ACTION_NUMBER = 43;
    public static final int ACTION_COPY = 0;
    public static final int ACTION_PASTE = 1;
    public static final int ACTION_RENAME = 2;
    public static final int ACTION_DELETE = 3;
    public static final int ACTION_ADDCLASS = 4;
    public static final int ACTION_TESTADMIN = 5;
    public static final int ACTION_SAVESERVER = 6;
    public static final int ACTION_CLASSWIZ = 7;
    public static final int ACTION_ADDDEVICE = 8;
    public static final int ACTION_DEVICESWIZ = 9;
    public static final int ACTION_MONITORDEV = 10;
    public static final int ACTION_TESTDEV = 11;
    public static final int ACTION_DEFALIAS = 12;
    public static final int ACTION_GOTODEVNODE = 13;
    public static final int ACTION_RESTART = 14;
    public static final int ACTION_DEVICEWIZ = 15;
    public static final int ACTION_GOTOSERVNODE = 16;
    public static final int ACTION_GOTOADMINNODE = 17;
    public static final int ACTION_ADDCLASSATT = 18;
    public static final int ACTION_UNEXPORT = 19;
    public static final int ACTION_SELECT_PROP = 20;
    public static final int ACTION_SELECT_POLLING = 21;
    public static final int ACTION_SELECT_EVENT = 22;
    public static final int ACTION_SELECT_ATTCONF = 23;
    public static final int ACTION_SELECT_LOGGING = 24;
    public static final int ACTION_LOG_VIEWER = 25;
    public static final int ACTION_DEV_DEPEND = 26;
    public static final int ACTION_THREAD_POLL = 27;
    public static final int ACTION_VIEW_HISTORY = 28;
    public static final int ACTION_MOVE_SERVER = 29;
    public static final int ACTION_CREATE_ATTPROP = 30;
    public static final int ACTION_START_SERVER = 31;
    public static final int ACTION_STOP_SERVER = 32;
    public static final int ACTION_RESTART_SERVER = 33;
    public static final int ACTION_START_LEVEL = 34;
    public static final int ACTION_STOP_LEVEL = 35;
    public static final int ACTION_START_HOST = 36;
    public static final int ACTION_STOP_HOST = 37;
    public static final int ACTION_CH_HOST_USAGE = 38;
    public static final int ACTION_GO_TO_STATER = 39;
    public static final int ACTION_CH_LEVEL = 40;
    public static final int ACTION_TERMINAL = 41;
    public static final int ACTION_NEW_SERVERS = 42;
    private static TangoNode[] selectedNodes = null;
    static File lastFile = null;
    private static JPopupMenu actionMenu = new JPopupMenu();
    private static JMenuItem copyMenu = new JMenuItem("Copy");
    private static JMenuItem pasteMenu;
    private static JMenuItem renameMenu;
    private static JMenuItem deleteMenu;
    private static JMenuItem addClassMenu;
    private static JMenuItem testAdminMenu;
    private static JMenuItem saveServerMenu;
    private static JMenuItem classWizMenu;
    private static JMenuItem addDeviceMenu;
    private static JMenuItem devicesWizMenu;
    private static JMenuItem monitorMenu;
    private static JMenuItem testMenu;
    private static JMenuItem aliasMenu;
    private static JMenuItem goToDevMenu;
    private static JMenuItem restartMenu;
    private static JMenuItem deviceWizMenu;
    private static JMenuItem goToServMenu;
    private static JMenuItem goToAdminMenu;
    private static JMenuItem addClassAttMenu;
    private static JMenuItem unexportDevices;
    private static JMenuItem selectPropNodeMenu;
    private static JMenuItem selectPollingNodeMenu;
    private static JMenuItem selectEventNodeMenu;
    private static JMenuItem selectAttConfNodeMenu;
    private static JMenuItem selectLoggingNodeMenu;
    private static JMenuItem logviewerMenu;
    private static JMenuItem devDependMenu;
    private static JMenuItem threadPollMenu;
    private static JMenuItem viewHistoryMenu;
    private static JMenuItem moveServerMenu;
    private static JMenuItem createAttPropMenu;
    private static JMenuItem startServerMenu;
    private static JMenuItem stopServerMenu;
    private static JMenuItem restartServerMenu;
    private static JMenuItem startLevelMenu;
    private static JMenuItem stopLevelMenu;
    private static JMenuItem startHostMenu;
    private static JMenuItem stopHostMenu;
    private static JMenuItem chHostUsageMenu;
    private static JMenuItem goToStarterMenu;
    private static JMenuItem chLevelMenu;
    private static JMenuItem terminalMenu;
    private static JMenuItem newServersMenu;

    abstract TangoNode createRoot();

    public void initTree() {
        this.root = this.createRoot();
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TangoNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tree.addMouseListener(this);
        this.tree.addTreeSelectionListener(this);
        this.tree.setToggleClickCount(0);
        this.treeView = new JScrollPane(this.tree);
        this.add((Component)this.treeView, "Center");
        this.updateOnChange = true;
        this.tree.addTreeExpansionListener(this);
    }

    public void setDatabase(Database db) {
        this.db = db;
        if (this.treeView != null) {
            this.remove(this.treeView);
            this.treeView = null;
        }
        if (db != null) {
            this.initTree();
        } else {
            this.repaint();
        }
    }

    public void refresh() {
        if (this.treeView == null) {
            return;
        }
        TreePath oldPath = this.tree.getSelectionPath();
        this.remove(this.treeView);
        if (this.db != null) {
            this.initTree();
        }
        this.invoker.resetNavigation();
        this.selectPath(oldPath);
    }

    public void selectPath(TreePath path) {
        if (path != null) {
            TreePath newPath = new TreePath(this.root);
            TangoNode node = this.root;
            boolean found = true;
            int i = 1;
            while (found && i < path.getPathCount()) {
                String item = path.getPathComponent(i).toString();
                if ((node = this.searchNode(node, item)) != null) {
                    newPath = newPath.pathByAddingChild(node);
                    ++i;
                    continue;
                }
                found = false;
            }
            this.tree.setSelectionPath(newPath);
            this.tree.expandPath(newPath);
            this.tree.makeVisible(newPath);
            this.tree.scrollPathToVisible(newPath);
        }
    }

    public void refreshValues() {
        if (this.treeView == null) {
            return;
        }
        TreePath[] selPaths = this.tree.getSelectionPaths();
        if (selPaths != null) {
            TangoNode[] nodes = new TangoNode[selPaths.length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = (TangoNode)selPaths[i].getLastPathComponent();
            }
            this.invoker.updatePanel(nodes);
            if (selPaths.length == 1) {
                this.tree.scrollPathToVisible(selPaths[0]);
            }
        } else {
            this.invoker.updatePanel(null);
        }
    }

    public boolean isRootItem(String itemName) {
        TangoNode node = this.searchNodeStartingWith(this.root, itemName);
        return node != null;
    }

    public TreePath selectRootItem(String itemName) {
        TangoNode node = this.searchNodeStartingWith(this.root, itemName);
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(node);
        this.tree.setSelectionPath(selPath);
        return selPath;
    }

    public TangoNode searchNode(TangoNode startNode, String value) {
        int numChild = this.treeModel.getChildCount(startNode);
        int i = 0;
        boolean found = false;
        TangoNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoNode)this.treeModel.getChild(startNode, i);
            found = elem.toString().compareToIgnoreCase(value) == 0;
            if (found) continue;
            ++i;
        }
        if (found) {
            return elem;
        }
        return null;
    }

    public TangoNode searchNodeStartingWith(TangoNode startNode, String value) {
        int numChild = this.treeModel.getChildCount(startNode);
        int i = 0;
        boolean found = false;
        TangoNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoNode)this.treeModel.getChild(startNode, i);
            found = elem.toString().toLowerCase().startsWith(value.toLowerCase());
            if (found) continue;
            ++i;
        }
        if (found) {
            return elem;
        }
        return null;
    }

    public TangoNode searchNodeCaseSensitive(TangoNode startNode, String value) {
        int numChild = this.treeModel.getChildCount(startNode);
        int i = 0;
        boolean found = false;
        TangoNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoNode)this.treeModel.getChild(startNode, i);
            found = elem.toString().compareTo(value) == 0;
            if (found) continue;
            ++i;
        }
        if (found) {
            return elem;
        }
        return null;
    }

    public void testDevice(String devName) {
        JDialog dlg = new JDialog((Frame)this.invoker, false);
        dlg.setTitle("Device Panel [" + devName + "]");
        try {
            ExecDev p = new ExecDev(devName);
            dlg.setContentPane(p);
            JiveUtils.centerDialog(dlg);
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void pasteDeviceProperty(Database db, String devname) {
        try {
            int i;
            JiveUtils.the_clipboard.parse();
            for (i = 0; i < JiveUtils.the_clipboard.getObjectPropertyLength(); ++i) {
                db.put_device_property(devname, JiveUtils.makeDbDatum(JiveUtils.the_clipboard.getObjectPropertyName(i), JiveUtils.the_clipboard.getObjectPropertyValue(i)));
            }
            for (i = 0; i < JiveUtils.the_clipboard.getAttPropertyLength(); ++i) {
                DbAttribute att = new DbAttribute(JiveUtils.the_clipboard.getAttName(i));
                att.add(JiveUtils.the_clipboard.getAttPropertyName(i), JiveUtils.the_clipboard.getAttPropertyValue(i));
                db.put_device_attribute_property(devname, att);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public String getDeviceInfo(String devName) {
        String result = "";
        try {
            DeviceProxy ds = new DeviceProxy(devName);
            result = "<b>Device Info</b>\n<hr>\n";
            result = result + ds.get_info().toString();
            result = result + "\n\n<b>Polling Status</b>\n<hr>\n";
            String[] pi = ds.polling_status();
            for (int i = 0; i < pi.length; ++i) {
                result = result + pi[i] + "\n\n";
            }
        }
        catch (DevFailed e) {
            for (int i = 0; i < e.errors.length; ++i) {
                result = result + "Desc -> " + e.errors[i].desc + "\n";
                result = result + "Reason -> " + e.errors[i].reason + "\n";
                result = result + "Origin -> " + e.errors[i].origin + "\n";
            }
        }
        return result;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.updateOnChange) {
            this.refreshValues();
        }
    }

    public void refreshNode(TangoNode node, String childToSelect) {
        node.clearNodes();
        node.getChildCount();
        this.treeModel.nodeStructureChanged(node);
        if (childToSelect != null) {
            Object[] nodes = node.getPath();
            TreePath path = new TreePath(nodes);
            TangoNode subNode = this.searchNode(node, childToSelect);
            path = path.pathByAddingChild(subNode);
            this.tree.setSelectionPath(path);
            this.tree.expandPath(path);
            this.tree.makeVisible(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    private void createSelectedNodes(int desriedLength) {
        if (selectedNodes == null) {
            selectedNodes = new TangoNode[desriedLength];
        } else if (selectedNodes.length != desriedLength) {
            selectedNodes = new TangoNode[desriedLength];
        }
    }

    private TreePath getNodePath(TangoNode node) {
        Object[] pNodes = node.getPath();
        return new TreePath(pNodes);
    }

    private boolean isGoodClass(String devName, String className, String[] devList) {
        boolean found = false;
        for (int i = 0; i < devList.length && !found; i += 2) {
            found = devList[i].equalsIgnoreCase(devName);
            if (!found) continue;
            return devList[i + 1].equalsIgnoreCase(className);
        }
        return false;
    }

    public void selectNodesFromDomain(TangoNode startNode, String nodeName) {
        String[] list;
        this.tree.clearSelection();
        this.updateOnChange = false;
        try {
            int i;
            DeviceData argin = new DeviceData();
            String request = "select name,class from device where domain='" + startNode.toString() + "'";
            argin.insert(request);
            DeviceData argout = this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            Vector<String> vList = new Vector<String>();
            for (i = 0; i < arg.svalue.length; i += 2) {
                if (arg.lvalue[i / 2] == 0) continue;
                vList.add(arg.svalue[i]);
                vList.add(arg.svalue[i + 1]);
            }
            list = new String[vList.size()];
            for (i = 0; i < list.length; ++i) {
                list[i] = (String)vList.get(i);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return;
        }
        JFrame top = (JFrame)ATKGraphicsUtils.getWindowForComponent((Component)this);
        TangoClassSelector classSel = new TangoClassSelector(top, list, nodeName);
        String classToSelect = classSel.getSelectedClass();
        if (classToSelect == null) {
            this.updateOnChange = true;
            return;
        }
        int numFamily = this.treeModel.getChildCount(startNode);
        for (int i = 0; i < numFamily; ++i) {
            TangoNode fNode = (TangoNode)this.treeModel.getChild(startNode, i);
            int numDev = this.treeModel.getChildCount(fNode);
            for (int j = 0; j < numDev; ++j) {
                TangoNode devNode = (TangoNode)this.treeModel.getChild(fNode, j);
                String devName = devNode.getParent().getParent().toString() + "/" + devNode.getParent().toString() + "/" + devNode.toString();
                if (!this.isGoodClass(devName, classToSelect, list)) continue;
                this.selectNodes(devNode, nodeName);
            }
        }
        this.refreshValues();
        this.updateOnChange = true;
    }

    public void selectNodesFromFamily(TangoNode startNode, String nodeName) {
        String[] list;
        this.tree.clearSelection();
        this.updateOnChange = false;
        try {
            int i;
            DeviceData argin = new DeviceData();
            String request = "select name,class from device where family='" + startNode.toString() + "' and domain='" + startNode.getParent().toString() + "'";
            argin.insert(request);
            DeviceData argout = this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            Vector<String> vList = new Vector<String>();
            for (i = 0; i < arg.svalue.length; i += 2) {
                if (arg.lvalue[i / 2] == 0) continue;
                vList.add(arg.svalue[i]);
                vList.add(arg.svalue[i + 1]);
            }
            list = new String[vList.size()];
            for (i = 0; i < list.length; ++i) {
                list[i] = (String)vList.get(i);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return;
        }
        JFrame top = (JFrame)ATKGraphicsUtils.getWindowForComponent((Component)this);
        TangoClassSelector classSel = new TangoClassSelector(top, list, nodeName);
        String classToSelect = classSel.getSelectedClass();
        if (classToSelect == null) {
            this.updateOnChange = true;
            return;
        }
        int numDev = this.treeModel.getChildCount(startNode);
        for (int i = 0; i < numDev; ++i) {
            TangoNode devNode = (TangoNode)this.treeModel.getChild(startNode, i);
            String devName = devNode.getParent().getParent().toString() + "/" + devNode.getParent().toString() + "/" + devNode.toString();
            if (!this.isGoodClass(devName, classToSelect, list)) continue;
            this.selectNodes(devNode, nodeName);
        }
        this.refreshValues();
        this.updateOnChange = true;
    }

    private void selectNodes(TangoNode startNode, String nodeName) {
        int numItem = this.treeModel.getChildCount(startNode);
        boolean found = false;
        for (int j = 0; !found && j < numItem; ++j) {
            TangoNode iNode = (TangoNode)this.treeModel.getChild(startNode, j);
            found = nodeName.equalsIgnoreCase(iNode.toString());
            if (!found) continue;
            this.tree.addSelectionPath(this.getNodePath(iNode));
        }
    }

    public String filterToRegExp(String filter) {
        if (filter.equals("*")) {
            return "*";
        }
        String wildcard = "[a-z0-9_\\-\\.]*";
        StringBuffer ret = new StringBuffer();
        int length = filter.length();
        for (int i = 0; i < length; ++i) {
            char c = filter.charAt(i);
            if (c == '*') {
                ret.append(wildcard);
                continue;
            }
            ret.append(c);
        }
        return ret.toString().toLowerCase();
    }

    public String replaceWildcard(String in) {
        StringBuffer ret = new StringBuffer();
        int length = in.length();
        for (int idx = 0; idx < length; ++idx) {
            if (in.charAt(idx) == '*') {
                ret.append('%');
                continue;
            }
            if (in.charAt(idx) == '_') {
                ret.append("\\_");
                continue;
            }
            ret.append(in.charAt(idx));
        }
        return ret.toString();
    }

    public void launchLogViewer(String devName) {
        Main m = new Main(new String[0], true);
        m.selectDevice(devName);
    }

    public void launchDevDepend(String srvName) {
        try {
            DeviceHierarchyDialog dlg = new DeviceHierarchyDialog((JFrame)this.invoker, srvName);
            dlg.setTitle("Device Hierarchy");
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void launchPollingThreadsManager(String srvName) {
        try {
            PoolThreadsManager dlg = new PoolThreadsManager((JFrame)this.invoker, srvName);
            dlg.setTitle("Polling threads manager");
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void createEmptyAttributeProperty(String devName) {
        String propName = JOptionPane.showInputDialog(this.invoker, "Name: (attribute/prop_name)", "Create attribute property", -1);
        if (propName != null) {
            String[] split = propName.split("/");
            if (split.length != 2) {
                JiveUtils.showJiveError("Invalid name syntax\nattribute/prop_name expected");
            } else {
                try {
                    DbAttribute dbAtt = new DbAttribute(split[0]);
                    dbAtt.add(split[1], "");
                    this.db.put_device_attribute_property(devName, dbAtt);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                this.refresh();
            }
        }
    }

    public void putAttributeProperty(String devName, String attName, String propName, String value) {
        try {
            DbAttribute att = new DbAttribute(attName);
            att.add(propName, JiveUtils.makeStringArray(value));
            this.db.put_device_attribute_property(devName, att);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void saveServerData(FileWriter fw, String srvName) throws IOException {
        try {
            int j;
            String[] prop_list;
            JiveUtils.savedClass.clear();
            String[] class_list = this.db.get_server_class_list(srvName);
            for (int i = 0; i < class_list.length; ++i) {
                int k;
                boolean prtOut;
                DbAttribute[] lst;
                String[] att_list;
                String[] value;
                fw.write("#---------------------------------------------------------\n");
                fw.write("# SERVER " + srvName + ", " + class_list[i] + " device declaration\n");
                fw.write("#---------------------------------------------------------\n\n");
                String[] dev_list = this.db.get_device_name(srvName, class_list[i]);
                JiveUtils.printFormatedRes(srvName + "/DEVICE/" + class_list[i] + ": ", dev_list, fw);
                fw.write("\n");
                for (int l = 0; l < dev_list.length; ++l) {
                    prop_list = this.db.get_device_property_list(dev_list[l], "*");
                    if (prop_list.length > 0) {
                        fw.write("\n# --- " + dev_list[l] + " properties\n\n");
                        for (j = 0; j < prop_list.length; ++j) {
                            value = this.db.get_device_property(dev_list[l], prop_list[j]).extractStringArray();
                            if (prop_list[j].indexOf(32) != -1) {
                                prop_list[j] = "\"" + prop_list[j] + "\"";
                            }
                            JiveUtils.printFormatedRes(dev_list[l] + "->" + prop_list[j] + ": ", value, fw);
                        }
                    }
                    try {
                        att_list = this.db.get_device_attribute_list(dev_list[l]);
                        lst = this.db.get_device_attribute_property(dev_list[l], att_list);
                        prtOut = false;
                        for (k = 0; k < lst.length; ++k) {
                            prop_list = lst[k].get_property_list();
                            for (j = 0; j < prop_list.length; ++j) {
                                if (!prtOut) {
                                    fw.write("\n# --- " + dev_list[l] + " attribute properties\n\n");
                                    prtOut = true;
                                }
                                if (prop_list[j].indexOf(32) != -1) {
                                    prop_list[j] = "\"" + prop_list[j] + "\"";
                                }
                                value = lst[k].get_value(j);
                                JiveUtils.printFormatedRes(dev_list[l] + "/" + att_list[k] + "->" + prop_list[j] + ": ", value, fw);
                            }
                        }
                        continue;
                    }
                    catch (DevFailed e) {
                        JiveUtils.showJiveError("Attribute properties for " + dev_list[l] + " has not been saved !\n" + e.errors[0].desc);
                    }
                }
                fw.write("\n");
                if (JiveUtils.isSavedClass(class_list[i])) continue;
                fw.write("#---------------------------------------------------------\n");
                fw.write("# CLASS " + class_list[i] + " properties\n");
                fw.write("#---------------------------------------------------------\n\n");
                prop_list = this.db.get_class_property_list(class_list[i], "*");
                for (j = 0; j < prop_list.length; ++j) {
                    value = this.db.get_class_property(class_list[i], prop_list[j]).extractStringArray();
                    if (prop_list[j].indexOf(32) != -1) {
                        prop_list[j] = "\"" + prop_list[j] + "\"";
                    }
                    JiveUtils.printFormatedRes("CLASS/" + class_list[i] + "->" + prop_list[j] + ": ", value, fw);
                }
                att_list = this.db.get_class_attribute_list(class_list[i], "*");
                lst = this.db.get_class_attribute_property(class_list[i], att_list);
                prtOut = false;
                for (k = 0; k < lst.length; ++k) {
                    prop_list = lst[k].get_property_list();
                    for (j = 0; j < prop_list.length; ++j) {
                        if (!prtOut) {
                            fw.write("\n# CLASS " + class_list[i] + " attribute properties\n\n");
                            prtOut = true;
                        }
                        if (prop_list[j].indexOf(32) != -1) {
                            prop_list[j] = "\"" + prop_list[j] + "\"";
                        }
                        value = lst[k].get_value(j);
                        JiveUtils.printFormatedRes("CLASS/" + class_list[i] + "/" + att_list[k] + "->" + prop_list[j] + ": ", value, fw);
                    }
                }
                fw.write("\n");
                JiveUtils.addSavedClass(class_list[i]);
            }
            String admDevName = "dserver/" + srvName;
            prop_list = this.db.get_device_property_list(admDevName, "*");
            if (prop_list.length > 0) {
                fw.write("\n# --- " + admDevName + " properties\n\n");
                for (j = 0; j < prop_list.length; ++j) {
                    String[] value = this.db.get_device_property(admDevName, prop_list[j]).extractStringArray();
                    if (prop_list[j].indexOf(32) != -1) {
                        prop_list[j] = "\"" + prop_list[j] + "\"";
                    }
                    JiveUtils.printFormatedRes(admDevName + "->" + prop_list[j] + ": ", value, fw);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            int[] actions;
            if (e.getClickCount() == 1 && e.getButton() == 3) {
                if (!this.tree.isSelectionEmpty() && (e.isControlDown() || e.isShiftDown())) {
                    TreePath[] paths;
                    if (!this.tree.isPathSelected(selPath)) {
                        this.tree.addSelectionPath(selPath);
                    }
                    if ((paths = this.tree.getSelectionPaths()).length > 1) {
                        int i;
                        boolean ok = true;
                        this.createSelectedNodes(paths.length);
                        for (i = 0; ok && i < paths.length; ++i) {
                            TreePanel.selectedNodes[i] = (TangoNode)paths[i].getLastPathComponent();
                            int[] actions2 = selectedNodes[i].getAction();
                            ok = JiveUtils.contains(actions2, 10) || JiveUtils.contains(actions2, 11);
                        }
                        if (ok) {
                            for (i = 0; i < 43; ++i) {
                                actionMenu.getComponent(i).setVisible(false);
                            }
                            actionMenu.getComponent(10).setVisible(true);
                            actionMenu.getComponent(11).setVisible(true);
                            actionMenu.show(this.tree, e.getX(), e.getY());
                            return;
                        }
                    }
                }
                this.createSelectedNodes(1);
                this.tree.setSelectionPath(selPath);
                TreePanel.selectedNodes[0] = (TangoNode)selPath.getLastPathComponent();
                actions = selectedNodes[0].getAction();
                if (actions.length > 0) {
                    for (int i = 0; i < 43; ++i) {
                        if (JiveUtils.contains(actions, i)) {
                            actionMenu.getComponent(i).setVisible(true);
                            continue;
                        }
                        actionMenu.getComponent(i).setVisible(false);
                    }
                    actionMenu.show(this.tree, e.getX(), e.getY());
                }
            }
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                this.createSelectedNodes(1);
                this.tree.setSelectionPath(selPath);
                TreePanel.selectedNodes[0] = (TangoNode)selPath.getLastPathComponent();
                actions = selectedNodes[0].getAction();
                if (actions.length > 0 && JiveUtils.contains(actions, 10)) {
                    selectedNodes[0].execAction(10);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        actionMenu.add(copyMenu);
        copyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(0);
            }
        });
        pasteMenu = new JMenuItem("Paste");
        actionMenu.add(pasteMenu);
        pasteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(1);
            }
        });
        renameMenu = new JMenuItem("Rename");
        actionMenu.add(renameMenu);
        renameMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(2);
            }
        });
        deleteMenu = new JMenuItem("Delete");
        actionMenu.add(deleteMenu);
        deleteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(3);
            }
        });
        addClassMenu = new JMenuItem("Add class");
        actionMenu.add(addClassMenu);
        addClassMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(4);
            }
        });
        testAdminMenu = new JMenuItem("Test admin server");
        actionMenu.add(testAdminMenu);
        testAdminMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(5);
            }
        });
        saveServerMenu = new JMenuItem("Save server data");
        actionMenu.add(saveServerMenu);
        saveServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(6);
            }
        });
        classWizMenu = new JMenuItem("Classes wizard");
        actionMenu.add(classWizMenu);
        classWizMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(7);
            }
        });
        addDeviceMenu = new JMenuItem("Add device");
        actionMenu.add(addDeviceMenu);
        addDeviceMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(8);
            }
        });
        devicesWizMenu = new JMenuItem("Devices wizard");
        actionMenu.add(devicesWizMenu);
        devicesWizMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(9);
            }
        });
        monitorMenu = new JMenuItem("Monitor device");
        actionMenu.add(monitorMenu);
        monitorMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < selectedNodes.length; ++i) {
                    selectedNodes[i].execAction(10);
                }
            }
        });
        testMenu = new JMenuItem("Test device");
        actionMenu.add(testMenu);
        testMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < selectedNodes.length; ++i) {
                    selectedNodes[i].execAction(11);
                }
            }
        });
        aliasMenu = new JMenuItem("Define device alias");
        actionMenu.add(aliasMenu);
        aliasMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(12);
            }
        });
        goToDevMenu = new JMenuItem("Go to device node");
        actionMenu.add(goToDevMenu);
        goToDevMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(13);
            }
        });
        restartMenu = new JMenuItem("Restart device");
        actionMenu.add(restartMenu);
        restartMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(14);
            }
        });
        deviceWizMenu = new JMenuItem("Device wizard");
        actionMenu.add(deviceWizMenu);
        deviceWizMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(15);
            }
        });
        goToServMenu = new JMenuItem("Go to server node");
        actionMenu.add(goToServMenu);
        goToServMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(16);
            }
        });
        goToAdminMenu = new JMenuItem("Go to device admin node");
        actionMenu.add(goToAdminMenu);
        goToAdminMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(17);
            }
        });
        addClassAttMenu = new JMenuItem("Add attribute");
        actionMenu.add(addClassAttMenu);
        addClassAttMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(18);
            }
        });
        unexportDevices = new JMenuItem("Unexport devices");
        actionMenu.add(unexportDevices);
        unexportDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(19);
            }
        });
        selectPropNodeMenu = new JMenuItem("Select 'property' nodes");
        actionMenu.add(selectPropNodeMenu);
        selectPropNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(20);
            }
        });
        selectPollingNodeMenu = new JMenuItem("Select 'polling' nodes");
        actionMenu.add(selectPollingNodeMenu);
        selectPollingNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(21);
            }
        });
        selectEventNodeMenu = new JMenuItem("Select 'event' nodes");
        actionMenu.add(selectEventNodeMenu);
        selectEventNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(22);
            }
        });
        selectAttConfNodeMenu = new JMenuItem("Select 'attribute config' nodes");
        actionMenu.add(selectAttConfNodeMenu);
        selectAttConfNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(23);
            }
        });
        selectLoggingNodeMenu = new JMenuItem("Select 'logging' nodes");
        actionMenu.add(selectLoggingNodeMenu);
        selectLoggingNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(24);
            }
        });
        logviewerMenu = new JMenuItem("Log Viewer");
        actionMenu.add(logviewerMenu);
        logviewerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(25);
            }
        });
        devDependMenu = new JMenuItem("Devices dependencies");
        actionMenu.add(devDependMenu);
        devDependMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(26);
            }
        });
        threadPollMenu = new JMenuItem("Polling threads manager");
        actionMenu.add(threadPollMenu);
        threadPollMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(27);
            }
        });
        viewHistoryMenu = new JMenuItem("View history");
        actionMenu.add(viewHistoryMenu);
        viewHistoryMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(28);
            }
        });
        moveServerMenu = new JMenuItem("Move server");
        actionMenu.add(moveServerMenu);
        moveServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(29);
            }
        });
        createAttPropMenu = new JMenuItem("Create attribute property");
        actionMenu.add(createAttPropMenu);
        createAttPropMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(30);
            }
        });
        startServerMenu = new JMenuItem("Start Server");
        actionMenu.add(startServerMenu);
        startServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(31);
            }
        });
        stopServerMenu = new JMenuItem("Stop Server");
        actionMenu.add(stopServerMenu);
        stopServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(32);
            }
        });
        restartServerMenu = new JMenuItem("Restart Server");
        actionMenu.add(restartServerMenu);
        restartServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(33);
            }
        });
        startLevelMenu = new JMenuItem("Start all servers (Level)");
        actionMenu.add(startLevelMenu);
        startLevelMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(34);
            }
        });
        stopLevelMenu = new JMenuItem("Stop all servers (Level)");
        actionMenu.add(stopLevelMenu);
        stopLevelMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(35);
            }
        });
        startHostMenu = new JMenuItem("Start all servers (Host)");
        actionMenu.add(startHostMenu);
        startHostMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(36);
            }
        });
        stopHostMenu = new JMenuItem("Stop all servers (Host)");
        actionMenu.add(stopHostMenu);
        stopHostMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(37);
            }
        });
        chHostUsageMenu = new JMenuItem("Edit Host Usage");
        actionMenu.add(chHostUsageMenu);
        chHostUsageMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(38);
            }
        });
        goToStarterMenu = new JMenuItem("Go to Starter Node");
        actionMenu.add(goToStarterMenu);
        goToStarterMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(39);
            }
        });
        chLevelMenu = new JMenuItem("Change Level");
        actionMenu.add(chLevelMenu);
        chLevelMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(40);
            }
        });
        terminalMenu = new JMenuItem("Open terminal");
        actionMenu.add(terminalMenu);
        terminalMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(41);
            }
        });
        newServersMenu = new JMenuItem("Start new servers");
        actionMenu.add(newServersMenu);
        newServersMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedNodes[0].execAction(42);
            }
        });
    }
}

