/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskEventNode
extends TangoNode {
    private Database db;
    private String devName;
    private Vector attEventInfo;

    TaskEventNode(Database db, String devName) {
        this.db = db;
        this.devName = devName;
        this.attEventInfo = null;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    void execAction(int number) {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.eventicon;
    }

    @Override
    public String toString() {
        return "Event";
    }

    @Override
    String getTitle() {
        return "Event";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    int getAttributeNumber() {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return this.attEventInfo.size();
    }

    String getAttName(int idx) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)idx)).name;
    }

    String getAbsChange(int idx) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)idx)).abs_change;
    }

    String getRelChange(int idx) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)idx)).rel_change;
    }

    String getPeriodic(int idx) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)idx)).periodic;
    }

    String getArchAbsChange(int idx) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)idx)).archive_abs_change;
    }

    String getArchRelChange(int idx) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)idx)).archive_rel_change;
    }

    String getArchPeriod(int idx) {
        if (this.attEventInfo == null) {
            this.browseEventInfo();
        }
        return ((EventInfo)this.attEventInfo.get((int)idx)).archive_period;
    }

    void setAbsChange(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
                ai.events.ch_event.abs_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setRelChange(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
                ai.events.ch_event.rel_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setArchAbsChange(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
                ai.events.arch_event.abs_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setArchRelChange(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
                ai.events.arch_event.rel_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setArchPeriod(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
                ai.events.arch_event.period = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setPeriodic(int idx, String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
                ai.events.per_event.period = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetChangeEvent(int idx) {
        try {
            String[] pNames = new String[]{"rel_change", "abs_change"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLChangeEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.ch_event.rel_change = "Not specified";
            ai.events.ch_event.abs_change = "Not specified";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULChangeEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.ch_event.rel_change = "";
            ai.events.ch_event.abs_change = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULChangeEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.ch_event.rel_change = "NaN";
            ai.events.ch_event.abs_change = "NaN";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetArchEvent(int idx) {
        try {
            String[] pNames = new String[]{"archive_rel_change", "archive_abs_change", "archive_period"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLArchEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.arch_event.abs_change = "Not specified";
            ai.events.arch_event.rel_change = "Not specified";
            ai.events.arch_event.period = "Not specified";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULArchEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.arch_event.abs_change = "";
            ai.events.arch_event.rel_change = "";
            ai.events.arch_event.period = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULArchEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.arch_event.abs_change = "NaN";
            ai.events.arch_event.rel_change = "NaN";
            ai.events.arch_event.period = "NaN";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetPeriodicEvent(int idx) {
        try {
            String[] pNames = new String[]{"event_period"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(idx), pNames);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetLPeriodicEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.per_event.period = "Not specified";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetULPeriodicEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.per_event.period = "";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void resetCULPeriodicEvent(int idx) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getAttName(idx));
            ai.events.per_event.period = "NaN";
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void restartDevice() {
        try {
            DbDevImportInfo info = this.db.import_device(this.devName);
            DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
            DeviceData in = new DeviceData();
            in.insert(this.devName);
            ds.command_inout("DevRestart", in);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public boolean isTango8() {
        try {
            DbDevImportInfo info = this.db.import_device(this.devName);
            DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
            CommandInfo[] cmds = ds.command_list_query();
            boolean found = false;
            int i = 0;
            while (!found && i < cmds.length) {
                found = cmds[i].cmd_name.equalsIgnoreCase("ZmqEventSubscriptionChange");
                if (found) continue;
                ++i;
            }
            return found;
        }
        catch (DevFailed e) {
            return false;
        }
    }

    void browseEventInfo() {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            this.attEventInfo = new Vector();
            if (ds.get_idl_version() >= 3) {
                String[] attList = ds.get_attribute_list();
                JiveUtils.sortList(attList);
                for (int i = 0; i < attList.length; ++i) {
                    AttributeInfoEx ai = ds.get_attribute_info_ex(attList[i]);
                    if (ai.events == null) continue;
                    EventInfo ei = new EventInfo();
                    ei.name = attList[i];
                    ei.abs_change = this.reformat(ai.events.ch_event.abs_change);
                    ei.rel_change = this.reformat(ai.events.ch_event.rel_change);
                    ei.periodic = this.reformat(ai.events.per_event.period);
                    ei.archive_abs_change = this.reformat(ai.events.arch_event.abs_change);
                    ei.archive_rel_change = this.reformat(ai.events.arch_event.rel_change);
                    ei.archive_period = this.reformat(ai.events.arch_event.period);
                    this.attEventInfo.add(ei);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private String reformat(String s) {
        if (s.equalsIgnoreCase("Not specified")) {
            return "None";
        }
        return s;
    }

    class EventInfo {
        String name;
        String abs_change;
        String rel_change;
        String periodic;
        String archive_abs_change;
        String archive_rel_change;
        String archive_period;

        EventInfo() {
        }
    }
}

