/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import jive.DevWizard;
import jive.JiveUtils;
import jive.MultiLineToolTipUI;
import jive.ServerDlg;
import jive.TangoFileReader;
import jive3.DefaultPanel;
import jive3.DeviceAttributePanel;
import jive3.DeviceEventPanel;
import jive3.DeviceLoggingPanel;
import jive3.DevicePipePanel;
import jive3.DevicePollingPanel;
import jive3.DiffDlg;
import jive3.FilterDlg;
import jive3.IServerAction;
import jive3.NavManager;
import jive3.NavigationBar;
import jive3.NavigationListener;
import jive3.ProgressFrame;
import jive3.PropertyHistoryDlg;
import jive3.PropertyNode;
import jive3.PropertyPanel;
import jive3.ResDlg;
import jive3.SearchEngine;
import jive3.SelectionDlg;
import jive3.SingleAttributePanel;
import jive3.TangoHostDlg;
import jive3.TangoNode;
import jive3.TaskAttributeNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPipeNode;
import jive3.TaskPollingNode;
import jive3.TaskSingleAttributeNode;
import jive3.TreePanel;
import jive3.TreePanelAlias;
import jive3.TreePanelAttributeAlias;
import jive3.TreePanelClass;
import jive3.TreePanelDevice;
import jive3.TreePanelFreeProperty;
import jive3.TreePanelHostCollection;
import jive3.TreePanelServer;

public class MainPanel
extends JFrame
implements ChangeListener,
NavigationListener,
IServerAction {
    private Database db;
    JTabbedPane treePane;
    JSplitPane splitPane;
    JPanel lockPanel;
    int panelMask;
    ArrayList<TreePanelRecord> treePanels;
    int nbPanels;
    DefaultPanel defaultPanel;
    PropertyPanel propertyPanel;
    DevicePollingPanel devicePollingPanel;
    DeviceEventPanel deviceEventPanel;
    DeviceAttributePanel deviceAttributePanel;
    DevicePipePanel devicePipePanel;
    DeviceLoggingPanel deviceLoggingPanel;
    SingleAttributePanel singleAttributePanel;
    PropertyHistoryDlg historyDlg;
    SelectionDlg selectionDlg;
    FilterDlg filterDlg = null;
    private NavManager navManager;
    private NavigationBar navBar;
    private boolean recordPos;
    SearchEngine searchEngine;
    JPanel innerPanel;
    private String lastResOpenedDir = ".";
    private boolean running_from_shell;
    Preferences prefs;
    private String[] knownTangoHost;
    private String THID = "TangoHost";
    public static final String DEFAULT_VERSION = "-.-";
    public static final String VERSION = MainPanel.getVersion();

    public MainPanel() {
        this(false, false);
    }

    public MainPanel(boolean runningFromShell, boolean readOnly) {
        this(runningFromShell, readOnly, 126);
    }

    public MainPanel(boolean runningFromShell, boolean readOnly, int panelMask) {
        this.panelMask = panelMask;
        this.prefs = Preferences.userRoot().node(this.getClass().getName());
        this.knownTangoHost = JiveUtils.makeStringArray(this.prefs.get(this.THID, ""));
        if (this.knownTangoHost.length == 1 && this.knownTangoHost[0].equals("")) {
            this.knownTangoHost = new String[0];
        }
        this.running_from_shell = runningFromShell;
        JiveUtils.readOnly = readOnly;
        this.initComponents();
        this.centerWindow();
        this.setVisible(true);
        JiveUtils.parent = this;
        this.navManager = new NavManager(this);
        this.searchEngine = new SearchEngine(this);
        this.recordPos = true;
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        MultiLineToolTipUI.initialize();
        String tangoHost = null;
        try {
            tangoHost = ApiUtil.getTangoHost();
        }
        catch (DevFailed e) {
            System.out.println("TANGO_HOST no defined, exiting...");
            this.exitForm();
        }
        try {
            this.db = ApiUtil.get_db_obj();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            this.db = null;
        }
        this.updateTitle(tangoHost);
        this.defaultPanel = new DefaultPanel();
        this.propertyPanel = new PropertyPanel();
        this.propertyPanel.setParent(this);
        this.devicePollingPanel = new DevicePollingPanel();
        this.deviceEventPanel = new DeviceEventPanel();
        this.deviceAttributePanel = new DeviceAttributePanel();
        this.devicePipePanel = new DevicePipePanel();
        this.deviceLoggingPanel = new DeviceLoggingPanel();
        this.singleAttributePanel = new SingleAttributePanel();
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(1);
        this.treePanels = new ArrayList();
        if (this.isCollectionPanelVisible()) {
            this.treePanels.add(new TreePanelRecord(new TreePanelHostCollection(this), this.db, "Collection", "Collection:", "COLLECTION"));
        }
        if (this.isServerPanelVisible()) {
            this.treePanels.add(new TreePanelRecord(new TreePanelServer(this), this.db, "Server", "Server:", "SERVER"));
        }
        if (this.isDevicePanelVisible()) {
            this.treePanels.add(new TreePanelRecord(new TreePanelDevice(this), this.db, "Device", "Device:", "DEVICE"));
        }
        if (this.isClassPanelVisible()) {
            this.treePanels.add(new TreePanelRecord(new TreePanelClass(this), this.db, "Class", "Class:", "CLASS"));
        }
        if (this.isDevAliasPanelVisible()) {
            this.treePanels.add(new TreePanelRecord(new TreePanelAlias(this), this.db, "Alias", "Alias:", "DEV-ALIAS"));
        }
        if (this.isAttAliasPanelVisible()) {
            this.treePanels.add(new TreePanelRecord(new TreePanelAttributeAlias(this), this.db, "Att. Alias", "AttAlias:", "ATT-ALIAS"));
        }
        if (this.isFreePropertyPanelVisible()) {
            this.treePanels.add(new TreePanelRecord(new TreePanelFreeProperty(this), this.db, "Property", "FreeProperty:", "PROPERTY"));
        }
        this.treePane = new JTabbedPane();
        this.treePane.setFont(ATKConstant.labelFont);
        this.treePane.addChangeListener(this);
        this.splitPane.setLeftComponent(this.treePane);
        this.nbPanels = this.treePanels.size();
        for (int i = 0; i < this.nbPanels; ++i) {
            this.treePane.add(this.treePanels.get((int)i).tabName, this.treePanels.get((int)i).treePanel);
        }
        int minWidth = 5;
        for (int i = 0; i < this.nbPanels; ++i) {
            Dimension d = ATKGraphicsUtils.measureString((String)this.treePanels.get((int)i).tabName, (Font)ATKConstant.labelFont);
            minWidth += 24 + d.width;
        }
        if (minWidth < 250) {
            minWidth = 250;
        }
        this.treePane.setMinimumSize(new Dimension(minWidth, 0));
        this.historyDlg = new PropertyHistoryDlg();
        this.historyDlg.setDatabase(this.db, tangoHost);
        this.selectionDlg = new SelectionDlg();
        this.selectionDlg.setDatabase(this.db);
        this.innerPanel.add((Component)this.splitPane, "Center");
        this.splitPane.setRightComponent(this.defaultPanel);
        this.navBar = new NavigationBar();
        this.navBar.enableBack(false);
        this.navBar.enableForward(false);
        this.navBar.enableNextOcc(false);
        this.navBar.enablePreviousOcc(false);
        this.navBar.addNavigationListener(this);
        if (JiveUtils.readOnly) {
            JPanel upPanel = new JPanel();
            upPanel.setLayout(new BorderLayout());
            this.lockPanel = new JPanel();
            this.lockPanel.setLayout(new FlowLayout(0));
            this.lockPanel.setBackground(new Color(233, 233, 233));
            JLabel lockIcon = new JLabel();
            lockIcon.setIcon(new ImageIcon(this.getClass().getResource("/jive/lock.gif")));
            this.lockPanel.add(lockIcon);
            JLabel lockLabel = new JLabel("Read only mode (No write access to database allowed)");
            lockLabel.setFont(ATKConstant.labelFont);
            this.lockPanel.add(lockLabel);
            upPanel.add((Component)this.lockPanel, "North");
            upPanel.add((Component)this.navBar, "South");
            this.innerPanel.add((Component)upPanel, "North");
        } else {
            this.innerPanel.add((Component)this.navBar, "North");
        }
        JMenuBar mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem loadFile = new JMenuItem("Load property file");
        loadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.loadPropFile();
            }
        });
        loadFile.setEnabled(!JiveUtils.readOnly);
        JMenuItem checkFile = new JMenuItem("Check property file");
        checkFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.checkPropFile();
            }
        });
        JSeparator sep1 = new JSeparator();
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.exitForm();
            }
        });
        fileMenu.add(loadFile);
        fileMenu.add(checkFile);
        fileMenu.add(sep1);
        fileMenu.add(exit);
        mainMenu.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem refresh = new JMenuItem("Refresh Tree");
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.refreshTree();
            }
        });
        refresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        editMenu.add(refresh);
        editMenu.add(new JSeparator());
        if (this.running_from_shell) {
            JMenuItem chTangoHost = new JMenuItem("Change Tango Host");
            chTangoHost.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainPanel.this.changeTangoHost();
                }
            });
            editMenu.add(chTangoHost);
            editMenu.add(new JSeparator());
        }
        JMenuItem createServer = new JMenuItem("Create server");
        createServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.createServer();
            }
        });
        createServer.setEnabled(!JiveUtils.readOnly);
        editMenu.add(createServer);
        JMenuItem createFreeProperty = new JMenuItem("Create free property");
        createFreeProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.createFreeProperty();
            }
        });
        createFreeProperty.setEnabled(!JiveUtils.readOnly);
        editMenu.add(createFreeProperty);
        editMenu.add(new JSeparator());
        JMenuItem showClipboard = new JMenuItem("Show clipboard");
        showClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.showClipboard();
            }
        });
        editMenu.add(showClipboard);
        JMenuItem clearClipboard = new JMenuItem("Clear clipboard");
        clearClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JiveUtils.the_clipboard.clear();
            }
        });
        editMenu.add(clearClipboard);
        editMenu.add(new JSeparator());
        final JCheckBoxMenuItem showSystemProperty = new JCheckBoxMenuItem("Show system property");
        showSystemProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JiveUtils.showSystemProperty = showSystemProperty.isSelected();
                MainPanel.this.refreshTree();
            }
        });
        editMenu.add(showSystemProperty);
        JMenu serverMenu = new JMenu("Tools");
        JMenuItem createServerWz = new JMenuItem("Server Wizard");
        createServerWz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.createServerWz();
            }
        });
        createServerWz.setEnabled(!JiveUtils.readOnly);
        serverMenu.add(createServerWz);
        JMenuItem dbInfoMenu = new JMenuItem("Database Info");
        dbInfoMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.showDatabaseInfo();
            }
        });
        serverMenu.add(dbInfoMenu);
        JMenuItem dbHistMenu = new JMenuItem("Database history");
        dbHistMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.showHistory();
            }
        });
        serverMenu.add(dbHistMenu);
        JMenuItem selectionMenu = new JMenuItem("Multiple selection");
        selectionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.showMultipleSelection();
            }
        });
        serverMenu.add(selectionMenu);
        JMenu filterMenu = new JMenu("Filter");
        JMenuItem filterServer = new JMenuItem("Server");
        filterServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.filterServer();
            }
        });
        filterMenu.add(filterServer);
        JMenuItem filterDevice = new JMenuItem("Device");
        filterDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.filterDevice();
            }
        });
        filterMenu.add(filterDevice);
        JMenuItem filterClass = new JMenuItem("Class");
        filterClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.filterClass();
            }
        });
        filterMenu.add(filterClass);
        JMenuItem filterAlias = new JMenuItem("Alias");
        filterAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.filterAlias();
            }
        });
        filterMenu.add(filterAlias);
        JMenuItem filterAttributeAlias = new JMenuItem("Att. Alias");
        filterAttributeAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.filterAttributeAlias();
            }
        });
        filterMenu.add(filterAttributeAlias);
        JMenuItem filterProperty = new JMenuItem("Property");
        filterProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.filterProperty();
            }
        });
        filterMenu.add(filterProperty);
        mainMenu.add(fileMenu);
        mainMenu.add(editMenu);
        mainMenu.add(serverMenu);
        mainMenu.add(filterMenu);
        this.setJMenuBar(mainMenu);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                MainPanel.this.exitForm();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/jive/jive.png"));
        this.setIconImage(icon.getImage());
        this.setContentPane(this.innerPanel);
    }

    public boolean isCollectionPanelVisible() {
        return (this.panelMask & 1) != 0;
    }

    public boolean isServerPanelVisible() {
        return (this.panelMask & 2) != 0;
    }

    public boolean isDevicePanelVisible() {
        return (this.panelMask & 4) != 0;
    }

    public boolean isClassPanelVisible() {
        return (this.panelMask & 8) != 0;
    }

    public boolean isDevAliasPanelVisible() {
        return (this.panelMask & 0x10) != 0;
    }

    public boolean isAttAliasPanelVisible() {
        return (this.panelMask & 0x20) != 0;
    }

    public boolean isFreePropertyPanelVisible() {
        return (this.panelMask & 0x40) != 0;
    }

    private void reselect() {
        TreePath path = this.navManager.getCurrentPath();
        JTree tree = this.navManager.getCurrentTree();
        this.recordPos = false;
        for (int i = 0; i < this.nbPanels; ++i) {
            if (tree != this.treePanels.get((int)i).treePanel.tree) continue;
            this.treePane.setSelectedComponent(this.treePanels.get((int)i).treePanel);
        }
        this.treePane.getSelectedComponent().setVisible(true);
        tree.setSelectionPath(path);
        this.recordPos = true;
        tree.scrollPathToVisible(path);
    }

    @Override
    public void backAction(NavigationBar src) {
        this.navManager.goBack();
        this.navBar.enableBack(this.navManager.canGoBackward());
        this.navBar.enableForward(this.navManager.canGoForward());
        this.reselect();
    }

    @Override
    public void forwardAction(NavigationBar src) {
        this.navManager.goForward();
        this.navBar.enableBack(this.navManager.canGoBackward());
        this.navBar.enableForward(this.navManager.canGoForward());
        this.reselect();
    }

    @Override
    public void nextOccAction(NavigationBar src) {
        TreePath path = this.searchEngine.findNext();
        TreePanel selected = (TreePanel)this.treePane.getSelectedComponent();
        if (path != null) {
            selected.tree.setSelectionPath(path);
            selected.tree.scrollPathToVisible(path);
        }
        this.navBar.enableNextOcc(!this.searchEngine.isStackEmpty());
    }

    @Override
    public void previousOccAction(NavigationBar src) {
    }

    @Override
    public void searchAction(NavigationBar src, TreePath pathToSelect) {
        TreePath path;
        TangoNode focusedNode;
        if (pathToSelect != null) {
            String treeName = pathToSelect.getPathComponent(0).toString();
            for (int i = 0; i < this.nbPanels; ++i) {
                if (!this.treePanels.get((int)i).name.equals(treeName)) continue;
                this.treePanels.get((int)i).treePanel.selectPath(pathToSelect);
                this.treePane.setSelectedComponent(this.treePanels.get((int)i).treePanel);
                this.treePane.getSelectedComponent().setVisible(true);
            }
            this.resetSearch();
            return;
        }
        String searchText = src.getSearchText();
        for (int i = 0; i < this.nbPanels; ++i) {
            if (!searchText.startsWith(this.treePanels.get((int)i).name)) continue;
            searchText = searchText.substring(this.treePanels.get((int)i).name.length());
            this.treePane.setSelectedComponent(this.treePanels.get((int)i).treePanel);
        }
        this.treePane.getSelectedComponent().setVisible(true);
        TreePanel selected = (TreePanel)this.treePane.getSelectedComponent();
        String[] fieldnames = searchText.split("/");
        if (fieldnames.length == 1 && selected.isRootItem(fieldnames[0])) {
            TreePath path2 = selected.selectRootItem(fieldnames[0]);
            selected.tree.scrollPathToVisible(path2);
            TangoNode focusedNode2 = (TangoNode)path2.getLastPathComponent();
            this.searchEngine.setSearchText(searchText);
            this.resetSearch(focusedNode2);
            return;
        }
        if (JiveUtils.isDeviceName(searchText)) {
            if (searchText.startsWith("tango:")) {
                searchText = searchText.substring(6);
            }
            if (this.getDeviceTreePanel().isDomain(fieldnames[0]) && (focusedNode = this.goToDeviceFullNode(searchText)) != null) {
                this.searchEngine.setSearchText(searchText);
                this.resetSearch(focusedNode);
                return;
            }
        }
        if (JiveUtils.isFullServerName(searchText) && this.getServerTreePanel().isServer(fieldnames[0])) {
            focusedNode = this.goToServerFullNode(searchText);
            if (focusedNode == null) {
                focusedNode = this.goToServerRootNode(fieldnames[0]);
                if (focusedNode != null) {
                    this.searchEngine.setSearchText(searchText);
                    this.resetSearch(focusedNode);
                    return;
                }
            } else {
                this.searchEngine.setSearchText(searchText);
                this.resetSearch(focusedNode);
                return;
            }
        }
        if ((path = this.searchEngine.findText(searchText, selected.root)) != null) {
            selected.tree.setSelectionPath(path);
            selected.tree.scrollPathToVisible(path);
        }
        this.navBar.enableNextOcc(!this.searchEngine.isStackEmpty());
    }

    @Override
    public void refreshAction(NavigationBar src) {
        this.refreshTree();
    }

    public void showClipboard() {
        JiveUtils.the_clipboard.show(this);
    }

    private void createFreeProperty() {
        String newProp = JOptionPane.showInputDialog(this, "Enter property object name", "Jive", 3);
        if (newProp != null) {
            TreePanelFreeProperty propertyTreePanel = this.getPropertyTreePanel();
            propertyTreePanel.addProperty(newProp);
            this.treePane.setSelectedComponent(propertyTreePanel);
            propertyTreePanel.setVisible(true);
        }
    }

    private void resetSearch() {
        this.resetSearch(null);
    }

    private void resetSearch(TangoNode focusedNode) {
        this.searchEngine.resetSearch(focusedNode);
        this.navBar.enableNextOcc(focusedNode != null);
        this.navBar.enablePreviousOcc(false);
    }

    @Override
    public void doJob(String server, String classname, String[] devices) {
        try {
            int i;
            Vector<String> exDevices = new Vector<String>();
            for (i = 0; i < devices.length; ++i) {
                try {
                    this.db.import_device(devices[i]);
                }
                catch (DevFailed e) {
                    continue;
                }
                exDevices.add(devices[i]);
            }
            if (exDevices.size() > 0) {
                String message = "Warning, following device(s) already declared:\n";
                for (int i2 = 0; i2 < exDevices.size(); ++i2) {
                    message = message + "   " + exDevices.get(i2) + "\n";
                }
                if (JOptionPane.showConfirmDialog(this, message = message + "Do you want to continue ?", "Confirmation", 0) != 0) {
                    return;
                }
            }
            for (i = 0; i < devices.length; ++i) {
                this.db.add_device(devices[i], classname, server);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        this.refreshTree();
        this.getServerTreePanel().selectFullServer(server);
    }

    private void createServer() {
        ServerDlg sdlg = new ServerDlg(this);
        sdlg.setValidFields(true, true);
        sdlg.setDefaults("", "");
        sdlg.setServerList(this.getServerTreePanel().getServerList());
        sdlg.setClassList(this.getClassTreePanel().getClassList());
        ATKGraphicsUtils.centerFrame((JComponent)this.innerPanel, (Frame)sdlg);
        sdlg.setVisible(true);
    }

    private void filterServer() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Server filter");
        this.filterDlg.setFilter(this.getServerTreePanel().getFilter());
        if (this.filterDlg.showDialog()) {
            this.filterServer(this.filterDlg.getFilterText());
        }
    }

    public void filterServer(String filter) {
        TreePanelServer serverTreePanel = this.getServerTreePanel();
        serverTreePanel.applyFilter(filter);
        serverTreePanel.refresh();
        this.resetSearch();
        serverTreePanel.revalidate();
    }

    private void filterDevice() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Device filter");
        this.filterDlg.setFilter(this.getDeviceTreePanel().getFilter());
        if (this.filterDlg.showDialog()) {
            this.filterDevice(this.filterDlg.getFilterText());
        }
    }

    public void filterDevice(String filter) {
        TreePanelDevice deviceTreePanel = this.getDeviceTreePanel();
        deviceTreePanel.applyFilter(filter);
        deviceTreePanel.refresh();
        this.resetSearch();
        deviceTreePanel.revalidate();
    }

    private void filterClass() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Class filter");
        this.filterDlg.setFilter(this.getClassTreePanel().getFilter());
        if (this.filterDlg.showDialog()) {
            this.filterClass(this.filterDlg.getFilterText());
        }
    }

    public void filterClass(String filter) {
        TreePanelClass classTreePanel = this.getClassTreePanel();
        classTreePanel.applyFilter(filter);
        classTreePanel.refresh();
        this.resetSearch();
        classTreePanel.revalidate();
    }

    private void filterAlias() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Alias filter");
        this.filterDlg.setFilter(this.getAliasTreePanel().getFilter());
        if (this.filterDlg.showDialog()) {
            this.filterAlias(this.filterDlg.getFilterText());
        }
    }

    public void filterAlias(String filter) {
        TreePanelAlias aliasTreePanel = this.getAliasTreePanel();
        aliasTreePanel.applyFilter(filter);
        aliasTreePanel.refresh();
        this.resetSearch();
        aliasTreePanel.revalidate();
    }

    private void filterAttributeAlias() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Att. Alias filter");
        this.filterDlg.setFilter(this.getAttributeAliasTreePanel().getFilter());
        if (this.filterDlg.showDialog()) {
            this.filterAttributeAlias(this.filterDlg.getFilterText());
        }
    }

    public void filterAttributeAlias(String filter) {
        TreePanelAttributeAlias attributeAliasTreePanel = this.getAttributeAliasTreePanel();
        attributeAliasTreePanel.applyFilter(filter);
        attributeAliasTreePanel.refresh();
        this.resetSearch();
        attributeAliasTreePanel.revalidate();
    }

    private void filterProperty() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Property filter");
        this.filterDlg.setFilter(this.getPropertyTreePanel().getFilter());
        if (this.filterDlg.showDialog()) {
            this.filterProperty(this.filterDlg.getFilterText());
        }
    }

    public void filterProperty(String filter) {
        TreePanelFreeProperty propertyTreePanel = this.getPropertyTreePanel();
        propertyTreePanel.applyFilter(this.filterDlg.getFilterText());
        propertyTreePanel.refresh();
        this.resetSearch();
        propertyTreePanel.revalidate();
    }

    private void createServerWz() {
        DevWizard wdlg = new DevWizard(this);
        wdlg.showWizard(null);
        this.refreshTree();
    }

    private void updateTitle(String tangoHost) {
        String title = new String("Jive " + VERSION);
        if (JiveUtils.readOnly) {
            title = title + "(Read Only)";
        }
        if (this.db == null) {
            this.setTitle(title + " [No connection]");
        } else {
            this.setTitle(title + " [" + tangoHost + "]");
        }
    }

    private boolean isKnowTangoHost(String th) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.knownTangoHost.length) {
            found = this.knownTangoHost[i].equalsIgnoreCase(th);
            if (found) continue;
            ++i;
        }
        return found;
    }

    private void changeTangoHost() {
        TangoHostDlg dlg = new TangoHostDlg(this, this.knownTangoHost);
        String th = dlg.getTangoHost();
        if (th != null) {
            String[] ths = th.split(":");
            if (ths.length != 2) {
                JiveUtils.showJiveError("Invalid tango host syntax: should be host:port");
                return;
            }
            try {
                Integer.parseInt(ths[1]);
            }
            catch (NumberFormatException e) {
                JiveUtils.showJiveError("Invalid tango host port number\n" + e.getMessage());
                return;
            }
            try {
                this.db = ApiUtil.change_db_obj((String)ths[0], (String)ths[1]);
                if (!this.isKnowTangoHost(th)) {
                    String[] newTH = new String[this.knownTangoHost.length + 1];
                    for (int i = 0; i < this.knownTangoHost.length; ++i) {
                        newTH[i] = this.knownTangoHost[i];
                    }
                    newTH[this.knownTangoHost.length] = th;
                    this.knownTangoHost = newTH;
                    JiveUtils.sortList(this.knownTangoHost);
                    this.prefs.put(this.THID, JiveUtils.stringArrayToString(this.knownTangoHost));
                }
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
                this.db = null;
            }
            catch (Exception e) {
                JiveUtils.showJiveError(e.getMessage());
                this.db = null;
            }
            ProgressFrame.displayProgress("Refresh in progress");
            for (int i = 0; i < this.nbPanels; ++i) {
                this.treePanels.get((int)i).treePanel.setDatabase(this.db);
                ProgressFrame.setProgress("Refreshing...", (int)(100.0 * (double)(i + 1) / (double)this.nbPanels));
            }
            ProgressFrame.hideProgress();
            this.historyDlg.setDatabase(this.db, th);
            this.selectionDlg.setDatabase(this.db);
            this.updateTitle(th);
            this.defaultPanel.setSource(null, 0);
            this.splitPane.setRightComponent(this.defaultPanel);
            this.resetSearch();
        }
    }

    public void resetNavigation() {
        this.navManager.reset();
        this.navBar.enableForward(false);
        this.navBar.enableBack(false);
    }

    private void refreshTreePanel() {
        ProgressFrame.displayProgress("Refresh in progress");
        for (int i = 0; i < this.nbPanels; ++i) {
            this.treePanels.get((int)i).treePanel.refresh();
            ProgressFrame.setProgress("Refreshing...", (int)(100.0 * (double)(i + 1) / (double)this.nbPanels));
        }
        ProgressFrame.hideProgress();
    }

    private void refreshTree() {
        this.refreshTreePanel();
        this.updateTabbedPane();
        this.resetSearch();
    }

    TreePanelHostCollection getHsotCollectionTreePanel() {
        return (TreePanelHostCollection)this.getInstanceOf(TreePanelHostCollection.class);
    }

    TreePanelServer getServerTreePanel() {
        return (TreePanelServer)this.getInstanceOf(TreePanelServer.class);
    }

    TreePanelDevice getDeviceTreePanel() {
        return (TreePanelDevice)this.getInstanceOf(TreePanelDevice.class);
    }

    TreePanelClass getClassTreePanel() {
        return (TreePanelClass)this.getInstanceOf(TreePanelClass.class);
    }

    TreePanelAlias getAliasTreePanel() {
        return (TreePanelAlias)this.getInstanceOf(TreePanelAlias.class);
    }

    TreePanelAttributeAlias getAttributeAliasTreePanel() {
        return (TreePanelAttributeAlias)this.getInstanceOf(TreePanelAttributeAlias.class);
    }

    TreePanelFreeProperty getPropertyTreePanel() {
        return (TreePanelFreeProperty)this.getInstanceOf(TreePanelAttributeAlias.class);
    }

    private TreePanel getInstanceOf(Class _class) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.nbPanels) {
            found = this.treePanels.get((int)i).treePanel.getClass() == _class;
            if (found) continue;
            ++i;
        }
        if (!found) {
            return null;
        }
        return this.treePanels.get((int)i).treePanel;
    }

    private void loadPropFile() {
        File f;
        ResDlg dlg;
        String err = "";
        TangoFileReader fr = new TangoFileReader(this.db);
        JFileChooser chooser = new JFileChooser(this.lastResOpenedDir);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (dlg = new ResDlg(this, (f = chooser.getSelectedFile()).getAbsolutePath())).showDlg()) {
            if (f != null) {
                err = fr.parse_res_file(f.getAbsolutePath());
            }
            if (err.length() > 0) {
                JiveUtils.showJiveError(err);
            }
            if (f != null) {
                this.lastResOpenedDir = f.getAbsolutePath();
            }
        }
    }

    private void checkPropFile() {
        File f;
        String err = "";
        TangoFileReader fr = new TangoFileReader(this.db);
        JFileChooser chooser = new JFileChooser(this.lastResOpenedDir);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            Vector diff = new Vector();
            err = fr.check_res_file(f.getAbsolutePath(), diff);
            this.lastResOpenedDir = f.getAbsolutePath();
            if (err.length() > 0) {
                JiveUtils.showJiveError(err);
            } else if (diff.size() > 0) {
                DiffDlg dlg = new DiffDlg(diff, f.getAbsolutePath());
                ATKGraphicsUtils.centerFrameOnScreen((Frame)dlg);
                dlg.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "Database and file match.");
            }
        }
    }

    private void showDatabaseInfo() {
        if (this.db == null) {
            return;
        }
        try {
            String result = this.db.get_info();
            JOptionPane.showMessageDialog(this, result, "Database Info", 1);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private void showMultipleSelection() {
        if (!this.selectionDlg.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this.selectionDlg);
        }
        this.selectionDlg.clear();
        this.selectionDlg.setVisible(true);
    }

    public void showHistory() {
        if (!this.historyDlg.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this.historyDlg);
        }
        this.historyDlg.setVisible(true);
    }

    public void goToDeviceNode(String devName) {
        if (this.isDevicePanelVisible()) {
            TreePanelDevice deviceTreePanel = this.getDeviceTreePanel();
            deviceTreePanel.selectDevice(devName);
            this.treePane.setSelectedComponent(deviceTreePanel);
            this.treePane.getSelectedComponent().setVisible(true);
        }
    }

    private TangoNode goToDeviceFullNode(String devName) {
        if (this.isDevicePanelVisible()) {
            TreePanelDevice deviceTreePanel = this.getDeviceTreePanel();
            TangoNode selected = deviceTreePanel.selectDevice(devName);
            if (selected != null) {
                this.treePane.setSelectedComponent(deviceTreePanel);
                this.treePane.getSelectedComponent().setVisible(true);
            }
            return selected;
        }
        return null;
    }

    public void goToServerNode(String srvName) {
        this.goToServerFullNode(srvName);
    }

    public TangoNode goToServerFullNode(String srvName) {
        if (this.isServerPanelVisible()) {
            TreePanelServer serverTreePanel = this.getServerTreePanel();
            TangoNode selected = serverTreePanel.selectFullServer(srvName);
            if (selected != null) {
                this.treePane.setSelectedComponent(serverTreePanel);
                this.treePane.getSelectedComponent().setVisible(true);
            }
            return selected;
        }
        return null;
    }

    public TangoNode goToServerRootNode(String srvName) {
        if (this.isServerPanelVisible()) {
            TreePanelServer serverTreePanel = this.getServerTreePanel();
            TangoNode selected = serverTreePanel.selectServerRoot(srvName);
            if (selected != null) {
                this.treePane.setSelectedComponent(serverTreePanel);
                this.treePane.getSelectedComponent().setVisible(true);
            }
            return selected;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateTabbedPane();
    }

    private void updateTabbedPane() {
        TreePanel p = (TreePanel)this.treePane.getSelectedComponent();
        p.refreshValues();
    }

    void updatePanel(TangoNode[] source) {
        TangoNode[] nodes;
        int i;
        try {
            SingleAttributePanel attPanel;
            PropertyPanel propertyPanel;
            Component panel = this.splitPane.getRightComponent();
            if (panel instanceof PropertyPanel && (propertyPanel = (PropertyPanel)panel).hasChanged() && JOptionPane.showConfirmDialog(this, "Some properties has been updated and not saved.\nWould you like to save change ?", "Confirmation", 0) == 0) {
                propertyPanel.saveChange();
            }
            if (panel instanceof SingleAttributePanel && (attPanel = (SingleAttributePanel)panel).hasChanged() && JOptionPane.showConfirmDialog(this, "Some attribute properties has been updated and not saved.\nWould you like to save change ?", "Confirmation", 0) == 0) {
                attPanel.saveChange();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (source == null || source.length == 0) {
            this.defaultPanel.setSource(null, 0);
            this.splitPane.setRightComponent(this.defaultPanel);
            return;
        }
        TreePanel p = (TreePanel)this.treePane.getSelectedComponent();
        if (this.recordPos) {
            this.navManager.recordPath(p.tree);
        }
        this.navBar.addLink(p.tree.getSelectionPath());
        this.navBar.enableBack(this.navManager.canGoBackward());
        this.navBar.enableForward(this.navManager.canGoForward());
        boolean sameClass = true;
        Class<?> nodeClass = source[0].getClass();
        for (i = 1; sameClass && i < source.length; ++i) {
            sameClass = source[i].getClass() == nodeClass;
        }
        if (!sameClass) {
            TangoNode[] newSource = new TangoNode[]{source[0]};
            source = newSource;
        }
        if (source[0] instanceof PropertyNode) {
            nodes = new PropertyNode[source.length];
            for (i = 0; i < source.length; ++i) {
                nodes[i] = (PropertyNode)source[i];
            }
            this.propertyPanel.setSource((PropertyNode[])nodes);
            this.splitPane.setRightComponent(this.propertyPanel);
        } else if (nodeClass == TaskPollingNode.class) {
            nodes = new TaskPollingNode[source.length];
            for (i = 0; i < source.length; ++i) {
                nodes[i] = (TaskPollingNode)source[i];
            }
            this.devicePollingPanel.setSource((TaskPollingNode[])nodes);
            this.splitPane.setRightComponent(this.devicePollingPanel);
        } else if (nodeClass == TaskEventNode.class) {
            nodes = new TaskEventNode[source.length];
            for (i = 0; i < source.length; ++i) {
                nodes[i] = (TaskEventNode)source[i];
            }
            this.deviceEventPanel.setSource((TaskEventNode[])nodes);
            this.splitPane.setRightComponent(this.deviceEventPanel);
        } else if (nodeClass == TaskAttributeNode.class) {
            nodes = new TaskAttributeNode[source.length];
            for (i = 0; i < source.length; ++i) {
                nodes[i] = (TaskAttributeNode)source[i];
            }
            this.deviceAttributePanel.setSource((TaskAttributeNode[])nodes);
            this.splitPane.setRightComponent(this.deviceAttributePanel);
        } else if (nodeClass == TaskPipeNode.class) {
            nodes = new TaskPipeNode[source.length];
            for (i = 0; i < source.length; ++i) {
                nodes[i] = (TaskPipeNode)source[i];
            }
            this.devicePipePanel.setSource((TaskPipeNode[])nodes);
            this.splitPane.setRightComponent(this.devicePipePanel);
        } else if (nodeClass == TaskLoggingNode.class) {
            nodes = new TaskLoggingNode[source.length];
            for (i = 0; i < source.length; ++i) {
                nodes[i] = (TaskLoggingNode)source[i];
            }
            this.deviceLoggingPanel.setSource((TaskLoggingNode[])nodes);
            this.splitPane.setRightComponent(this.deviceLoggingPanel);
        } else if (nodeClass == TaskSingleAttributeNode.class) {
            nodes = new TaskSingleAttributeNode[source.length];
            for (i = 0; i < source.length; ++i) {
                nodes[i] = (TaskSingleAttributeNode)source[i];
            }
            this.singleAttributePanel.setSource((TaskSingleAttributeNode[])nodes);
            this.splitPane.setRightComponent(this.singleAttributePanel);
        } else {
            this.defaultPanel.setSource(source[0], source.length);
            this.splitPane.setRightComponent(this.defaultPanel);
        }
    }

    private void exitForm() {
        if (this.running_from_shell) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = new Dimension(830, 500);
        int x = (scrsize.width - appsize.width) / 2;
        int y = (scrsize.height - appsize.height) / 2;
        this.setBounds(x, y, appsize.width, appsize.height);
    }

    private static String getVersion() {
        Package p = MainPanel.class.getPackage();
        if (p.getImplementationVersion() != null) {
            return p.getImplementationVersion();
        }
        return DEFAULT_VERSION;
    }

    static void printUsage() {
        System.out.println("Usage: jive [-r] [-s server] [-d device] [-fxx filter] [-p panel]");
        System.out.println("   -r        Read only mode (No write access to database allowed)");
        System.out.println("   -s server Open jive and show specified server node (server=ServerName/instance)");
        System.out.println("   -d device Open jive and show specified device node (device=domain/family/member)");
        System.out.println("   -fs filter Default server filter");
        System.out.println("   -fd filter Default device filter");
        System.out.println("   -fc filter Default class filter");
        System.out.println("   -fa filter Default alias filter");
        System.out.println("   -faa filter Default attribute alias filter");
        System.out.println("   -fp filter Default property filter");
        System.out.println("   -p panelmask (1=Collection 2=Server 4=Device 8=Class 16=DevAlias 32=AttAlias 64=FreeProperty");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new MainPanel(true, false);
        } else {
            boolean readOnly = false;
            String server = null;
            String device = null;
            String fs = null;
            String fd = null;
            String fc = null;
            String fa = null;
            String faa = null;
            String fp = null;
            int pmask = 126;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-r")) {
                    readOnly = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-s")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    server = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    device = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fs")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    fs = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fd")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    fd = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fc")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    fc = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fa")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    fa = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-faa")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    faa = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fp")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    fp = args[i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-p")) {
                    if (++i >= args.length) {
                        MainPanel.printUsage();
                    }
                    pmask = Integer.parseInt(args[i]);
                    continue;
                }
                System.out.println("Invalid option " + args[i]);
                MainPanel.printUsage();
            }
            MainPanel p = new MainPanel(true, readOnly, pmask);
            if (server != null) {
                p.goToServerFullNode(server);
            }
            if (device != null) {
                p.goToDeviceNode(device);
            }
            if (fs != null) {
                p.filterServer(fs);
            }
            if (fd != null) {
                p.filterDevice(fd);
            }
            if (fc != null) {
                p.filterClass(fc);
            }
            if (fa != null) {
                p.filterAlias(fa);
            }
            if (faa != null) {
                p.filterAttributeAlias(faa);
            }
            if (fp != null) {
                p.filterProperty(fp);
            }
        }
    }

    class TreePanelRecord {
        String name;
        String tabName;
        TreePanel treePanel;
        boolean display;

        TreePanelRecord(TreePanel t, Database db, String tabName, String name, String treeName) {
            t.setDatabase(db);
            this.treePanel = t;
            this.tabName = tabName;
            this.name = name;
            this.treePanel.tree.setName(treeName);
            this.display = true;
        }
    }
}

