/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jive.AttributePanel;
import jive.DetailsDlg;
import jive.JiveUtils;
import jive.TangoHelp;

public class TangoTreeNode
extends DefaultMutableTreeNode {
    private boolean areChildrenDefined = false;
    public int type;
    public int level;
    private String value;
    private Database db;
    private boolean valid;
    public String help;
    public int idl = 0;

    public TangoTreeNode(int level, int type, String value, Database db, boolean valid) {
        this.initNode(level, type, value, db, valid);
    }

    private void initNode(int level, int type, String value, Database db, boolean valid) {
        this.level = level;
        this.type = type;
        this.value = value;
        this.db = db;
        this.valid = valid;
        this.help = TangoHelp.getHelp(this.toString(), type, level);
        if (!this.isValid()) {
            this.help = this.help != null ? this.help + "\n" : "";
            this.help = level == 4 && type == 2 ? this.help + "Warning: The class " + value + " is not defined for this server." : this.help + "Warning: The value stored in the database differs from the server value";
        }
    }

    void addNode(DbAttribute dbai, String name, String srvVal) {
        boolean valid = true;
        if (srvVal != null && !dbai.is_empty(name)) {
            String dbVal = dbai.get_string_value(name);
            valid = srvVal.equalsIgnoreCase(dbVal);
        }
        this.areChildrenDefined = true;
        this.addNode(new TangoTreeNode(this.level + 1, this.type, name, this.db, valid));
    }

    void addNode(TangoTreeNode n) {
        n.idl = this.idl;
        this.add(n);
    }

    void constructAttNode(String devName, String attName) throws DevFailed {
        String[] att_list = new String[]{attName};
        DbAttribute dbai = this.db.get_device_attribute_property(devName, att_list)[0];
        DeviceProxy ds = new DeviceProxy(devName);
        AttributeInfoEx ai = ds.get_attribute_info_ex(attName);
        if (ai.events != null) {
            TangoTreeNode archEvent = new TangoTreeNode(this.level + 1, this.type, "Archive Event", this.db, true);
            this.addNode(archEvent);
            archEvent.addNode(dbai, "archive_abs_change", JiveUtils.convertEventString(ai.events.arch_event.abs_change));
            archEvent.addNode(dbai, "archive_rel_change", JiveUtils.convertEventString(ai.events.arch_event.rel_change));
            archEvent.addNode(dbai, "archive_period", ai.events.arch_event.period);
            TangoTreeNode changeEvent = new TangoTreeNode(this.level + 1, this.type, "Change Event", this.db, true);
            this.addNode(changeEvent);
            changeEvent.addNode(dbai, "abs_change", JiveUtils.convertEventString(ai.events.ch_event.abs_change));
            changeEvent.addNode(dbai, "rel_change", JiveUtils.convertEventString(ai.events.ch_event.rel_change));
            TangoTreeNode periodEvent = new TangoTreeNode(this.level + 1, this.type, "Periodic Event", this.db, true);
            this.addNode(periodEvent);
            periodEvent.addNode(dbai, "event_period", ai.events.per_event.period);
        }
        TangoTreeNode alarms = new TangoTreeNode(this.level + 1, this.type, "Alarms", this.db, true);
        this.addNode(alarms);
        if (ai.alarms != null) {
            alarms.addNode(dbai, "min_alarm", ai.alarms.min_alarm);
            alarms.addNode(dbai, "max_alarm", ai.alarms.max_alarm);
            alarms.addNode(dbai, "min_warning", ai.alarms.min_warning);
            alarms.addNode(dbai, "max_warning", ai.alarms.max_warning);
            alarms.addNode(dbai, "delta_t", ai.alarms.delta_t);
            alarms.addNode(dbai, "delta_val", ai.alarms.delta_val);
        } else {
            alarms.addNode(dbai, "min_alarm", ai.min_alarm);
            alarms.addNode(dbai, "max_alarm", ai.max_alarm);
        }
        this.addNode(dbai, "is_polled", null);
        this.addNode(dbai, "polling_period", null);
        this.addNode(dbai, "description", ai.description);
        this.addNode(dbai, "label", ai.label);
        this.addNode(dbai, "unit", ai.unit);
        this.addNode(dbai, "standard_unit", ai.standard_unit);
        this.addNode(dbai, "display_unit", ai.display_unit);
        this.addNode(dbai, "format", ai.format);
        this.addNode(dbai, "min_value", ai.min_value);
        this.addNode(dbai, "max_value", ai.max_value);
        String[] propList = dbai.get_property_list();
        for (int i = 0; i < propList.length; ++i) {
            if (JiveUtils.IsAttCfgItem(propList[i], this.idl) >= 0) continue;
            this.addNode(dbai, propList[i], null);
        }
    }

    void constructClassNode() throws DevFailed {
        String[] srvList = null;
        String[] dbList = null;
        try {
            String admName = "dserver/" + this.getParent().toString() + "/" + this.toString();
            DeviceProxy adm = new DeviceProxy(admName);
            DeviceData datum = adm.command_inout("QueryClass");
            srvList = datum.extractStringArray();
        }
        catch (DevFailed e) {
            // empty catch block
        }
        DbServer dbs = new DbServer(this.getParent().toString() + "/" + this.toString());
        dbList = dbs.get_class_list();
        if (srvList != null) {
            int i;
            for (i = 0; i < srvList.length; ++i) {
                this.addNode(new TangoTreeNode(this.level + 1, this.type, srvList[i], this.db, true));
            }
            for (i = 0; i < dbList.length; ++i) {
                if (JiveUtils.contains(srvList, dbList[i])) continue;
                this.addNode(new TangoTreeNode(this.level + 1, this.type, dbList[i], this.db, false));
            }
        } else {
            for (int i = 0; i < dbList.length; ++i) {
                this.addNode(new TangoTreeNode(this.level + 1, this.type, dbList[i], this.db, true));
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isLeaf() {
        switch (this.type) {
            case 1: {
                if (this.level == 4 && this.getParent().toString().equals("PROPERTY")) {
                    return true;
                }
                return this.level == 5 && this.getParent().getParent().toString().equals("ATTRIBUTE");
            }
            case 2: {
                return this.level >= 5;
            }
            case 3: {
                if (!(this.level != 5 || this.toString().equals("PROPERTY") || this.toString().equals("ATTRIBUTE") || this.toString().equals("COMMAND"))) {
                    return true;
                }
                if (this.level == 6 && this.getParent().toString().equals("PROPERTY")) {
                    return true;
                }
                if (this.level == 7 && this.getParent().getParent().toString().equals("ATTRIBUTE")) {
                    return !this.isAlarmCfgItem() && !this.isEventCfgItem();
                }
                if (this.level == 7 && this.getParent().getParent().toString().equals("COMMAND")) {
                    return true;
                }
                return this.level == 8 && this.getParent().getParent().getParent().toString().equals("ATTRIBUTE");
            }
            case 4: {
                return this.level == 3;
            }
            case 5: {
                return this.level >= 2;
            }
        }
        return false;
    }

    public boolean isDeviceNode() {
        return this.toString().equals("PROPERTY") || this.toString().equals("ATTRIBUTE") || this.toString().equals("COMMAND");
    }

    public boolean isPollCfgItem() {
        return JiveUtils.IsPollCfgItem(this.toString());
    }

    public boolean isAttCfgItem() {
        return JiveUtils.IsAttCfgItem(this.toString(), this.idl) != -1;
    }

    public boolean isAlarmCfgItem() {
        return JiveUtils.IsAlarmCfgItem(this.toString());
    }

    public boolean isEventCfgItem() {
        return JiveUtils.IsEventCfgItem(this.toString());
    }

    public boolean isSystemItem() {
        return JiveUtils.IsSystemItem(this.toString());
    }

    public boolean isLogCfgItem() {
        return JiveUtils.IsLogCfgItem(this.toString());
    }

    public boolean isCopiableItem() {
        return !this.isLogCfgItem() && !this.isPollCfgItem() && !this.isSystemItem() && !this.isAlarmCfgItem() && !this.isEventCfgItem();
    }

    @Override
    public int getChildCount() {
        if (!this.areChildrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    public Database getDB() {
        return this.db;
    }

    private void defineChildNodes() {
        block60: {
            int i;
            String[] list;
            block58: {
                block59: {
                    this.areChildrenDefined = true;
                    if (this.level != 0) break block59;
                    this.add(new TangoTreeNode(1, 1, "CLASS", this.db, true));
                    this.add(new TangoTreeNode(1, 2, "SERVER", this.db, true));
                    this.add(new TangoTreeNode(1, 3, "DEVICE", this.db, true));
                    this.add(new TangoTreeNode(1, 4, "PROPERTY", this.db, true));
                    this.add(new TangoTreeNode(1, 5, "ALIAS", this.db, true));
                    break block60;
                }
                if (this.db == null) break block60;
                list = null;
                try {
                    block6 : switch (this.type) {
                        case 1: {
                            try {
                                switch (this.level) {
                                    case 1: {
                                        list = this.db.get_class_list("*");
                                        break block6;
                                    }
                                    case 2: {
                                        list = new String[]{"PROPERTY", "ATTRIBUTE"};
                                        break block6;
                                    }
                                    case 3: {
                                        if (this.toString().equals("PROPERTY")) {
                                            list = this.db.get_class_property_list(this.getParent().toString(), "*");
                                            break block6;
                                        }
                                        list = this.db.get_class_attribute_list(this.getParent().toString(), "*");
                                        break block6;
                                    }
                                    case 4: {
                                        String[] att_list = new String[]{this.toString()};
                                        DbAttribute[] lst = this.db.get_class_attribute_property(this.getParent().getParent().toString(), att_list);
                                        if (lst.length <= 0) break;
                                        list = lst[0].get_property_list();
                                    }
                                }
                            }
                            catch (DevFailed e) {
                                JiveUtils.showTangoError(e);
                            }
                            break;
                        }
                        case 2: {
                            try {
                                switch (this.level) {
                                    case 1: {
                                        list = this.db.get_server_name_list();
                                        break block6;
                                    }
                                    case 2: {
                                        list = this.db.get_instance_name_list(this.toString());
                                        break block6;
                                    }
                                    case 3: {
                                        this.constructClassNode();
                                        return;
                                    }
                                    case 4: {
                                        DbServer dbs = new DbServer(this.getParent().getParent().toString() + "/" + this.getParent().toString());
                                        list = dbs.get_device_name(this.toString());
                                    }
                                }
                            }
                            catch (DevFailed e) {
                                JiveUtils.showTangoError(e);
                            }
                            break;
                        }
                        case 3: {
                            try {
                                switch (this.level) {
                                    case 1: {
                                        list = this.db.get_device_domain("*");
                                        break;
                                    }
                                    case 2: {
                                        list = this.db.get_device_family(this.toString() + "/*");
                                        break;
                                    }
                                    case 3: {
                                        list = this.db.get_device_member(this.getParent().toString() + "/" + this.toString() + "/*");
                                        break;
                                    }
                                    case 4: {
                                        String dm = this.getParent().getParent().toString();
                                        list = dm.equalsIgnoreCase("dserver") ? new String[11] : new String[10];
                                        list[0] = "poll_old_factor";
                                        list[1] = "poll_ring_depth";
                                        list[2] = "logging_level";
                                        list[3] = "current_logging_level";
                                        list[4] = "logging_target";
                                        list[5] = "current_logging_target";
                                        list[6] = "logging_rft";
                                        if (list.length == 11) {
                                            list[7] = "logging_path";
                                            list[8] = "PROPERTY";
                                            list[9] = "ATTRIBUTE";
                                            list[10] = "COMMAND";
                                            break;
                                        }
                                        list[7] = "PROPERTY";
                                        list[8] = "ATTRIBUTE";
                                        list[9] = "COMMAND";
                                        break;
                                    }
                                    case 5: {
                                        DeviceProxy ds;
                                        String devname = this.getDevname(1);
                                        if (this.toString().equals("PROPERTY")) {
                                            String[] plist = this.db.get_device_property_list(devname, "*");
                                            boolean[] iscfg = new boolean[plist.length];
                                            int nbItem = 0;
                                            int j = 0;
                                            for (i = 0; i < plist.length; ++i) {
                                                boolean bl = iscfg[i] = JiveUtils.IsPollCfgItem(plist[i]) || JiveUtils.IsLogCfgItem(plist[i]);
                                                if (iscfg[i]) continue;
                                                ++nbItem;
                                            }
                                            list = new String[nbItem];
                                            for (i = 0; i < plist.length; ++i) {
                                                if (iscfg[i]) continue;
                                                list[j++] = plist[i];
                                            }
                                            JiveUtils.sortList(list, null, this.idl);
                                            break;
                                        }
                                        if (this.toString().equals("ATTRIBUTE")) {
                                            ds = new DeviceProxy(devname);
                                            list = ds.get_attribute_list();
                                            this.idl = ds.get_idl_version();
                                            break;
                                        }
                                        if (this.toString().equals("COMMAND")) {
                                            ds = new DeviceProxy(devname);
                                            CommandInfo[] ci = ds.command_list_query();
                                            list = new String[ci.length];
                                            for (i = 0; i < ci.length; ++i) {
                                                list[i] = ci[i].cmd_name;
                                            }
                                            break block58;
                                        }
                                        break block58;
                                    }
                                    case 6: {
                                        String devname = this.getDevname(2);
                                        if (this.getParent().toString().equals("ATTRIBUTE")) {
                                            this.constructAttNode(devname, this.toString());
                                            return;
                                        }
                                        if (this.getParent().toString().equals("COMMAND")) {
                                            list = new String[]{"is_polled", "polling_period"};
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break;
                            }
                            catch (DevFailed e) {
                                JiveUtils.showTangoError(e);
                                break;
                            }
                        }
                        case 4: {
                            try {
                                switch (this.level) {
                                    case 1: {
                                        list = this.db.get_object_list("*");
                                        break block6;
                                    }
                                    case 2: {
                                        list = this.db.get_object_property_list(this.toString(), "*");
                                    }
                                }
                            }
                            catch (DevFailed e) {
                                JiveUtils.showTangoError(e);
                            }
                            break;
                        }
                        case 5: {
                            try {
                                switch (this.level) {
                                    case 1: {
                                        list = this.db.get_device_alias_list("*");
                                    }
                                }
                                break;
                            }
                            catch (DevFailed e) {
                                JiveUtils.showTangoError(e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
            if (list != null) {
                for (i = 0; i < list.length; ++i) {
                    this.addNode(new TangoTreeNode(this.level + 1, this.type, list[i], this.db, true));
                }
            }
        }
    }

    public String[] getValue() {
        String[] ret;
        String pname;
        String result;
        block118: {
            block117: {
                result = "";
                pname = "...";
                ret = new String[2];
                if (this.db != null) break block117;
                result = "No connection to database server.";
                break block118;
            }
            switch (this.type) {
                case 0: {
                    pname = "Database info";
                    try {
                        result = this.db.get_info();
                        break;
                    }
                    catch (DevFailed e) {
                        for (int i = 0; i < e.errors.length; ++i) {
                            result = result + "Desc -> " + e.errors[i].desc + "\n";
                            result = result + "Reason -> " + e.errors[i].reason + "\n";
                            result = result + "Origin -> " + e.errors[i].origin + "\n";
                        }
                        break;
                    }
                }
                case 1: {
                    if (this.level == 4 && this.getParent().toString().equals("PROPERTY")) {
                        try {
                            String[] res = this.db.get_class_property(this.getParent().getParent().toString(), this.toString()).extractStringArray();
                            result = JiveUtils.stringArrayToString(res);
                            pname = "Property value";
                            if (res.length >= 2) {
                                pname = pname + " [" + res.length + " items]";
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                    }
                    if (this.level != 5 || !this.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                    try {
                        String[] att_list = new String[]{this.getParent().toString()};
                        DbAttribute[] lst = this.db.get_class_attribute_property(this.getParent().getParent().getParent().toString(), att_list);
                        if (lst != null && lst.length > 0) {
                            result = result + lst[0].get_string_value(this.toString());
                        }
                        pname = "Property value";
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: 
                case 3: {
                    DeviceProxy ds;
                    String devname;
                    int i;
                    String devname2;
                    if (this.type == 3 && this.level == 4 || this.type == 2 && this.level == 5) {
                        try {
                            try {
                                result = "- Device Info ----------------------------------------\n\n";
                                devname2 = this.type == 2 ? this.toString() : this.getDevname(0);
                                DeviceProxy dbdev = new DeviceProxy(devname2);
                                DbDevImportInfo info = dbdev.import_device();
                                result = result + info.toString();
                                result = result + "\n\n- Polling Status -------------------------------------\n\n";
                                String[] pi = dbdev.polling_status();
                                for (i = 0; i < pi.length; ++i) {
                                    result = result + pi[i] + "\n\n";
                                }
                                pname = "Device info";
                            }
                            catch (DevFailed e) {
                                for (i = 0; i < e.errors.length; ++i) {
                                    result = result + "Desc -> " + e.errors[i].desc + "\n";
                                    result = result + "Reason -> " + e.errors[i].reason + "\n";
                                    result = result + "Origin -> " + e.errors[i].origin + "\n";
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                    }
                    if (this.type == 2 && this.level == 3) {
                        try {
                            try {
                                DbServer dbserv = new DbServer(this.toString());
                                DbServInfo info = dbserv.get_info();
                                result = info.toString();
                                pname = "Server info";
                            }
                            catch (DevFailed e) {
                                for (i = 0; i < e.errors.length; ++i) {
                                    result = result + "Desc -> " + e.errors[i].desc + "\n";
                                    result = result + "Reason -> " + e.errors[i].reason + "\n";
                                    result = result + "Origin -> " + e.errors[i].origin + "\n";
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                    }
                    if (this.type == 2) break;
                    if (this.level == 5 && !this.isDeviceNode()) {
                        String[] res = null;
                        devname = this.getDevname(1);
                        if (this.isPollCfgItem()) {
                            pname = "Polling configuration property";
                        } else if (this.isLogCfgItem()) {
                            pname = "Logging configuration property";
                        }
                        try {
                            if (this.toString().equals("current_logging_level")) {
                                res = JiveUtils.getLoggingStatus(this.db, devname, 0);
                                result = JiveUtils.stringArrayToString(res);
                            } else if (this.toString().equals("current_logging_target")) {
                                res = JiveUtils.getLoggingStatus(this.db, devname, 1);
                                result = JiveUtils.stringArrayToString(res);
                            } else {
                                res = this.db.get_device_property(devname, this.toString()).extractStringArray();
                                result = JiveUtils.stringArrayToString(res);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (res == null || res.length == 0) {
                            if (this.toString().equals("poll_old_factor")) {
                                result = "4";
                            } else if (this.toString().equals("poll_ring_depth")) {
                                result = "10";
                            } else if (this.toString().equals("logging_rft")) {
                                result = "2";
                            }
                        } else if (res.length >= 2) {
                            pname = pname + " [" + res.length + " items]";
                        }
                    }
                    if (this.level == 6 && this.getParent().toString().equals("PROPERTY")) {
                        try {
                            pname = this.isSystemItem() ? "System property" : "Property value";
                            devname2 = this.getDevname(2);
                            String[] res = this.db.get_device_property(devname2, this.toString()).extractStringArray();
                            result = JiveUtils.stringArrayToString(res);
                            if (res != null && res.length >= 2) {
                                pname = pname + " [" + res.length + " items]";
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                    }
                    if (this.level == 6 && this.getParent().toString().equals("ATTRIBUTE")) {
                        devname2 = this.getDevname(2);
                        try {
                            result = result + "- Attribute Info -------------------------------------\n\n";
                            ds = new DeviceProxy(devname2);
                            AttributeInfo ai = ds.get_attribute_info(this.toString());
                            result = result + "Data type:     " + TangoConst.Tango_CmdArgTypeName[ai.data_type] + "\n";
                            result = result + "Data format:   " + AttributePanel.getFormatString(ai) + "\n";
                            result = result + "Display level: " + ai.level + "\n";
                            result = result + "Writable:      " + AttributePanel.getWriteString(ai) + "\n";
                            result = result + "Writable name: " + ai.writable_attr_name + "\n";
                            if (ai.extensions.length > 0) {
                                for (i = 0; i < ai.extensions.length; ++i) {
                                    result = result + "Extension " + i + "  :" + ai.extensions[0] + "\n";
                                }
                            } else {
                                result = result + "No extensions.\n";
                            }
                        }
                        catch (DevFailed e) {
                            // empty catch block
                        }
                        result = result + "\n\n- Polling Status -------------------------------------\n\n";
                        String ps = JiveUtils.getPollingStatus(devname2, this.toString(), "attribute", 4);
                        result = ps == null ? result + "The attribute is not polled" : result + ps;
                        pname = "Attribute info";
                    }
                    if (this.level == 7 && this.getParent().getParent().toString().equals("ATTRIBUTE")) {
                        try {
                            String name = this.toString();
                            if (name.equals("is_polled")) {
                                result = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "attribute", 1);
                                result = result == null ? "No" : "Yes";
                                pname = "Polling configuration property";
                            } else if (name.equals("polling_period")) {
                                result = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "attribute", 2);
                                if (result == null) {
                                    result = "";
                                }
                                pname = "Polling configuration property";
                            } else if (!JiveUtils.IsAlarmCfgItem(this.toString()) && !JiveUtils.IsEventCfgItem(this.toString())) {
                                devname = this.getDevname(3);
                                int p = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                                if (p < 0) {
                                    String[] att_list = new String[]{this.getParent().toString()};
                                    DbAttribute[] lst = this.db.get_device_attribute_property(devname, att_list);
                                    if (lst != null && lst.length > 0) {
                                        result = result + lst[0].get_string_value(this.toString());
                                    }
                                    pname = "Property value";
                                } else {
                                    DeviceProxy ds2 = new DeviceProxy(devname);
                                    AttributeInfoEx ai = ds2.get_attribute_info_ex(this.getParent().toString());
                                    switch (p) {
                                        case 0: {
                                            result = result + ai.description;
                                            break;
                                        }
                                        case 1: {
                                            result = result + ai.label;
                                            break;
                                        }
                                        case 2: {
                                            result = result + ai.unit;
                                            break;
                                        }
                                        case 3: {
                                            result = result + ai.standard_unit;
                                            break;
                                        }
                                        case 4: {
                                            result = result + ai.display_unit;
                                            break;
                                        }
                                        case 5: {
                                            result = result + ai.format;
                                            break;
                                        }
                                        case 6: {
                                            result = result + ai.min_value;
                                            break;
                                        }
                                        case 7: {
                                            result = result + ai.max_value;
                                        }
                                    }
                                    pname = "Attribute configuration property";
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                    }
                    if (this.level == 8 && this.getParent().getParent().getParent().toString().equals("ATTRIBUTE")) {
                        devname2 = this.getDevname(4);
                        pname = "Attribute configuration property";
                        try {
                            ds = new DeviceProxy(devname2);
                            AttributeInfoEx ai = ds.get_attribute_info_ex(this.getParent().getParent().toString());
                            int p = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                            switch (p) {
                                case 8: {
                                    result = result + ai.min_alarm;
                                    break;
                                }
                                case 9: {
                                    result = result + ai.max_alarm;
                                    break;
                                }
                                case 10: {
                                    if (ai.alarms != null) {
                                        result = result + ai.alarms.min_warning;
                                    }
                                    break;
                                }
                                case 11: {
                                    if (ai.alarms != null) {
                                        result = result + ai.alarms.max_warning;
                                    }
                                    break;
                                }
                                case 12: {
                                    if (ai.alarms != null) {
                                        result = result + ai.alarms.delta_t;
                                    }
                                    break;
                                }
                                case 13: {
                                    if (ai.alarms != null) {
                                        result = result + ai.alarms.delta_val;
                                    }
                                    break;
                                }
                                case 14: {
                                    if (ai.events != null) {
                                        result = result + ai.events.ch_event.rel_change;
                                    }
                                    break;
                                }
                                case 15: {
                                    if (ai.events != null) {
                                        result = result + ai.events.ch_event.abs_change;
                                    }
                                    break;
                                }
                                case 16: {
                                    if (ai.events != null) {
                                        result = result + ai.events.per_event.period;
                                    }
                                    break;
                                }
                                case 17: {
                                    if (ai.events != null) {
                                        result = result + ai.events.arch_event.abs_change;
                                    }
                                    break;
                                }
                                case 18: {
                                    if (ai.events != null) {
                                        result = result + ai.events.arch_event.rel_change;
                                    }
                                    break;
                                }
                                case 19: {
                                    if (ai.events != null) {
                                        result = result + ai.events.arch_event.period;
                                    }
                                    break;
                                }
                                default: {
                                    result = "Not supported property :" + this.toString();
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                    }
                    if (this.level == 6 && this.getParent().toString().equals("COMMAND")) {
                        result = JiveUtils.getPollingStatus(this.getDevname(2), this.toString(), "command", 4);
                        if (result == null) {
                            result = "The command is not polled";
                        }
                        pname = "Command info";
                    }
                    if (this.level != 7 || !this.getParent().getParent().toString().equals("COMMAND")) break;
                    if (this.toString().equals("is_polled")) {
                        result = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "command", 1);
                        result = result == null ? "No" : "Yes";
                    } else if (this.toString().equals("polling_period") && (result = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "command", 2)) == null) {
                        result = "";
                    }
                    pname = "Polling configuration property";
                    break;
                }
                case 4: {
                    if (this.level != 3) break;
                    try {
                        String[] res = this.db.get_property(this.getParent().toString(), this.toString()).extractStringArray();
                        result = JiveUtils.stringArrayToString(res);
                        pname = "Property value";
                        if (res.length < 2) break;
                        pname = pname + " [" + res.length + " items]";
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        e.printStackTrace();
                    }
                    break;
                }
                case 5: {
                    if (this.level != 2) break;
                    try {
                        String devname = this.toString();
                        DbDevice dbdev = new DbDevice(devname);
                        DbDevImportInfo info = dbdev.import_device();
                        result = info.toString();
                        pname = "Device info";
                        break;
                    }
                    catch (DevFailed e) {
                        for (int i = 0; i < e.errors.length; ++i) {
                            result = result + "Desc -> " + e.errors[i].desc + "\n";
                            result = result + "Reason -> " + e.errors[i].reason + "\n";
                            result = result + "Origin -> " + e.errors[i].origin + "\n";
                        }
                        break;
                    }
                }
            }
        }
        ret[0] = result;
        ret[1] = pname;
        return ret;
    }

    public boolean setValue(String value) {
        switch (this.type) {
            case 1: {
                if (this.level == 2 && value.equals("%")) {
                    String classname = this.toString();
                    int ok = JOptionPane.showConfirmDialog(JiveUtils.parent, "This will erase all class and attribute properties for " + classname + "\n Do you want to continue ?", "Confirm delete class properties", 0);
                    if (ok == 0) {
                        return JiveUtils.removeClassProperties(this.db, classname);
                    }
                    return false;
                }
                if (this.level == 4 && this.getParent().toString().equals("PROPERTY")) {
                    try {
                        if (value.equals("%")) {
                            this.db.delete_class_property(this.getParent().getParent().toString(), JiveUtils.makeDbDatum(this.toString(), value));
                        } else {
                            this.db.put_class_property(this.getParent().getParent().toString(), JiveUtils.makeDbDatum(this.toString(), value));
                        }
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return false;
                    }
                }
                if (this.level != 5 || !this.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                try {
                    String className = this.getParent().getParent().getParent().toString();
                    DbAttribute att = new DbAttribute(this.getParent().toString());
                    att.add(this.toString(), value);
                    if (!value.equals("%")) {
                        this.db.put_class_attribute_property(className, att);
                        break;
                    }
                    this.db.delete_class_attribute_property(className, this.getParent().toString(), this.toString());
                    break;
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                    return false;
                }
            }
            case 2: {
                if (this.level == 3 && value.equals("%")) {
                    try {
                        this.db.delete_server(this.getParent().toString() + "/" + this.toString());
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return false;
                    }
                }
                if (this.level == 4) {
                    try {
                        if (value.equals("%")) {
                            for (int i = 0; i < this.getChildCount(); ++i) {
                                this.db.delete_device(this.getChildAt(i).toString());
                            }
                        }
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return false;
                    }
                }
                if (this.level != 5) break;
                try {
                    if (value.equals("%")) {
                        this.db.delete_device(this.toString());
                        break;
                    }
                    this.db.add_device(this.toString(), this.getParent().toString(), this.getParent().getParent().getParent().toString() + "/" + this.getParent().getParent().toString());
                    break;
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                    return false;
                }
            }
            case 3: {
                AttributeInfo[] ais;
                AttributeInfo ai;
                DeviceProxy ds;
                int p;
                String devname;
                if (this.level == 4 && value.equals("%")) {
                    String devname2 = this.getDevname(0);
                    int ok = JOptionPane.showConfirmDialog(JiveUtils.parent, "This will erase all device and attribute properties for " + devname2 + "\n Do you want to continue ?\nHint: To remove the device itself from the database,\ngo to the server node and delete the device\nfrom its class.", "Confirm delte device properties", 0);
                    if (ok == 0) {
                        return JiveUtils.removeDeviceProperties(this.db, devname2);
                    }
                    return false;
                }
                if (this.level == 5 && !this.isDeviceNode()) {
                    devname = this.getDevname(1);
                    try {
                        if (this.toString().equals("current_logging_target")) {
                            return JiveUtils.setLoggingTarget(this.db, devname, value);
                        }
                        if (this.toString().equals("current_logging_level")) {
                            return JiveUtils.setLoggingLevel(this.db, devname, value);
                        }
                        if (value.equals("%")) {
                            this.db.delete_device_property(devname, JiveUtils.makeDbDatum(this.toString(), value));
                        } else {
                            this.db.put_device_property(devname, JiveUtils.makeDbDatum(this.toString(), value));
                        }
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return false;
                    }
                }
                if (this.level == 6 && this.getParent().toString().equals("PROPERTY")) {
                    try {
                        devname = this.getDevname(2);
                        if (value.equals("%")) {
                            this.db.delete_device_property(devname, JiveUtils.makeDbDatum(this.toString(), value));
                        } else {
                            this.db.put_device_property(devname, JiveUtils.makeDbDatum(this.toString(), value));
                        }
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return false;
                    }
                }
                if (this.level == 7 && this.getParent().getParent().toString().equals("ATTRIBUTE")) {
                    try {
                        devname = this.getDevname(3);
                        p = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                        if (this.isPollCfgItem()) {
                            String period = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "attribute", 2);
                            if (this.toString().equals("is_polled")) {
                                if (value.equalsIgnoreCase("yes")) {
                                    if (period == null) {
                                        JiveUtils.addPolling(devname, this.getParent().toString(), "attribute", "3000");
                                    }
                                } else if (period != null) {
                                    JiveUtils.remPolling(devname, this.getParent().toString(), "attribute");
                                }
                            } else if (this.toString().equals("polling_period") && value.length() > 0) {
                                if (period == null) {
                                    JiveUtils.addPolling(devname, this.getParent().toString(), "attribute", value);
                                } else {
                                    JiveUtils.addPolling(devname, this.getParent().toString(), "attribute", value);
                                }
                            }
                        } else if (p >= 0) {
                            ds = new DeviceProxy(devname);
                            ai = ds.get_attribute_info(this.getParent().toString());
                            switch (p) {
                                case 0: {
                                    ai.description = value;
                                    break;
                                }
                                case 1: {
                                    ai.label = value;
                                    break;
                                }
                                case 2: {
                                    ai.unit = value;
                                    break;
                                }
                                case 3: {
                                    ai.standard_unit = value;
                                    break;
                                }
                                case 4: {
                                    ai.display_unit = value;
                                    break;
                                }
                                case 5: {
                                    ai.format = value;
                                    break;
                                }
                                case 6: {
                                    ai.min_value = value;
                                    break;
                                }
                                case 7: {
                                    ai.max_value = value;
                                }
                            }
                            ais = new AttributeInfo[]{ai};
                            ds.set_attribute_info(ais);
                        } else {
                            DbAttribute att = new DbAttribute(this.getParent().toString());
                            att.add(this.toString(), value);
                            if (value.equals("%")) {
                                this.db.delete_device_attribute_property(devname, att);
                            } else {
                                this.db.put_device_attribute_property(devname, att);
                            }
                        }
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return false;
                    }
                }
                if (this.level == 8 && this.getParent().getParent().getParent().toString().equals("ATTRIBUTE")) {
                    try {
                        devname = this.getDevname(4);
                        p = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                        if (p >= 0) {
                            ds = new DeviceProxy(devname);
                            ai = ds.get_attribute_info_ex(this.getParent().getParent().toString());
                            if ((ai.alarms == null || ai.events == null) && p > 9) {
                                JiveUtils.showJiveError("The attribute property " + this.toString() + " is not supported by the device.");
                                return false;
                            }
                            switch (p) {
                                case 8: {
                                    ai.min_alarm = value;
                                    if (ai.alarms == null) break;
                                    ai.alarms.min_alarm = value;
                                    break;
                                }
                                case 9: {
                                    ai.max_alarm = value;
                                    if (ai.alarms == null) break;
                                    ai.alarms.max_alarm = value;
                                    break;
                                }
                                case 10: {
                                    ai.alarms.min_warning = value;
                                    break;
                                }
                                case 11: {
                                    ai.alarms.max_warning = value;
                                    break;
                                }
                                case 12: {
                                    ai.alarms.delta_t = value;
                                    break;
                                }
                                case 13: {
                                    ai.alarms.delta_val = value;
                                    break;
                                }
                                case 14: {
                                    ai.events.ch_event.rel_change = value;
                                    break;
                                }
                                case 15: {
                                    ai.events.ch_event.abs_change = value;
                                    break;
                                }
                                case 16: {
                                    ai.events.per_event.period = value;
                                    break;
                                }
                                case 17: {
                                    ai.events.arch_event.abs_change = value;
                                    break;
                                }
                                case 18: {
                                    ai.events.arch_event.rel_change = value;
                                    break;
                                }
                                case 19: {
                                    ai.events.arch_event.period = value;
                                    break;
                                }
                                default: {
                                    JiveUtils.showJiveError("Unexpected property : " + this.toString());
                                }
                            }
                            ais = new AttributeInfoEx[]{ai};
                            ds.set_attribute_info((AttributeInfoEx[])ais);
                        }
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return false;
                    }
                }
                if (this.level != 7 || !this.getParent().getParent().toString().equals("COMMAND")) break;
                try {
                    devname = this.getDevname(3);
                    if (!this.isPollCfgItem()) break;
                    String period = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "command", 2);
                    if (this.toString().equals("is_polled")) {
                        if (value.equalsIgnoreCase("yes")) {
                            if (period != null) break;
                            JiveUtils.addPolling(devname, this.getParent().toString(), "command", "3000");
                            break;
                        }
                        if (period == null) break;
                        JiveUtils.remPolling(devname, this.getParent().toString(), "command");
                        break;
                    }
                    if (!this.toString().equals("polling_period")) break;
                    if (period == null) {
                        JiveUtils.addPolling(devname, this.getParent().toString(), "command", value);
                        break;
                    }
                    JiveUtils.addPolling(devname, this.getParent().toString(), "command", value);
                    break;
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                    return false;
                }
            }
            case 4: {
                if (this.level != 3) break;
                try {
                    if (value.equals("%")) {
                        this.db.delete_property(this.getParent().toString(), this.toString());
                        break;
                    }
                    this.db.put_property(this.getParent().toString(), JiveUtils.makeDbDatum(this.toString(), value));
                    break;
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                    return false;
                }
            }
        }
        return true;
    }

    public String getDevname(int level) {
        TreeNode father = this;
        for (int i = 0; i < level; ++i) {
            father = father.getParent();
        }
        return father.getParent().getParent().toString() + "/" + father.getParent().toString() + "/" + father.toString();
    }

    public void saveServerData(FileWriter fw) throws IOException {
        String srvName = this.getParent().toString() + "/" + this.toString();
        try {
            DbServer dbs = new DbServer(srvName);
            String[] class_list = dbs.get_class_list();
            for (int i = 0; i < class_list.length; ++i) {
                int k;
                boolean prtOut;
                DbAttribute[] lst;
                String[] att_list;
                int j;
                String[] prop_list;
                if (!JiveUtils.isSavedClass(class_list[i])) {
                    String[] value;
                    fw.write("#---------------------------------------------------------\n");
                    fw.write("# CLASS " + class_list[i] + " properties\n");
                    fw.write("#---------------------------------------------------------\n\n");
                    prop_list = this.db.get_class_property_list(class_list[i], "*");
                    for (j = 0; j < prop_list.length; ++j) {
                        value = this.db.get_class_property(class_list[i], prop_list[j]).extractStringArray();
                        if (prop_list[j].indexOf(32) != -1) {
                            prop_list[j] = "\"" + prop_list[j] + "\"";
                        }
                        JiveUtils.printFormatedRes("CLASS/" + class_list[i] + "->" + prop_list[j] + ": ", value, fw);
                    }
                    att_list = this.db.get_class_attribute_list(class_list[i], "*");
                    lst = this.db.get_class_attribute_property(class_list[i], att_list);
                    prtOut = false;
                    for (k = 0; k < lst.length; ++k) {
                        prop_list = lst[k].get_property_list();
                        for (j = 0; j < prop_list.length; ++j) {
                            if (!prtOut) {
                                fw.write("\n# CLASS " + class_list[i] + " attribute properties\n\n");
                                prtOut = true;
                            }
                            if (prop_list[j].indexOf(32) != -1 || prop_list[j].indexOf(47) != -1) {
                                prop_list[j] = "\"" + prop_list[j] + "\"";
                            }
                            value = lst[k].get_value(j);
                            JiveUtils.printFormatedRes("CLASS/" + class_list[i] + "/" + att_list[k] + "->" + prop_list[j] + ": ", value, fw);
                        }
                    }
                    fw.write("\n");
                    JiveUtils.addSavedClass(class_list[i]);
                }
                fw.write("#---------------------------------------------------------\n");
                fw.write("# SERVER " + srvName + ", " + class_list[i] + " device declaration\n");
                fw.write("#---------------------------------------------------------\n\n");
                String[] dev_list = dbs.get_device_name(class_list[i]);
                JiveUtils.printFormatedRes(srvName + "/DEVICE/" + class_list[i] + ": ", dev_list, fw);
                fw.write("\n");
                for (int l = 0; l < dev_list.length; ++l) {
                    prop_list = this.db.get_device_property_list(dev_list[l], "*");
                    if (prop_list.length > 0) {
                        fw.write("\n# --- " + dev_list[l] + " properties\n\n");
                        for (j = 0; j < prop_list.length; ++j) {
                            String[] value = this.db.get_device_property(dev_list[l], prop_list[j]).extractStringArray();
                            if (prop_list[j].indexOf(32) != -1 || prop_list[j].indexOf(47) != -1) {
                                prop_list[j] = "\"" + prop_list[j] + "\"";
                            }
                            JiveUtils.printFormatedRes(dev_list[l] + "->" + prop_list[j] + ": ", value, fw);
                        }
                    }
                    try {
                        DeviceProxy ds = new DeviceProxy(dev_list[l]);
                        att_list = ds.get_attribute_list();
                        lst = this.db.get_device_attribute_property(dev_list[l], att_list);
                        prtOut = false;
                        for (k = 0; k < lst.length; ++k) {
                            prop_list = lst[k].get_property_list();
                            for (j = 0; j < prop_list.length; ++j) {
                                if (!prtOut) {
                                    fw.write("\n# --- " + dev_list[l] + " attribute properties\n\n");
                                    prtOut = true;
                                }
                                if (prop_list[j].indexOf(32) != -1 || prop_list[j].indexOf(47) != -1) {
                                    prop_list[j] = "\"" + prop_list[j] + "\"";
                                }
                                String[] value = lst[k].get_value(j);
                                JiveUtils.printFormatedRes(dev_list[l] + "/" + att_list[k] + "->" + prop_list[j] + ": ", value, fw);
                            }
                        }
                        continue;
                    }
                    catch (DevFailed e) {
                        JiveUtils.showJiveError("Attribute properties for " + dev_list[l] + " has not been saved !\n" + e.errors[0].desc);
                    }
                }
                fw.write("\n");
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void editProperties(String info) {
        int count = this.getChildCount();
        if (count > 0) {
            TreePath[] paths = new TreePath[count];
            Object[][] rows = new Object[count][2];
            for (int i = 0; i < count; ++i) {
                TangoTreeNode n = (TangoTreeNode)this.getChildAt(i);
                paths[i] = n.getCompletePath();
                String[] values = n.getValue();
                rows[i][0] = JiveUtils.formatPath(paths[i]);
                rows[i][1] = values[0];
            }
            DetailsDlg dlg = new DetailsDlg(JiveUtils.parent, rows, paths);
            dlg.showDlg();
        } else {
            JiveUtils.showJiveError("No properties defined for " + info);
        }
    }

    public void editAttProperties(String info) {
        int count = this.getChildCount();
        TreePath[] paths = new TreePath[count + 8];
        Object[][] rows = new Object[count + 8][2];
        int k = 0;
        for (int i = 0; i < count; ++i) {
            TangoTreeNode n = (TangoTreeNode)this.getChildAt(i);
            if (n.isLeaf()) {
                String[] values = n.getValue();
                paths[k] = n.getCompletePath();
                rows[k][0] = JiveUtils.formatPath(paths[k]);
                rows[k][1] = values[0];
                ++k;
                continue;
            }
            for (int j = 0; j < n.getChildCount(); ++j) {
                TangoTreeNode n2 = (TangoTreeNode)n.getChildAt(j);
                String[] values = n2.getValue();
                paths[k] = n2.getCompletePath();
                rows[k][0] = JiveUtils.formatPath(paths[k]);
                rows[k][1] = values[0];
                ++k;
            }
        }
        DetailsDlg dlg = new DetailsDlg(JiveUtils.parent, rows, paths);
        dlg.showDlg();
    }

    @Override
    public String toString() {
        return this.value;
    }

    public TreePath getCompletePath() {
        TangoTreeNode node = this;
        Object[] nodes = new TangoTreeNode[node.level + 1];
        for (int i = nodes.length - 1; i >= 0; --i) {
            nodes[i] = node;
            node = (TangoTreeNode)node.getParent();
        }
        return new TreePath(nodes);
    }

    public String toStringEx() {
        int i;
        String ret = "";
        TangoTreeNode node = this;
        TangoTreeNode[] nodes = new TangoTreeNode[node.level + 1];
        for (i = nodes.length - 1; i >= 0; --i) {
            nodes[i] = node;
            node = (TangoTreeNode)node.getParent();
        }
        for (i = 0; i < nodes.length; ++i) {
            ret = ret + nodes[i].toString();
            ret = ret + "/";
        }
        return ret;
    }
}

