/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jive.DevWizard;
import jive.JiveUtils;
import jive.WizardPanel;

class PropertyPanel
extends WizardPanel
implements ActionListener {
    static final int CLASS_PROPERTY = 0;
    static final int DEVICE_PROPERTY = 1;
    JTextArea propValue;
    JScrollPane valueView;
    JButton setDefaultButton;
    JButton viewDefaultButton;
    int type;
    String entity;
    String description;
    String name;
    String defValue;
    String dbValue;
    String srvName;
    String devClass;

    public PropertyPanel(DevWizard parent, int propertyType, String serverName, String entityName, String propertyName, String propertyDesc, String defaultValue, String deviceClassName) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(350, 95));
        this.parent = parent;
        this.entity = entityName;
        this.type = propertyType;
        this.description = propertyDesc;
        this.name = propertyName;
        this.defValue = defaultValue;
        this.dbValue = defaultValue;
        this.srvName = serverName;
        this.devClass = deviceClassName;
        this.propValue = new JTextArea();
        this.propValue.setEditable(true);
        this.propValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.valueView = new JScrollPane(this.propValue);
        this.valueView.setBounds(0, 0, 230, 95);
        this.add(this.valueView);
        this.refreshValue();
        this.setDefaultButton = new JButton("Set Default");
        this.setDefaultButton.setMargin(new Insets(2, 1, 2, 1));
        this.setDefaultButton.setFont(DevWizard.wizFont);
        this.setDefaultButton.addActionListener(this);
        this.setDefaultButton.setBounds(235, 0, 115, 25);
        this.add(this.setDefaultButton);
        this.viewDefaultButton = new JButton("View Default");
        this.viewDefaultButton.setMargin(new Insets(2, 1, 2, 1));
        this.viewDefaultButton.setFont(DevWizard.wizFont);
        this.viewDefaultButton.addActionListener(this);
        this.viewDefaultButton.setBounds(235, 30, 115, 25);
        this.add(this.viewDefaultButton);
        this.panelIcon = propertyType == 0 ? new ImageIcon(this.getClass().getResource("/jive/class_wz.gif")) : new ImageIcon(this.getClass().getResource("/jive/device_wz.gif"));
    }

    private void refreshValue() {
        DbDatum d = null;
        try {
            Database db = ApiUtil.get_db_obj();
            switch (this.type) {
                case 0: {
                    d = db.get_class_property(this.entity, this.name);
                    break;
                }
                case 1: {
                    d = db.get_device_property(this.entity, this.name);
                }
            }
            this.dbValue = this.defValue;
            if (!d.is_empty()) {
                this.dbValue = d.extractString();
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        this.propValue.setText(this.dbValue);
    }

    public void setEntityName(String s) {
        this.entity = s;
        this.refreshValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.setDefaultButton) {
            this.propValue.setText(this.defValue);
        } else if (src == this.viewDefaultButton) {
            JOptionPane.showMessageDialog(this, this.defValue, "Default value for " + this.name, 1);
        }
    }

    @Override
    public String getTitle() {
        return "Property: " + this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean getNextState() {
        return true;
    }

    @Override
    public boolean next() {
        String newValue = this.propValue.getText();
        if (!newValue.equals(this.dbValue)) {
            DbDatum d = new DbDatum(this.name, newValue);
            DbDatum[] argin = new DbDatum[]{d};
            try {
                Database db = ApiUtil.get_db_obj();
                switch (this.type) {
                    case 0: {
                        db.put_class_property(this.entity, JiveUtils.makeDbDatum(this.name, newValue));
                        break;
                    }
                    case 1: {
                        db.put_device_property(this.entity, JiveUtils.makeDbDatum(this.name, newValue));
                    }
                }
                System.out.println("Writting " + this.entity + "/" + this.name + " to database");
                this.dbValue = newValue;
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean back() {
        return true;
    }

    @Override
    public String getSubTitle() {
        String ret = "Server:\n " + this.srvName + "\n";
        switch (this.type) {
            case 0: {
                ret = ret + "Class:\n " + this.entity;
                break;
            }
            case 1: {
                ret = ret + "Class:\n " + this.devClass + "\n";
                ret = ret + "Device:\n " + this.entity;
            }
        }
        return ret;
    }
}

