/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import jive.MultiLineCellRenderer;
import jive.MultiLineTextArea;

public class MultiLineCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    MultiLineTextArea textArea;
    JScrollPane textView;
    JTable table;

    public MultiLineCellEditor(JTable ta) {
        this.table = ta;
        MultiLineCellRenderer renderer = new MultiLineCellRenderer();
        this.table.setDefaultRenderer(String.class, renderer);
        this.textArea = new MultiLineTextArea(this);
        this.textView = new JScrollPane(this.textArea);
        this.textView.setVerticalScrollBarPolicy(21);
        this.textView.setHorizontalScrollBarPolicy(31);
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.updateRow(i);
        }
    }

    public MultiLineTextArea getTextArea() {
        return this.textArea;
    }

    private int cellHeight(int row, int col) {
        if (row == this.table.getEditingRow() && col == this.table.getEditingColumn()) {
            return this.textArea.getPreferredSize().height + 4;
        }
        return this.table.getDefaultRenderer(String.class).getTableCellRendererComponent((JTable)this.table, (Object)this.table.getModel().getValueAt((int)row, (int)col), (boolean)false, (boolean)false, (int)row, (int)col).getPreferredSize().height + 1;
    }

    void updateRow(int row) {
        int maxHeight = 0;
        for (int j = 0; j < this.table.getColumnCount(); ++j) {
            int ch = this.cellHeight(row, j);
            if (ch <= maxHeight) continue;
            maxHeight = ch;
        }
        this.table.setRowHeight(row, maxHeight);
    }

    public void updateRows() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.updateRow(i);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textArea.rowEditing = row;
        this.textArea.columnEditing = column;
        this.textArea.setEditable(column != 0);
        this.textArea.ignoreChange = true;
        this.textArea.setText(table.getValueAt(row, column).toString());
        this.textArea.ignoreChange = false;
        table.setRowHeight(row, this.textArea.getPreferredSize().height + 4);
        return this.textView;
    }
}

