/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.DetailsDlg;
import jive.JiveUtils;
import jive.MultiLineToolTipUI;
import jive.SearchDlg;
import jive.TangoFileReader;
import jive.TangoTreeNode;
import jive.TangoTreeNodeRenderer;
import jive.ThreadDlg;

public class MainPanel
extends JFrame {
    static ThreadDlg applyDlg;
    static TreePath[] applySelPath;
    static String applyValue;
    private JTree mainTree = null;
    private DefaultTreeModel mainTreeModel;
    private DefaultMutableTreeNode rootNode;
    private TangoTreeNodeRenderer renderer;
    private MouseListener treeMousellistemner;
    private MouseListener valueMousellistemner;
    private TreeSelectionListener treeSelectionlistemner;
    private JScrollPane treeView;
    private JSplitPane splitPane;
    private JPanel resPanel;
    private JPanel btnPanel;
    private JTextArea resValue;
    private JScrollPane resView;
    private JButton applyPb;
    private JButton refreshPb;
    private JButton detailsPb;
    private Database db;
    private String tangoHost;
    private JLabel statusLine;
    private JMenuBar mainMenu;
    private JPopupMenu treeMenu;
    private JMenuItem[] treeMenuItem;
    private JMenuItem jMenuItemMDelete;
    private JMenuItem jMenuItemMCopy;
    private JMenuItem jMenuItemMSave;
    private JPopupMenu treeMenuMultiple;
    private JMenuItem jMenuItemMDelete2;
    private JMenuItem jMenuItemMCopy2;
    private JMenuItem jMenuItemMSave2;
    private boolean running_from_shell;
    private boolean refresh_values = true;
    private boolean searchInProgress = false;
    private static final String appVersion = "Jive 2.7e ";

    public MainPanel() {
        this.running_from_shell = false;
        this.initComponents();
        this.centerWindow();
        this.placeComponents();
        this.setTitle(appVersion);
        this.setVisible(true);
        JiveUtils.parent = this;
    }

    public MainPanel(boolean runningFromShell, boolean readOnly) {
        this.running_from_shell = runningFromShell;
        JiveUtils.readOnly = readOnly;
        this.initComponents();
        this.centerWindow();
        this.placeComponents();
        this.setTitle(appVersion);
        this.setVisible(true);
        JiveUtils.parent = this;
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = new Dimension(750, 500);
        int x = (scrsize.width - appsize.width) / 2;
        int y = (scrsize.height - appsize.height) / 2;
        this.setBounds(x, y, appsize.width, appsize.height);
    }

    private boolean isEditable(String name) {
        return name.startsWith("Property value") || name.startsWith("Polling configuration property") || name.startsWith("Attribute configuration property") || name.startsWith("HDB configuration property") || name.startsWith("Logging configuration property");
    }

    private void refreshValues(TreePath selPath) {
        String[] values = JiveUtils.getValue(selPath);
        this.resValue.setText(values[0]);
        this.resValue.setCaretPosition(0);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), values[1]);
        this.resView.setBorder(b);
        this.resValue.setEditable(this.isEditable(values[1]) && !JiveUtils.readOnly);
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(false);
    }

    private void refreshEmptySelection() {
        this.resValue.setText("");
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.resView.setBorder(b);
        this.resValue.setEditable(false);
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(false);
        this.statusLine.setText("");
        this.jMenuItemMDelete.setEnabled(false);
        this.jMenuItemMCopy.setEnabled(false);
        this.jMenuItemMSave.setEnabled(false);
        this.jMenuItemMDelete2.setEnabled(false);
        this.jMenuItemMCopy2.setEnabled(false);
        this.jMenuItemMSave2.setEnabled(false);
    }

    private void refreshValuesMultiple(TreePath[] selPaths) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String[] values = JiveUtils.getValue(selPaths[0]);
        boolean only_property_selected = this.isEditable(values[1]);
        boolean same_value = true;
        String res_value = values[0];
        for (int i = 1; i < selPaths.length; ++i) {
            values = JiveUtils.getValue(selPaths[i]);
            same_value &= values[0].equals(res_value);
            only_property_selected &= this.isEditable(values[1]);
        }
        if (same_value) {
            this.resValue.setText(res_value);
        } else {
            this.resValue.setText("Values are not equals");
        }
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Multiple selection");
        this.resView.setBorder(b);
        this.resValue.setEditable(only_property_selected && !JiveUtils.readOnly);
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(!same_value);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void gobalValueRefresh() {
        TreePath[] selPaths = this.mainTree.getSelectionPaths();
        if (selPaths != null) {
            if (selPaths.length == 1) {
                String status = JiveUtils.formatPath(selPaths[0]);
                this.statusLine.setText(status);
                this.refreshValues(selPaths[0]);
                this.jMenuItemMDelete.setEnabled(false);
                this.jMenuItemMCopy.setEnabled(false);
                this.jMenuItemMSave.setEnabled(false);
                this.jMenuItemMDelete2.setEnabled(false);
                this.jMenuItemMCopy2.setEnabled(false);
                this.jMenuItemMSave2.setEnabled(false);
            } else if (selPaths.length > 1) {
                this.statusLine.setText("Multiple selection: " + selPaths.length + " items selected");
                this.refreshValuesMultiple(selPaths);
                this.jMenuItemMDelete.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMCopy.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMSave.setEnabled(true);
                this.jMenuItemMDelete2.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMCopy2.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMSave2.setEnabled(true);
            } else if (selPaths.length == 0) {
                this.refreshEmptySelection();
            }
        } else {
            this.refreshEmptySelection();
        }
    }

    private void refreshTree() {
        TreePath old_p = this.mainTree.getSelectionPath();
        this.splitPane.remove(this.treeView);
        this.createMainTree();
        this.splitPane.setLeftComponent(this.treeView);
        TreePath np = JiveUtils.convertOldPath(this.mainTreeModel, (TangoTreeNode)this.rootNode, old_p);
        this.mainTree.setSelectionPath(np);
        this.mainTree.expandPath(np);
        this.mainTree.makeVisible(np);
        this.mainTree.scrollPathToVisible(np);
        this.placeComponents();
    }

    private void createMainTree() {
        if (this.mainTree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.mainTree);
        }
        this.renderer = new TangoTreeNodeRenderer();
        this.rootNode = new TangoTreeNode(0, 0, this.tangoHost, this.db, true);
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.mainTreeModel);
        this.mainTree.setEditable(false);
        this.mainTree.setCellRenderer(this.renderer);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.mainTree);
        this.mainTree.addMouseListener(this.treeMousellistemner);
        this.mainTree.addTreeSelectionListener(this.treeSelectionlistemner);
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        ToolTipManager.sharedInstance().setInitialDelay(500);
    }

    public void showClipboard() {
        JiveUtils.the_clipboard.show(this);
    }

    public void showDetails() {
        TreePath[] selPaths = this.mainTree.getSelectionPaths();
        if (selPaths != null) {
            Object[][] rows = new Object[selPaths.length][2];
            for (int i = 0; i < selPaths.length; ++i) {
                String[] values = JiveUtils.getValue(selPaths[i]);
                rows[i][0] = JiveUtils.formatPath(selPaths[i]);
                rows[i][1] = values[0];
            }
            DetailsDlg dlg = new DetailsDlg((Frame)this, rows, selPaths);
            dlg.showDlg();
        }
    }

    public boolean checkDeviceName(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        int nb = 0;
        for (int i = 0; i < s.length() && nb <= 2; ++i) {
            if (s.charAt(i) != '/') continue;
            ++nb;
        }
        return nb == 2;
    }

    public void applyChange() {
        applySelPath = this.mainTree.getSelectionPaths();
        applyValue = this.resValue.getText();
        Thread doApply = new Thread(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < applySelPath.length && !ThreadDlg.stopflag; ++i) {
                        JiveUtils.setValue(applySelPath[i], applyValue);
                        applyDlg.setProgress((i + 1) * 100 / applySelPath.length);
                    }
                    MainPanel.this.gobalValueRefresh();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                applyDlg.hideDlg();
            }
        };
        if (applySelPath != null) {
            if (applySelPath.length > 1) {
                applyDlg = new ThreadDlg((Frame)this, "", true, doApply);
                applyDlg.showDlg();
            } else {
                for (int i = 0; i < applySelPath.length; ++i) {
                    JiveUtils.setValue(applySelPath[i], applyValue);
                }
                this.gobalValueRefresh();
            }
        }
    }

    private void initComponents() {
        int i;
        this.getContentPane().setLayout(null);
        MultiLineToolTipUI.initialize();
        this.tangoHost = System.getProperty("TANGO_HOST", "null");
        if (this.tangoHost.equals("null") || this.tangoHost.equals("")) {
            System.out.println("TANGO_HOST no defined, exiting...");
            this.exitForm();
        }
        try {
            this.db = ApiUtil.get_db_obj();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            this.db = null;
        }
        if (JiveUtils.hdbEnabled) {
            try {
                JiveUtils.hdbManager = new DeviceProxy("Archivage/HdbManager/HdbManager");
                JiveUtils.hdbEnabled = true;
            }
            catch (DevFailed e) {
                JiveUtils.hdbEnabled = false;
            }
        }
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(1);
        this.resPanel = new JPanel(new BorderLayout());
        this.resPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnPanel = new JPanel(new FlowLayout(0));
        this.resPanel.add((Component)this.btnPanel, "South");
        this.resValue = new JTextArea();
        this.resValue.setBackground(Color.white);
        this.resValue.setForeground(Color.black);
        this.resValue.setOpaque(true);
        this.resValue.setText("");
        this.resValue.setEditable(false);
        this.resValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.resValue.setFont(new Font("Monospaced", 0, 11));
        this.valueMousellistemner = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TangoTreeNode devnode;
                TangoTreeNode n;
                String sel;
                if (e.getClickCount() == 1 && e.getButton() == 3 && MainPanel.this.checkDeviceName(sel = MainPanel.this.resValue.getSelectedText()) && (n = JiveUtils.findDeviceNode(devnode = (TangoTreeNode)MainPanel.this.rootNode.getChildAt(2), sel)) != null) {
                    TreePath np = n.getCompletePath();
                    MainPanel.this.mainTree.setSelectionPath(np);
                    MainPanel.this.mainTree.scrollPathToVisible(np);
                }
            }
        };
        this.resValue.addMouseListener(this.valueMousellistemner);
        this.resValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }

            public void updateLog(DocumentEvent e, String action) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }
        });
        this.resView = new JScrollPane(this.resValue);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.resView.setBorder(b);
        this.resPanel.add((Component)this.resView, "Center");
        this.applyPb = new JButton();
        this.applyPb.setText("Apply change");
        this.applyPb.setEnabled(false);
        this.applyPb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (MainPanel.this.applyPb.isEnabled()) {
                    MainPanel.this.applyChange();
                }
            }
        });
        this.btnPanel.add(this.applyPb);
        this.detailsPb = new JButton();
        this.detailsPb.setText("Show details");
        this.detailsPb.setEnabled(false);
        this.detailsPb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (MainPanel.this.detailsPb.isEnabled()) {
                    MainPanel.this.showDetails();
                }
            }
        });
        this.btnPanel.add(this.detailsPb);
        this.refreshPb = new JButton();
        this.refreshPb.setText("Refresh");
        this.btnPanel.add(this.refreshPb);
        this.refreshPb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.gobalValueRefresh();
            }
        });
        this.splitPane.setRightComponent(this.resPanel);
        this.statusLine = new JLabel();
        this.statusLine.setFont(new Font("Dialog", 0, 12));
        this.statusLine.setBackground(Color.white);
        this.statusLine.setForeground(Color.black);
        this.statusLine.setOpaque(true);
        this.statusLine.setText("");
        this.statusLine.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add(this.statusLine);
        this.treeMousellistemner = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = MainPanel.this.mainTree.getPathForLocation(e.getX(), e.getY());
                int selRow = MainPanel.this.mainTree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1 && e.getButton() == 3 && selPath != null) {
                    boolean found = false;
                    int i = 0;
                    while (i < MainPanel.this.mainTree.getSelectionCount() && !found) {
                        found = MainPanel.this.mainTree.getSelectionPaths()[i].equals(selPath);
                        if (found) continue;
                        ++i;
                    }
                    if (MainPanel.this.mainTree.getSelectionCount() <= 1 || !found) {
                        MainPanel.this.mainTree.setSelectionPath(selPath);
                        boolean[] menuState = JiveUtils.getAction(selPath);
                        for (i = 0; i < menuState.length; ++i) {
                            MainPanel.this.treeMenuItem[i].setEnabled(menuState[i]);
                            if (i <= 3) continue;
                            MainPanel.this.treeMenuItem[i].setVisible(menuState[i]);
                        }
                        MainPanel.this.treeMenu.show(MainPanel.this.mainTree, e.getX(), e.getY());
                    } else {
                        boolean copyOk = true;
                        boolean deleteOk = true;
                        boolean saveOk = true;
                        for (i = 0; i < MainPanel.this.mainTree.getSelectionCount(); ++i) {
                            boolean[] menuState = JiveUtils.getAction(MainPanel.this.mainTree.getSelectionPaths()[i]);
                            copyOk = copyOk && menuState[1];
                            deleteOk = deleteOk && menuState[3];
                            saveOk = menuState[15];
                        }
                        MainPanel.this.jMenuItemMCopy2.setEnabled(copyOk);
                        MainPanel.this.jMenuItemMDelete2.setEnabled(deleteOk);
                        MainPanel.this.jMenuItemMSave2.setEnabled(saveOk);
                        MainPanel.this.treeMenuMultiple.show(MainPanel.this.mainTree, e.getX(), e.getY());
                    }
                }
            }
        };
        this.treeSelectionlistemner = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (MainPanel.this.refresh_values) {
                    MainPanel.this.gobalValueRefresh();
                }
            }
        };
        this.createMainTree();
        this.splitPane.setLeftComponent(this.treeView);
        this.getContentPane().add(this.splitPane);
        this.mainMenu = new JMenuBar();
        JMenu jMenu1 = new JMenu();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem1 = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        this.jMenuItemMDelete = new JMenuItem();
        this.jMenuItemMCopy = new JMenuItem();
        this.jMenuItemMSave = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        JMenuItem jMenuItem8 = new JMenuItem();
        JMenuItem jMenuItem9 = new JMenuItem();
        JMenuItem jMenuItem10 = new JMenuItem();
        jMenu1.setText("File");
        jMenu2.setText("Edit");
        jMenuItem1.setText("Exit");
        jMenuItem2.setText("Refresh tree");
        jMenuItem3.setText("Show clipbaord");
        jMenuItem4.setText("Clear clipbaord");
        this.jMenuItemMDelete.setText("Multiple delete");
        this.jMenuItemMCopy.setText("Multiple copy");
        this.jMenuItemMSave.setText("Multiple save");
        jMenuItem7.setText("Multiple selection");
        jMenuItem8.setText("Find property");
        jMenuItem9.setText("Find next");
        jMenuItem10.setText("Load property file");
        jMenuItem10.setEnabled(!JiveUtils.readOnly);
        jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.exitForm();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.refreshTree();
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.showClipboard();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JiveUtils.the_clipboard.clear();
            }
        });
        this.jMenuItemMDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.execMultipleAction(3);
            }
        });
        this.jMenuItemMCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.execMultipleAction(1);
            }
        });
        this.jMenuItemMSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.execMultipleAction(15);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!MainPanel.this.searchInProgress) {
                    MainPanel.this.searchInProgress = true;
                    MainPanel.this.selectProperties();
                    MainPanel.this.searchInProgress = false;
                }
            }
        });
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!MainPanel.this.searchInProgress) {
                    MainPanel.this.searchInProgress = true;
                    MainPanel.this.findProperty(0);
                    MainPanel.this.searchInProgress = false;
                }
            }
        });
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!MainPanel.this.searchInProgress) {
                    MainPanel.this.searchInProgress = true;
                    MainPanel.this.findProperty(1);
                    MainPanel.this.searchInProgress = false;
                }
            }
        });
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.loadPropFile();
            }
        });
        this.jMenuItemMDelete.setEnabled(false);
        this.jMenuItemMCopy.setEnabled(false);
        this.jMenuItemMSave.setEnabled(false);
        jMenu1.add(jMenuItem10);
        jMenu1.add(new JSeparator());
        jMenu1.add(jMenuItem1);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem7);
        jMenu2.add(new JSeparator());
        jMenu2.add(this.jMenuItemMDelete);
        jMenu2.add(this.jMenuItemMCopy);
        jMenu2.add(this.jMenuItemMSave);
        jMenu2.add(new JSeparator());
        jMenu2.add(jMenuItem8);
        jMenu2.add(jMenuItem9);
        this.mainMenu.add(jMenu1);
        this.mainMenu.add(jMenu2);
        this.setJMenuBar(this.mainMenu);
        this.treeMenu = new JPopupMenu();
        this.treeMenuItem = new JMenuItem[JiveUtils.nbAction];
        for (i = 0; i < JiveUtils.nbAction; ++i) {
            this.treeMenuItem[i] = new JMenuItem();
            this.treeMenuItem[i].setEnabled(false);
            this.treeMenuItem[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.execMenuAction(evt);
                }
            });
        }
        this.treeMenuItem[0].setText("Cut");
        this.treeMenuItem[1].setText("Copy");
        this.treeMenuItem[2].setText("Paste");
        this.treeMenuItem[3].setText("Delete");
        this.treeMenuItem[4].setText("Add device");
        this.treeMenuItem[5].setText("Create server");
        this.treeMenuItem[6].setText("Create new property");
        this.treeMenuItem[7].setText("Change TANGO HOST");
        this.treeMenuItem[8].setText("Add class to server");
        this.treeMenuItem[9].setText("Rename");
        this.treeMenuItem[10].setText("Monitor device");
        this.treeMenuItem[11].setText("Test device");
        this.treeMenuItem[12].setText("Show properties");
        this.treeMenuItem[13].setText("Test admin server");
        this.treeMenuItem[14].setText("Unexport devices");
        this.treeMenuItem[15].setText("Save server data");
        this.treeMenuItem[16].setText("Define device alias");
        this.treeMenuItem[17].setText("Go to server node");
        this.treeMenuItem[18].setText("Go to device node");
        this.treeMenuItem[19].setText("Restart device");
        this.treeMenuItem[20].setText("Reset to default value");
        this.treeMenuItem[21].setText("Go to device admin node");
        this.treeMenuItem[22].setText("Change Archiving mode");
        this.treeMenuItem[23].setText("Create class attribute");
        this.treeMenuItem[24].setText("Server wizard");
        this.treeMenuItem[25].setText("Classes wizard");
        this.treeMenuItem[26].setText("Devices wizard");
        this.treeMenuItem[27].setText("Device wizard");
        for (i = 0; i < JiveUtils.nbAction; ++i) {
            if (i == 4) {
                this.treeMenu.add(new JSeparator());
            }
            this.treeMenu.add(this.treeMenuItem[i]);
        }
        this.treeMenuMultiple = new JPopupMenu();
        this.jMenuItemMDelete2 = new JMenuItem();
        this.jMenuItemMCopy2 = new JMenuItem();
        this.jMenuItemMSave2 = new JMenuItem();
        this.jMenuItemMDelete2.setText("Delete");
        this.jMenuItemMCopy2.setText("Copy");
        this.jMenuItemMSave2.setText("Save servers");
        this.treeMenuMultiple.add(this.jMenuItemMCopy2);
        this.treeMenuMultiple.add(this.jMenuItemMDelete2);
        this.treeMenuMultiple.add(this.jMenuItemMSave2);
        this.jMenuItemMDelete2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.execMultipleAction(3);
            }
        });
        this.jMenuItemMCopy2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.execMultipleAction(1);
            }
        });
        this.jMenuItemMSave2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.execMultipleAction(15);
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                MainPanel.this.exitForm();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TreePath selPath;
                if (JiveUtils.dlg != null && (selPath = MainPanel.this.mainTree.getSelectionPath()) != null) {
                    MainPanel.this.mainTree.makeVisible(selPath);
                    Rectangle r = MainPanel.this.mainTree.getPathBounds(selPath);
                    Point pto = r.getLocation();
                    SwingUtilities.convertPointToScreen(pto, MainPanel.this.mainTree);
                    JiveUtils.dlg.moveToLocation(pto.x, pto.y);
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MainPanel.this.placeComponents();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                MainPanel.this.placeComponents();
            }
        });
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/jive/jive.jpg"));
        this.setIconImage(icon.getImage());
    }

    public void loadPropFile() {
        String err = "";
        TangoFileReader fr = new TangoFileReader(this.db);
        JFileChooser chooser = new JFileChooser(".");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            if (f != null) {
                err = fr.parse_res_file(f.getAbsolutePath());
            }
            if (err.length() > 0) {
                JiveUtils.showJiveError(err);
            }
        }
    }

    public void execMenuAction(ActionEvent evt) {
        Rectangle r;
        boolean needRefresh;
        TreePath selPath;
        String th;
        JMenuItem sel = (JMenuItem)evt.getSource();
        int i = 0;
        boolean found = false;
        while (i < JiveUtils.nbAction && !found) {
            found = sel == this.treeMenuItem[i];
            if (found) continue;
            ++i;
        }
        if (i == 7 && (th = JOptionPane.showInputDialog(this, "Enter tango host (ex gizmo:20000)", "Jive", 3)) != null) {
            String[] ths = th.split(":");
            if (ths.length != 2) {
                JiveUtils.showJiveError("Invalid tango host syntax: should be host:port");
                return;
            }
            try {
                Integer.parseInt(ths[1]);
            }
            catch (NumberFormatException e) {
                JiveUtils.showJiveError("Invalid tango host port number\n" + e.getMessage());
                return;
            }
            this.tangoHost = th;
            try {
                this.db = ApiUtil.change_db_obj((String)ths[0], (String)ths[1]);
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
                this.db = null;
            }
            catch (Exception e) {
                JiveUtils.showJiveError(e.getMessage());
                this.db = null;
            }
            this.refreshTree();
        }
        if ((selPath = this.mainTree.getSelectionPath()) != null && (needRefresh = JiveUtils.execAction(i, selPath, this.mainTree, this.mainTreeModel, r = JiveUtils.computeBounds(this.mainTree, selPath), 0, 1))) {
            this.refreshTree();
        }
    }

    public void execMultipleAction(int action) {
        Rectangle r = new Rectangle();
        TreePath[] selPaths = this.mainTree.getSelectionPaths();
        if (action == 1) {
            JiveUtils.the_clipboard.clear();
        }
        if (action == 3 && JOptionPane.showConfirmDialog(this, "Delete multiple selection ?", "Confirm delete", 0) != 0) {
            return;
        }
        if (selPaths != null) {
            for (int i = 0; i < selPaths.length; ++i) {
                JiveUtils.execAction(action + 100, selPaths[i], this.mainTree, this.mainTreeModel, r, i, selPaths.length);
            }
        }
    }

    public void placeComponents() {
        Dimension d = this.getContentPane().getSize();
        int w = d.width - 10;
        int h = d.height;
        this.statusLine.setBounds(5, 2, w, 20);
        this.splitPane.setBounds(5, 25, w, h - 30);
        this.splitPane.setDividerLocation(0.4);
    }

    public void findProperty(int a) {
        if (a == 0) {
            JiveUtils.scan_progress = 0;
            TreePath selPath = this.mainTree.getSelectionPath();
            TangoTreeNode start_node = selPath == null ? (TangoTreeNode)this.rootNode : (TangoTreeNode)selPath.getLastPathComponent();
            SearchDlg dlg = new SearchDlg((Frame)this, true, "Search Tango data base", "Text to find");
            if (!dlg.showDlg()) {
                return;
            }
            JiveUtils.InitiateSearch(start_node, SearchDlg.textToFind, SearchDlg.textToFindValue, SearchDlg.dIgnoreCase, SearchDlg.dSearchValues, SearchDlg.dSearchAttributes, SearchDlg.dSearchCommands, SearchDlg.dSearchUseRegexp, false);
        }
        JiveUtils.error_report = false;
        TreePath found = JiveUtils.findText();
        if (found != null) {
            this.mainTree.setSelectionPath(found);
            this.mainTree.scrollPathToVisible(found);
        }
        JiveUtils.error_report = true;
        if (found == null) {
            JiveUtils.showJiveError("No item found...");
        }
    }

    public void selectProperties() {
        JiveUtils.scan_progress = 0;
        applySelPath = this.mainTree.getSelectionPaths();
        if (applySelPath == null) {
            JiveUtils.showJiveError("Please select starting nodes");
            return;
        }
        SearchDlg dlg = new SearchDlg((Frame)this, true, "Multiple selection", "Select");
        if (!dlg.showDlg()) {
            return;
        }
        Thread doApply = new Thread(){

            @Override
            public void run() {
                try {
                    int j;
                    int i;
                    Vector<TreePath> foundPaths = new Vector<TreePath>();
                    for (i = 0; i < applySelPath.length && !ThreadDlg.stopflag; ++i) {
                        TangoTreeNode start_node = (TangoTreeNode)applySelPath[i].getLastPathComponent();
                        JiveUtils.InitiateSearch(start_node, SearchDlg.textToFind, SearchDlg.textToFindValue, SearchDlg.dIgnoreCase, SearchDlg.dSearchValues, SearchDlg.dSearchAttributes, SearchDlg.dSearchCommands, SearchDlg.dSearchUseRegexp, true);
                        JiveUtils.error_report = false;
                        TreePath[] found = JiveUtils.findMultipleText();
                        if (found != null) {
                            for (j = 0; j < found.length; ++j) {
                                foundPaths.add(found[j]);
                            }
                        }
                        applyDlg.setProgress((int)((double)(i + 1) / (double)applySelPath.length * 50.0));
                    }
                    MainPanel.this.mainTree.clearSelection();
                    if (ThreadDlg.stopflag) {
                        applyDlg.hideDlg();
                        return;
                    }
                    MainPanel.this.refresh_values = false;
                    int step = foundPaths.size() / 10 + 1;
                    for (i = 0; i < foundPaths.size() && !ThreadDlg.stopflag; i += step) {
                        TreePath[] ps = null;
                        ps = i + step < foundPaths.size() ? new TreePath[step] : new TreePath[foundPaths.size() - i];
                        for (j = 0; j < ps.length; ++j) {
                            ps[j] = (TreePath)foundPaths.get(i + j);
                        }
                        MainPanel.this.mainTree.addSelectionPaths(ps);
                        applyDlg.setProgress((int)((double)(i + 1) / (double)foundPaths.size() * 50.0 + 50.0));
                    }
                    if (foundPaths.size() > 0) {
                        MainPanel.this.mainTree.scrollPathToVisible((TreePath)foundPaths.get(0));
                    }
                    JiveUtils.error_report = true;
                    MainPanel.this.gobalValueRefresh();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MainPanel.this.refresh_values = true;
                applyDlg.hideDlg();
            }
        };
        applyDlg = new ThreadDlg((Frame)this, "", true, doApply);
        applyDlg.showDlg();
    }

    private void exitForm() {
        if (this.running_from_shell) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new MainPanel(true, false);
        } else if (args[0].equalsIgnoreCase("-r")) {
            new MainPanel(true, true);
        } else {
            System.out.println("Usage: jive [-r]");
            System.out.println("   -r  Read only mode (No write access to database allowed)");
        }
    }
}

