/*
 * Decompiled with CFR 0.152.
 */
package jive;

import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.Clipboard;
import jive.DevWizard;
import jive.FindInfo;
import jive.JiveMenu;
import jive.RenameDlg;
import jive.ServerDlg;
import jive.TangoTreeNode;
import jive.ThreadDlg;

public class JiveUtils {
    public static int nbAction = 29;
    public static RenameDlg dlg = null;
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    public static String[] att_prop_default = new String[]{"description", "label", "unit", "standard_unit", "display_unit", "format", "min_value", "max_value", "min_alarm", "max_alarm"};
    public static String[] att_prop_default_idl3 = new String[]{"min_warning", "max_warning", "delta_t", "delta_val", "rel_change", "abs_change", "event_period", "archive_abs_change", "archive_rel_change", "archive_period"};
    public static String[] logging_level = new String[]{"OFF", "FATAL", "ERROR", "WARNING", "INFO", "DEBUG"};
    public static Clipboard the_clipboard = new Clipboard();
    public static Frame parent = null;
    public static MainPanel atkdlg = null;
    public static boolean error_report = true;
    public static boolean readOnly = false;
    public static FileWriter resFile = null;
    public static File lastFile = null;
    public static Vector savedClass = new Vector();
    public static Insets noMargin = new Insets(0, 0, 0, 0);
    public static boolean showSystemProperty = false;
    public static int scan_progress;
    public static Stack searchStack;
    public static String searchText;
    public static String searchTextValue;
    public static boolean searchIngoreCase;
    public static int searchValues;
    public static boolean searchAttributes;
    public static boolean searchCommands;
    public static boolean searchUseRegexp;
    public static boolean searchOnlyLeaf;
    public static TreePath searchResult;
    public static TreePath[] searchResults;
    public static ThreadDlg searchDlg;
    public static DeviceProxy hdbManager;
    public static boolean hdbEnabled;

    public static int isInsideArray(String s, String[] arr) {
        boolean found = false;
        int i = 0;
        while (i < arr.length && !found) {
            found = arr[i].equalsIgnoreCase(s);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public static int isInsideVector(String s, Vector arr) {
        boolean found = false;
        int i = 0;
        while (i < arr.size() && !found) {
            found = ((String)arr.get(i)).equalsIgnoreCase(s);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public static boolean IsPollCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("is_polled") || s.equals("polling_period") || s.equals("poll_old_factor") || s.equals("poll_ring_depth");
    }

    public static int IsAttCfgItem(String s, int idl) {
        if (showSystemProperty) {
            return -1;
        }
        int i = JiveUtils.isInsideArray(s, att_prop_default);
        if (i < 0 && idl >= 3 && (i = JiveUtils.isInsideArray(s, att_prop_default_idl3)) >= 0) {
            i += att_prop_default.length;
        }
        return i;
    }

    public static boolean IsSystemItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("polled_cmd") || s.equals("polled_attr") || s.equals("non_auto_polled_cmd") || s.equals("non_auto_polled_attr");
    }

    public static boolean IsLogCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("logging_level") || s.equals("logging_target") || s.equals("current_logging_level") || s.equals("current_logging_target") || s.equals("logging_rft") || s.equals("logging_path");
    }

    public static boolean IsHdbCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("is_archived") || s.equals("archiving_settings");
    }

    public static boolean IsAlarmCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("Alarms");
    }

    public static boolean IsEventCfgItem(String s) {
        if (showSystemProperty) {
            return false;
        }
        return s.equals("Archive Event") || s.equals("Change Event") || s.equals("Periodic Event");
    }

    public static boolean isSavedClass(String className) {
        return JiveUtils.isInsideVector(className, savedClass) >= 0;
    }

    public static void addSavedClass(String className) {
        savedClass.add(className);
    }

    public static void sortList(String[] lst) {
        boolean end = false;
        int i = lst.length - 1;
        while (!end) {
            end = true;
            for (int j = 0; j < i; ++j) {
                boolean swap = false;
                int diff = lst[j].compareToIgnoreCase(lst[j + 1]);
                boolean bl = swap = diff > 0;
                if (!swap) continue;
                String tmp = lst[j + 1];
                lst[j + 1] = lst[j];
                lst[j] = tmp;
                end = false;
            }
            --i;
        }
    }

    public static void sortList(String[] lst, boolean[] v, int idl) {
        int i;
        boolean end = false;
        int[] weight = new int[lst.length];
        for (i = 0; i < lst.length; ++i) {
            weight[i] = JiveUtils.IsSystemItem(lst[i]) ? 0 : (JiveUtils.IsPollCfgItem(lst[i]) ? 1 : (JiveUtils.IsAlarmCfgItem(lst[i]) ? 2 : (JiveUtils.IsHdbCfgItem(lst[i]) ? 3 : (JiveUtils.IsLogCfgItem(lst[i]) ? 4 : (JiveUtils.IsAttCfgItem(lst[i], idl) >= 0 ? 5 : 6)))));
        }
        i = lst.length - 1;
        while (!end) {
            end = true;
            for (int j = 0; j < i; ++j) {
                boolean swap = false;
                if (weight[j] > weight[j + 1]) {
                    swap = true;
                } else if (weight[j] == weight[j + 1]) {
                    int diff = lst[j].compareToIgnoreCase(lst[j + 1]);
                    boolean bl = swap = diff > 0;
                }
                if (!swap) continue;
                String tmp = lst[j + 1];
                lst[j + 1] = lst[j];
                lst[j] = tmp;
                int tw = weight[j + 1];
                weight[j + 1] = weight[j];
                weight[j] = tw;
                if (v != null) {
                    boolean b = v[j];
                    v[j] = v[j + 1];
                    v[j + 1] = b;
                }
                end = false;
            }
            --i;
        }
    }

    public static String formatPath(TreePath path) {
        String result = "";
        if (path == null) {
            return result;
        }
        int n = path.getPathCount();
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        block28: for (int i = 1; i < n; ++i) {
            result = result + path.getPathComponent(i);
            if (i >= n - 1 && node.isLeaf()) continue;
            switch (node.type) {
                case 1: {
                    switch (i - 1) {
                        case 0: {
                            result = result + ":";
                            continue block28;
                        }
                        case 1: {
                            result = result + " ";
                            continue block28;
                        }
                        case 2: {
                            result = result + ":";
                            continue block28;
                        }
                        case 3: {
                            result = result + "/";
                            continue block28;
                        }
                    }
                    result = result + " ";
                    continue block28;
                }
                case 2: {
                    switch (i - 1) {
                        case 0: {
                            result = result + ":";
                            continue block28;
                        }
                        case 1: {
                            result = result + "/";
                            continue block28;
                        }
                        case 2: {
                            result = result + " CLASS:";
                            continue block28;
                        }
                    }
                    result = result + " ";
                    continue block28;
                }
                case 3: {
                    switch (i - 1) {
                        case 0: {
                            result = result + ":";
                            continue block28;
                        }
                        case 1: {
                            result = result + "/";
                            continue block28;
                        }
                        case 2: {
                            result = result + "/";
                            continue block28;
                        }
                        case 3: {
                            result = result + " ";
                            continue block28;
                        }
                        case 4: {
                            result = result + ":";
                            continue block28;
                        }
                        case 5: {
                            result = result + "/";
                            continue block28;
                        }
                    }
                    result = result + " ";
                    continue block28;
                }
                case 4: 
                case 5: {
                    switch (i - 1) {
                        case 0: {
                            result = result + ":";
                            continue block28;
                        }
                    }
                    result = result + " ";
                }
            }
        }
        return result;
    }

    public static boolean contains(String[] l, String item) {
        return JiveUtils.isInsideArray(item, l) >= 0;
    }

    public static boolean contains(int[] arr, int item) {
        boolean found = false;
        int i = 0;
        while (i < arr.length && !found) {
            found = arr[i] == item;
            if (found) continue;
            ++i;
        }
        return found;
    }

    public static String stringArrayToString(String[] res) {
        String result = "";
        if (res != null) {
            for (int i = 0; i < res.length; ++i) {
                result = result + res[i];
                if (i + 1 >= res.length) continue;
                result = result + "\n";
            }
        }
        return result;
    }

    public static String extractEndValue(String s) {
        int i = s.lastIndexOf(61);
        if (i != -1) {
            return s.substring(i + 2, s.length());
        }
        return "";
    }

    public static String[] extractPollingInfo(String s) {
        String[] splitted = s.split("\n");
        String[] ret = new String[5];
        ret[0] = splitted[0].startsWith("Polled attribute") ? "attribute" : "command";
        ret[1] = JiveUtils.extractEndValue(splitted[0]);
        ret[2] = JiveUtils.extractEndValue(splitted[1]);
        ret[3] = JiveUtils.extractEndValue(splitted[2]);
        String status = "";
        for (int i = 3; i < splitted.length; ++i) {
            status = status + splitted[i] + "\n";
        }
        ret[4] = status;
        return ret;
    }

    public static String[] makeStringArray(String value) {
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        return value.split("\n");
    }

    public static DbDatum[] makeDbDatum(String prop_name, String value) {
        String[] splitted = JiveUtils.makeStringArray(value);
        DbDatum[] ret = new DbDatum[]{splitted.length == 1 ? new DbDatum(prop_name, splitted[0]) : new DbDatum(prop_name, splitted)};
        return ret;
    }

    public static String getPollingStatus(String devname, String name, String type, int field) {
        String result;
        block4: {
            result = null;
            int i = 0;
            try {
                DeviceProxy ds = new DeviceProxy(devname);
                String[] pi = ds.polling_status();
                boolean found = false;
                String[] pinfo = null;
                i = 0;
                while (i < pi.length && !found) {
                    pinfo = JiveUtils.extractPollingInfo(pi[i]);
                    found = pinfo[0].equalsIgnoreCase(type) && pinfo[1].equalsIgnoreCase(name);
                    if (found) continue;
                    ++i;
                }
                if (!found) break block4;
                result = pinfo[field];
            }
            catch (DevFailed e) {
                if (field != 4) break block4;
                result = "";
                for (i = 0; i < e.errors.length; ++i) {
                    result = result + "Desc -> " + e.errors[i].desc + "\n";
                    result = result + "Reason -> " + e.errors[i].reason + "\n";
                    result = result + "Origin -> " + e.errors[i].origin + "\n";
                }
            }
        }
        return result;
    }

    public static void addPolling(String devname, String name, String type, String polling_period) throws DevFailed {
        int period;
        try {
            period = Integer.parseInt(polling_period);
        }
        catch (NumberFormatException e) {
            JiveUtils.showJiveError("Invalid polling period " + devname + "/" + name + ":" + e.toString());
            return;
        }
        DeviceProxy ds = new DeviceProxy(devname);
        if (type.equalsIgnoreCase("command")) {
            ds.poll_command(name, period);
        } else {
            ds.poll_attribute(name, period);
        }
    }

    public static void remPolling(String devname, String name, String type) throws DevFailed {
        DeviceProxy ds = new DeviceProxy(devname);
        if (type.equalsIgnoreCase("command")) {
            ds.stop_poll_command(name);
        } else {
            ds.stop_poll_attribute(name);
        }
    }

    public static void copyClassProperties(Database db, String classname) {
        try {
            int i;
            String[] list = db.get_class_property_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] res = db.get_class_property(classname, list[i]).extractStringArray();
                the_clipboard.add(list[i], JiveUtils.stringArrayToString(res));
            }
            list = db.get_class_attribute_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_class_attribute_property(classname, att_list);
                if (lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    the_clipboard.add(list2[j], list[i], lst[0].get_string_value(j));
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public static String[] getLoggingStatus(Database db, String devname, int field) {
        String[] result = null;
        try {
            DbDevImportInfo info = db.import_device(devname);
            String devadmin = "dserver/" + info.server;
            DeviceData argin = new DeviceData();
            DeviceProxy ds = new DeviceProxy(devadmin);
            switch (field) {
                case 0: {
                    String[] names = new String[]{devname};
                    argin.insert(names);
                    DeviceData argout = ds.command_inout("GetLoggingLevel", argin);
                    DevVarLongStringArray res = argout.extractLongStringArray();
                    result = new String[]{logging_level[res.lvalue[0]]};
                    return result;
                }
                case 1: {
                    argin.insert(devname);
                    DeviceData argout = ds.command_inout("GetLoggingTarget", argin);
                    result = argout.extractStringArray();
                    return result;
                }
            }
            return null;
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return null;
        }
    }

    public static boolean setLoggingLevel(Database db, String devname, String level) {
        int i = JiveUtils.isInsideArray(level, logging_level);
        if (i < 0) {
            String err = "Possible value are:";
            for (i = 0; i < logging_level.length; ++i) {
                err = err + " " + logging_level[i];
            }
            JiveUtils.showJiveError("Invalid logging level value.\n" + err);
            return false;
        }
        try {
            DbDevImportInfo info = db.import_device(devname);
            String devadmin = "dserver/" + info.server;
            DeviceData argin = new DeviceData();
            DeviceProxy ds = new DeviceProxy(devadmin);
            int[] l = new int[1];
            String[] s = new String[1];
            l[0] = i;
            s[0] = devname;
            DevVarLongStringArray la = new DevVarLongStringArray(l, s);
            argin.insert(la);
            ds.command_inout("SetLoggingLevel", argin);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static boolean setLoggingTarget(Database db, String devname, String tg) {
        Vector<String> toAdd = new Vector<String>();
        Vector<String> toRemove = new Vector<String>();
        String[] settg = tg.split("\n");
        try {
            String[] tin;
            int i;
            DbDevImportInfo info = db.import_device(devname);
            String devadmin = "dserver/" + info.server;
            DeviceProxy ds = new DeviceProxy(devadmin);
            DeviceData argin = new DeviceData();
            argin.insert(devname);
            DeviceData argout = ds.command_inout("GetLoggingTarget", argin);
            String[] curtg = argout.extractStringArray();
            for (i = 0; i < curtg.length; ++i) {
                if (JiveUtils.contains(settg, curtg[i])) continue;
                toRemove.add(curtg[i]);
            }
            for (i = 0; i < settg.length; ++i) {
                if (JiveUtils.contains(curtg, settg[i]) || settg[i].length() <= 0) continue;
                toAdd.add(settg[i]);
            }
            if (toRemove.size() > 0) {
                tin = new String[toRemove.size() * 2];
                for (i = 0; i < toRemove.size(); ++i) {
                    tin[2 * i] = devname;
                    tin[2 * i + 1] = (String)toRemove.get(i);
                }
                argin = new DeviceData();
                argin.insert(tin);
                ds.command_inout("RemoveLoggingTarget", argin);
            }
            if (toAdd.size() > 0) {
                tin = new String[toAdd.size() * 2];
                for (i = 0; i < toAdd.size(); ++i) {
                    tin[2 * i] = devname;
                    tin[2 * i + 1] = (String)toAdd.get(i);
                }
                argin = new DeviceData();
                argin.insert(tin);
                ds.command_inout("AddLoggingTarget", argin);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static boolean removeClassProperties(Database db, String classname) {
        String value = "%";
        try {
            int i;
            String[] list = db.get_class_property_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                db.delete_class_property(classname, JiveUtils.makeDbDatum(list[i], value));
            }
            list = db.get_class_attribute_list(classname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_class_attribute_property(classname, att_list);
                if (lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    System.out.println("Removing: " + classname + " ATT " + list[i] + " PROP " + list2[j]);
                    db.delete_class_attribute_property(classname, list[i], list2[j]);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static void copyDeviceProperties(Database db, String devname) {
        try {
            int i;
            String[] list = db.get_device_property_list(devname, "*");
            for (i = 0; i < list.length; ++i) {
                String[] res = db.get_device_property(devname, list[i]).extractStringArray();
                the_clipboard.add(list[i], JiveUtils.stringArrayToString(res));
            }
            list = db.get_device_attribute_list(devname);
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_device_attribute_property(devname, att_list);
                if (lst == null || lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    the_clipboard.add(list2[j], list[i], lst[0].get_string_value(j));
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public static boolean removeDeviceProperties(Database db, String devname) {
        String value = "%";
        try {
            int i;
            String[] list = db.get_device_property_list(devname, "*");
            for (i = 0; i < list.length; ++i) {
                db.delete_device_property(devname, JiveUtils.makeDbDatum(list[i], value));
            }
            list = db.get_device_attribute_list(devname);
            for (i = 0; i < list.length; ++i) {
                String[] att_list = new String[]{list[i]};
                DbAttribute[] lst = db.get_device_attribute_property(devname, att_list);
                if (lst.length <= 0) continue;
                String[] list2 = lst[0].get_property_list();
                for (int j = 0; j < list2.length; ++j) {
                    DbAttribute att = new DbAttribute(list[i]);
                    att.add(list2[j], value);
                    db.delete_device_attribute_property(devname, att);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        return true;
    }

    public static String[] getValue(TreePath path) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        return node.getValue();
    }

    public static boolean setValue(TreePath path, String value) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        return node.setValue(value);
    }

    public static void showTangoError(DevFailed e) {
        String result = "";
        if (error_report && e != null) {
            for (int i = 0; i < e.errors.length; ++i) {
                result = result + "Desc -> " + e.errors[i].desc + "\n";
                result = result + "Reason -> " + e.errors[i].reason + "\n";
                result = result + "Origin -> " + e.errors[i].origin + "\n";
            }
            if (result.length() > 0) {
                JOptionPane.showMessageDialog(parent, result, "Tango error", 0);
            }
        }
    }

    public static void printTangoError(DevFailed e) {
        String result = "";
        if (e != null) {
            for (int i = 0; i < e.errors.length; ++i) {
                result = result + " Desc -> " + e.errors[i].desc + "\n";
                result = result + " Reason -> " + e.errors[i].reason + "\n";
                result = result + " Origin -> " + e.errors[i].origin + "\n";
            }
            System.out.println("Tango exception:");
            System.out.print(result);
        }
    }

    public static void showJiveError(String msg) {
        if (error_report) {
            JOptionPane.showMessageDialog(parent, msg, "Jive error", 0);
        }
    }

    public static void showJiveWarning(String msg) {
        JOptionPane.showMessageDialog(parent, msg, "Jive warning", 2);
    }

    public static FindInfo propertyExist(String prop_name, DefaultTreeModel model, TangoTreeNode node) {
        int numChild = model.getChildCount(node);
        int i = 0;
        boolean found = false;
        TangoTreeNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoTreeNode)model.getChild(node, i);
            found = elem.toString().compareToIgnoreCase(prop_name) == 0;
            if (found) continue;
            ++i;
        }
        return new FindInfo(i, found, elem);
    }

    public static TreePath addProperty(String prop_name, DefaultTreeModel model, TreePath path, String value, int pos) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        FindInfo fi = JiveUtils.propertyExist(prop_name, model, node);
        if (!fi.found) {
            TangoTreeNode n = new TangoTreeNode(node.level + 1, node.type, prop_name, node.getDB(), true);
            model.insertNodeInto(n, node, pos);
            TreePath np = path.pathByAddingChild(n);
            JiveUtils.setValue(np, value);
            return np;
        }
        if (prop_name.toLowerCase().startsWith("new property")) {
            int n = 2;
            FindInfo f = JiveUtils.propertyExist("New property#" + n, model, node);
            while (f.found) {
                f = JiveUtils.propertyExist("New property#" + ++n, model, node);
            }
            return JiveUtils.addProperty("New property#" + n, model, path, value, pos);
        }
        return fi.nodeFound.getCompletePath();
    }

    public static void removeProperty(DefaultTreeModel model, TreePath path) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        if (JiveUtils.setValue(path, "%")) {
            model.removeNodeFromParent(node);
        }
    }

    public static TreePath convertOldPath(DefaultTreeModel model, TangoTreeNode root, TreePath path) {
        TreePath np = new TreePath(root);
        if (path != null) {
            int l = path.getPathCount();
            int i = 1;
            boolean end = false;
            TangoTreeNode r = root;
            while (!end && i < l) {
                TangoTreeNode old_node = (TangoTreeNode)path.getPathComponent(i);
                FindInfo f = JiveUtils.propertyExist(old_node.toString(), model, r);
                end = !f.found;
                if (end) continue;
                r = (TangoTreeNode)model.getChild(r, f.index);
                np = np.pathByAddingChild(r);
                ++i;
            }
        }
        return np;
    }

    public static void showServerDlg(ServerDlg sdlg, TreePath path, DefaultTreeModel model, JTree tree) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        if (node.level == 4) {
            path = path.getParentPath();
            node = (TangoTreeNode)path.getLastPathComponent();
        }
    }

    public static Rectangle computeBounds(JTree tree, TreePath selPath) {
        tree.scrollPathToVisible(selPath);
        Rectangle r = tree.getPathBounds(selPath);
        Point pto = r.getLocation();
        SwingUtilities.convertPointToScreen(pto, tree);
        r.setLocation(pto);
        r.width += 20;
        r.height += 2;
        return r;
    }

    public static boolean rename(TreePath path, JTree tree, DefaultTreeModel model, Rectangle bounds) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        TreePath np = null;
        boolean need_refresh = false;
        boolean isAlive = false;
        dlg = new RenameDlg(parent, path.getLastPathComponent().toString(), bounds);
        if (dlg.showDlg()) {
            String new_name = dlg.getNewName();
            FindInfo f1 = JiveUtils.propertyExist(new_name, model, (TangoTreeNode)node.getParent());
            FindInfo f2 = JiveUtils.propertyExist(node.toString(), model, (TangoTreeNode)node.getParent());
            if (!f1.found || f1.index != f2.index) {
                if (f1.found && f1.index != f2.index) {
                    JiveUtils.showJiveError("Name already exists.");
                } else {
                    if (node.type == 2 && node.level == 2) {
                        int i;
                        np = JiveUtils.addProperty(new_name, model, path.getParentPath(), "", 0);
                        for (i = 0; i < node.getChildCount(); ++i) {
                            TreePath iPath = JiveUtils.addProperty(node.getChildAt(i).toString(), model, np, "", i);
                            for (int j = 0; j < node.getChildAt(i).getChildCount(); ++j) {
                                TreePath cPath = JiveUtils.addProperty(node.getChildAt(i).getChildAt(j).toString(), model, iPath, "", j);
                                for (int k = 0; k < node.getChildAt(i).getChildAt(j).getChildCount(); ++k) {
                                    JiveUtils.addProperty(node.getChildAt(i).getChildAt(j).getChildAt(k).toString(), model, cPath, "", k);
                                }
                            }
                        }
                        for (i = 0; i < node.getChildCount(); ++i) {
                            TangoTreeNode n = (TangoTreeNode)node.getChildAt(i);
                            n.removeAllChildren();
                            JiveUtils.removeProperty(model, n.getCompletePath());
                        }
                        JiveUtils.removeProperty(model, path);
                    } else if (node.type == 2 && node.level == 3) {
                        int i;
                        np = JiveUtils.addProperty(new_name, model, path.getParentPath(), "", 0);
                        for (i = 0; i < node.getChildCount(); ++i) {
                            TreePath iPath = JiveUtils.addProperty(node.getChildAt(i).toString(), model, np, "", i);
                            for (int k = 0; k < node.getChildAt(i).getChildCount(); ++k) {
                                JiveUtils.addProperty(node.getChildAt(i).getChildAt(k).toString(), model, iPath, "", k);
                            }
                        }
                        for (i = 0; i < node.getChildCount(); ++i) {
                            TangoTreeNode n = (TangoTreeNode)node.getChildAt(i);
                            n.removeAllChildren();
                            JiveUtils.removeProperty(model, n.getCompletePath());
                        }
                        JiveUtils.removeProperty(model, path);
                    } else if (node.type == 2 && node.level == 4) {
                        try {
                            DbServer dbs = new DbServer(node.getParent().getParent().toString() + "/" + node.getParent().toString());
                            String[] devList = dbs.get_device_name(node.toString());
                            np = JiveUtils.addProperty(dlg.getNewName(), model, path.getParentPath(), "", f2.index);
                            if (np != null) {
                                for (int i = 0; i < devList.length; ++i) {
                                    JiveUtils.addProperty(devList[i], model, np, "", f2.index);
                                }
                            }
                            node.removeAllChildren();
                            JiveUtils.removeProperty(model, path);
                        }
                        catch (DevFailed e) {
                            JiveUtils.showTangoError(e);
                        }
                    } else if (node.type == 2 && node.level == 5) {
                        String nDevName = dlg.getNewName();
                        try {
                            DbDevImportInfo ii = node.getDB().import_device(nDevName);
                            JiveUtils.showJiveError("The device " + nDevName + " already exits.\nServer: " + ii.server);
                        }
                        catch (DevFailed e1) {
                            try {
                                node.getDB().add_device(nDevName, node.getParent().toString(), node.getParent().getParent().getParent().toString() + "/" + node.getParent().getParent().toString());
                                DeviceProxy ds = null;
                                try {
                                    ds = new DeviceProxy(node.toString());
                                    ds.ping();
                                    isAlive = true;
                                }
                                catch (DevFailed e2) {
                                    // empty catch block
                                }
                                int ok = JOptionPane.showConfirmDialog(parent, "Do you want to copy propeties of " + node.toString() + " to " + nDevName + " ?", "Confirm propety move", 0);
                                if (ok == 0) {
                                    String[] propList = node.getDB().get_device_property_list(node.toString(), "*");
                                    if (propList.length > 0) {
                                        DbDatum[] data = node.getDB().get_device_property(node.toString(), propList);
                                        node.getDB().put_device_property(nDevName, data);
                                    }
                                    if (isAlive) {
                                        try {
                                            String[] attList = ds.get_attribute_list();
                                            if (attList.length > 0) {
                                                DbAttribute[] adata = node.getDB().get_device_attribute_property(node.toString(), attList);
                                                node.getDB().put_device_attribute_property(nDevName, adata);
                                            }
                                        }
                                        catch (DevFailed e3) {
                                            JiveUtils.showJiveError("Failed to copy attribute properties of " + node.toString() + "\n" + e3.errors[0].desc);
                                        }
                                    } else {
                                        JiveUtils.showJiveError("Cannot copy attribute properties of " + node.toString() + "\nThe device is not alive.");
                                    }
                                }
                                if (!isAlive) {
                                    JiveUtils.removeProperty(model, path);
                                } else {
                                    JiveUtils.showJiveWarning("The old device " + node.toString() + " is still alive and should be removed by hand.");
                                }
                                np = path.getParentPath();
                                need_refresh = true;
                            }
                            catch (DevFailed e4) {
                                JiveUtils.showTangoError(e4);
                            }
                        }
                    } else {
                        String value = JiveUtils.getValue(path)[0];
                        JiveUtils.removeProperty(model, path);
                        np = JiveUtils.addProperty(dlg.getNewName(), model, path.getParentPath(), value, f2.index);
                    }
                    if (np != null) {
                        tree.setSelectionPath(np);
                        tree.scrollPathToVisible(np);
                    }
                }
            }
        }
        dlg = null;
        return need_refresh;
    }

    public static void paste(TangoTreeNode node) {
        try {
            String classname;
            DbAttribute att;
            int i;
            String devname;
            the_clipboard.parse();
            if (node.type == 3 && node.level == 5 && node.toString().equals("PROPERTY")) {
                devname = node.getDevname(1);
                for (i = 0; i < the_clipboard.getObjectPropertyLength(); ++i) {
                    node.getDB().put_device_property(devname, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(i), the_clipboard.getObjectPropertyValue(i)));
                }
            }
            if (node.type == 3 && node.level == 5 && node.toString().equals("ATTRIBUTE")) {
                devname = node.getDevname(1);
                for (i = 0; i < the_clipboard.getAttPropertyLength(); ++i) {
                    att = new DbAttribute(the_clipboard.getAttName(i));
                    att.add(the_clipboard.getAttPropertyName(i), the_clipboard.getAttPropertyValue(i));
                    node.getDB().put_device_attribute_property(devname, att);
                }
            }
            if (node.type == 3 && node.level == 6 && node.getParent().toString().equals("ATTRIBUTE")) {
                devname = node.getDevname(2);
                for (i = 0; i < the_clipboard.getAttPropertyLength(); ++i) {
                    att = new DbAttribute(node.toString());
                    att.add(the_clipboard.getAttPropertyName(i), the_clipboard.getAttPropertyValue(i));
                    node.getDB().put_device_attribute_property(devname, att);
                }
            }
            if (node.type == 1 && node.level == 3 && node.toString().equals("PROPERTY")) {
                classname = node.getParent().toString();
                for (i = 0; i < the_clipboard.getObjectPropertyLength(); ++i) {
                    node.getDB().put_class_property(classname, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(i), the_clipboard.getObjectPropertyValue(i)));
                }
            }
            if (node.type == 4 && node.level == 2) {
                String objName = node.toString();
                for (i = 0; i < the_clipboard.getObjectPropertyLength(); ++i) {
                    node.getDB().put_property(objName, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(i), the_clipboard.getObjectPropertyValue(i)));
                }
            }
            if (node.type == 1 && node.level == 3 && node.toString().equals("ATTRIBUTE")) {
                classname = node.getParent().toString();
                for (i = 0; i < the_clipboard.getAttPropertyLength(); ++i) {
                    att = new DbAttribute(the_clipboard.getAttName(i));
                    att.add(the_clipboard.getAttPropertyName(i), the_clipboard.getAttPropertyValue(i));
                    node.getDB().put_class_attribute_property(classname, att);
                }
            }
            if (node.type == 3 && node.level == 4) {
                devname = node.getDevname(0);
                for (i = 0; i < the_clipboard.getObjectPropertyLength(); ++i) {
                    node.getDB().put_device_property(devname, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(i), the_clipboard.getObjectPropertyValue(i)));
                }
                for (i = 0; i < the_clipboard.getAttPropertyLength(); ++i) {
                    att = new DbAttribute(the_clipboard.getAttName(i));
                    att.add(the_clipboard.getAttPropertyName(i), the_clipboard.getAttPropertyValue(i));
                    node.getDB().put_device_attribute_property(devname, att);
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    static boolean execAction(int a, TreePath path, JTree tree, DefaultTreeModel model, Rectangle bounds, int idx, int nbAction) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        TreePath np = null;
        TangoTreeNode pnode = null;
        switch (a) {
            case 0: 
            case 1: {
                the_clipboard.clear();
            }
            case 101: {
                if (node.isLeaf() && node.isCopiableItem()) {
                    String val = JiveUtils.getValue(path)[0];
                    if (node.type == 3 && node.level == 6 || node.type == 1 && node.level == 4 || node.type == 4 && node.level == 3) {
                        the_clipboard.add(node.toString(), val);
                    } else if (node.level == 7 || node.level == 5) {
                        the_clipboard.add(node.toString(), node.getParent().toString(), val);
                    } else if (node.level == 8) {
                        the_clipboard.add(node.toString(), node.getParent().getParent().toString(), val);
                    }
                }
                if (node.type == 3 && node.level == 4) {
                    String devname = node.getDevname(0);
                    JiveUtils.copyDeviceProperties(node.getDB(), devname);
                }
                if (node.type == 1 && node.level == 2) {
                    JiveUtils.copyClassProperties(node.getDB(), node.toString());
                }
                if (a != 0) break;
                JiveUtils.removeProperty(model, path);
                break;
            }
            case 2: {
                JiveUtils.paste(node);
                return true;
            }
            case 3: {
                if (JOptionPane.showConfirmDialog(parent, "Delete selection ?", "Confirm delete", 0) != 0) break;
                pnode = (TangoTreeNode)node.getParent();
                JiveUtils.removeProperty(model, path);
                tree.setSelectionPath(pnode.getCompletePath());
                break;
            }
            case 103: {
                JiveUtils.removeProperty(model, path);
                break;
            }
            case 4: {
                String devname = JOptionPane.showInputDialog(parent, "Enter device name", "Add device", 3);
                if (devname == null || (np = JiveUtils.addProperty(devname, model, path, "", 0)) == null) break;
                tree.setSelectionPath(np);
                break;
            }
            case 5: {
                return true;
            }
            case 6: {
                if (node.level == 1) {
                    String inputValue = JOptionPane.showInputDialog(parent, "Enter object name", "New property", 3);
                    np = JiveUtils.addProperty(inputValue, model, path, "", 0);
                    if (np != null) {
                        np = JiveUtils.addProperty("New property", model, np, "", 0);
                    }
                } else {
                    np = JiveUtils.addProperty("New property", model, path, "", 0);
                }
                if (np == null) break;
                tree.setSelectionPath(np);
                Rectangle r = JiveUtils.computeBounds(tree, np);
                JiveUtils.execAction(9, np, tree, model, r, 0, 1);
                break;
            }
            case 8: {
                return true;
            }
            case 9: {
                return JiveUtils.rename(path, tree, model, bounds);
            }
            case 10: {
                String[] args = new String[]{node.isLeaf() ? node.toString() : node.getDevname(0)};
                System.out.println("Running AtkPanel " + args[0]);
                atkdlg = new MainPanel(args[0], false, true, !readOnly);
                break;
            }
            case 11: {
                String devname = node.isLeaf() ? node.toString() : node.getDevname(0);
                JiveMenu m = new JiveMenu(parent);
                m.showDlg(devname);
                break;
            }
            case 12: {
                String att_name;
                String devname;
                if (node.type == 3 && node.level == 4) {
                    devname = node.getDevname(0);
                    int nc = node.getChildCount();
                    node = (TangoTreeNode)node.getChildAt(nc - 3);
                    node.editProperties("device:" + devname);
                }
                if (node.type == 3 && node.level == 6 && node.getParent().toString().equals("ATTRIBUTE")) {
                    att_name = node.toString();
                    node.editAttProperties("attribute:" + att_name);
                }
                if (node.type == 1 && node.level == 2) {
                    String classname = node.toString();
                    node.getChildCount();
                    node = (TangoTreeNode)node.getChildAt(0);
                    node.editProperties("class:" + classname);
                }
                if (node.type == 1 && node.level == 4 && node.getParent().toString().equals("ATTRIBUTE")) {
                    att_name = node.toString();
                    node.editProperties("attribute:" + att_name);
                }
                if (node.type == 2 && node.level == 5) {
                    devname = node.toString();
                    TangoTreeNode root = (TangoTreeNode)path.getPathComponent(0);
                    TangoTreeNode devnode = (TangoTreeNode)root.getChildAt(2);
                    TangoTreeNode n = JiveUtils.findDeviceNode(devnode, devname);
                    if (n != null) {
                        int nc = n.getChildCount();
                        n = (TangoTreeNode)n.getChildAt(nc - 3);
                        n.editProperties("device:" + devname);
                    }
                }
                if (node.type != 5 || node.level != 2) break;
                JiveUtils.showJiveError("Edit properties from alias not yet supported");
                break;
            }
            case 13: {
                String devname = "dserver/" + node.getParent().toString() + "/" + node.toString();
                JiveMenu m = new JiveMenu(parent);
                m.showDlg(devname);
                break;
            }
            case 14: {
                String srvName = node.getParent().toString() + "/" + node.toString();
                int ok = JOptionPane.showConfirmDialog(parent, "This will unexport all devices of " + srvName + "\n Do you want to continue ?", "Confirm unexport device", 0);
                if (ok != 0) break;
                try {
                    node.getDB().unexport_server(srvName);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                break;
            }
            case 15: 
            case 115: {
                if (resFile == null && idx == 0) {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser(".");
                    int ok = 0;
                    if (lastFile != null) {
                        chooser.setSelectedFile(lastFile);
                    }
                    if ((returnVal = chooser.showSaveDialog(parent)) == 0 && (lastFile = chooser.getSelectedFile()) != null) {
                        if (lastFile.exists()) {
                            ok = JOptionPane.showConfirmDialog(parent, "Do you want to overwrite " + lastFile.getName() + " ?", "Confirm overwrite", 0);
                        }
                        if (ok == 0) {
                            try {
                                resFile = new FileWriter(lastFile.getAbsolutePath());
                                Date date = new Date(System.currentTimeMillis());
                                resFile.write("#\n# Resource backup , created " + date + "\n#\n\n");
                                savedClass.clear();
                            }
                            catch (IOException e) {
                                JiveUtils.showJiveError("Failed to create resource file !\n" + e.getMessage());
                            }
                        }
                    }
                }
                if (resFile == null) break;
                try {
                    node.saveServerData(resFile);
                    if (idx != nbAction - 1) break;
                    resFile.close();
                    resFile = null;
                }
                catch (IOException e) {
                    JiveUtils.showJiveError("Failed to save resource file !\n" + e.getMessage());
                }
                break;
            }
            case 16: {
                String devname;
                String inputValue = JOptionPane.showInputDialog(parent, "Enter alias", "Define device alias", 3);
                if (node.type == 3 && node.level == 4) {
                    devname = node.getDevname(0);
                    try {
                        node.getDB().put_device_alias(devname, inputValue);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                }
                if (node.type != 2 || node.level != 4) break;
                devname = node.toString();
                try {
                    node.getDB().put_device_alias(devname, inputValue);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                break;
            }
            case 17: {
                try {
                    String devname = node.getDevname(0);
                    DbDevImportInfo info = node.getDB().import_device(devname);
                    TangoTreeNode root = (TangoTreeNode)path.getPathComponent(0);
                    TangoTreeNode srvnode = (TangoTreeNode)root.getChildAt(1);
                    TangoTreeNode n = JiveUtils.findServerNode(srvnode, info.server);
                    if (n == null) break;
                    np = n.getCompletePath();
                    tree.setSelectionPath(np);
                    tree.scrollPathToVisible(np);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                break;
            }
            case 18: {
                String devname = node.toString();
                TangoTreeNode root = (TangoTreeNode)path.getPathComponent(0);
                TangoTreeNode devnode = (TangoTreeNode)root.getChildAt(2);
                TangoTreeNode n = JiveUtils.findDeviceNode(devnode, devname);
                if (n == null) break;
                np = n.getCompletePath();
                tree.setSelectionPath(np);
                tree.scrollPathToVisible(np);
                break;
            }
            case 19: {
                try {
                    String devname = node.type == 2 ? node.toString() : node.getDevname(0);
                    DbDevImportInfo info = node.getDB().import_device(devname);
                    DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
                    DeviceData in = new DeviceData();
                    in.insert(devname);
                    ds.command_inout("DevRestart", in);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                return true;
            }
            case 20: {
                try {
                    DbAttribute att;
                    String devname;
                    if (node.level == 7) {
                        devname = node.getDevname(3);
                        att = new DbAttribute(node.getParent().toString());
                    } else {
                        devname = node.getDevname(4);
                        att = new DbAttribute(node.getParent().getParent().toString());
                    }
                    att.add(node.toString(), "");
                    node.getDB().delete_device_attribute_property(devname, att);
                    DbDevImportInfo info = node.getDB().import_device(devname);
                    DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
                    DeviceData in = new DeviceData();
                    in.insert(devname);
                    ds.command_inout("DevRestart", in);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                return true;
            }
            case 21: {
                try {
                    String devname = node.getDevname(0);
                    DbDevImportInfo info = node.getDB().import_device(devname);
                    TangoTreeNode root = (TangoTreeNode)path.getPathComponent(0);
                    TangoTreeNode devnode = (TangoTreeNode)root.getChildAt(2);
                    TangoTreeNode n = JiveUtils.findDeviceNode(devnode, "dserver/" + info.server);
                    if (n == null) break;
                    np = n.getCompletePath();
                    tree.setSelectionPath(np);
                    tree.scrollPathToVisible(np);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                String inputValue = JOptionPane.showInputDialog(parent, "Enter class attribute name", "", 3);
                np = JiveUtils.addProperty(inputValue, model, path, "", 0);
                if (np == null) break;
                tree.setSelectionPath(np);
                break;
            }
            case 24: {
                DevWizard wdlg = new DevWizard(parent);
                wdlg.showWizard(null);
                return true;
            }
            case 25: {
                DevWizard cwdlg = new DevWizard(parent);
                cwdlg.showClassesWizard(node.getParent().toString() + "/" + node.toString());
                return true;
            }
            case 26: {
                DevWizard dswdlg = new DevWizard(parent);
                dswdlg.showDevicesWizard(node.getParent().getParent().toString() + "/" + node.getParent().toString(), node.toString());
                return true;
            }
            case 27: {
                DevWizard dwdlg = new DevWizard(parent);
                dwdlg.showDeviceWizard(node.getParent().getParent().getParent().toString() + "/" + node.getParent().getParent().toString(), node.getParent().toString(), node.toString());
                return true;
            }
        }
        return false;
    }

    public static TangoTreeNode findServerNode(TangoTreeNode srv_node, String srvname) {
        TangoTreeNode n = null;
        String[] srvnames = srvname.split("/");
        if (srvnames.length != 2) {
            JiveUtils.showJiveError("Invalid server name:" + srvname);
            return null;
        }
        int count = srv_node.getChildCount();
        int i = 0;
        boolean found = false;
        while (!found && i < count) {
            n = (TangoTreeNode)srv_node.getChildAt(i);
            found = srvnames[0].compareToIgnoreCase(n.toString()) == 0;
            if (found) continue;
            ++i;
        }
        if (!found) {
            JiveUtils.showJiveError("Server not found:" + srvname);
            return null;
        }
        srv_node = n;
        count = srv_node.getChildCount();
        i = 0;
        found = false;
        while (!found && i < count) {
            n = (TangoTreeNode)srv_node.getChildAt(i);
            found = srvnames[1].compareToIgnoreCase(n.toString()) == 0;
            if (found) continue;
            ++i;
        }
        if (!found) {
            JiveUtils.showJiveError("Server not found:" + srvname);
            return null;
        }
        return n;
    }

    public static TangoTreeNode findDeviceNode(TangoTreeNode dev_node, String devname) {
        TangoTreeNode n = null;
        String[] devnames = devname.split("/");
        if (devnames.length != 3) {
            JiveUtils.showJiveError("Invalid device name:" + devname);
            return null;
        }
        int count = dev_node.getChildCount();
        int i = 0;
        boolean found = false;
        while (!found && i < count) {
            n = (TangoTreeNode)dev_node.getChildAt(i);
            found = devnames[0].compareToIgnoreCase(n.toString()) == 0;
            if (found) continue;
            ++i;
        }
        if (!found) {
            JiveUtils.showJiveError("Device domain not found:" + devnames[0]);
            return null;
        }
        dev_node = n;
        count = dev_node.getChildCount();
        i = 0;
        found = false;
        while (!found && i < count) {
            n = (TangoTreeNode)dev_node.getChildAt(i);
            found = devnames[1].compareToIgnoreCase(n.toString()) == 0;
            if (found) continue;
            ++i;
        }
        if (!found) {
            JiveUtils.showJiveError("Device family not found:" + devnames[1]);
            return null;
        }
        dev_node = n;
        count = dev_node.getChildCount();
        i = 0;
        found = false;
        while (!found && i < count) {
            n = (TangoTreeNode)dev_node.getChildAt(i);
            found = devnames[2].compareToIgnoreCase(n.toString()) == 0;
            if (found) continue;
            ++i;
        }
        if (!found) {
            JiveUtils.showJiveError("Device member not found:" + devnames[2]);
            return null;
        }
        return n;
    }

    public static void printFormatedRes(String name, String[] vals, FileWriter fw) throws IOException {
        int k;
        if (vals == null) {
            if (fw != null) {
                fw.write("\"\"");
            } else {
                System.out.print("\"\"");
            }
            return;
        }
        if (vals.length == 0) {
            if (fw != null) {
                fw.write("\"\"");
            } else {
                System.out.print("\"\"");
            }
            return;
        }
        Vector<String> values = new Vector<String>();
        int j = 0;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].indexOf(10) != -1) {
                String[] tmpStr = JiveUtils.makeStringArray(vals[i]);
                for (k = 0; k < tmpStr.length; ++k) {
                    values.add(tmpStr[k]);
                }
                continue;
            }
            values.add(vals[i]);
        }
        Object[] value = values.toArray();
        int shift = name.length();
        if (fw != null) {
            fw.write(name, 0, shift);
        } else {
            System.out.print(name);
        }
        for (j = 0; j < value.length; ++j) {
            String str = (String)value[j];
            if (str.length() == 0) {
                value[j] = new String("\"\"");
            }
            StringBuffer qStr = new StringBuffer(str);
            int qIdx = qStr.indexOf("\"");
            while (qIdx != -1) {
                qStr.insert(qIdx, "\\");
                qIdx = qStr.indexOf("\"", qIdx + 2);
            }
            str = qStr.toString();
            if (str.indexOf(32) != -1 || str.indexOf(47) != -1 || str.indexOf(44) != -1 || str.indexOf(34) != -1) {
                value[j] = new String("\"" + str + "\"");
            }
            for (k = 0; j > 0 && k < shift; ++k) {
                if (fw != null) {
                    fw.write(32);
                    continue;
                }
                System.out.print(" ");
            }
            String to_write = j < value.length - 1 ? value[j] + ",\\ \n" : value[j] + "\n";
            if (fw != null) {
                fw.write(to_write, 0, to_write.length());
                continue;
            }
            System.out.print(to_write.toString());
        }
    }

    public static String convertEventString(String str) {
        int idx = str.indexOf(44);
        if (idx != -1) {
            String[] ret = str.split(",");
            return ret[0] + "\n" + ret[1];
        }
        return str;
    }

    public static void InitiateSearch(TangoTreeNode root, String textToFind, String textToFindValue, boolean ignorecase, int svalue, boolean sattribute, boolean scommand, boolean sregexp, boolean sonlyleaf) {
        searchStack = new Stack();
        searchStack.push(root);
        searchIngoreCase = ignorecase;
        searchValues = svalue;
        searchAttributes = sattribute;
        searchCommands = scommand;
        searchUseRegexp = sregexp;
        searchOnlyLeaf = sonlyleaf;
        searchText = textToFind;
        searchTextValue = textToFindValue;
    }

    public static TreePath findText() {
        Thread doSearch = new Thread(){

            @Override
            public void run() {
                searchResult = JiveUtils.findText_sub();
                searchDlg.hideDlg();
            }
        };
        searchResult = null;
        searchDlg = new ThreadDlg(parent, "Searching the database", false, doSearch);
        searchDlg.showDlg();
        try {
            doSearch.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        doSearch = null;
        return searchResult;
    }

    public static TreePath[] findMultipleText() {
        boolean end = false;
        Vector<TreePath> pvect = new Vector<TreePath>();
        while (!end) {
            searchResult = JiveUtils.findText_sub();
            if (searchResult != null) {
                pvect.add(searchResult);
                continue;
            }
            end = true;
        }
        if (pvect.size() > 0 && !ThreadDlg.stopflag) {
            searchResults = new TreePath[pvect.size()];
            for (int i = 0; i < pvect.size(); ++i) {
                JiveUtils.searchResults[i] = (TreePath)pvect.get(i);
            }
        } else {
            searchResults = null;
        }
        return searchResults;
    }

    public static TreePath findText_sub() {
        Pattern p = null;
        if (searchUseRegexp) {
            try {
                p = Pattern.compile(searchText);
            }
            catch (PatternSyntaxException e) {
                error_report = true;
                JiveUtils.showJiveError("Invalid regular expression\n" + e.getDescription());
                return null;
            }
        }
        if (searchStack != null) {
            while (!searchStack.empty() && !ThreadDlg.stopflag) {
                boolean perform_search;
                TangoTreeNode node = (TangoTreeNode)searchStack.pop();
                ++scan_progress;
                boolean ok = false;
                if (node.isLeaf() || !searchOnlyLeaf) {
                    String str2;
                    String str1;
                    if (searchIngoreCase) {
                        str1 = node.toStringEx().toLowerCase();
                        str2 = searchText.toLowerCase();
                    } else {
                        str1 = node.toStringEx();
                        str2 = searchText;
                    }
                    if (searchUseRegexp) {
                        ok = p.matcher(str1).matches();
                    } else {
                        boolean bl = ok = str1.indexOf(str2) != -1;
                    }
                    if (ok) {
                        if (searchValues == 0) {
                            return node.getCompletePath();
                        }
                        if (searchIngoreCase) {
                            str1 = JiveUtils.getValue(new TreePath(node))[0].toLowerCase();
                            str2 = searchTextValue.toLowerCase();
                        } else {
                            str1 = JiveUtils.getValue(new TreePath(node))[0];
                            str2 = searchTextValue;
                        }
                        switch (searchValues) {
                            case 1: {
                                if (str1.compareTo(str2) != 0) break;
                                return node.getCompletePath();
                            }
                            case 2: {
                                if (str1.indexOf(str2) == -1) break;
                                return node.getCompletePath();
                            }
                        }
                    }
                }
                if (!(perform_search = !(node.toString().equals("ATTRIBUTE") && !searchAttributes || node.toString().equals("COMMAND") && !searchCommands))) continue;
                int count = node.getChildCount();
                for (int i = count - 1; i >= 0; --i) {
                    searchStack.push(node.getChildAt(i));
                }
            }
        }
        if (ThreadDlg.stopflag) {
            System.out.println("Search interrupted by user.");
        }
        return null;
    }

    public static void printAttInfo(AttributeInfoEx ai) {
        System.out.println("------- Attribute info -------");
        System.out.println("Name             :" + ai.name);
        System.out.println("Data format      :" + ai.data_format.value());
        System.out.println("Data type        :" + ai.data_type);
        System.out.println("Description      :" + ai.description);
        System.out.println("Display unit     :" + ai.display_unit);
        System.out.println("Std unit         :" + ai.standard_unit);
        System.out.println("Unit             :" + ai.unit);
        System.out.println("Format           :" + ai.format);
        System.out.println("Label            :" + ai.label);
        System.out.println("Disp level       :" + ai.level.value());
        System.out.println("Max alarm        :" + ai.max_alarm);
        System.out.println("Min alarm        :" + ai.min_alarm);
        System.out.println("Max value        :" + ai.max_value);
        System.out.println("Min value        :" + ai.min_value);
        System.out.println("Max DimX         :" + ai.max_dim_x);
        System.out.println("Max DimY         :" + ai.max_dim_y);
        System.out.println("Alarms.delta_t   :" + ai.alarms.delta_t);
        System.out.println("Alarms.delta_v   :" + ai.alarms.delta_val);
        System.out.println("Alarms.max       :" + ai.alarms.max_alarm);
        System.out.println("Alarms.min       :" + ai.alarms.min_alarm);
        System.out.println("Alarms.max_w     :" + ai.alarms.max_warning);
        System.out.println("Alarms.min_w     :" + ai.alarms.min_warning);
        System.out.println("ArchEvent.abs_ch :" + ai.events.arch_event.abs_change);
        System.out.println("ArchEvent.rel_ch :" + ai.events.arch_event.rel_change);
        System.out.println("ArchEvent.period :" + ai.events.arch_event.period);
        System.out.println("ChEvent.abs_ch   :" + ai.events.ch_event.abs_change);
        System.out.println("ChEvent.rel_ch   :" + ai.events.ch_event.rel_change);
        System.out.println("PerEvent.abs_ch  :" + ai.events.per_event.period);
    }

    public static boolean[] getAction(TreePath path) {
        TangoTreeNode node = (TangoTreeNode)path.getLastPathComponent();
        boolean[] arr = new boolean[nbAction];
        for (int i = 0; i < nbAction; ++i) {
            arr[i] = false;
        }
        switch (node.type) {
            case 0: {
                arr[7] = true;
                return arr;
            }
            case 1: {
                if (node.level == 2) {
                    arr[0] = !readOnly;
                    arr[1] = !readOnly;
                    arr[3] = !readOnly;
                    arr[12] = true;
                }
                if (node.level == 2 || node.level == 3) {
                    boolean bl = arr[2] = !the_clipboard.empty() && !readOnly;
                }
                if (node.level == 3 && node.toString().equals("PROPERTY")) {
                    boolean bl = arr[6] = !readOnly;
                }
                if (node.level == 3 && node.toString().equals("ATTRIBUTE")) {
                    boolean bl = arr[23] = !readOnly;
                }
                if (node.level == 4 && node.getParent().toString().equals("PROPERTY")) {
                    arr[0] = !readOnly;
                    arr[1] = !readOnly;
                    arr[3] = !readOnly;
                    boolean bl = arr[9] = !readOnly;
                }
                if (node.level == 4 && node.getParent().toString().equals("ATTRIBUTE")) {
                    arr[12] = true;
                    boolean bl = arr[6] = !readOnly;
                }
                if (node.level != 5 || !node.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                arr[0] = !readOnly;
                arr[1] = !readOnly;
                arr[3] = !readOnly;
                arr[9] = !readOnly;
                break;
            }
            case 2: {
                if (node.level == 1) {
                    arr[5] = !readOnly;
                    boolean bl = arr[24] = !readOnly;
                }
                if (node.level == 2) {
                    boolean bl = arr[9] = !readOnly;
                }
                if (node.level == 3) {
                    arr[3] = !readOnly;
                    arr[8] = !readOnly;
                    arr[9] = !readOnly;
                    arr[13] = true;
                    arr[14] = !readOnly;
                    arr[15] = true;
                    boolean bl = arr[25] = !readOnly;
                }
                if (node.level == 4) {
                    arr[3] = !readOnly;
                    arr[4] = !readOnly;
                    arr[9] = !readOnly;
                    boolean bl = arr[26] = !readOnly;
                }
                if (node.level != 5) break;
                arr[3] = !readOnly;
                arr[9] = !readOnly;
                arr[10] = true;
                arr[11] = true;
                arr[12] = true;
                arr[16] = !readOnly;
                arr[18] = true;
                arr[19] = true;
                arr[27] = !readOnly;
                break;
            }
            case 3: {
                if (node.level == 4 || node.level == 5) {
                    boolean bl = arr[2] = !the_clipboard.empty() && !readOnly;
                }
                if (node.level == 4) {
                    arr[0] = !readOnly;
                    arr[1] = !readOnly;
                    arr[3] = !readOnly;
                    arr[10] = true;
                    arr[11] = true;
                    arr[12] = true;
                    arr[16] = !readOnly;
                    arr[17] = true;
                    arr[19] = true;
                    arr[21] = true;
                }
                if (node.level == 5 && node.toString().equals("PROPERTY")) {
                    arr[6] = !readOnly;
                    boolean bl = arr[2] = !the_clipboard.empty() && !readOnly;
                }
                if (node.level == 6 && node.getParent().toString().equals("PROPERTY")) {
                    arr[0] = !node.isSystemItem() && !node.isPollCfgItem() && !readOnly;
                    arr[1] = !node.isSystemItem() && !readOnly;
                    arr[3] = !node.isSystemItem() && !node.isPollCfgItem() && !readOnly;
                    boolean bl = arr[9] = !node.isSystemItem() && !node.isPollCfgItem() && !readOnly;
                }
                if (node.level == 6 && node.getParent().toString().equals("ATTRIBUTE")) {
                    arr[6] = !readOnly;
                    arr[12] = true;
                    boolean bl = arr[2] = !the_clipboard.empty() && !readOnly;
                }
                if (node.level == 7 && node.getParent().getParent().toString().equals("ATTRIBUTE")) {
                    arr[0] = !node.isEventCfgItem() && !node.isAlarmCfgItem() && !node.isPollCfgItem() && !node.isAttCfgItem() && !readOnly;
                    arr[1] = !node.isEventCfgItem() && !node.isAlarmCfgItem() && !node.isPollCfgItem() && !readOnly;
                    arr[3] = !node.isEventCfgItem() && !node.isAlarmCfgItem() && !node.isPollCfgItem() && !node.isAttCfgItem() && !readOnly;
                    arr[9] = !node.isEventCfgItem() && !node.isAlarmCfgItem() && !node.isPollCfgItem() && !node.isAttCfgItem() && !readOnly;
                    boolean bl = arr[20] = node.isAttCfgItem() && !readOnly;
                }
                if (node.level != 8 || !node.getParent().getParent().getParent().toString().equals("ATTRIBUTE")) break;
                arr[1] = !readOnly;
                arr[20] = node.isAttCfgItem() && !readOnly;
                break;
            }
            case 4: {
                if (node.level == 1) {
                    boolean bl = arr[6] = !readOnly;
                }
                if (node.level == 2) {
                    arr[6] = !readOnly;
                    boolean bl = arr[2] = !the_clipboard.empty() && !readOnly;
                }
                if (node.level != 3) break;
                arr[0] = !readOnly;
                arr[1] = !readOnly;
                arr[3] = !readOnly;
                arr[9] = !readOnly;
                break;
            }
            case 5: {
                if (node.level != 2) break;
                arr[10] = true;
                arr[11] = true;
                arr[12] = true;
            }
        }
        return arr;
    }

    public static void centerDialog(Dialog dlg, int dlgWidth, int dlgHeight) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (dlg.getParent() != null && dlg.getParent().isVisible()) {
            r = dlg.getParent().getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = JiveUtils.screenSize.width;
            r.height = JiveUtils.screenSize.height;
        }
        dlg.pack();
        Insets insets = dlg.getInsets();
        int wx = dlgWidth + (insets.right + insets.left);
        int wy = dlgHeight + (insets.bottom + insets.top);
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        if (xe + wx > JiveUtils.screenSize.width) {
            xe = JiveUtils.screenSize.width - wx;
        }
        if (ye + wy > JiveUtils.screenSize.height) {
            ye = JiveUtils.screenSize.height - wy;
        }
        dlg.setBounds(xe, ye, wx, wy);
    }

    public static void centerDialog(Dialog dlg) {
        dlg.pack();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (dlg.getParent() != null && dlg.getParent().isVisible()) {
            r = dlg.getParent().getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = JiveUtils.screenSize.width;
            r.height = JiveUtils.screenSize.height;
        }
        int wx = dlg.getPreferredSize().width;
        int wy = dlg.getPreferredSize().height;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        if (xe + wx > JiveUtils.screenSize.width) {
            xe = JiveUtils.screenSize.width - wx;
        }
        if (ye + wy > JiveUtils.screenSize.height) {
            ye = JiveUtils.screenSize.height - wy;
        }
        dlg.setBounds(xe, ye, wx, wy);
    }

    public static void centerFrameOnScreen(Frame fr) {
        Rectangle r = new Rectangle(0, 0, JiveUtils.screenSize.width, JiveUtils.screenSize.height);
        fr.pack();
        int wx = fr.getPreferredSize().width;
        int wy = fr.getPreferredSize().height;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        fr.setBounds(xe, ye, wx, wy);
    }

    public static void centerFrameOnScreen(Frame fr, int frWidth, int frHeight) {
        Rectangle r = new Rectangle(0, 0, JiveUtils.screenSize.width, JiveUtils.screenSize.height);
        fr.pack();
        int wx = frWidth;
        int wy = frHeight;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        fr.setBounds(xe, ye, wx, wy);
    }

    public static boolean isDeviceName(String devName) {
        boolean devNamePattern;
        if (devName.length() < 5 || devName.contains(" ")) {
            return false;
        }
        String s = new String(devName);
        if (s.startsWith("tango:")) {
            s = s.substring(6);
        }
        if (!(devNamePattern = Pattern.matches("//[a-zA-Z_0-9]+:[0-9]+/[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+", s))) {
            devNamePattern = Pattern.matches("[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+/[[a-zA-Z_0-9\\.][-]]+", s);
        }
        if (!devNamePattern) {
            devNamePattern = Pattern.matches("//[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+:[0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", s);
        }
        return devNamePattern;
    }

    public static boolean isFullServerName(String srvName) {
        return Pattern.matches("[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+", srvName);
    }

    public static String getPathAsText(TreePath path) {
        StringBuffer str = new StringBuffer();
        if (path == null) {
            str.append("null");
        } else {
            for (int i = 0; i < path.getPathCount(); ++i) {
                str.append(path.getPathComponent(i).toString());
                if (i == path.getPathCount() - 1) continue;
                str.append("/");
            }
        }
        return str.toString();
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        searchStack = null;
        hdbManager = null;
        hdbEnabled = false;
    }
}

