/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import jive.AttributePanel;
import jive.CommandPanel;
import jive.CommonPanel;
import jive.ConsolePanel;
import jive.PipePanel;

public class ExecDev
extends JPanel {
    public ExecDev(String devName) throws DevFailed {
        DeviceProxy ds = new DeviceProxy(devName);
        this.setLayout(new BorderLayout());
        ConsolePanel console = new ConsolePanel();
        CommonPanel common = new CommonPanel(ds, console);
        JTabbedPane tab = new JTabbedPane();
        tab.add("Commands", new CommandPanel(ds, console, common));
        tab.add("Attributes", new AttributePanel(ds, console, common));
        int idl = ds.get_idl_version();
        if (idl >= 5) {
            tab.add("Pipe", new PipePanel(ds, console, common));
        }
        tab.add("Admin", common);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(tab);
        splitPane.setBottomComponent(console);
        splitPane.setDividerLocation(235);
        this.add((Component)splitPane, "Center");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: tg_devtest devicename");
        } else {
            try {
                ExecDev p = new ExecDev(args[0]);
                JFrame f = new JFrame();
                f.setTitle("Device panel [" + args[0] + "]");
                f.setContentPane(p);
                f.setDefaultCloseOperation(3);
                ATKGraphicsUtils.centerFrameOnScreen((Frame)f);
                f.setVisible(true);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage(null, (String)args[0], (DevFailed)e);
            }
        }
    }
}

