/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jive.DevWizard;
import jive.JiveUtils;
import jive.PropertyPanel;
import jive.WizardPanel;

class DevicePanel
extends WizardPanel {
    String className;
    String serverName;
    JComboBox deviceCombo;
    JLabel deviceLabel;

    public DevicePanel(DevWizard parent, String serverName, String className) {
        this.setLayout(null);
        this.parent = parent;
        this.className = className;
        this.serverName = serverName;
        this.deviceLabel = new JLabel("Device name");
        this.deviceLabel.setFont(DevWizard.wizFont);
        this.deviceLabel.setBounds(10, 30, 100, 25);
        this.add(this.deviceLabel);
        this.deviceCombo = new JComboBox();
        this.deviceCombo.setEditable(true);
        this.deviceCombo.setFont(DevWizard.wizFont);
        this.deviceCombo.setBounds(115, 30, 160, 25);
        this.add(this.deviceCombo);
        try {
            Database db = ApiUtil.get_db_obj();
            String[] devList = db.get_device_name(serverName, className);
            for (int i = 0; i < devList.length; ++i) {
                this.deviceCombo.addItem(devList[i]);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        this.deviceCombo.setSelectedItem(null);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/device_wz.gif"));
    }

    @Override
    public String getTitle() {
        return "Device Declaration of Class \"" + this.className + "\"";
    }

    @Override
    public String getDescription() {
        return "It is now time to give a device name for the '" + this.className + "' class. " + "If this device does not already exit, it will be added. Otherwise, the " + "server's device list remains unchanged.\n" + "Click [Next] to edit device properties.";
    }

    @Override
    public boolean getNextState() {
        return true;
    }

    @Override
    public boolean next() {
        String devName = (String)this.deviceCombo.getSelectedItem();
        if (devName == null || devName.length() == 0) {
            JiveUtils.showJiveError("Please enter a device name.");
            return false;
        }
        try {
            Database db = ApiUtil.get_db_obj();
            if (!this.deviceExists(devName, this.serverName, this.className)) {
                db.add_device(devName, this.className, this.serverName);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return false;
        }
        boolean isAdded = false;
        int idx = this.parent.getPanels().indexOf(this);
        if (idx < this.parent.getPanels().size() - 1) {
            isAdded = this.parent.getPanel(idx + 1) instanceof PropertyPanel;
        }
        if (!isAdded) {
            try {
                DeviceData classData = new DeviceData();
                classData.insert(this.className);
                DeviceProxy adminDev = new DeviceProxy("dserver/" + this.serverName);
                DeviceData ret = adminDev.command_inout("QueryWizardDevProperty", classData);
                String[] conf = ret.extractStringArray();
                for (int j = 0; j < conf.length; j += 3) {
                    this.parent.addPanel(idx + 1 + j / 3, new PropertyPanel(this.parent, 1, this.serverName, devName, conf[j], conf[j + 1], conf[j + 2], this.className));
                }
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
                return false;
            }
        } else {
            boolean end = false;
            ++idx;
            while (idx < this.parent.getPanels().size() && !end) {
                end = !(this.parent.getPanel(idx) instanceof PropertyPanel);
                if (end) continue;
                ((PropertyPanel)this.parent.getPanel(idx)).setEntityName(devName);
                ++idx;
            }
        }
        return true;
    }

    @Override
    public boolean back() {
        return true;
    }
}

