/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatable;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDPolyline
extends JDObject
implements JDRotatable {
    static final boolean isClosedDefault = true;
    static final int stepDefault = 1;
    boolean isClosed;
    int step;
    int breakId = -1;
    int breakX;
    int breakY;

    JDPolyline() {
    }

    public JDPolyline(String string, Point[] pointArray) {
        this.initDefault();
        this.summit = new Point2D.Double[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            this.summit[i] = new Point2D.Double(pointArray[i].x, pointArray[i].y);
        }
        this.name = string;
        this.updateShape();
        Point2D.Double double_ = new Point2D.Double(this.boundRect.x + this.boundRect.width / 2, this.boundRect.y + this.boundRect.height / 2);
        this.setOrigin(double_);
    }

    JDPolyline(JDPolyline jDPolyline, int n, int n2) {
        this.cloneObject(jDPolyline, n, n2);
        this.isClosed = jDPolyline.isClosed;
        this.step = jDPolyline.step;
        this.updateShape();
    }

    JDPolyline(JLXObject jLXObject, JLXPath jLXPath) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        int n = jLXPath.path.size();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[n];
        this.createSummit();
        for (int i = 0; i < n; ++i) {
            double[] dArray = (double[])jLXPath.path.get(i);
            this.summit[i].x = this.origin.x + dArray[0];
            this.summit[i].y = this.origin.y + dArray[1];
        }
        this.isClosed = jLXPath.closed;
        this.step = 1;
        this.updateShape();
    }

    JDPolyline(LXObject lXObject, double[] dArray, double[] dArray2, boolean bl) {
        this.initDefault();
        this.loadObject(lXObject);
        int n = dArray.length;
        this.summit = new Point2D.Double[n];
        this.createSummit();
        for (int i = 0; i < n; ++i) {
            this.summit[i].x = dArray[i];
            this.summit[i].y = dArray2[i];
        }
        this.isClosed = bl;
        this.step = 1;
        this.updateShape();
        double d = this.boundRect.getX();
        double d2 = this.boundRect.getY();
        double d3 = this.boundRect.getWidth();
        double d4 = this.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.step = 1;
        this.isClosed = true;
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDPolyline(this, n, n2);
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        Object object;
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        if (this.fillStyle != 0) {
            object = GraphicsUtils.createPatternForFilling(this);
            if (object != null) {
                graphics2D.setPaint((Paint)object);
            }
            graphics.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
        }
        if (!this.isClosed) {
            if (this.lineWidth > 0) {
                graphics.setColor(this.foreground);
                object = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
                if (object != null) {
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke((Stroke)object);
                    graphics.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
                }
            }
        } else if (this.lineWidth > 0) {
            graphics.setColor(this.foreground);
            object = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            if (object != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke((Stroke)object);
                graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                graphics2D.setStroke(stroke);
            } else {
                graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
        }
        this.paintShadows(graphics);
    }

    void paintSelectedSummit(Graphics graphics, int[] nArray, double d) {
        graphics.setColor(Color.MAGENTA);
        graphics.setXORMode(Color.white);
        int n = (int)(d / 2.0 + 1.0);
        for (int i = 0; i < nArray.length; ++i) {
            graphics.fillRect((int)(this.summit[nArray[i]].x + 0.5) - n, (int)(this.summit[nArray[i]].y + 0.5) - n, 2 * n, 2 * n);
        }
        graphics.setPaintMode();
    }

    @Override
    int getSummitMotion(int n) {
        return 3;
    }

    void translateSummits(int[] nArray, double d, double d2) {
        for (int i = 0; i < nArray.length; ++i) {
            this.summit[nArray[i]].x += d;
            this.summit[nArray[i]].y += d2;
        }
        this.updateShape();
    }

    int[] getSummitsInsideRectangle(Rectangle rectangle) {
        int[] nArray = new int[this.summit.length];
        int n = 0;
        for (int i = 0; i < this.summit.length; ++i) {
            if (!rectangle.contains((int)(this.summit[i].x + 0.5), (int)(this.summit[i].y + 0.5))) continue;
            nArray[n] = i;
            ++n;
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    @Override
    public void moveSummit(int n, double d, double d2) {
        this.summit[n].x = d;
        this.summit[n].y = d2;
        this.updateShape();
    }

    void deleteSummit() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length - 1];
        int n = 0;
        for (int i = 0; i < this.summit.length; ++i) {
            if (i == this.breakId) continue;
            doubleArray[n++] = this.summit[i];
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    boolean canDeleteSummit(int n) {
        if (!this.visible) {
            return false;
        }
        this.breakId = -1;
        if (n < 0 || n >= this.summit.length || this.summit.length <= 2) {
            return false;
        }
        this.breakId = n;
        return true;
    }

    boolean canBreakShape(int n, int n2) {
        if (!this.visible) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double();
        this.breakId = -1;
        for (int i = 0; i < this.ptsx.length; ++i) {
            int n3 = i + 1;
            if (n3 >= this.ptsx.length) {
                n3 -= this.ptsx.length;
            }
            double_.setLine(this.ptsx[i], this.ptsy[i], this.ptsx[n3], this.ptsy[n3]);
            if (!double_.intersects(n - 3, n2 - 3, 6.0, 6.0)) continue;
            this.breakId = i;
            this.breakX = n;
            this.breakY = n2;
            return true;
        }
        return false;
    }

    void breakShape() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + 1];
        int n = 0;
        for (int i = 0; i < this.summit.length; ++i) {
            doubleArray[n++] = this.summit[i];
            if (i != this.breakId) continue;
            doubleArray[n++] = new Point2D.Double(this.breakX, this.breakY);
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    @Override
    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        boolean bl = false;
        int n3 = 0;
        if (this.fillStyle != 0 && this.isClosed) {
            Polygon polygon = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            bl = polygon.contains(n, n2);
        } else {
            while (n3 < this.ptsx.length - 1 && !bl) {
                bl = this.isPointOnLine(n, n2, this.ptsx[n3], this.ptsy[n3], this.ptsx[n3 + 1], this.ptsy[n3 + 1]);
                if (bl) continue;
                ++n3;
            }
            if (!bl && this.isClosed) {
                bl = this.isPointOnLine(n, n2, this.ptsx[n3], this.ptsy[n3], this.ptsx[0], this.ptsy[0]);
            }
        }
        return bl;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        for (int i = 0; i < this.summit.length; ++i) {
            double d6 = this.summit[i].x - d2;
            double d7 = this.summit[i].y - d3;
            this.summit[i].x = d6 * d5 + d7 * d4 + d2;
            this.summit[i].y = -d6 * d4 + d7 * d5 + d3;
        }
        this.updateShape();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) {
        this.isClosed = bl;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = 1;
    }

    public void setStartingPoint(int n) {
        int n2;
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length];
        for (n2 = n %= this.summit.length; n2 < this.summit.length; ++n2) {
            doubleArray[n2 - n] = this.summit[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            doubleArray[n2 + this.summit.length - n] = this.summit[n2];
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    public void connect(JDPolyline jDPolyline) {
        int n;
        JDPolyline jDPolyline2 = jDPolyline instanceof JDSpline ? ((JDSpline)jDPolyline).convertToPolyline() : jDPolyline;
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + jDPolyline2.getSummitNumber()];
        for (n = 0; n < this.summit.length; ++n) {
            doubleArray[n] = this.summit[n];
        }
        for (n = 0; n < jDPolyline2.getSummitNumber(); ++n) {
            doubleArray[n + this.summit.length] = new Point2D.Double(jDPolyline2.getSummit((int)n).x, jDPolyline2.getSummit((int)n).y);
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    public void invertSummitOrder() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length];
        for (int i = 0; i < this.summit.length; ++i) {
            doubleArray[this.summit.length - i - 1] = this.summit[i];
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    @Override
    void recordObject(StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2 = this.recordObjectHeader(stringBuffer, n);
        if (this.step != 1) {
            stringBuffer.append(stringBuffer2).append("step:").append(this.step).append("\n");
        }
        if (!this.isClosed) {
            stringBuffer.append(stringBuffer2).append("isClosed:").append(this.isClosed).append("\n");
        }
        this.closeObjectHeader(stringBuffer, n);
    }

    JDPolyline(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        int n = jDFileLoader.getCurrentLine();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseSummitArray();
        if (this.summit.length < 2) {
            throw new IOException("Invalid summit number for JDPolyline at line " + n);
        }
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("isClosed")) {
                this.isClosed = jDFileLoader.parseBoolean();
                continue;
            }
            if (string.equals("step")) {
                this.step = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(5);
        this.fillUndoPattern(undoPattern);
        undoPattern.step = this.step;
        undoPattern.isClosed = this.isClosed;
        return undoPattern;
    }

    JDPolyline(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.step = undoPattern.step;
        this.isClosed = undoPattern.isClosed;
        this.updateShape();
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[this.summit.length];
        this.ptsy = new int[this.summit.length];
        for (int i = 0; i < this.summit.length; ++i) {
            this.ptsx[i] = (int)(this.summit[i].x + 0.5);
            this.ptsy[i] = (int)(this.summit[i].y + 0.5);
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }
}

