/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class JDFileFilter
extends FileFilter {
    private String description = null;
    private String[] extensions;

    public JDFileFilter(String string, String[] stringArray) {
        this.extensions = stringArray;
        this.description = string + "  (";
        for (int i = 0; i < stringArray.length; ++i) {
            this.description = this.description + "." + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            this.description = this.description + ",";
        }
        this.description = this.description + ")";
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            return this.isWantedExtension(this.getExtension(file));
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    private boolean isWantedExtension(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.extensions.length && !bl; ++i) {
            bl = string.equalsIgnoreCase(this.extensions[i]);
        }
        return bl;
    }
}

