/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class EditorPanel
extends JPanel
implements ActionListener {
    private JButton bwButton;
    private JButton colorButton;
    private JButton invertButton;
    private JButton helpButton;
    private JButton okButton;
    private JButton cancelButton;
    private JGradientEditor gradEditor;
    private static String helpString = "Cursor color can be changed by double clicking on it.\nCursors can be moved by dragging them.\nColor entry can be added or removed by right clicking on the gradient.";
    int dlgRetValue = 0;

    public EditorPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.gradEditor = new JGradientEditor();
        jPanel.add((Component)this.gradEditor, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.bwButton = new JButton("Monochrome");
        this.bwButton.setFont(ATKConstant.labelFont);
        this.bwButton.addActionListener(this);
        jPanel2.add(this.bwButton);
        this.colorButton = new JButton("Color");
        this.colorButton.setFont(ATKConstant.labelFont);
        this.colorButton.addActionListener(this);
        jPanel2.add(this.colorButton);
        this.invertButton = new JButton("Invert");
        this.invertButton.setFont(ATKConstant.labelFont);
        this.invertButton.addActionListener(this);
        jPanel2.add(this.invertButton);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "Center");
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(2);
        JPanel jPanel3 = new JPanel(flowLayout);
        this.helpButton = new JButton("Help");
        this.helpButton.setFont(ATKConstant.labelFont);
        this.helpButton.addActionListener(this);
        this.okButton = new JButton("Apply");
        this.okButton.setFont(ATKConstant.labelFont);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Dismiss");
        this.cancelButton.setFont(ATKConstant.labelFont);
        this.cancelButton.addActionListener(this);
        jPanel3.add(this.helpButton);
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        this.add((Component)jPanel3, "South");
    }

    public void setEditable(boolean bl) {
        this.gradEditor.setEditable(bl);
    }

    public boolean isEditable() {
        return this.gradEditor.isEditable();
    }

    public void setGradient(Gradient gradient) {
        this.gradEditor.setGradient(gradient);
    }

    public Gradient getGradient() {
        return this.gradEditor.getGradient();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.dlgRetValue = 1;
            this.getRootPane().getParent().setVisible(false);
        } else if (object == this.cancelButton) {
            this.dlgRetValue = 0;
            this.getRootPane().getParent().setVisible(false);
        } else if (object == this.bwButton) {
            this.gradEditor.setDefaultGradient();
        } else if (object == this.colorButton) {
            this.gradEditor.setRainbowGradient();
        } else if (object == this.invertButton) {
            this.gradEditor.invertGradient();
        } else if (object == this.helpButton) {
            JOptionPane.showMessageDialog(null, helpString, "Help on Gradient Editor", 1);
        }
    }
}

