/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConfirmCommandViewer
extends VoidVoidCommandViewer {
    protected Component confirmDialParent = null;
    protected String confirmTitle = "Command Execute Confirm Window";
    protected String confirmMessage = "Do you really want to execute this command?\n";
    protected String commandLabel = null;

    public Component getConfirmDialParent() {
        return this.confirmDialParent;
    }

    public void setConfirmDialParent(Component component) {
        this.confirmDialParent = component;
    }

    public String getConfirmTitle() {
        return this.confirmTitle;
    }

    public void setConfirmTitle(String string) {
        this.confirmTitle = string;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public void setConfirmMessage(String string) {
        this.confirmMessage = string;
    }

    public String getCommandLabel() {
        return this.commandLabel;
    }

    public void setCommandLabel(String string) {
        this.commandLabel = string;
        if (this.commandLabel == null) {
            this.setText(this.model.getNameSansDevice() + " ...");
        }
    }

    @Override
    public void setModel(ICommand iCommand) {
        if (this.model != null) {
            this.setText("command-name ...");
            this.setToolTipText(null);
            this.model = null;
        }
        if (iCommand != null && iCommand instanceof VoidVoidCommand) {
            this.model = iCommand;
            if (this.commandLabel != null) {
                this.setText(this.commandLabel);
            } else {
                this.setText(this.model.getNameSansDevice() + " ...");
            }
            this.setToolTipText(this.model.getDevice().toString());
        }
    }

    @Override
    protected void executeButtonActionPerformed(ActionEvent actionEvent) {
        int n = 1;
        try {
            n = JOptionPane.showConfirmDialog(this.confirmDialParent, this.confirmMessage, this.confirmTitle, 0);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (n == 0 && this.model != null) {
            this.model.execute();
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        CommandList commandList = new CommandList();
        ConfirmCommandViewer confirmCommandViewer = new ConfirmCommandViewer();
        try {
            object = (ICommand)commandList.add("elin/gun/aux/Off");
            String string = "Gun aux OFF command confirmation";
            String string2 = "If you turn off the Gun Aux device now, \nnext time when it is turned on it will take 7 minutes for the Gun AUX to heat again.\n\nDo you really want to turn off the Gun AUX?\n";
            confirmCommandViewer.setModel((ICommand)object);
            confirmCommandViewer.setConfirmTitle(string);
            confirmCommandViewer.setConfirmMessage(string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        object = new JFrame();
        ((JFrame)object).getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((JFrame)object).getContentPane().add((Component)confirmCommandViewer, gridBagConstraints);
        confirmCommandViewer.setConfirmDialParent((Component)object);
        ((Window)object).pack();
        ((Window)object).setVisible(true);
    }

    @Override
    public String toString() {
        return "{ConfirmCommandViewer}";
    }
}

