/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SimpleEnumScalarViewer
extends JAutoScrolledText
implements IEnumScalarListener,
IErrorListener,
JDrawable {
    private IEnumScalar model = null;
    private String invalidText = "-----";
    private Color backgroundColor = ATKConstant.getColor4Quality("VALID");
    private boolean alarmEnabled = true;
    private boolean hasToolTip = false;
    private boolean qualityInTooltip = false;
    static String[] exts = new String[]{"alarmEnabled", "validBackground"};

    public SimpleEnumScalarViewer() {
        this.setOpaque(true);
    }

    public void setInvalidText(String string) {
        this.invalidText = string;
    }

    public String getInvalidText() {
        return this.invalidText;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setAlarmEnabled(boolean bl) {
        this.alarmEnabled = bl;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public IEnumScalar getModel() {
        return this.model;
    }

    public void setModel(IEnumScalar iEnumScalar) {
        this.clearModel();
        if (iEnumScalar != null) {
            this.model = iEnumScalar;
            this.model.addEnumScalarListener((IEnumScalarListener)this);
            if (this.hasToolTip) {
                this.setToolTipText(this.model.getName());
            }
            this.model.refresh();
        }
    }

    public void clearModel() {
        if (this.hasToolTip) {
            this.setToolTipText(null);
        }
        if (this.model != null) {
            this.model.removeEnumScalarListener((IEnumScalarListener)this);
            this.model = null;
        }
    }

    public void enumScalarChange(EnumScalarEvent enumScalarEvent) {
        String string = enumScalarEvent.getValue();
        if (string == null) {
            this.setText(this.invalidText);
            return;
        }
        String string2 = this.getText();
        if (!string.equals(string2)) {
            this.setText(string);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = attributeStateEvent.getState();
        if (this.hasToolTip && this.qualityInTooltip) {
            IAttribute iAttribute = (IAttribute)attributeStateEvent.getSource();
            this.setToolTipText(iAttribute.getName() + " : " + string);
        }
        if (string.equals("INVALID")) {
            this.setText(this.invalidText);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (string.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(string));
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setText(this.invalidText);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean bl) {
        if (this.hasToolTip == bl) {
            return;
        }
        this.hasToolTip = bl;
        this.setToolTipText(null);
        if (this.hasToolTip && this.model != null) {
            this.setToolTipText(this.model.getName());
        }
    }

    public boolean getQualityInTooltip() {
        return this.qualityInTooltip;
    }

    public void setQualityInTooltip(boolean bl) {
        if (this.qualityInTooltip == bl) {
            return;
        }
        this.qualityInTooltip = bl;
        if (!this.hasToolTip) {
            return;
        }
        if (!this.qualityInTooltip && this.model != null) {
            this.setToolTipText(this.model.getName());
        }
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String string) {
        if (string.equalsIgnoreCase("alarmEnabled")) {
            return "When enabled, the background color change with the\nTango attribute quality factor.\nDefault colors are: ( unless they have been changed with\nATKConstant.setColor4Quality() )\n VALID   => Green\n INVALID => Grey\n ALARM   => Orange\n WARNING => Orange\n CHANGING => Blue\n UNKNOWN => Grey\nPossible values are: true, false.";
        }
        if (string.equalsIgnoreCase("validBackground")) {
            return "Sets the background color (r,g,b) for the VALID quality factor for this viewer.\nHas effect only if alarmEnabled is true.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("alarmEnabled")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setAlarmEnabled(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setAlarmEnabled(false);
                return true;
            }
            this.showJdrawError(bl, "alarmEnabled", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("validBackground")) {
            String[] stringArray = string2.split(",");
            if (stringArray.length != 3) {
                this.showJdrawError(bl, "validBackground", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
                    this.showJdrawError(bl, "validBackground", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setBackgroundColor(new Color(n, n2, n3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showJdrawError(bl, "validBackground", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getExtendedParam(String string) {
        if (string.equals("alarmEnabled")) {
            return this.isAlarmEnabled() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("validBackground")) {
            Color color = this.backgroundColor;
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "SimpleScalarViewer: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AttributeList attributeList = new AttributeList();
        SimpleEnumScalarViewer simpleEnumScalarViewer = new SimpleEnumScalarViewer();
        IEnumScalar iEnumScalar = (IEnumScalar)attributeList.add("//acudebian7:10000/dev/test/10/DynEnum_attr");
        simpleEnumScalarViewer.setHasToolTip(true);
        simpleEnumScalarViewer.setModel(iEnumScalar);
        simpleEnumScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
        simpleEnumScalarViewer.setBackgroundColor(Color.WHITE);
        simpleEnumScalarViewer.setForeground(Color.BLACK);
        simpleEnumScalarViewer.setFont(new Font("Dialog", 1, 30));
        simpleEnumScalarViewer.setAutoScroll(30);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(simpleEnumScalarViewer);
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.startRefresher();
    }
}

