/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.I3DTrendChangeListener;
import fr.esrf.tangoatk.widget.attribute.I3DTrendCursorListener;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumTrend3DViewerListener;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.TrendData;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.J3DTrend;
import fr.esrf.tangoatk.widget.util.J3DTrendListener;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.EventListenerList;

public class NumberSpectrumTrend3DViewer
extends JComponent
implements ISpectrumListener,
ActionListener,
MouseListener,
J3DTrendListener,
IJLChartListener,
AdjustmentListener {
    static final GregorianCalendar calendar = new GregorianCalendar();
    static final SimpleDateFormat genFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    protected INumberSpectrum model = null;
    private TrendData[] data;
    private TrendData[] derivativeData;
    private J3DTrend trend;
    private JScrollPane trendView;
    private int historyLength;
    private int[] gColormap;
    private Gradient gColor;
    private double zMin;
    private double zMax;
    private boolean zAutoScale;
    private JGradientViewer gradientViewer;
    private JLabel statusLabel;
    private Color NaNColor = new Color(128, 128, 128);
    private int rdimx;
    private int rdimy;
    private int vZoom;
    private int hZoom;
    private boolean readPollingHistory = true;
    private String valueName = "value";
    private String yName = "Y";
    private String[] yIndexName = new String[0];
    private String yUnit = "";
    private double yGain = 1.0;
    private double yOffset = 0.0;
    private String generalName = " ";
    private String unitName = "";
    private boolean logScale = false;
    private boolean showDerivative = false;
    private int zoomScroll;
    private String format;
    private File currentFile = null;
    private EventListenerList listenerList = new EventListenerList();
    private int lastHScrollPos = 0;
    private int lastVScrollPos = 0;
    private boolean showingMenu;
    protected JPopupMenu popupMenu;
    protected JMenuItem saveFileMenuItem;
    protected JMenuItem settingsMenuItem;
    protected JMenuItem hProfileMenuItem;
    protected JMenuItem vProfileMenuItem;
    protected JMenuItem hZoomInMenuItem;
    protected JMenuItem hZoomOutMenuItem;
    protected JMenuItem vZoomInMenuItem;
    protected JMenuItem vZoomOutMenuItem;
    protected JFrame settingsFrame = null;
    private JPanel settingsPanel;
    private LabelViewer attNameLabel = null;
    private JButton propButton;
    private JCheckBox autoScaleCheck;
    private JTextField minText;
    private JTextField maxText;
    private JGradientEditor gradEditor;
    private JButton gradButton;
    private JTextField hLengthText;
    private JComboBox hZoomCombo = null;
    private JComboBox vZoomCombo = null;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox logScaleCheck;
    private JCheckBox derivativeCheck;
    private JTextField formatText;
    protected SimplePropertyFrame propDialog = null;
    protected LineProfilerViewer vProfiler = null;
    protected JFrame hProfiler = null;
    protected JLChart hProfilerGraph;
    protected JLDataView hProfilerData;

    public NumberSpectrumTrend3DViewer() {
        this.setLayout(new BorderLayout());
        this.historyLength = 0;
        this.setHistoryLength(800);
        this.derivativeData = null;
        this.zAutoScale = true;
        this.zMin = 0.0;
        this.zMax = 100.0;
        this.rdimx = this.historyLength;
        this.rdimy = 256;
        this.hZoom = 1;
        this.vZoom = 1;
        this.zoomScroll = 0;
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.format = "";
        this.trend = new J3DTrend();
        this.trend.setParent(this);
        this.trend.addMouseListener(this);
        this.trendView = new JScrollPane(this.trend);
        this.trendView.getHorizontalScrollBar().addAdjustmentListener(this);
        this.trendView.getVerticalScrollBar().addAdjustmentListener(this);
        this.add((Component)this.trendView, "Center");
        this.gradientViewer = new JGradientViewer();
        this.gradientViewer.setGradient(this.gColor);
        this.add((Component)this.gradientViewer, "East");
        this.statusLabel = new JLabel(" ");
        this.add((Component)this.statusLabel, "North");
        this.showingMenu = true;
        this.popupMenu = new JPopupMenu();
        this.hZoomInMenuItem = new JMenuItem("Horz. ZoomIn");
        this.hZoomInMenuItem.addActionListener(this);
        this.popupMenu.add(this.hZoomInMenuItem);
        this.hZoomOutMenuItem = new JMenuItem("Horz. ZoomOut");
        this.hZoomOutMenuItem.addActionListener(this);
        this.popupMenu.add(this.hZoomOutMenuItem);
        this.vZoomInMenuItem = new JMenuItem("Vert. ZoomIn");
        this.vZoomInMenuItem.addActionListener(this);
        this.popupMenu.add(this.vZoomInMenuItem);
        this.vZoomOutMenuItem = new JMenuItem("Vert. ZoomOut");
        this.vZoomOutMenuItem.addActionListener(this);
        this.popupMenu.add(this.vZoomOutMenuItem);
        this.popupMenu.add(new JSeparator());
        this.hProfileMenuItem = new JMenuItem("Horz. profile");
        this.hProfileMenuItem.addActionListener(this);
        this.popupMenu.add(this.hProfileMenuItem);
        this.vProfileMenuItem = new JMenuItem("Vert. profile");
        this.vProfileMenuItem.addActionListener(this);
        this.popupMenu.add(this.vProfileMenuItem);
        this.popupMenu.add(new JSeparator());
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.popupMenu.add(this.settingsMenuItem);
        this.popupMenu.add(new JSeparator());
        this.saveFileMenuItem = new JMenuItem("Save data");
        this.saveFileMenuItem.addActionListener(this);
        this.popupMenu.add(this.saveFileMenuItem);
        this.buildImage();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n;
        Object object = adjustmentEvent.getSource();
        if (adjustmentEvent.getAdjustmentType() != 1 && adjustmentEvent.getAdjustmentType() != 2 && adjustmentEvent.getAdjustmentType() != 4 && adjustmentEvent.getAdjustmentType() != 3 && adjustmentEvent.getAdjustmentType() != 5) {
            return;
        }
        if (object == this.trendView.getHorizontalScrollBar()) {
            int n2 = this.trendView.getHorizontalScrollBar().getValue();
            if (this.lastHScrollPos != n2) {
                this.fireHScroolChange(n2);
                this.lastHScrollPos = n2;
            }
        } else if (object == this.trendView.getVerticalScrollBar() && (n = this.trendView.getVerticalScrollBar().getValue()) != this.lastVScrollPos) {
            this.fireVScroolChange(n);
            this.lastVScrollPos = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryLength(int n) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            int n2;
            TrendData[] trendDataArray = new TrendData[n];
            for (n2 = 0; n2 < this.historyLength && n2 < n; ++n2) {
                trendDataArray[n2] = this.data[n2];
            }
            while (n2 < n) {
                trendDataArray[n2] = null;
                ++n2;
            }
            this.data = trendDataArray;
            this.historyLength = n;
            if (this.showDerivative) {
                this.buildDerivative();
            }
        }
    }

    public J3DTrend getTrend() {
        return this.trend;
    }

    public int getHistoryLength() {
        return this.historyLength;
    }

    public void clearData() {
        this.setData(null, null);
        this.trend.clearCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(long[] lArray, double[][] dArray) {
        if (lArray == null || dArray == null) {
            NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
            synchronized (numberSpectrumTrend3DViewer) {
                TrendData[] trendDataArray = new TrendData[this.historyLength];
                for (int i = 0; i < this.historyLength; ++i) {
                    trendDataArray[i] = null;
                }
                this.data = trendDataArray;
                if (this.showDerivative) {
                    this.buildDerivative();
                }
                this.buildImage();
                return;
            }
        }
        if (lArray.length != dArray.length) {
            System.out.println("Invalid data: date length and data length differ");
            return;
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            int n = lArray.length;
            TrendData[] trendDataArray = new TrendData[n];
            for (int i = 0; i < n; ++i) {
                trendDataArray[n - i - 1] = new TrendData();
                trendDataArray[n - i - 1].time = lArray[i];
                trendDataArray[n - i - 1].values = dArray[i];
            }
            this.data = trendDataArray;
            this.historyLength = n;
            if (this.showDerivative) {
                this.buildDerivative();
            }
            this.buildImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZMinimum(double d) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zMin = d;
        }
    }

    public double getZMinimum() {
        return this.zMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZMaximum(double d) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zMax = d;
        }
    }

    public double getZMaximum() {
        return this.zMax;
    }

    public boolean isZAutoScale() {
        return this.zAutoScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZAutoScale(boolean bl) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zAutoScale = bl;
        }
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogScale(boolean bl) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.logScale = bl;
        }
    }

    public boolean isShowDerivative() {
        return this.showDerivative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowDerivative(boolean bl) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.showDerivative = bl;
            this.buildDerivative();
            this.buildImage();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient gradient) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.gColor = gradient;
            this.gColormap = gradient.buildColorMap(65536);
            this.gradientViewer.setGradient(this.gColor);
            this.gradientViewer.repaint();
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    public void setGradientVisible(boolean bl) {
        this.gradientViewer.setVisible(bl);
    }

    public boolean isGradientVisible() {
        return this.gradientViewer.isVisible();
    }

    public void setNaNColor(Color color) {
        this.NaNColor = color;
    }

    public JLAxis getXAxis() {
        return this.trend.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.trend.getYAxis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHorizontalZoom(int n) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zoomScroll = 0;
            this.hZoom = n;
        }
    }

    public int getHorizontalZoom() {
        return this.hZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVerticalZoom(int n) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.vZoom = n;
        }
    }

    public int getVerticalZoom() {
        return this.vZoom;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(INumberSpectrum iNumberSpectrum) {
        this.clearModel();
        if (iNumberSpectrum == null) {
            this.repaint();
            return;
        }
        this.model = iNumberSpectrum;
        if (this.readPollingHistory) {
            this.readHistory();
        }
        this.statusLabel.setText(this.model.getName());
        this.model.addSpectrumListener((ISpectrumListener)this);
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeSpectrumListener((ISpectrumListener)this);
            if (this.attNameLabel != null) {
                this.attNameLabel.setModel(null);
            }
        }
        this.model = null;
    }

    public long getTimeAt(int n) {
        int n2 = this.hZoom >= 1 ? this.historyLength - n / this.hZoom - 1 : this.historyLength - n * -this.hZoom - 1;
        if (n2 >= 0 && n2 < this.historyLength) {
            if (this.data[n2] != null) {
                return this.data[n2].time;
            }
            return 0L;
        }
        return 0L;
    }

    public void addNumberSpectrumTrend3DViewerListener(NumberSpectrumTrend3DViewerListener numberSpectrumTrend3DViewerListener) {
        this.listenerList.add(NumberSpectrumTrend3DViewerListener.class, numberSpectrumTrend3DViewerListener);
    }

    public void addCursorListener(I3DTrendCursorListener i3DTrendCursorListener) {
        this.listenerList.add(I3DTrendCursorListener.class, i3DTrendCursorListener);
    }

    public void removeCursorListener(I3DTrendCursorListener i3DTrendCursorListener) {
        this.listenerList.remove(I3DTrendCursorListener.class, i3DTrendCursorListener);
    }

    public void addChangeListener(I3DTrendChangeListener i3DTrendChangeListener) {
        this.listenerList.add(I3DTrendChangeListener.class, i3DTrendChangeListener);
    }

    public void removeChangeListener(I3DTrendChangeListener i3DTrendChangeListener) {
        this.listenerList.remove(I3DTrendChangeListener.class, i3DTrendChangeListener);
    }

    private void fireZoomChange() {
        I3DTrendChangeListener[] i3DTrendChangeListenerArray = (I3DTrendChangeListener[])this.listenerList.getListeners(I3DTrendChangeListener.class);
        for (int i = 0; i < i3DTrendChangeListenerArray.length; ++i) {
            i3DTrendChangeListenerArray[i].zoomChanged(this, this.getHorizontalZoom(), this.getVerticalZoom());
        }
    }

    private void fireVScroolChange(int n) {
        I3DTrendChangeListener[] i3DTrendChangeListenerArray = (I3DTrendChangeListener[])this.listenerList.getListeners(I3DTrendChangeListener.class);
        for (int i = 0; i < i3DTrendChangeListenerArray.length; ++i) {
            i3DTrendChangeListenerArray[i].verticalScrollChanged(this, n);
        }
    }

    private void fireHScroolChange(int n) {
        I3DTrendChangeListener[] i3DTrendChangeListenerArray = (I3DTrendChangeListener[])this.listenerList.getListeners(I3DTrendChangeListener.class);
        for (int i = 0; i < i3DTrendChangeListenerArray.length; ++i) {
            i3DTrendChangeListenerArray[i].horinzontalScrollChanged(this, n);
        }
    }

    private void fireCursorMove() {
        I3DTrendCursorListener[] i3DTrendCursorListenerArray = (I3DTrendCursorListener[])this.listenerList.getListeners(I3DTrendCursorListener.class);
        for (int i = 0; i < i3DTrendCursorListenerArray.length; ++i) {
            i3DTrendCursorListenerArray[i].cursorMove(this, this.getXCursor(), this.getYCursor());
        }
    }

    public void setCursorPos(int n, int n2) {
        int n3 = this.hZoom >= 1 ? this.hZoom * (this.historyLength - (n + 1)) : (this.historyLength - (n + 1)) / -this.hZoom;
        int n4 = this.vZoom >= 1 ? this.vZoom * n2 : n2 / -this.vZoom;
        this.trend.setCursor(n3, n4);
    }

    public int getXCursor() {
        int n = this.trend.getXCursor();
        if (n < 0) {
            return -1;
        }
        int n2 = this.hZoom >= 1 ? this.historyLength - n / this.hZoom - 1 : this.historyLength - n * -this.hZoom - 1;
        return n2;
    }

    public int getYCursor() {
        int n = this.trend.getYCursor();
        if (n < 0) {
            return -1;
        }
        int n2 = this.vZoom >= 1 ? n / this.vZoom : n * -this.vZoom;
        return n2;
    }

    public double getValueAt(int n, int n2) {
        int n3 = this.hZoom >= 1 ? this.historyLength - n / this.hZoom - 1 : this.historyLength - n * -this.hZoom - 1;
        if (n3 >= 0 && n3 < this.historyLength) {
            if (this.data[n3] != null) {
                int n4 = this.vZoom >= 1 ? n2 / this.vZoom : n2 * -this.vZoom;
                if (n4 >= 0 && n4 < this.data[n3].values.length) {
                    return this.data[n3].values[n4];
                }
                return Double.NaN;
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public void setCursorEnabled(boolean bl) {
        this.trend.setCursorEnabled(bl);
    }

    public void clearStatusLabel() {
        this.trend.clearCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCursor(int n, int n2, boolean bl) {
        String string = this.generalName;
        String string2 = this.unitName;
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            NumberSpectrumTrend3DViewerListener[] numberSpectrumTrend3DViewerListenerArray;
            if (this.model != null) {
                string = this.model.getName();
                string2 = this.model.getUnit();
                this.format = this.model.getFormat();
            }
            if ((numberSpectrumTrend3DViewerListenerArray = (NumberSpectrumTrend3DViewerListener[])this.listenerList.getListeners(NumberSpectrumTrend3DViewerListener.class)).length > 0) {
                int n3 = this.vZoom >= 1 ? n2 / this.vZoom : n2 * -this.vZoom;
                int n4 = this.hZoom >= 1 ? this.historyLength - n / this.hZoom - 1 : this.historyLength - n * -this.hZoom - 1;
                long l = this.getTimeAt(n);
                double d = this.getValueAt(n, n2);
                String string3 = n < 0 | n2 < 0 ? numberSpectrumTrend3DViewerListenerArray[0].getStatusLabel(this, -1, -1, l, d) : numberSpectrumTrend3DViewerListenerArray[0].getStatusLabel(this, n4, n3, l, d);
                this.statusLabel.setText(string3);
            } else if (n < 0) {
                this.statusLabel.setText(string);
            } else {
                long l = this.getTimeAt(n);
                if (l == 0L) {
                    this.statusLabel.setText(string + "  | no data at marker position");
                } else {
                    String string4 = this.buildTime(l);
                    double d = this.getValueAt(n, n2);
                    if (Double.isNaN(d)) {
                        if (this.vZoom >= 1) {
                            int n5 = (int)((double)(n2 / this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (n5 >= 0 && n5 < this.yIndexName.length) {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=NaN at " + this.yName + "=" + this.yIndexName[n5] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=NaN at " + this.yName + "=" + ((double)(n2 / this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        } else {
                            int n6 = (int)((double)(n2 * -this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (n6 >= 0 && n6 < this.yIndexName.length) {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=NaN at " + this.yName + "=" + this.yIndexName[n6] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=NaN at " + this.yName + "=" + ((double)(n2 * -this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        }
                    } else {
                        String string5 = this.format.length() > 0 ? ATKFormat.format(this.format, d) : Double.toString(d);
                        if (this.vZoom >= 1) {
                            int n7 = (int)((double)(n2 / this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (n7 >= 0 && n7 < this.yIndexName.length) {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=" + string5 + " " + string2 + " at " + this.yName + "=" + this.yIndexName[n7] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=" + string5 + " " + string2 + " at " + this.yName + "=" + ((double)(n2 / this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        } else {
                            int n8 = (int)((double)(n2 * -this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (n8 >= 0 && n8 < this.yIndexName.length) {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=" + string5 + " " + string2 + " at " + this.yName + "=" + this.yIndexName[n8] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(string + "  | " + string4 + " " + this.valueName + "=" + string5 + " " + string2 + " at " + this.yName + "=" + ((double)(n2 * -this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        }
                    }
                }
            }
            if (this.vProfiler != null && this.vProfiler.isVisible()) {
                this.buildVerticalProfile();
            }
            if (this.hProfiler != null && this.hProfiler.isVisible()) {
                this.buildHorizontalProfile();
            }
        }
        if (bl) {
            this.fireCursorMove();
        }
    }

    public void setShowingMenu(boolean bl) {
        this.showingMenu = bl;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public void readPollingHistory(boolean bl) {
        this.readPollingHistory = bl;
    }

    public void setValueName(String string) {
        this.valueName = string.length() == 0 ? "value" : string;
    }

    public void setYName(String string) {
        this.yName = string.length() == 0 ? "Y" : string;
    }

    public void setYIndexName(String[] stringArray) {
        this.yIndexName = stringArray == null ? new String[0] : stringArray;
    }

    public void setYUnit(String string) {
        this.yUnit = string;
    }

    public void setYTransfom(double d, double d2) {
        this.yGain = d;
        this.yOffset = d2;
    }

    public void setUnit(String string) {
        this.unitName = string;
    }

    @Override
    public void setName(String string) {
        this.generalName = string.length() == 0 ? " " : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    public void scrollToRight() {
        JScrollBar jScrollBar = this.trendView.getHorizontalScrollBar();
        int n = jScrollBar.getMaximum();
        jScrollBar.setValue(n);
    }

    public void scrollToLeft() {
        JScrollBar jScrollBar = this.trendView.getHorizontalScrollBar();
        int n = jScrollBar.getMinimum();
        jScrollBar.setValue(n);
    }

    public void setHorinzontalScrollPos(int n) {
        JScrollBar jScrollBar = this.trendView.getHorizontalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setVertitalScrollPos(int n) {
        JScrollBar jScrollBar = this.trendView.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setTrendBackground(Color color) {
        this.trend.setBackground(color);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.settingsMenuItem) {
            this.showSettings();
        } else if (object == this.saveFileMenuItem) {
            this.saveDataFile();
        } else if (object == this.propButton) {
            this.showPropertyFrame();
        } else if (object == this.autoScaleCheck) {
            this.applyAutoScale();
        } else if (object == this.cancelButton) {
            this.settingsFrame.setVisible(false);
        } else if (object == this.okButton) {
            this.applySettings();
        } else if (object == this.minText) {
            this.applyMinMaxAndBuild();
        } else if (object == this.maxText) {
            this.applyMinMaxAndBuild();
        } else if (object == this.gradButton) {
            this.showGradientEditor();
        } else if (object == this.hLengthText) {
            this.applyHistoryLengthAndBuild();
        } else if (object == this.hZoomCombo) {
            this.applyHorizontalZoom();
        } else if (object == this.vZoomCombo) {
            this.applyVerticalZoom();
        } else if (object == this.vProfileMenuItem) {
            this.showVerticalProfile();
        } else if (object == this.hProfileMenuItem) {
            this.showHorizontalProfile();
        } else if (object == this.hZoomInMenuItem) {
            this.applyHorizontalZoomIn();
        } else if (object == this.hZoomOutMenuItem) {
            this.applyHorizontalZoomOut();
        } else if (object == this.vZoomInMenuItem) {
            this.applyVerticalZoomIn();
        } else if (object == this.vZoomOutMenuItem) {
            this.applyVerticalZoomOut();
        } else if (object == this.logScaleCheck) {
            this.applyLogScale();
        } else if (object == this.derivativeCheck) {
            this.applyDerivative();
        } else if (object == this.formatText) {
            this.applyFormat();
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        Object object;
        String[] stringArray = new String[]{};
        String string = this.unitName;
        if (this.model != null) {
            string = this.model.getUnit();
        }
        if ((object = jLChartEvent.getSource()) == this.hProfilerGraph) {
            stringArray = new String[2];
            long l = (long)jLChartEvent.getTransformedXValue();
            stringArray[0] = this.buildTime(l);
            double d = jLChartEvent.getTransformedYValue();
            String string2 = this.format.length() > 0 ? ATKFormat.format(this.format, d) : Double.toString(d);
            stringArray[1] = this.valueName + "=" + string2 + " " + string;
        }
        return stringArray;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && this.showingMenu && mouseEvent.getSource() == this.trend) {
            this.hProfileMenuItem.setEnabled(this.trend.isCursorInside());
            this.vProfileMenuItem.setEnabled(this.trend.isCursorInside());
            this.hZoomInMenuItem.setEnabled(this.hZoom < 8);
            this.hZoomOutMenuItem.setEnabled(this.hZoom > -10);
            this.vZoomInMenuItem.setEnabled(this.vZoom < 8);
            this.vZoomOutMenuItem.setEnabled(this.vZoom > -10);
            this.popupMenu.show(this.trend, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            TrendData trendData = new TrendData();
            trendData.values = numberSpectrumEvent.getValue();
            trendData.time = numberSpectrumEvent.getTimeStamp();
            this.shiftData();
            if (this.hZoom >= 1) {
                this.trend.shiftCursorX(-this.hZoom);
            } else {
                ++this.zoomScroll;
                if (this.zoomScroll >= -this.hZoom) {
                    this.trend.shiftCursorX(-1);
                    this.zoomScroll = 0;
                }
            }
            this.data[0] = trendData;
            if (this.showDerivative) {
                TrendData trendData2 = new TrendData();
                trendData2.time = numberSpectrumEvent.getTimeStamp();
                this.derivativeData[0] = trendData2;
                this.calcD(0);
            }
            this.buildImage();
            this.repaint();
            if (this.hProfiler != null && this.hProfiler.isVisible()) {
                this.buildHorizontalProfile();
            }
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorChange(ErrorEvent errorEvent) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            TrendData trendData = new TrendData();
            trendData.values = new double[0];
            trendData.time = errorEvent.getTimeStamp();
            this.shiftData();
            if (this.hZoom >= 1) {
                this.trend.shiftCursorX(-this.hZoom);
            } else {
                ++this.zoomScroll;
                if (this.zoomScroll >= -this.hZoom) {
                    this.trend.shiftCursorX(-1);
                    this.zoomScroll = 0;
                }
            }
            this.data[0] = trendData;
            if (this.showDerivative) {
                TrendData trendData2 = new TrendData();
                trendData2.time = errorEvent.getTimeStamp();
                this.derivativeData[0] = trendData2;
                this.calcD(0);
            }
            this.buildImage();
            this.repaint();
            if (this.hProfiler != null && this.hProfiler.isVisible()) {
                this.buildHorizontalProfile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showVerticalProfile() {
        String string = this.unitName;
        if (this.model != null) {
            string = this.model.getUnit();
        }
        this.constructVerticalProfiler();
        this.vProfiler.setMode(1);
        if (this.yUnit.length() > 0) {
            this.vProfiler.setXAxisName(this.yName + " [" + this.yUnit + "]");
        } else {
            this.vProfiler.setXAxisName(this.yName);
        }
        if (string.length() > 0) {
            this.vProfiler.setYAxisName(this.valueName + " [" + string + "]");
        } else {
            this.vProfiler.setYAxisName(this.valueName);
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildVerticalProfile();
        }
        if (!this.vProfiler.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen(this.vProfiler);
        }
        this.vProfiler.setVisible(true);
    }

    private void buildVerticalProfile() {
        int n = this.trend.getXCursor();
        double[] dArray = new double[this.rdimy];
        for (int i = 0; i < this.rdimy; ++i) {
            dArray[i] = Double.NaN;
        }
        String string = "Vertical profile";
        int n2 = this.hZoom >= 1 ? this.historyLength - n / this.hZoom - 1 : this.historyLength - n * -this.hZoom - 1;
        if (n2 >= 0 && n2 < this.historyLength && this.data[n2] != null) {
            String string2 = this.buildTime(this.data[n2].time);
            string = string + " at " + string2;
            for (int i = 0; i < this.rdimy; ++i) {
                dArray[i] = i < this.data[n2].values.length ? this.data[n2].values[i] : Double.NaN;
            }
        }
        this.vProfiler.setData(dArray, this.yGain, this.yOffset);
        this.vProfiler.setTitle("[profile]");
        this.vProfiler.getProfile1().getChart().setHeader(string);
        this.vProfiler.getProfile1().getChart().setLabelVisible(false);
        this.vProfiler.setFormat(this.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHorizontalProfile() {
        this.constructHorizontalProfiler();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildHorizontalProfile();
        }
        if (!this.hProfiler.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen(this.hProfiler);
        }
        this.hProfiler.setVisible(true);
    }

    private void buildHorizontalProfile() {
        int n;
        int n2 = this.trend.getYCursor();
        int n3 = this.vZoom >= 1 ? n2 / this.vZoom : n2 * -this.vZoom;
        this.hProfilerData.reset();
        for (n = 0; n < this.rdimx; ++n) {
            if (this.data[n] == null || this.data[n].time <= 0L) continue;
            if (n3 >= 0 && n3 < this.data[n].values.length) {
                this.hProfilerData.add(this.data[n].time, this.data[n].values[n3]);
                continue;
            }
            this.hProfilerData.add(this.data[n].time, Double.NaN);
        }
        if (n3 >= 0 && n3 < this.rdimy) {
            n = (int)((double)n3 * this.yGain + this.yOffset + 0.5);
            if (n >= 0 && n < this.yIndexName.length) {
                this.hProfilerGraph.setHeader("Horizontal profile at " + this.yName + "=" + this.yIndexName[n]);
            } else {
                this.hProfilerGraph.setHeader("Horizontal profile at " + this.yName + "=" + ((double)n3 * this.yGain + this.yOffset));
            }
        } else {
            this.hProfilerGraph.setHeader("Horizontal profile");
        }
        this.hProfilerGraph.repaint();
    }

    private void constructHorizontalProfiler() {
        if (this.hProfiler == null) {
            String string = this.unitName;
            if (this.model != null) {
                string = this.model.getUnit();
            }
            JPanel jPanel = new JPanel(new BorderLayout());
            this.hProfilerGraph = new JLChart();
            this.hProfilerGraph.setBorder(new EtchedBorder());
            this.hProfilerGraph.getXAxis().setAutoScale(true);
            this.hProfilerGraph.getXAxis().setAnnotation(1);
            this.hProfilerGraph.getXAxis().setGridVisible(true);
            this.hProfilerGraph.getXAxis().setName("Time");
            this.hProfilerGraph.getY1Axis().setAutoScale(true);
            this.hProfilerGraph.getY1Axis().setGridVisible(true);
            if (string.length() > 0) {
                this.hProfilerGraph.getY1Axis().setName(this.valueName + " [" + string + "]");
            } else {
                this.hProfilerGraph.getY1Axis().setName(this.valueName);
            }
            this.hProfilerGraph.setPreferredSize(new Dimension(600, 400));
            this.hProfilerGraph.setMinimumSize(new Dimension(600, 400));
            this.hProfilerGraph.setHeaderFont(new Font("Dialog", 1, 18));
            this.hProfilerGraph.setHeader("Horizontal profile");
            this.hProfilerGraph.setLabelVisible(false);
            this.hProfilerGraph.setJLChartListener(this);
            jPanel.add((Component)this.hProfilerGraph, "Center");
            this.hProfilerData = new JLDataView();
            this.hProfilerGraph.getY1Axis().addDataView(this.hProfilerData);
            this.hProfiler = new JFrame();
            this.hProfiler.setTitle("[profile]");
            this.hProfiler.setContentPane(jPanel);
        }
    }

    private void constructVerticalProfiler() {
        if (this.vProfiler == null) {
            this.vProfiler = new LineProfilerViewer();
            this.vProfiler.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    NumberSpectrumTrend3DViewer.this.vProfiler.setData(null);
                    NumberSpectrumTrend3DViewer.this.vProfiler.dispose();
                }
            });
        }
    }

    public void showSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        if (!this.settingsFrame.isVisible()) {
            ATKGraphicsUtils.centerFrame(this, this.settingsFrame);
        }
        this.settingsFrame.setVisible(true);
    }

    private void setZoomCombo(JComboBox jComboBox, int n) {
        switch (n) {
            case -10: {
                jComboBox.setSelectedIndex(0);
                break;
            }
            case -9: {
                jComboBox.setSelectedIndex(1);
                break;
            }
            case -8: {
                jComboBox.setSelectedIndex(2);
                break;
            }
            case -7: {
                jComboBox.setSelectedIndex(3);
                break;
            }
            case -6: {
                jComboBox.setSelectedIndex(4);
                break;
            }
            case -5: {
                jComboBox.setSelectedIndex(5);
                break;
            }
            case -4: {
                jComboBox.setSelectedIndex(6);
                break;
            }
            case -3: {
                jComboBox.setSelectedIndex(7);
                break;
            }
            case -2: {
                jComboBox.setSelectedIndex(8);
                break;
            }
            case 1: {
                jComboBox.setSelectedIndex(9);
                break;
            }
            case 2: {
                jComboBox.setSelectedIndex(10);
                break;
            }
            case 3: {
                jComboBox.setSelectedIndex(11);
                break;
            }
            case 4: {
                jComboBox.setSelectedIndex(12);
                break;
            }
            case 5: {
                jComboBox.setSelectedIndex(13);
                break;
            }
            case 6: {
                jComboBox.setSelectedIndex(14);
                break;
            }
            case 7: {
                jComboBox.setSelectedIndex(15);
                break;
            }
            case 8: {
                jComboBox.setSelectedIndex(16);
            }
        }
    }

    private int getZoomCombo(JComboBox jComboBox) {
        int n = jComboBox.getSelectedIndex();
        switch (n) {
            case 0: {
                return -10;
            }
            case 1: {
                return -9;
            }
            case 2: {
                return -8;
            }
            case 3: {
                return -7;
            }
            case 4: {
                return -6;
            }
            case 5: {
                return -5;
            }
            case 6: {
                return -4;
            }
            case 7: {
                return -3;
            }
            case 8: {
                return -2;
            }
            case 9: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 5;
            }
            case 14: {
                return 6;
            }
            case 15: {
                return 7;
            }
            case 16: {
                return 8;
            }
        }
        return 1;
    }

    private void initSettings() {
        this.autoScaleCheck.setSelected(this.zAutoScale);
        this.minText.setEnabled(!this.zAutoScale);
        this.minText.setText(Double.toString(this.zMin));
        this.maxText.setEnabled(!this.zAutoScale);
        this.maxText.setText(Double.toString(this.zMax));
        this.gradEditor.setGradient(this.gColor);
        this.hLengthText.setText(Integer.toString(this.historyLength));
        this.setZoomCombo(this.vZoomCombo, this.vZoom);
        this.setZoomCombo(this.hZoomCombo, this.hZoom);
        this.logScaleCheck.setSelected(this.logScale);
        this.derivativeCheck.setSelected(this.showDerivative);
        this.formatText.setText(this.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySettings() {
        this.applyMinMax();
        this.applyHistoryLength();
        this.applyFormat();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    private void applyFormat() {
        this.format = this.formatText.getText();
        this.trend.cursorMove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMinMax() {
        double d;
        double d2;
        try {
            d2 = Double.parseDouble(this.minText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid entry for min\n" + numberFormatException.getMessage());
            return;
        }
        try {
            d = Double.parseDouble(this.maxText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid entry for max\n" + numberFormatException.getMessage());
            return;
        }
        if (d2 >= d) {
            JOptionPane.showMessageDialog(this, "min must be lower than max\n");
            return;
        }
        if (this.logScale && !this.zAutoScale && (d2 <= 0.0 || d <= 0.0)) {
            JOptionPane.showMessageDialog(this, "min and max must be strictly positive in log scale\n");
            return;
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zMin = d2;
            this.zMax = d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMinMaxAndBuild() {
        this.applyMinMax();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    private void applyHistoryLength() {
        int n;
        try {
            n = Integer.parseInt(this.hLengthText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid entry for history length\n" + numberFormatException.getMessage());
            return;
        }
        this.setHistoryLength(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHistoryLengthAndBuild() {
        this.applyHistoryLength();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLogScale() {
        if (!this.zAutoScale && (this.zMin <= 0.0 || this.zMax <= 0.0)) {
            JOptionPane.showMessageDialog(this, "min and max must be strictly positive in log scale\n");
            this.logScaleCheck.setSelected(false);
            this.logScale = false;
            return;
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.logScale = this.logScaleCheck.isSelected();
            this.buildImage();
        }
        this.repaint();
    }

    private void applyDerivative() {
        this.setShowDerivative(this.derivativeCheck.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAutoScale() {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zAutoScale = this.autoScaleCheck.isSelected();
            if (!this.zAutoScale && this.logScale && (this.zMin <= 0.0 || this.zMax <= 0.0)) {
                JOptionPane.showMessageDialog(this, "min and max must be strictly positive in log scale\n");
                this.zAutoScale = true;
                this.autoScaleCheck.setSelected(true);
                return;
            }
            this.minText.setEnabled(!this.zAutoScale);
            this.maxText.setEnabled(!this.zAutoScale);
            this.buildImage();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHorizontalZoom() {
        this.setHorizontalZoom(this.getZoomCombo(this.hZoomCombo));
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
        this.fireZoomChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyVerticalZoom() {
        this.setVerticalZoom(this.getZoomCombo(this.vZoomCombo));
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
        this.fireZoomChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHorizontalZoomIn() {
        if (this.hZoom < 8) {
            NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
            synchronized (numberSpectrumTrend3DViewer) {
                ++this.hZoom;
                if (this.hZoom == -1) {
                    this.hZoom = 1;
                }
                if (this.hZoomCombo != null) {
                    this.setZoomCombo(this.hZoomCombo, this.hZoom);
                }
                this.zoomScroll = 0;
                this.buildImage();
            }
            this.repaint();
            this.fireZoomChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHorizontalZoomOut() {
        if (this.hZoom > -10) {
            NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
            synchronized (numberSpectrumTrend3DViewer) {
                --this.hZoom;
                if (this.hZoom == 0) {
                    this.hZoom = -2;
                }
                if (this.hZoomCombo != null) {
                    this.setZoomCombo(this.hZoomCombo, this.hZoom);
                }
                this.zoomScroll = 0;
                this.buildImage();
            }
            this.repaint();
            this.fireZoomChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyVerticalZoomIn() {
        if (this.vZoom < 8) {
            NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
            synchronized (numberSpectrumTrend3DViewer) {
                ++this.vZoom;
                if (this.vZoom == -1) {
                    this.vZoom = 1;
                }
                if (this.vZoomCombo != null) {
                    this.setZoomCombo(this.vZoomCombo, this.vZoom);
                }
                this.buildImage();
            }
            this.repaint();
            this.fireZoomChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyVerticalZoomOut() {
        if (this.vZoom > -10) {
            NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
            synchronized (numberSpectrumTrend3DViewer) {
                --this.vZoom;
                if (this.vZoom == 0) {
                    this.vZoom = -2;
                }
                if (this.vZoomCombo != null) {
                    this.setZoomCombo(this.vZoomCombo, this.vZoom - 1);
                }
                this.buildImage();
            }
            this.repaint();
            this.fireZoomChange();
        }
    }

    private void showGradientEditor() {
        Gradient gradient = JGradientEditor.showDialog(this.settingsFrame, this.gColor);
        if (gradient != null) {
            this.gColor = gradient;
            this.gColormap = gradient.buildColorMap(65536);
            this.gradEditor.setGradient(this.gColor);
            this.gradEditor.repaint();
            this.gradientViewer.setGradient(this.gColor);
            this.gradientViewer.repaint();
        }
    }

    private void constructSettingsPanel() {
        if (this.settingsFrame == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(null);
            this.settingsPanel.setMinimumSize(new Dimension(290, 290));
            this.settingsPanel.setPreferredSize(new Dimension(290, 290));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            this.settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel((IAttribute)this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(ATKConstant.labelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            this.settingsPanel.add(this.propButton);
            JSeparator jSeparator = new JSeparator();
            jSeparator.setBounds(0, 40, 500, 10);
            this.settingsPanel.add(jSeparator);
            this.autoScaleCheck = new JCheckBox("Auto scale");
            this.autoScaleCheck.setFont(ATKConstant.labelFont);
            this.autoScaleCheck.setBounds(5, 52, 100, 20);
            this.autoScaleCheck.setToolTipText("Auto scale colormap");
            this.autoScaleCheck.addActionListener(this);
            this.settingsPanel.add(this.autoScaleCheck);
            JLabel jLabel = new JLabel("Min");
            jLabel.setFont(ATKConstant.labelFont);
            jLabel.setBounds(110, 50, 30, 25);
            this.settingsPanel.add(jLabel);
            this.minText = new JTextField();
            this.minText.setBounds(145, 50, 50, 25);
            this.minText.addActionListener(this);
            this.settingsPanel.add(this.minText);
            JLabel jLabel2 = new JLabel("Max");
            jLabel2.setFont(ATKConstant.labelFont);
            jLabel2.setBounds(200, 50, 30, 25);
            this.settingsPanel.add(jLabel2);
            this.maxText = new JTextField();
            this.maxText.setBounds(235, 50, 50, 25);
            this.maxText.addActionListener(this);
            this.settingsPanel.add(this.maxText);
            JLabel jLabel3 = new JLabel("Colormap");
            jLabel3.setFont(ATKConstant.labelFont);
            jLabel3.setBounds(5, 80, 70, 20);
            this.settingsPanel.add(jLabel3);
            this.gradEditor = new JGradientEditor();
            this.gradEditor.setEditable(false);
            this.gradEditor.setToolTipText("Display the image using this colormap");
            this.gradEditor.setBounds(80, 80, 180, 20);
            this.settingsPanel.add(this.gradEditor);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(ATKConstant.labelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 80, 25, 20);
            this.gradButton.addActionListener(this);
            this.settingsPanel.add(this.gradButton);
            JSeparator jSeparator2 = new JSeparator();
            jSeparator2.setBounds(0, 110, 500, 10);
            this.settingsPanel.add(jSeparator2);
            JLabel jLabel4 = new JLabel("History length");
            jLabel4.setFont(ATKConstant.labelFont);
            jLabel4.setBounds(5, 120, 90, 25);
            this.settingsPanel.add(jLabel4);
            this.hLengthText = new JTextField();
            this.hLengthText.setBounds(100, 120, 185, 25);
            this.hLengthText.addActionListener(this);
            this.settingsPanel.add(this.hLengthText);
            JSeparator jSeparator3 = new JSeparator();
            jSeparator3.setBounds(0, 150, 500, 10);
            this.settingsPanel.add(jSeparator3);
            JLabel jLabel5 = new JLabel("Horz. zoom");
            jLabel5.setFont(ATKConstant.labelFont);
            jLabel5.setBounds(5, 160, 70, 20);
            this.settingsPanel.add(jLabel5);
            this.hZoomCombo = new JComboBox();
            this.hZoomCombo.setFont(ATKConstant.labelFont);
            this.hZoomCombo.addItem("10%");
            this.hZoomCombo.addItem("11%");
            this.hZoomCombo.addItem("12%");
            this.hZoomCombo.addItem("14%");
            this.hZoomCombo.addItem("16%");
            this.hZoomCombo.addItem("20%");
            this.hZoomCombo.addItem("25%");
            this.hZoomCombo.addItem("33%");
            this.hZoomCombo.addItem("50%");
            this.hZoomCombo.addItem("100%");
            this.hZoomCombo.addItem("200%");
            this.hZoomCombo.addItem("300%");
            this.hZoomCombo.addItem("400%");
            this.hZoomCombo.addItem("500%");
            this.hZoomCombo.addItem("600%");
            this.hZoomCombo.addItem("700%");
            this.hZoomCombo.addItem("800%");
            this.hZoomCombo.setBounds(80, 160, 60, 22);
            this.hZoomCombo.addActionListener(this);
            this.settingsPanel.add(this.hZoomCombo);
            JLabel jLabel6 = new JLabel("Vert. zoom");
            jLabel6.setFont(ATKConstant.labelFont);
            jLabel6.setBounds(150, 160, 70, 20);
            this.settingsPanel.add(jLabel6);
            this.vZoomCombo = new JComboBox();
            this.vZoomCombo.setFont(ATKConstant.labelFont);
            this.vZoomCombo.addItem("10%");
            this.vZoomCombo.addItem("11%");
            this.vZoomCombo.addItem("12%");
            this.vZoomCombo.addItem("14%");
            this.vZoomCombo.addItem("16%");
            this.vZoomCombo.addItem("20%");
            this.vZoomCombo.addItem("25%");
            this.vZoomCombo.addItem("33%");
            this.vZoomCombo.addItem("50%");
            this.vZoomCombo.addItem("100%");
            this.vZoomCombo.addItem("200%");
            this.vZoomCombo.addItem("300%");
            this.vZoomCombo.addItem("400%");
            this.vZoomCombo.addItem("500%");
            this.vZoomCombo.addItem("600%");
            this.vZoomCombo.addItem("700%");
            this.vZoomCombo.addItem("800%");
            this.vZoomCombo.setBounds(225, 160, 60, 22);
            this.vZoomCombo.addActionListener(this);
            this.settingsPanel.add(this.vZoomCombo);
            JSeparator jSeparator4 = new JSeparator();
            jSeparator4.setBounds(0, 190, 500, 10);
            this.settingsPanel.add(jSeparator4);
            this.logScaleCheck = new JCheckBox("Display log values");
            this.logScaleCheck.setFont(ATKConstant.labelFont);
            this.logScaleCheck.setBounds(5, 200, 150, 20);
            this.logScaleCheck.setToolTipText("Display log values");
            this.logScaleCheck.addActionListener(this);
            this.settingsPanel.add(this.logScaleCheck);
            this.derivativeCheck = new JCheckBox("Display derivative");
            this.derivativeCheck.setFont(ATKConstant.labelFont);
            this.derivativeCheck.setBounds(155, 200, 150, 20);
            this.derivativeCheck.setToolTipText("Display derivative");
            this.derivativeCheck.addActionListener(this);
            this.settingsPanel.add(this.derivativeCheck);
            JLabel jLabel7 = new JLabel("Format");
            jLabel7.setFont(ATKConstant.labelFont);
            jLabel7.setBounds(5, 230, 100, 25);
            this.settingsPanel.add(jLabel7);
            this.formatText = new JTextField();
            this.formatText.addActionListener(this);
            this.formatText.setEditable(true);
            this.formatText.setBounds(110, 230, 175, 25);
            this.settingsPanel.add(this.formatText);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(ATKConstant.labelFont);
            this.okButton.setBounds(5, 260, 90, 25);
            this.okButton.addActionListener(this);
            this.settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(ATKConstant.labelFont);
            this.cancelButton.setBounds(195, 260, 90, 25);
            this.cancelButton.addActionListener(this);
            this.settingsPanel.add(this.cancelButton);
            this.settingsFrame = new JFrame();
            this.settingsFrame.setTitle("NumberSpectrumTrend Options");
            this.settingsFrame.setContentPane(this.settingsPanel);
        }
    }

    private void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsFrame, true);
            }
            this.propDialog.setModel((IAttribute)this.model);
            this.propDialog.setVisible(true);
        }
    }

    private void readHistory() {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = this.model.getNumberSpectrumHistory();
        if (iNumberSpectrumHistoryArray != null) {
            for (int i = 0; i < iNumberSpectrumHistoryArray.length; ++i) {
                TrendData trendData = new TrendData();
                trendData.values = iNumberSpectrumHistoryArray[i].getValue();
                trendData.time = iNumberSpectrumHistoryArray[i].getTimestamp();
                this.shiftData();
                this.data[0] = trendData;
            }
        }
    }

    private void shiftData() {
        int n;
        for (n = this.historyLength - 1; n > 0; --n) {
            this.data[n] = this.data[n - 1];
        }
        if (this.showDerivative) {
            for (n = this.historyLength - 1; n > 0; --n) {
                this.derivativeData[n] = this.derivativeData[n - 1];
            }
        }
    }

    private double computeHighTen(double d) {
        int n = (int)Math.log10(d);
        return Math.pow(10.0, n + 1);
    }

    private double computeLowTen(double d) {
        int n = (int)Math.log10(d);
        return Math.pow(10.0, n);
    }

    private int getDataLength(TrendData trendData) {
        if (trendData == null) {
            return 0;
        }
        if (trendData.values == null) {
            return 0;
        }
        return trendData.values.length;
    }

    private void calcD(int n) {
        int n2 = this.getDataLength(this.data[n]);
        int n3 = this.getDataLength(this.data[n + 1]);
        int n4 = n3 > n2 ? n2 : n3;
        this.derivativeData[n].values = new double[n4];
        for (int i = 0; i < n4; ++i) {
            this.derivativeData[n].values[i] = (this.data[n].values[i] - this.data[n + 1].values[i]) / ((double)(this.data[n].time - this.data[n + 1].time) / 1000.0);
        }
    }

    private void buildDerivative() {
        this.derivativeData = new TrendData[this.historyLength];
        for (int i = 0; i < this.historyLength - 1; ++i) {
            if (this.data[i] != null && this.data[i + 1] != null) {
                this.derivativeData[i] = new TrendData();
                this.derivativeData[i].time = this.data[i].time;
                this.calcD(i);
                continue;
            }
            this.derivativeData[i] = null;
        }
        this.derivativeData[this.historyLength - 1] = null;
    }

    private void buildImage() {
        int n;
        TrendData[] trendDataArray = null;
        trendDataArray = this.showDerivative ? this.derivativeData : this.data;
        int n2 = 0;
        boolean bl = false;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        if (!this.zAutoScale) {
            d2 = this.zMax;
            d = this.zMin;
        }
        for (int i = 0; i < this.historyLength; ++i) {
            if (trendDataArray[i] == null || trendDataArray[i].values == null) continue;
            if (trendDataArray[i].values.length > n2) {
                n2 = trendDataArray[i].values.length;
            }
            if (!this.zAutoScale) continue;
            for (n = 0; n < trendDataArray[i].values.length; ++n) {
                double d3;
                if (this.logScale) {
                    if (Double.isNaN(trendDataArray[i].values[n]) || !(trendDataArray[i].values[n] > 0.0)) continue;
                    d3 = trendDataArray[i].values[n];
                    if (d3 < d) {
                        d = d3;
                    }
                    if (d3 > d2) {
                        d2 = d3;
                    }
                    bl = true;
                    continue;
                }
                d3 = trendDataArray[i].values[n];
                if (Double.isNaN(d3)) continue;
                if (d3 < d) {
                    d = d3;
                }
                if (d3 > d2) {
                    d2 = d3;
                }
                bl = true;
            }
        }
        if (bl) {
            if (this.logScale) {
                if (d2 - d < 1.0E-100) {
                    d2 = this.computeHighTen(d2);
                    d = this.computeLowTen(d);
                }
            } else if (d2 - d < 1.0E-100) {
                d2 += 0.999;
                d -= 0.999;
            }
        } else {
            d = this.zMin;
            d2 = this.zMax;
        }
        this.gradientViewer.getAxis().setMinimum(d);
        this.gradientViewer.getAxis().setMaximum(d2);
        if (this.logScale) {
            this.gradientViewer.getAxis().setScale(1);
        } else {
            this.gradientViewer.getAxis().setScale(0);
        }
        BufferedImage bufferedImage = this.trend.getImage();
        this.rdimx = this.historyLength;
        this.rdimy = n2 == 0 ? this.rdimy : n2;
        n = this.hZoom >= 1 ? this.rdimx * this.hZoom : this.rdimx / -this.hZoom;
        int n3 = this.vZoom >= 1 ? this.rdimy * this.vZoom : this.rdimy / -this.vZoom;
        if (bufferedImage == null || bufferedImage.getHeight() != n3 || bufferedImage.getWidth() != n) {
            bufferedImage = new BufferedImage(n, n3, 1);
            this.trend.setImage(bufferedImage, this.hZoom, this.vZoom);
        }
        if (n2 == 0 || this.zAutoScale && !bl) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(this.NaNColor);
            graphics2D.fillRect(0, 0, n, n3);
        } else {
            if (d2 - d < 1.0E-20) {
                d2 += 1.0;
            }
            if (this.logScale) {
                d = Math.log10(d);
                d2 = Math.log10(d2);
            }
            int n4 = this.NaNColor.getRGB();
            int[] nArray = new int[n];
            if (this.vZoom >= 1 && this.hZoom >= 1) {
                for (int i = 0; i < this.rdimy; ++i) {
                    int n5;
                    for (n5 = 0; n5 < this.rdimx; ++n5) {
                        int n6 = this.rdimx - n5 - 1;
                        if (trendDataArray[n5] == null) {
                            for (int j = 0; j < this.hZoom; ++j) {
                                nArray[this.hZoom * n6 + j] = n4;
                            }
                            continue;
                        }
                        if (i >= trendDataArray[n5].values.length) {
                            for (int j = 0; j < this.hZoom; ++j) {
                                nArray[this.hZoom * n6 + j] = n4;
                            }
                            continue;
                        }
                        if (Double.isNaN(trendDataArray[n5].values[i])) {
                            for (int j = 0; j < this.hZoom; ++j) {
                                nArray[this.hZoom * n6 + j] = n4;
                            }
                            continue;
                        }
                        double d4 = this.logScale ? (Math.log10(trendDataArray[n5].values[i]) - d) / (d2 - d) * 65536.0 : (trendDataArray[n5].values[i] - d) / (d2 - d) * 65536.0;
                        if (d4 < 0.0) {
                            d4 = 0.0;
                        }
                        if (d4 > 65535.0) {
                            d4 = 65535.0;
                        }
                        for (int j = 0; j < this.hZoom; ++j) {
                            nArray[this.hZoom * n6 + j] = this.gColormap[(int)d4];
                        }
                    }
                    for (n5 = 0; n5 < this.vZoom; ++n5) {
                        bufferedImage.setRGB(0, this.vZoom * i + n5, n, 1, nArray, 0, n);
                    }
                }
            } else if (this.vZoom >= 1 && this.hZoom < 0) {
                for (int i = 0; i < this.rdimy; ++i) {
                    int n7;
                    for (n7 = 0; n7 < this.rdimx; n7 += -this.hZoom) {
                        int n8 = (this.rdimx - n7 - 1) / -this.hZoom;
                        if (trendDataArray[n7] == null) {
                            if (n8 >= n) continue;
                            nArray[n8] = n4;
                            continue;
                        }
                        if (i >= trendDataArray[n7].values.length) {
                            if (n8 >= n) continue;
                            nArray[n8] = n4;
                            continue;
                        }
                        if (Double.isNaN(trendDataArray[n7].values[i])) {
                            if (n8 >= n) continue;
                            nArray[n8] = n4;
                            continue;
                        }
                        double d5 = this.logScale ? (Math.log10(trendDataArray[n7].values[i]) - d) / (d2 - d) * 65536.0 : (trendDataArray[n7].values[i] - d) / (d2 - d) * 65536.0;
                        if (d5 < 0.0) {
                            d5 = 0.0;
                        }
                        if (d5 > 65535.0) {
                            d5 = 65535.0;
                        }
                        if (n8 >= n) continue;
                        nArray[n8] = this.gColormap[(int)d5];
                    }
                    for (n7 = 0; n7 < this.vZoom; ++n7) {
                        bufferedImage.setRGB(0, this.vZoom * i + n7, n, 1, nArray, 0, n);
                    }
                }
            } else if (this.vZoom < 0 && this.hZoom >= 1) {
                for (int i = 0; i < this.rdimy; i += -this.vZoom) {
                    for (int j = 0; j < this.rdimx; ++j) {
                        int n9 = this.rdimx - j - 1;
                        if (trendDataArray[j] == null) {
                            for (int k = 0; k < this.hZoom; ++k) {
                                nArray[this.hZoom * n9 + k] = n4;
                            }
                            continue;
                        }
                        if (i >= trendDataArray[j].values.length) {
                            for (int k = 0; k < this.hZoom; ++k) {
                                nArray[this.hZoom * n9 + k] = n4;
                            }
                            continue;
                        }
                        if (Double.isNaN(trendDataArray[j].values[i])) {
                            for (int k = 0; k < this.hZoom; ++k) {
                                nArray[this.hZoom * n9 + k] = n4;
                            }
                            continue;
                        }
                        double d6 = this.logScale ? (Math.log10(trendDataArray[j].values[i]) - d) / (d2 - d) * 65536.0 : (trendDataArray[j].values[i] - d) / (d2 - d) * 65536.0;
                        if (d6 < 0.0) {
                            d6 = 0.0;
                        }
                        if (d6 > 65535.0) {
                            d6 = 65535.0;
                        }
                        for (int k = 0; k < this.hZoom; ++k) {
                            nArray[this.hZoom * n9 + k] = this.gColormap[(int)d6];
                        }
                    }
                    if (i / -this.vZoom >= n3) continue;
                    bufferedImage.setRGB(0, i / -this.vZoom, n, 1, nArray, 0, n);
                }
            } else if (this.vZoom < 0 && this.hZoom < 0) {
                for (int i = 0; i < this.rdimy; i += -this.vZoom) {
                    for (int j = 0; j < this.rdimx; j += -this.hZoom) {
                        int n10 = (this.rdimx - j - 1) / -this.hZoom;
                        if (trendDataArray[j] == null) {
                            if (n10 >= n) continue;
                            nArray[n10] = n4;
                            continue;
                        }
                        if (i >= trendDataArray[j].values.length) {
                            if (n10 >= n) continue;
                            nArray[n10] = n4;
                            continue;
                        }
                        if (Double.isNaN(trendDataArray[j].values[i])) {
                            if (n10 >= n) continue;
                            nArray[n10] = n4;
                            continue;
                        }
                        double d7 = this.logScale ? (Math.log10(trendDataArray[j].values[i]) - d) / (d2 - d) * 65536.0 : (trendDataArray[j].values[i] - d) / (d2 - d) * 65536.0;
                        if (d7 < 0.0) {
                            d7 = 0.0;
                        }
                        if (d7 > 65535.0) {
                            d7 = 65535.0;
                        }
                        if (n10 >= n) continue;
                        nArray[n10] = this.gColormap[(int)d7];
                    }
                    if (i / -this.vZoom >= n3) continue;
                    bufferedImage.setRGB(0, i / -this.vZoom, n, 1, nArray, 0, n);
                }
            }
        }
        this.trend.setImage(bufferedImage, this.rdimx, this.rdimy);
        this.trendView.getViewport().revalidate();
        this.revalidate();
    }

    public void saveDataFile() {
        int n;
        JFileChooser jFileChooser = new JFileChooser(".");
        JCheckBox jCheckBox = new JCheckBox("Transpose data");
        jCheckBox.setFont(ATKConstant.labelFont);
        jCheckBox.setSelected(true);
        jFileChooser.setAccessory(jCheckBox);
        if (this.currentFile != null) {
            jFileChooser.setSelectedFile(this.currentFile);
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 0) {
            this.currentFile = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(this.currentFile);
                fileWriter.write(this.makeTabbedString(jCheckBox.isSelected()));
                fileWriter.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException, "Error while saving data", 0);
            }
        }
    }

    private String buildTime(long l) {
        calendar.setTimeInMillis(l);
        Date date = calendar.getTime();
        return genFormat.format(date);
    }

    private String getStringValueAt(int n, int n2) {
        if (n2 < this.data[n].values.length) {
            double d = this.data[n].values[n2];
            if (this.format.length() > 0) {
                return ATKFormat.format(this.format, d);
            }
            return Double.toString(d);
        }
        return " ";
    }

    protected String makeTabbedString(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.data.length;
        int n3 = 0;
        for (n = 0; n < this.data.length; ++n) {
            if (this.data[n].values.length <= n3) continue;
            n3 = this.data[n].values.length;
        }
        if (bl) {
            for (n = n2 - 1; n >= 0; --n) {
                stringBuffer.append(this.buildTime(this.data[n].time));
                stringBuffer.append("\t");
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(this.getStringValueAt(n, i));
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
        } else {
            for (n = n2 - 1; n >= 0; --n) {
                stringBuffer.append(this.buildTime(this.data[n].time));
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
            for (n = 0; n < n3; ++n) {
                for (int i = n2 - 1; i >= 0; --i) {
                    stringBuffer.append(this.getStringValueAt(i, n));
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            final NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = new NumberSpectrumTrend3DViewer();
            numberSpectrumTrend3DViewer.readPollingHistory(true);
            numberSpectrumTrend3DViewer.setShowDerivative(true);
            numberSpectrumTrend3DViewer.setName("Data test");
            numberSpectrumTrend3DViewer.setUnit("au");
            numberSpectrumTrend3DViewer.setYName("Height");
            numberSpectrumTrend3DViewer.setValueName("Strength");
            numberSpectrumTrend3DViewer.setYUnit("yu");
            numberSpectrumTrend3DViewer.setFormat("%.3f");
            String[] stringArray2 = new String[200];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = new String("I" + i);
            }
            numberSpectrumTrend3DViewer.setYIndexName(stringArray2);
            numberSpectrumTrend3DViewer.setModel((INumberSpectrum)attributeList.add("jlp/test/1/att_spectrum"));
            numberSpectrumTrend3DViewer.setZAutoScale(true);
            numberSpectrumTrend3DViewer.setZMinimum(-0.5);
            numberSpectrumTrend3DViewer.setZMaximum(0.5);
            attributeList.startRefresher();
            JFrame jFrame = new JFrame();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("Test");
            jMenuBar.add(jMenu);
            JMenuItem jMenuItem = new JMenuItem("Clear");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    numberSpectrumTrend3DViewer.clearData();
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem("Remove cursor");
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    numberSpectrumTrend3DViewer.clearStatusLabel();
                }
            });
            JMenuItem jMenuItem3 = new JMenuItem("Cursor coordinates");
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("X = " + numberSpectrumTrend3DViewer.getXCursor());
                    System.out.println("Y = " + numberSpectrumTrend3DViewer.getYCursor());
                }
            });
            JMenuItem jMenuItem4 = new JMenuItem("Scroll to right");
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    numberSpectrumTrend3DViewer.scrollToRight();
                }
            });
            JMenuItem jMenuItem5 = new JMenuItem("Scroll to left");
            jMenuItem5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    numberSpectrumTrend3DViewer.scrollToLeft();
                }
            });
            jMenu.add(jMenuItem);
            jMenu.add(jMenuItem2);
            jMenu.add(jMenuItem3);
            jMenu.add(jMenuItem4);
            jMenu.add(jMenuItem5);
            jFrame.setJMenuBar(jMenuBar);
            jFrame.setContentPane(numberSpectrumTrend3DViewer);
            jFrame.setDefaultCloseOperation(3);
            ATKGraphicsUtils.centerFrameOnScreen(jFrame);
            jFrame.setSize(new Dimension(600, 400));
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

