/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class NumberScalarTextEditor
extends JTextField
implements INumberScalarListener,
PropertyChangeListener {
    String format = "";
    private INumberScalar model = null;
    private String lastSet = null;

    public NumberScalarTextEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberScalarTextEditor.this.textInsertActionPerformed(actionEvent);
            }
        });
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        this.model.removeNumberScalarListener((INumberScalarListener)this);
        this.model = null;
    }

    public void setModel(INumberScalar iNumberScalar) {
        this.clearModel();
        if (iNumberScalar == null) {
            return;
        }
        if (!iNumberScalar.isWritable()) {
            throw new IllegalArgumentException("NumberScalarTextEditor: Only accept writeable attribute.");
        }
        this.model = iNumberScalar;
        this.format = this.model.getProperty("format").getPresentation();
        this.model.addNumberScalarListener((INumberScalarListener)this);
        this.model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
        this.model.refresh();
    }

    public INumberScalar getModel() {
        return this.model;
    }

    private String getDisplayString(double d) {
        String string;
        Double d2 = new Double(d);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            string = Double.toString(d);
        } else {
            try {
                string = this.format.indexOf(37) == -1 ? String.format("%.2f", d) : ATKFormat.format(this.format, d2);
            }
            catch (Exception exception) {
                string = String.format("%.2f", d);
            }
        }
        return string;
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = Double.NaN;
        d = this.hasFocus() ? this.model.getNumberScalarSetPointFromDevice() : this.model.getNumberScalarSetPoint();
        String string = this.getDisplayString(d);
        if (this.lastSet == null) {
            this.setText(string);
            this.lastSet = string;
        } else if (!this.lastSet.equals(string)) {
            this.setText(string);
            this.lastSet = string;
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setText("Read Error");
        this.lastSet = "Read Error";
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.model != null) {
            if (property.getName().equalsIgnoreCase("format")) {
                this.format = property.getValue().toString();
            }
            this.model.refresh();
        }
    }

    private void textInsertActionPerformed(ActionEvent actionEvent) {
        if (this.model == null) {
            return;
        }
        String string = this.getText();
        try {
            double d = Double.parseDouble(string);
            this.model.setValue(d);
        }
        catch (NumberFormatException numberFormatException) {
            this.lastSet = null;
            this.model.refresh();
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        NumberScalarTextEditor numberScalarTextEditor = new NumberScalarTextEditor();
        try {
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("id-carr/TD13/GAP/Position");
            numberScalarTextEditor.setModel(iNumberScalar);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(numberScalarTextEditor);
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.startRefresher();
    }
}

