/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class NumberImageJTableAdapter
extends AbstractTableModel
implements IImageListener {
    Double[] vals = new Double[256];
    double[][] value;
    JTable table;
    INumberImage model;

    public NumberImageJTableAdapter() {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = new Double(i);
        }
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getYDimension();
    }

    @Override
    public int getColumnCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getXDimension();
    }

    public void imageChange(NumberImageEvent numberImageEvent) {
        double[][] dArray = numberImageEvent.getValue();
        if (dArray == null) {
            dArray = new double[0][0];
        }
        boolean bl = false;
        if (this.value == null) {
            bl = true;
        } else if (this.value.length != dArray.length) {
            bl = true;
        } else if (this.value.length > 0 && this.value[0].length != dArray[0].length) {
            bl = true;
        }
        this.value = dArray;
        if (bl) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableRowsUpdated(0, this.value.length);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        double d = -1.0;
        try {
            d = this.value[n][n2];
            if (Math.rint(d) == d && d > -1.0 && d < 256.0) {
                return this.vals[(int)d];
            }
            return new Double(d);
        }
        catch (Exception exception) {
            System.out.println("Caught exception at (" + n + ", " + n2 + ") value = " + d);
            return new Double(Double.NaN);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void setModel(INumberImage iNumberImage) {
        if (this.model != null) {
            this.model.removeImageListener((IImageListener)this);
        }
        this.model = iNumberImage;
        this.model.addImageListener((IImageListener)this);
        this.fireTableStructureChanged();
    }

    public INumberImage getModel() {
        return this.model;
    }

    public void setJTable(JTable jTable) {
        this.setViewer(jTable);
    }

    public JTable getJTable() {
        return this.getViewer();
    }

    public void setViewer(JTable jTable) {
        this.table = jTable;
        jTable.setModel(this);
    }

    public JTable getViewer() {
        return this.table;
    }

    public static void main(String[] stringArray) throws Exception {
        AttributeList attributeList = new AttributeList();
        NumberImageJTableAdapter numberImageJTableAdapter = new NumberImageJTableAdapter();
        JTable jTable = new JTable();
        numberImageJTableAdapter.setViewer(jTable);
        numberImageJTableAdapter.setModel((INumberImage)attributeList.add("fe/imacq/2/Image"));
        attributeList.startRefresher();
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(jTable);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

