/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoConfiguration
extends JDialog {
    private Component parent;
    private List<String> families;
    private int retVal = 2;
    private JTextArea copyrightText;
    private JList<String> familyList;
    private JTextField siteLabel;
    private JLabel titleLabel;

    public PogoConfiguration(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.titleLabel.setToolTipText(Utils.buildToolTip("Class Families", "If you use your own repository with specific class families\nAdd your  institute name on right fields\n&nbsp; &nbsp; and the specific family names below.\nIt will ne used for Class Identification Window."));
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel rightPanel = new JPanel();
        JButton addBtn = new JButton();
        JButton removeBtn = new JButton();
        JScrollPane familyScrollPane = new JScrollPane();
        this.familyList = new JList();
        JPanel topTopPanel = new JPanel();
        JLabel copyrightLabel = new JLabel();
        JScrollPane copyrightScrollPane = new JScrollPane();
        this.copyrightText = new JTextArea();
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.siteLabel = new JTextField();
        JLabel jLabel1 = new JLabel();
        JButton helpBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PogoConfiguration.this.closeDialog(evt);
            }
        });
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        rightPanel.setLayout(new GridBagLayout());
        addBtn.setText("Add");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.addBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(60, 0, 5, 0);
        rightPanel.add((Component)addBtn, gridBagConstraints);
        removeBtn.setText("Remove");
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.removeBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        rightPanel.add((Component)removeBtn, gridBagConstraints);
        this.getContentPane().add((Component)rightPanel, "After");
        familyScrollPane.setPreferredSize(new Dimension(300, 360));
        familyScrollPane.setViewportView(this.familyList);
        this.getContentPane().add((Component)familyScrollPane, "Center");
        topTopPanel.setLayout(new BorderLayout());
        copyrightLabel.setText("Copyright:");
        topTopPanel.add((Component)copyrightLabel, "North");
        copyrightScrollPane.setPreferredSize(new Dimension(400, 100));
        this.copyrightText.setColumns(40);
        this.copyrightText.setFont(new Font("Monospaced", 1, 12));
        this.copyrightText.setRows(5);
        copyrightScrollPane.setViewportView(this.copyrightText);
        topTopPanel.add((Component)copyrightScrollPane, "Center");
        this.titleLabel.setFont(new Font("Dialog", 1, 14));
        this.titleLabel.setText("Specific Class Family Names for  ");
        topPanel.add(this.titleLabel);
        this.siteLabel.setColumns(10);
        this.siteLabel.setFont(new Font("Dialog", 1, 14));
        topPanel.add(this.siteLabel);
        jLabel1.setText("        ");
        topPanel.add(jLabel1);
        helpBtn.setText("?");
        helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PogoConfiguration.this.helpBtnActionPerformed(evt);
            }
        });
        topPanel.add(helpBtn);
        topTopPanel.add((Component)topPanel, "South");
        this.getContentPane().add((Component)topTopPanel, "North");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            PogoProperty.siteName = this.siteLabel.getText();
            PogoProperty.copyright = this.copyrightText.getText();
            if (PogoProperty.getInstance().updateSitePropertyFile(this)) {
                this.retVal = 0;
                this.doClose();
            }
        }
        catch (Exception e) {
            PogoException.popup((Component)this, e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String new_family = "";
        boolean ok = false;
        while (!ok) {
            if ((new_family = (String)JOptionPane.showInputDialog(this, "Family Name ", "Input Dialog", 1, null, null, new_family)) == null || new_family.length() == 0) {
                return;
            }
            boolean found = false;
            for (String family : this.families) {
                if (!family.equalsIgnoreCase(new_family)) continue;
                found = true;
            }
            if (found) {
                Utils.popupError(this, new_family + " family  already exists");
                continue;
            }
            ok = true;
        }
        this.families.add(new_family);
        MyCompare compare = new MyCompare();
        Collections.sort(this.families, compare);
        this.setFamilyList();
    }

    private void setFamilyList() {
        this.familyList.setListData((String[])this.families.toArray(new String[this.families.size()]));
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        List<String> selections = this.familyList.getSelectedValuesList();
        if (selections.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Nothing selected to be removed !", "Error Window", 0);
        } else {
            Iterator<String> i$ = selections.iterator();
            block0: while (i$.hasNext()) {
                String selection;
                String name = selection = i$.next();
                for (String family : this.families) {
                    if (!family.equals(name)) continue;
                    this.families.remove(family);
                    continue block0;
                }
            }
            this.setFamilyList();
        }
    }

    private void helpBtnActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "If you use your own repository with specific class families,\nenter your site name and use the list to add or remove your \nspecific families.", "Help Window", 1);
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void displayProperties() throws PogoException {
        this.siteLabel.setText(PogoProperty.siteName);
        this.copyrightText.setText(PogoProperty.copyright);
        this.families = PogoProperty.siteClassFamilies;
        this.setFamilyList();
        this.pack();
    }

    public int showDialog() {
        try {
            this.displayProperties();
            this.setVisible(true);
        }
        catch (Exception e) {
            PogoException.popup((Component)new JFrame(), e);
        }
        return this.retVal;
    }

    public static void main(String[] args) {
        try {
            PogoProperty.init();
            new PogoConfiguration(null).showDialog();
        }
        catch (Exception e) {
            PogoException.popup((Component)new JFrame(), e);
            System.exit(0);
        }
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                String s1 = o1.toString().toLowerCase();
                String s2 = o2.toString().toLowerCase();
                if (s1.equals("miscellaneous")) {
                    return 0;
                }
                if (s2.equals("miscellaneous")) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

