/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.packaging;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.packaging.PackUtils;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class Packaging {
    private List<PackClass> packClassList = new ArrayList<PackClass>();
    private List<String> addedClasses = new ArrayList<String>();
    private String packageName;
    private String packageAuthor;
    private String packagePath;
    private String packageVersion;
    private boolean multipleClasses = false;
    private PackFile[] packFiles = new PackFile[]{new PackFile("README", true, true), new PackFile("COPYING", false, false), new PackFile("NEWS", false, false), new PackFile("INSTALL", false, false), new PackFile("AUTHORS", true, false), new PackFile("ChangeLog", false, false), new PackFile("autogen.sh", true, true), new PackFile("configure.ac", true, true), new PackFile("Makefile.am", true, true), new PackFile("src/Makefile.am", true, true), new PackFile("m4/gcc_release.m4", false, false)};
    private static final String[] directories = new String[]{"", "src", "build", "m4"};
    private static final boolean NO_MODIF = false;
    private static final boolean MODIFY = true;
    private static final boolean NO_UPDATE = false;
    private static final boolean UPDATE = true;
    static final String PackageDir = "/packaging/";

    public Packaging(PogoDeviceClass deviceClass, String packageVersion, String author) throws PogoException {
        this.packageVersion = packageVersion;
        String className = deviceClass.getName();
        String path = deviceClass.getDescription().getSourcePath();
        this.initialize(className, path, author);
        PackClass _class = new PackClass(className, path);
        _class.addAdditionalFiles(deviceClass.getAdditionalFiles());
        this.packClassList.add(_class);
        this.manageInheritances(deviceClass.getDescription().getInheritances());
    }

    public Packaging(PogoMultiClasses deviceClasses, String packageVersion, String author) throws PogoException {
        this.packageVersion = packageVersion;
        String className = deviceClasses.getName();
        String path = deviceClasses.getSourcePath();
        this.initialize(className, path, author);
        EList<OneClassSimpleDef> simpleDefList = deviceClasses.getClasses();
        for (OneClassSimpleDef _class : simpleDefList) {
            PackClass packClass = new PackClass(_class.getClassname(), _class.getSourcePath());
            packClass.addAdditionalFiles(_class.getAdditionalFiles());
            this.packClassList.add(packClass);
            this.manageInheritances(_class.getInheritances());
        }
        this.multipleClasses = true;
    }

    private void manageInheritances(List<Inheritance> inheritances) throws PogoException {
        for (Inheritance inheritance : inheritances) {
            String name = inheritance.getClassname();
            if (name.startsWith("Device") && name.endsWith("Impl")) continue;
            this.packClassList.add(new PackClass(name, inheritance.getSourcePath()));
        }
    }

    private void initialize(String name, String path, String author) throws PogoException {
        this.packageName = name;
        this.packagePath = path + "/packaging";
        this.packageAuthor = author;
        if (!Packaging.isAvailable()) {
            throw new PogoException("Property 'PACKAGING_HOME' not set");
        }
        for (PackFile packFile : this.packFiles) {
            if (!PackUtils.getInstance().fileExistsInPackage(PackageDir + packFile.name)) continue;
            throw new PogoException("Template file '" + packFile.name + "' not found");
        }
    }

    private void copyTemplates() throws PogoException {
        for (PackFile packFile : this.packFiles) {
            String targetFile = this.packagePath + "/" + packFile.name;
            packFile.alreadyExists = new File(targetFile).exists();
            if (!packFile.update && packFile.alreadyExists) continue;
            String code = PackUtils.getInstance().readFileFromPackage(PackageDir + packFile.name);
            ParserTool.writeFile(targetFile, code);
            if (!packFile.name.endsWith(".sh") || new File(targetFile).setExecutable(true)) continue;
            System.err.println("Cannot set executable " + targetFile);
        }
    }

    private String addSourceReferences(String code) {
        String nextLine = PackUtils.buildNextLine(this.packageName + "_SOURCES = ");
        StringBuilder sb = new StringBuilder();
        for (PackClass packClass : this.packClassList) {
            if (this.addedClasses.indexOf(packClass.name) < 0) {
                for (String file : packClass.headers) {
                    sb.append(file).append(nextLine);
                }
                List files = packClass.sources;
                for (String file : files) {
                    sb.append(file).append(nextLine);
                }
                this.addedClasses.add(packClass.name);
                continue;
            }
            PackUtils.println(packClass.name + " has already been added!");
        }
        String factory = this.multipleClasses ? "MultiClassesFactory.cpp" : "ClassFactory.cpp";
        sb.append(factory).append(nextLine);
        sb.append("main.cpp");
        code = code.replaceAll("TEMPLATE_SOURCES", sb.toString());
        return code;
    }

    private void updateTemplate(String fileName) throws PogoException {
        String code = ParserTool.readFile(fileName);
        if (fileName.endsWith("src/Makefile.am")) {
            code = this.addSourceReferences(code);
        }
        code = code.replaceAll("TEMPLATE_AUTHOR", this.packageAuthor);
        code = code.replaceAll("TEMPLATE_VERSION", this.packageVersion);
        code = code.replaceAll("TEMPLATE_CLASS", this.packageName);
        ParserTool.writeFile(fileName, code);
    }

    private void updateConfig(String fileName, List<String> headers, List<String> functions) throws PogoException {
        String code = ParserTool.readFile(fileName);
        code = code.replaceAll("TEMPLATE_CHECK_HEADERS", PackUtils.buildConfigureList(headers));
        code = code.replaceAll("TEMPLATE_CHECK_FUNCS", PackUtils.buildConfigureList(functions));
        ParserTool.writeFile(fileName, code);
    }

    private void createSourceLinks(String path, String fileName, String srcPath) throws PogoException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(fileName);
        this.createSourceLinks(path, list, srcPath);
    }

    private void createSourceLinks(String path, List<String> fileNames, String srcPath) throws PogoException {
        try {
            String scriptName = path + "/create_links";
            String code = "#!/bin/sh\n\n";
            code = code + "cd  " + path + "\n\n";
            for (String fileName : fileNames) {
                code = code + "rm -f  " + fileName + "\n";
                code = code + "ln -s  " + srcPath + "/" + fileName + "   " + fileName + "\n\n";
            }
            ParserTool.writeFile(scriptName, code);
            File script = new File(scriptName);
            if (script.setExecutable(true)) {
                PackUtils.println("execute " + scriptName);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                PackUtils.executeShellCommand(scriptName);
            }
            script.delete();
        }
        catch (Exception e) {
            throw new PogoException("Cannot create link: " + e);
        }
    }

    public void generate(List<String> headers, List<String> functions) throws PogoException {
        PackUtils.buildDirectories(directories, this.packagePath);
        this.copyTemplates();
        for (PackFile packFile : this.packFiles) {
            if (!packFile.doUpdates()) continue;
            this.updateTemplate(this.packagePath + "/" + packFile.name);
            if (!packFile.name.endsWith("configure.ac")) continue;
            this.updateConfig(this.packagePath + "/" + packFile.name, headers, functions);
        }
        if (this.multipleClasses) {
            for (PackClass _class : this.packClassList) {
                this.createSourceLinks(this.packagePath + "/src", _class.headers, _class.path);
                this.createSourceLinks(this.packagePath + "/src", _class.getSources(), _class.path);
                _class.manageSerialSpecialCase();
            }
            this.createSourceLinks(this.packagePath + "/src", "MultiClassesFactory.cpp", "../..");
        } else {
            int cnt = 0;
            for (PackClass _class : this.packClassList) {
                String srcPath = cnt++ == 0 ? "../.." : _class.path;
                this.createSourceLinks(this.packagePath + "/src", _class.headers, srcPath);
                this.createSourceLinks(this.packagePath + "/src", _class.getSources(), srcPath);
                _class.manageSerialSpecialCase();
            }
            this.createSourceLinks(this.packagePath + "/src", "ClassFactory.cpp", "../..");
        }
        this.createSourceLinks(this.packagePath + "/src", "main.cpp", "../..");
        PackUtils.println("Packaging for " + this.packageName + " has been created in:\n" + this.packagePath);
    }

    public static boolean isAvailable() {
        return PackUtils.isAvailable();
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private class PackClass {
        private String name;
        private String path;
        private List<String> headers;
        private List<String> sources = new ArrayList<String>();
        private final String[] badSerialFiles = new String[]{"SerialLinux.cpp", "SerialWin32.cpp"};

        private PackClass(String name, String path) throws PogoException {
            this.name = name;
            this.path = path;
            this.headers = PackUtils.getFileList(path, ".h");
            this.sources.add(name + ".cpp");
            this.sources.add(name + "Class.cpp");
            this.sources.add(name + "StateMachine.cpp");
            String dynAttrFile = name + "DynAttrUtils.cpp";
            if (new File(path + "/" + dynAttrFile).exists()) {
                this.sources.add(dynAttrFile);
            }
        }

        private void addAdditionalFiles(List<AdditionalFile> additionalFiles) {
            if (additionalFiles != null) {
                for (AdditionalFile file : additionalFiles) {
                    this.sources.add(file.getName() + ".cpp");
                }
            }
        }

        private void manageSerialSpecialCase() {
            if (this.name.equals("Serial")) {
                try {
                    String code = ParserTool.readFile(Packaging.this.packagePath + "/Makefile.am");
                    String key = "EXTRA_DIST = ";
                    String badFiles = "";
                    for (String badFile : this.badSerialFiles) {
                        badFiles = badFiles + " src/" + badFile + " ";
                    }
                    int pos = code.indexOf(key);
                    if (pos > 0) {
                        code = code.substring(0, pos += key.length()) + badFiles + code.substring(pos);
                        ParserTool.writeFile(Packaging.this.packagePath + "/Makefile.am", code);
                    }
                }
                catch (PogoException e) {
                    System.err.println(e.toString());
                }
            }
        }

        private List<String> getSources() {
            ArrayList<String> list = new ArrayList<String>();
            for (String file : this.sources) {
                if (file.equals("main.cpp") || file.equals("ClassFactory.cpp")) continue;
                list.add(file);
            }
            if (this.name.equals("Serial")) {
                Collections.addAll(list, this.badSerialFiles);
            }
            return list;
        }
    }

    private class PackFile {
        String name;
        boolean modify;
        boolean update = false;
        boolean alreadyExists = false;

        private PackFile(String name, boolean modify, boolean update) {
            this.name = name;
            this.modify = modify;
            this.update = update;
        }

        private boolean doUpdates() {
            return this.modify && !this.alreadyExists || this.update;
        }
    }
}

