/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xtext.XtextRuleInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidEntryRuleInspector
extends XtextRuleInspector<Pair<Boolean, Boolean>, ParserRule> {
    public ValidEntryRuleInspector(ValidationMessageAcceptor acceptor) {
        super(acceptor);
    }

    @Override
    protected boolean canInspect(ParserRule rule) {
        if (GrammarUtil.getGrammar(rule).getRules().get(0) != rule) {
            return false;
        }
        if (GrammarUtil.isDatatypeRule(rule) || rule.getAlternatives() == null) {
            return false;
        }
        return super.canInspect(rule);
    }

    @Override
    protected void handleResult(Pair<Boolean, Boolean> r, ParserRule rule) {
        if (!r.getFirst().booleanValue()) {
            this.acceptWarning("The entry rule '" + rule.getName() + "' may consume non empty input without object instantiation. " + "Add an action to ensure object creation, e.g. '{" + this.getTypeRefName(rule.getType()) + "}'.", rule, XtextPackage.Literals.ABSTRACT_RULE__NAME);
        }
    }

    @Override
    public Pair<Boolean, Boolean> caseCompoundElement(CompoundElement object) {
        boolean valid = true;
        boolean instantiated = false;
        for (AbstractElement element : object.getElements()) {
            Pair elementResult = (Pair)this.doSwitch(element);
            if (instantiated |= ((Boolean)elementResult.getSecond()).booleanValue()) continue;
            valid &= ((Boolean)elementResult.getFirst()).booleanValue();
        }
        valid |= instantiated;
        return Tuples.create(valid, instantiated &= !GrammarUtil.isOptionalCardinality(object));
    }

    @Override
    public Pair<Boolean, Boolean> caseAbstractElement(AbstractElement object) {
        return Tuples.create(false, false);
    }

    @Override
    public Pair<Boolean, Boolean> caseAction(Action object) {
        return Tuples.create(true, true);
    }

    @Override
    public Pair<Boolean, Boolean> caseAlternatives(Alternatives object) {
        boolean valid = true;
        boolean instantiated = !GrammarUtil.isOptionalCardinality(object);
        for (AbstractElement element : object.getElements()) {
            Pair elementResult = (Pair)this.doSwitch(element);
            valid &= ((Boolean)elementResult.getFirst()).booleanValue();
            instantiated &= ((Boolean)elementResult.getSecond()).booleanValue();
        }
        return Tuples.create(valid, instantiated);
    }

    @Override
    public Pair<Boolean, Boolean> caseAssignment(Assignment object) {
        return Tuples.create(true, !GrammarUtil.isOptionalCardinality(object));
    }

    @Override
    public Pair<Boolean, Boolean> caseRuleCall(RuleCall object) {
        boolean instantiated = !GrammarUtil.isOptionalCardinality(object) && (object.getRule() == null || object.getRule() instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)object.getRule()));
        return Tuples.create(instantiated, instantiated);
    }
}

