/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IShadowedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.util.Strings;

public class IndexedJvmTypeAccess {
    private static final Logger logger = Logger.getLogger(IndexedJvmTypeAccess.class);
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private CompilerPhases compilerPhases;

    public boolean isIndexingPhase(Notifier notifier) {
        return this.compilerPhases.isIndexing(notifier);
    }

    public EObject getIndexedJvmType(URI javaObjectURI, ResourceSet resourceSet) {
        return this.getIndexedJvmType(javaObjectURI, resourceSet, false);
    }

    public EObject getIndexedJvmType(URI javaObjectURI, ResourceSet resourceSet, boolean throwShadowedException) {
        if (resourceSet != null) {
            EObject result;
            Map<URI, Resource> resourceMap;
            URI withoutFragment = javaObjectURI.trimFragment();
            if (resourceSet instanceof ResourceSetImpl && (resourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap()) != null && resourceMap.containsKey(withoutFragment) && (result = resourceSet.getEObject(javaObjectURI, true)) != null) {
                return result;
            }
            String fqn = withoutFragment.segment(withoutFragment.segmentCount() - 1);
            List<String> fqnSegments = Strings.split(fqn, '.');
            QualifiedName qualifiedName = QualifiedName.create(fqnSegments);
            return this.getIndexedJvmType(qualifiedName, javaObjectURI.fragment(), resourceSet, throwShadowedException);
        }
        return null;
    }

    public EObject getIndexedJvmType(QualifiedName qualifiedName, String fragment, ResourceSet resourceSet) {
        return this.getIndexedJvmType(qualifiedName, fragment, resourceSet, false);
    }

    public EObject getIndexedJvmType(QualifiedName qualifiedName, String fragment, ResourceSet resourceSet, boolean throwShadowedException) {
        if (resourceSet != null) {
            IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
            Iterable<IEObjectDescription> candidates = descriptions.getExportedObjects(TypesPackage.Literals.JVM_TYPE, qualifiedName, false);
            Iterator<IEObjectDescription> iterator = candidates.iterator();
            if (iterator.hasNext()) {
                IEObjectDescription description = iterator.next();
                EObject typeProxy = description.getEObjectOrProxy();
                if (typeProxy.eIsProxy()) {
                    typeProxy = EcoreUtil.resolve(typeProxy, resourceSet);
                }
                if (!typeProxy.eIsProxy() && typeProxy instanceof JvmType) {
                    if (fragment != null) {
                        EObject result = this.resolveJavaObject((JvmType)typeProxy, fragment);
                        if (result != null) {
                            return result;
                        }
                    } else {
                        return typeProxy;
                    }
                }
            }
            if (throwShadowedException && descriptions instanceof IShadowedResourceDescriptions && ((IShadowedResourceDescriptions)((Object)descriptions)).isShadowed(TypesPackage.Literals.JVM_TYPE, qualifiedName, false)) {
                throw new ShadowedTypeException("The type '" + qualifiedName + "' is locally shadowed.");
            }
        }
        return null;
    }

    public EObject resolveJavaObject(JvmType rootType, String fragment) {
        block12: {
            int dot;
            int dollar;
            int max;
            block11: {
                if (fragment.endsWith("[]")) {
                    return this.resolveJavaArrayObject(rootType, fragment);
                }
                int slash = fragment.indexOf(47);
                if (slash == -1) break block11;
                if (slash == 0) {
                    return null;
                }
                String containerFragment = fragment.substring(0, slash);
                EObject container = this.resolveJavaObject(rootType, containerFragment);
                if (container == null) break block12;
                String parameterName = fragment.substring(slash + 1);
                if (container instanceof JvmTypeParameterDeclarator) {
                    JvmTypeParameterDeclarator executable = (JvmTypeParameterDeclarator)container;
                    for (JvmTypeParameter parameter : executable.getTypeParameters()) {
                        if (!parameter.getName().equals(parameterName)) continue;
                        return parameter;
                    }
                }
                break block12;
            }
            if (rootType.getIdentifier().equals(fragment)) {
                return rootType;
            }
            if (rootType.getIdentifier().length() >= fragment.length()) {
                return null;
            }
            int paren = fragment.indexOf(40);
            if (paren == -1) {
                paren = fragment.length();
            }
            if ((max = Math.max(dollar = fragment.lastIndexOf(36, paren), dot = fragment.lastIndexOf(46, paren))) == -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Couldn't resolve java object for root type " + rootType.getQualifiedName() + " and fragment '" + fragment + "'");
                }
                return null;
            }
            String subFragment = fragment.substring(0, max);
            EObject container = this.resolveJavaObject(rootType, subFragment);
            if (container instanceof JvmDeclaredType) {
                EList<JvmMember> members = ((JvmDeclaredType)container).getMembers();
                for (JvmMember member : members) {
                    String name;
                    if (!(member instanceof JvmType) || !(name = member.getIdentifier()).equals(fragment)) continue;
                    return member;
                }
            }
        }
        return null;
    }

    public EObject resolveJavaArrayObject(JvmType rootType, String fragment) {
        JvmComponentType component = (JvmComponentType)this.resolveJavaObject(rootType, fragment.substring(0, fragment.length() - 2));
        if (component == null) {
            return null;
        }
        return component.getArrayType();
    }

    public static class ShadowedTypeException
    extends RuntimeException {
        public ShadowedTypeException() {
        }

        public ShadowedTypeException(String message) {
            super(message);
        }
    }
}

