/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

public class BinaryClass {
    private final String name;
    private final ClassLoader classLoader;
    private static final int DEFAULT_READING_SIZE = 8192;

    public BinaryClass(String binaryName, ClassLoader classLoader) {
        this.name = binaryName;
        this.classLoader = classLoader;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getOutermostClassName() {
        int lastDot = this.name.lastIndexOf(46);
        return this.getOutermostClassName(lastDot + 1);
    }

    private String getOutermostClassName(int offset) {
        if (offset > this.name.length()) {
            return this.name;
        }
        int dollar = this.name.indexOf(36, offset);
        while (dollar != -1) {
            String outerName = this.name.substring(0, dollar);
            if (this.classLoader.getResource(BinaryClass.toClassFile(outerName)) != null) {
                return outerName;
            }
            dollar = this.name.indexOf(36, dollar + 1);
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        InputStream stream = null;
        try {
            stream = this.classLoader.getResourceAsStream(BinaryClass.toClassFile(this.name));
            byte[] byArray = this.getInputStreamAsByteArray(stream, -1);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read bytes for " + e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public int getArrayDimensions() {
        return -1;
    }

    public BinaryClass getRootComponentType() {
        return null;
    }

    public String toString() {
        return this.name;
    }

    public URI getResourceURI() {
        return URIHelperConstants.OBJECTS_URI.appendSegment(this.getOutermostClassName());
    }

    public String getURIFragment() {
        return this.getName();
    }

    public static BinaryClass forName(String clazzName, ClassLoader classLoader) throws ClassNotFoundException {
        URL url;
        int i = 0;
        while (clazzName.charAt(i) == '[') {
            ++i;
        }
        if (i != 0) {
            switch (clazzName.charAt(i)) {
                case 'B': {
                    return new Array(new Primitive(Byte.TYPE), i, clazzName);
                }
                case 'C': {
                    return new Array(new Primitive(Character.TYPE), i, clazzName);
                }
                case 'D': {
                    return new Array(new Primitive(Double.TYPE), i, clazzName);
                }
                case 'F': {
                    return new Array(new Primitive(Float.TYPE), i, clazzName);
                }
                case 'I': {
                    return new Array(new Primitive(Integer.TYPE), i, clazzName);
                }
                case 'J': {
                    return new Array(new Primitive(Long.TYPE), i, clazzName);
                }
                case 'S': {
                    return new Array(new Primitive(Short.TYPE), i, clazzName);
                }
                case 'Z': {
                    return new Array(new Primitive(Boolean.TYPE), i, clazzName);
                }
                case 'L': {
                    String actualName = clazzName.substring(i + 1, clazzName.length() - 1);
                    return new Array(BinaryClass.forName(actualName, classLoader), i, clazzName);
                }
            }
        }
        if ((url = classLoader.getResource(BinaryClass.toClassFile(clazzName))) != null) {
            return new BinaryClass(clazzName, classLoader);
        }
        throw new ClassNotFoundException(clazzName){

            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    protected static String toClassFile(String name) {
        return String.valueOf(name.replace('.', '/')) + ".class";
    }

    public static class Array
    extends BinaryClass {
        private final int dimensions;
        private final BinaryClass componentType;

        public Array(BinaryClass componentType, int dimensions, String binaryName) {
            super(binaryName, null);
            this.componentType = componentType;
            this.dimensions = dimensions;
        }

        public boolean isArray() {
            return true;
        }

        public int getArrayDimensions() {
            return this.dimensions;
        }

        public BinaryClass getRootComponentType() {
            return this.componentType;
        }

        public URI getResourceURI() {
            return this.getRootComponentType().getResourceURI();
        }

        public String getURIFragment() {
            return String.valueOf(this.getRootComponentType().getURIFragment()) + Strings.repeat("[]", this.getArrayDimensions());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Primitive
    extends BinaryClass {
        public Primitive(Class<?> type) {
            super(type.getName(), null);
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public URI getResourceURI() {
            return URIHelperConstants.PRIMITIVES_URI;
        }
    }
}

