/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;

public class BufferedBinaryResourceFactory
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        BinaryResourceImpl binaryResource = new BinaryResourceImpl(uri){

            @Override
            protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 65536);
                try {
                    super.doSave(bufferedOutputStream, options);
                }
                finally {
                    bufferedOutputStream.close();
                }
            }

            @Override
            protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 65536);
                try {
                    BinaryResourceImpl.EObjectInputStream eObjectInputStream = new BinaryResourceImpl.EObjectInputStream(bufferedInputStream, options){

                        public String readString() throws IOException {
                            int length = this.readCompressedInt();
                            if (length == -1) {
                                return null;
                            }
                            if (this.characters == null || this.characters.length < length) {
                                this.characters = new char[length];
                            }
                            int i = 0;
                            while (i < length) {
                                byte value = this.readByte();
                                if (value == 0) {
                                    do {
                                        this.characters[i] = this.readChar();
                                    } while (++i < length);
                                    break;
                                }
                                this.characters[i] = (char)(value & 0xFF);
                                ++i;
                            }
                            return new String(this.characters, 0, length);
                        }
                    };
                    eObjectInputStream.loadResource(this);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
            }
        };
        return binaryResource;
    }
}

