/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import com.ibm.icu.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.ui.internal.themes.Theme;

public class ThemeElementDefinition {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(Theme.class.getName());
    private String id;
    private String label;
    private String description;
    private String formattedDescription;
    private String categoryId;
    private int state = 0;
    private int stateDuringFormattingMessage;

    public ThemeElementDefinition(String id, String label, String description, String categoryId) {
        this.id = id;
        this.label = label;
        this.description = description;
        this.categoryId = categoryId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.label;
    }

    public void setName(String label) {
        this.label = label;
        this.appendState(1);
    }

    public String getDescription() {
        if (this.formattedDescription == null || this.stateDuringFormattingMessage != this.state) {
            this.formattedDescription = this.formatDescription();
            this.stateDuringFormattingMessage = this.state;
        }
        return this.formattedDescription;
    }

    private String formatDescription() {
        String modifiedByUserLabel;
        String description = this.description != null ? this.description : this.label;
        String string = modifiedByUserLabel = this.isModifiedByUser() ? RESOURCE_BUNDLE.getString("Modified.by.user.label") : "";
        if (this.isAddedByCss()) {
            return RESOURCE_BUNDLE.getString("Added.by.css.desc").trim();
        }
        if (this.isOverridden()) {
            return MessageFormat.format(RESOURCE_BUNDLE.getString("Overridden.by.css.label"), description, modifiedByUserLabel).trim();
        }
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.formattedDescription = null;
        this.appendState(1);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        this.appendState(1);
    }

    public int getState() {
        return this.state;
    }

    public void appendState(int state) {
        this.state |= state;
    }

    public void removeState(int state) {
        this.state &= ~state;
    }

    public boolean isOverridden() {
        return (this.state & 1) != 0;
    }

    public boolean isAddedByCss() {
        return (this.state & 2) != 0;
    }

    public boolean isModifiedByUser() {
        return (this.state & 4) != 0;
    }

    public void resetToDefaultValue() {
        this.state = 0;
    }

    public static interface State {
        public static final int UNKNOWN = 0;
        public static final int OVERRIDDEN = 1;
        public static final int ADDED_BY_CSS = 2;
        public static final int MODIFIED_BY_USER = 4;
    }
}

