/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.factory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.mwe2.language.factory.ISetting;
import org.eclipse.emf.mwe2.language.factory.ISettingProvider;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.BooleanLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.PlainString;
import org.eclipse.emf.mwe2.language.mwe2.PropertyReference;
import org.eclipse.emf.mwe2.language.mwe2.Reference;
import org.eclipse.emf.mwe2.language.mwe2.StringLiteral;
import org.eclipse.emf.mwe2.language.mwe2.StringPart;
import org.eclipse.emf.mwe2.language.scoping.FactorySupport;
import org.eclipse.emf.mwe2.runtime.IFactory;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.JavaReflectAccess;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.PolymorphicDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mwe2ExecutionEngine {
    private PolymorphicDispatcher<Object> dispatcher = PolymorphicDispatcher.createForSingleTarget("inCase", 2, 2, this);
    @Inject
    private FactorySupport factorySupport;
    @Inject
    private JavaReflectAccess reflectAccess;
    @Inject
    private ISettingProvider settingProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public Object execute(Module m) {
        return this.create(m, Maps.<QualifiedName, Object>newHashMap());
    }

    public Object create(Module m, Map<QualifiedName, Object> params) {
        return this.internalSwitch(m, Maps.newHashMap(params));
    }

    protected Object internalSwitch(Object o, Map<QualifiedName, Object> variables) {
        return this.dispatcher.invoke(o, variables);
    }

    protected Object inCase(Module m, Map<QualifiedName, Object> variables) {
        for (DeclaredProperty prop : m.getDeclaredProperties()) {
            QualifiedName propertyQualifiedName = this.qualifiedNameConverter.toQualifiedName(prop.getName());
            if (prop.getDefault() == null && !variables.containsKey(propertyQualifiedName)) {
                throw new IllegalArgumentException("Cannot execute module '" + m.getCanonicalName() + "'.The mandatory parameter '" + prop.getName() + "' has not been passed.");
            }
            this.internalSwitch(prop, variables);
        }
        return this.internalSwitch(m.getRoot(), variables);
    }

    protected Object inCase(DeclaredProperty prop, Map<QualifiedName, Object> variables) {
        QualifiedName propertyQualifiedName = this.qualifiedNameConverter.toQualifiedName(prop.getName());
        if (prop.getDefault() != null && !variables.containsKey(propertyQualifiedName)) {
            variables.put(propertyQualifiedName, this.internalSwitch(prop.getDefault(), variables));
        }
        return null;
    }

    protected Object inCase(Component comp, Map<QualifiedName, Object> variables) {
        ArrayList<Assignment> assignments = Lists.newArrayList(comp.getAssignment());
        if (comp.getModule() != null) {
            HashMap<QualifiedName, Object> params = comp.isAutoInject() ? Maps.newHashMap(variables) : Maps.newHashMap();
            for (Assignment ass : assignments) {
                params.put(this.qualifiedNameConverter.toQualifiedName(((DeclaredProperty)ass.getFeature()).getName()), this.internalSwitch(ass.getValue(), variables));
            }
            return this.internalSwitch(comp.getModule(), params);
        }
        JvmType actualType = comp.getActualType();
        Object object = this.create(actualType);
        JvmType factoryType = this.factorySupport.findFactoriesCreationType(actualType);
        if (factoryType != null) {
            this.internalApplyAssignments(object, actualType, comp.isAutoInject(), assignments, variables);
            object = ((IFactory)object).create();
            actualType = factoryType;
        }
        if (comp.getName() != null) {
            variables.put(this.qualifiedNameConverter.toQualifiedName(comp.getName()), object);
        }
        this.internalApplyAssignments(object, actualType, comp.isAutoInject(), assignments, variables);
        return object;
    }

    protected void internalApplyAssignments(Object object, JvmType type, boolean isAutoInject, List<Assignment> assignments, Map<QualifiedName, Object> variables) {
        Map<QualifiedName, ISetting> settings = this.settingProvider.getSettings(object, type);
        if (isAutoInject) {
            HashSet<QualifiedName> explicitAssigned = Sets.newHashSet();
            for (Assignment assignment : assignments) {
                explicitAssigned.add(this.qualifiedNameConverter.toQualifiedName(assignment.getFeatureName()));
            }
            for (ISetting setting : settings.values()) {
                QualifiedName name = setting.getName();
                if (!variables.containsKey(name) || explicitAssigned.contains(name)) continue;
                setting.setValue(variables.get(name));
            }
        }
        Iterator<Assignment> iterator = assignments.iterator();
        while (iterator.hasNext()) {
            Assignment assignment;
            assignment = iterator.next();
            QualifiedName featureName = this.qualifiedNameConverter.toQualifiedName(assignment.getFeatureName());
            if (!settings.containsKey(featureName)) continue;
            Object actualValueToSet = this.internalSwitch(assignment.getValue(), variables);
            settings.get(featureName).setValue(actualValueToSet);
            iterator.remove();
        }
    }

    protected Object create(JvmType jvmType) {
        Class<?> class1 = this.reflectAccess.getRawType(jvmType);
        if (class1 == null) {
            throw new IllegalStateException("Couldn't find java.lang.Class for name '" + jvmType.getIdentifier() + "'");
        }
        try {
            return class1.newInstance();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    protected Object inCase(Reference ref, Map<QualifiedName, Object> variables) {
        return variables.get(this.qualifiedNameConverter.toQualifiedName(ref.getReferable().getName()));
    }

    protected Object inCase(BooleanLiteral comp, Map<QualifiedName, Object> variables) {
        return comp.isIsTrue();
    }

    protected Object inCase(StringLiteral comp, Map<QualifiedName, Object> variables) {
        StringBuilder builder = new StringBuilder();
        for (StringPart part : comp.getParts()) {
            if (part instanceof PropertyReference) {
                builder.append(variables.get(this.qualifiedNameConverter.toQualifiedName(((PropertyReference)part).getReferable().getName())));
                continue;
            }
            builder.append(((PlainString)part).getValue());
        }
        return builder.toString();
    }

    public void setFactorySupport(FactorySupport factorySupport) {
        this.factorySupport = factorySupport;
    }

    public void setReflectAccess(JavaReflectAccess reflectAccess) {
        this.reflectAccess = reflectAccess;
    }

    public void setSettingProvider(ISettingProvider settingProvider) {
        this.settingProvider = settingProvider;
    }
}

