/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.python;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.python.ProtectedAreaHL;
import fr.esrf.tango.pogo.generator.python.PythonHlProjectUtils;
import fr.esrf.tango.pogo.generator.python.PythonTypeDefinitions;
import fr.esrf.tango.pogo.generator.python.PythonUtils;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class PythonDeviceHL
implements IGenerator {
    @Inject
    @Extension
    private PythonUtils _pythonUtils;
    @Inject
    @Extension
    private PythonTypeDefinitions _pythonTypeDefinitions;
    @Inject
    @Extension
    private PythonHlProjectUtils _pythonHlProjectUtils;
    @Inject
    @Extension
    private ProtectedAreaHL _protectedAreaHL;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description = cls.getDescription();
            String _filestogenerate = _description.getFilestogenerate();
            String _lowerCase = _filestogenerate.toLowerCase();
            boolean _contains = _lowerCase.contains("python package");
            if (_contains) {
                StringUtils.printTrace("Generating PythonHl project directory");
                CharSequence _generatePythonHlProjectSetup = this._pythonHlProjectUtils.generatePythonHlProjectSetup(cls);
                fsa.generateFile("setup.py", _generatePythonHlProjectSetup);
                CharSequence _generatePythonHlProjectReadme = this._pythonHlProjectUtils.generatePythonHlProjectReadme(cls);
                fsa.generateFile("README.rst", _generatePythonHlProjectReadme);
                CharSequence _generatePythonHlProjectManifest = this._pythonHlProjectUtils.generatePythonHlProjectManifest(cls);
                fsa.generateFile("MANIFEST.in", _generatePythonHlProjectManifest);
                String _name = cls.getName();
                String _plus = "test/" + _name;
                String _plus_1 = String.valueOf(_plus) + "_test.py";
                CharSequence _generatePythonHlTest = this._pythonHlProjectUtils.generatePythonHlTest(cls);
                fsa.generateFile(_plus_1, _generatePythonHlTest);
                CharSequence _generatePythonHlTestInit = this._pythonHlProjectUtils.generatePythonHlTestInit(cls);
                fsa.generateFile("test/__init__.py", _generatePythonHlTestInit);
                String _name_1 = cls.getName();
                String _plus_2 = String.valueOf(_name_1) + "/__init__.py";
                CharSequence _generatePythonHlProjectInit = this._pythonHlProjectUtils.generatePythonHlProjectInit(cls);
                fsa.generateFile(_plus_2, _generatePythonHlProjectInit);
                String _name_2 = cls.getName();
                String _plus_3 = String.valueOf(_name_2) + "/release.py";
                CharSequence _generatePythonHlProjectRelease = this._pythonHlProjectUtils.generatePythonHlProjectRelease(cls);
                fsa.generateFile(_plus_3, _generatePythonHlProjectRelease);
                String _name_3 = cls.getName();
                String _plus_4 = String.valueOf(_name_3) + "/__main__.py";
                CharSequence _generatePythonHlProjectMain = this._pythonHlProjectUtils.generatePythonHlProjectMain(cls);
                fsa.generateFile(_plus_4, _generatePythonHlProjectMain);
                ClassDescription _description_1 = cls.getDescription();
                String _license = _description_1.getLicense();
                boolean _equals = Objects.equal(_license, "GPL");
                if (_equals) {
                    CharSequence _generatePythonHlProjectLicenseGPL = this._pythonHlProjectUtils.generatePythonHlProjectLicenseGPL(cls);
                    fsa.generateFile("LICENSE.txt", _generatePythonHlProjectLicenseGPL);
                } else {
                    ClassDescription _description_2 = cls.getDescription();
                    String _license_1 = _description_2.getLicense();
                    boolean _equals_1 = Objects.equal(_license_1, "LGPL");
                    if (_equals_1) {
                        CharSequence _generatePythonHlProjectLicenseLGPL = this._pythonHlProjectUtils.generatePythonHlProjectLicenseLGPL(cls);
                        fsa.generateFile("LICENSE.txt", _generatePythonHlProjectLicenseLGPL);
                    } else {
                        ClassDescription _description_3 = cls.getDescription();
                        String _license_2 = _description_3.getLicense();
                        boolean _equals_2 = Objects.equal(_license_2, "APACHE");
                        if (_equals_2) {
                            CharSequence _generatePythonHlProjectLicenseAPACHE = this._pythonHlProjectUtils.generatePythonHlProjectLicenseAPACHE(cls);
                            fsa.generateFile("LICENSE.txt", _generatePythonHlProjectLicenseAPACHE);
                        } else {
                            ClassDescription _description_4 = cls.getDescription();
                            String _license_3 = _description_4.getLicense();
                            boolean _equals_3 = Objects.equal(_license_3, "MIT");
                            if (_equals_3) {
                                CharSequence _generatePythonHlProjectLicenseMIT = this._pythonHlProjectUtils.generatePythonHlProjectLicenseMIT(cls);
                                fsa.generateFile("LICENSE.txt", _generatePythonHlProjectLicenseMIT);
                            }
                        }
                    }
                }
                ClassDescription _description_5 = cls.getDescription();
                String _filestogenerate_1 = _description_5.getFilestogenerate();
                String _lowerCase_1 = _filestogenerate_1.toLowerCase();
                boolean _contains_1 = _lowerCase_1.contains("sphinx");
                if (_contains_1) {
                    CharSequence _generatePythonHlSphinxIndex = this._pythonHlProjectUtils.generatePythonHlSphinxIndex(cls);
                    fsa.generateFile("docs/source/index.rst", _generatePythonHlSphinxIndex);
                    CharSequence _generatePythonHlSphinxConf = this._pythonHlProjectUtils.generatePythonHlSphinxConf(cls);
                    fsa.generateFile("docs/source/conf.py", _generatePythonHlSphinxConf);
                    CharSequence _generatePythonHlSetupCfg = this._pythonHlProjectUtils.generatePythonHlSetupCfg(cls);
                    fsa.generateFile("setup.cfg", _generatePythonHlSetupCfg);
                }
            }
            boolean _and = false;
            ClassDescription _description_6 = cls.getDescription();
            String _filestogenerate_2 = _description_6.getFilestogenerate();
            String _lowerCase_2 = _filestogenerate_2.toLowerCase();
            boolean _contains_2 = _lowerCase_2.contains("code files");
            if (!_contains_2) {
                _and = false;
            } else {
                boolean _equals_4;
                ClassDescription _description_7 = cls.getDescription();
                String _language = _description_7.getLanguage();
                String _lowerCase_3 = _language.toLowerCase();
                _and = _equals_4 = _lowerCase_3.equals("pythonhl");
            }
            if (!_and) continue;
            ClassDescription _description_8 = cls.getDescription();
            String _filestogenerate_3 = _description_8.getFilestogenerate();
            String _lowerCase_4 = _filestogenerate_3.toLowerCase();
            boolean _contains_3 = _lowerCase_4.contains("python package");
            if (_contains_3) {
                String _name_4 = cls.getName();
                String _plus_5 = "doGenerate for pythonHL " + _name_4;
                InputOutput.println(_plus_5);
                String _name_5 = cls.getName();
                String _plus_6 = String.valueOf(_name_5) + "/";
                String _name_6 = cls.getName();
                String _plus_7 = String.valueOf(_plus_6) + _name_6;
                String _plus_8 = String.valueOf(_plus_7) + ".py";
                CharSequence _generate_pythonFile = this.generate_pythonFile(cls);
                fsa.generateFile(_plus_8, _generate_pythonFile);
                continue;
            }
            String _name_7 = cls.getName();
            String _plus_9 = "doGenerate for pythonHL " + _name_7;
            InputOutput.println(_plus_9);
            String _name_8 = cls.getName();
            String _plus_10 = String.valueOf(_name_8) + ".py";
            CharSequence _generate_pythonFile_1 = this.generate_pythonFile(cls);
            fsa.generateFile(_plus_10, _generate_pythonFile_1);
        }
    }

    public CharSequence generate_pythonFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _pythonDevice = this.pythonDevice(cls);
        _builder.append((Object)_pythonDevice, "");
        _builder.newLineIfNotEmpty();
        CharSequence _pythonMainMethodHL = this.pythonMainMethodHL(cls);
        _builder.append((Object)_pythonMainMethodHL, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonDevice(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This file is part of the ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" project");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#");
        ClassDescription _description = cls.getDescription();
        String _copyright = _description.getCopyright();
        boolean _isSet = StringUtils.isSet(_copyright);
        if (_isSet) {
            ClassDescription _description_1 = cls.getDescription();
            String _copyright_1 = _description_1.getCopyright();
            String _commentMultiLinesPythonStr = this._pythonUtils.commentMultiLinesPythonStr(_copyright_1);
            _builder.append((Object)_commentMultiLinesPythonStr, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Distributed under the terms of the ");
        ClassDescription _description_2 = cls.getDescription();
        String _license = _description_2.getLicense();
        _builder.append((Object)_license, "");
        _builder.append(" license.");
        _builder.newLineIfNotEmpty();
        _builder.append("# See LICENSE.txt for more info.");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonHeader = this.pythonHeader(cls);
        _builder.append((Object)_pythonHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("(");
        String _inheritedPythonClassNameHL = this._pythonTypeDefinitions.inheritedPythonClassNameHL(cls);
        _builder.append((Object)_inheritedPythonClassNameHL, "");
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("    ");
        ClassDescription _description_3 = cls.getDescription();
        String _description_4 = _description_3.getDescription();
        _builder.append((Object)_description_4, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("__metaclass__ = DeviceMeta");
        _builder.newLine();
        _builder.append("    ");
        ClassDescription _description_5 = cls.getDescription();
        String _filestogenerate = _description_5.getFilestogenerate();
        String _lowerCase = _filestogenerate.toLowerCase();
        boolean _contains = _lowerCase.contains("protected regions");
        if (_contains) {
            String _protectedAreaHL = this._protectedAreaHL.protectedAreaHL(cls, "class_variable");
            _builder.append((Object)_protectedAreaHL, "    ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# ----------------");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Class Properties");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# ----------------");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonClassProperties = this.pythonClassProperties(cls);
        _builder.append((Object)_pythonClassProperties, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# -----------------");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Device Properties");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# -----------------");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonDeviceProperties = this.pythonDeviceProperties(cls);
        _builder.append((Object)_pythonDeviceProperties, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# ----------");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Attributes");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# ----------");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonAttributeDefinitions = this.pythonAttributeDefinitions(cls);
        _builder.append((Object)_pythonAttributeDefinitions, "");
        _builder.newLineIfNotEmpty();
        CharSequence _pythonForwardedAttributeDefinitions = this.pythonForwardedAttributeDefinitions(cls);
        _builder.append((Object)_pythonForwardedAttributeDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# -----");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Pipes");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# -----");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonDevicePipes = this.pythonDevicePipes(cls);
        _builder.append((Object)_pythonDevicePipes, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# ---------------");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# General methods");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# ---------------");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonConstructors = this.pythonConstructors(cls);
        _builder.append((Object)_pythonConstructors, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# ------------------");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Attributes methods");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# ------------------");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonAttributes = this.pythonAttributes(cls);
        _builder.append((Object)_pythonAttributes, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# -------------");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Pipes methods");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# -------------");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonPipes = this.pythonPipes(cls);
        _builder.append((Object)_pythonPipes, "");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# --------");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Commands");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# --------");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pythonCommands = this.pythonCommands(cls);
        _builder.append((Object)_pythonCommands, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"\"\" ");
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        _builder.append((Object)_title, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        ClassDescription _description_1 = cls.getDescription();
        String _description_2 = _description_1.getDescription();
        _builder.append((Object)_description_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__all__ = [\"");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("\", \"main\"]");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# PyTango imports");
        _builder.newLine();
        _builder.append("import PyTango");
        _builder.newLine();
        _builder.append("from PyTango import DebugIt");
        _builder.newLine();
        _builder.append("from PyTango.server import run");
        _builder.newLine();
        _builder.append("from PyTango.server import Device, DeviceMeta");
        _builder.newLine();
        _builder.append("from PyTango.server import attribute, command, pipe");
        _builder.newLine();
        _builder.append("from PyTango.server import class_property, device_property");
        _builder.newLine();
        _builder.append("from PyTango import AttrQuality,DispLevel, DevState");
        _builder.newLine();
        _builder.append("from PyTango import AttrWriteType, PipeWriteType");
        _builder.newLine();
        String _inheritedAdditionalImportHL = this._pythonTypeDefinitions.inheritedAdditionalImportHL(cls);
        _builder.append((Object)_inheritedAdditionalImportHL, "");
        _builder.newLineIfNotEmpty();
        _builder.append("# Additional import");
        _builder.newLine();
        ClassDescription _description_3 = cls.getDescription();
        String _filestogenerate = _description_3.getFilestogenerate();
        String _lowerCase = _filestogenerate.toLowerCase();
        boolean _contains = _lowerCase.contains("protected regions");
        if (_contains) {
            String _protectedAreaHL = this._protectedAreaHL.protectedAreaHL(cls, "additionnal_import");
            _builder.append((Object)_protectedAreaHL, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonConstructors(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _constructorHL = this._pythonTypeDefinitions.constructorHL(cls);
        _builder.append((Object)_constructorHL, "");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        CharSequence _setEventCriteria = this._pythonUtils.setEventCriteria(cls);
        _builder.append((Object)_setEventCriteria, "        ");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        ClassDescription _description = cls.getDescription();
        String _filestogenerate = _description.getFilestogenerate();
        String _lowerCase = _filestogenerate.toLowerCase();
        boolean _contains = _lowerCase.contains("protected regions");
        if (_contains) {
            String _protectedAreaHL = this._protectedAreaHL.protectedAreaHL(cls, "init_device");
            _builder.append((Object)_protectedAreaHL, "        ");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def always_executed_hook(self):");
        _builder.newLine();
        _builder.append("        ");
        ClassDescription _description_1 = cls.getDescription();
        String _filestogenerate_1 = _description_1.getFilestogenerate();
        String _lowerCase_1 = _filestogenerate_1.toLowerCase();
        boolean _contains_1 = _lowerCase_1.contains("protected regions");
        if (_contains_1) {
            String _protectedAreaHL_1 = this._protectedAreaHL.protectedAreaHL(cls, "always_executed_hook", "pass", false);
            _builder.append((Object)_protectedAreaHL_1, "        ");
        } else {
            _builder.append("pass");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def delete_device(self):");
        _builder.newLine();
        _builder.append("        ");
        ClassDescription _description_2 = cls.getDescription();
        String _filestogenerate_2 = _description_2.getFilestogenerate();
        String _lowerCase_2 = _filestogenerate_2.toLowerCase();
        boolean _contains_2 = _lowerCase_2.contains("protected regions");
        if (_contains_2) {
            String _protectedAreaHL_2 = this._protectedAreaHL.protectedAreaHL(cls, "delete_device", "pass", false);
            _builder.append((Object)_protectedAreaHL_2, "        ");
        } else {
            _builder.append("pass");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence pythonAttributeDefinitions(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attr : _attributes) {
            EList<Attribute> _attributes_1;
            boolean _isEmpty;
            boolean bl;
            InheritanceStatus _status = attr.getStatus();
            String _concreteHere = _status.getConcreteHere();
            boolean _isTrue = StringUtils.isTrue(_concreteHere);
            if (_isTrue) {
                _builder.append("    ");
                CharSequence _pythonAttributeClassHL = this._pythonUtils.pythonAttributeClassHL(attr);
                _builder.append((Object)_pythonAttributeClassHL, "");
            }
            boolean bl2 = bl = !(_isEmpty = (_attributes_1 = cls.getAttributes()).isEmpty());
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonAttributes(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attr : _attributes) {
            EList<String> _writeExcludedStates;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            InheritanceStatus _status = attr.getStatus();
            String _concreteHere = _status.getConcreteHere();
            boolean _isTrue = StringUtils.isTrue(_concreteHere);
            if (!_isTrue) continue;
            boolean _isRead = StringUtils.isRead(attr);
            if (_isRead) {
                _builder.append("    ");
                CharSequence _readAttributeMethodHL = this._pythonUtils.readAttributeMethodHL(cls, attr);
                _builder.append((Object)_readAttributeMethodHL, "");
            }
            _builder.newLineIfNotEmpty();
            boolean _isWrite = StringUtils.isWrite(attr);
            if (_isWrite) {
                _builder.append("    ");
                CharSequence _writeAttributeMethodHL = this._pythonUtils.writeAttributeMethodHL(cls, attr);
                _builder.append((Object)_writeAttributeMethodHL, "");
            }
            _builder.newLineIfNotEmpty();
            boolean _or = false;
            EList<String> _readExcludedStates = attr.getReadExcludedStates();
            boolean _isEmpty = _readExcludedStates.isEmpty();
            boolean bl = _not = !_isEmpty;
            _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_writeExcludedStates = attr.getWriteExcludedStates()).isEmpty()));
            if (_or) {
                _builder.append("    ");
                CharSequence _attributeMethodStateMachineHL = this._pythonUtils.attributeMethodStateMachineHL(cls, attr);
                _builder.append((Object)_attributeMethodStateMachineHL, "");
            }
            _builder.newLineIfNotEmpty();
        }
        CharSequence _pythonDynamicAttributes = this.pythonDynamicAttributes(cls);
        _builder.append((Object)_pythonDynamicAttributes, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonDynamicAttributes(PogoDeviceClass cls) {
        boolean _not_2;
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        for (Attribute attr : _dynamicAttributes) {
            EList<String> _writeExcludedStates;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            boolean _isWrite;
            InheritanceStatus _status = attr.getStatus();
            String _concreteHere = _status.getConcreteHere();
            boolean _isTrue = StringUtils.isTrue(_concreteHere);
            if (!_isTrue) continue;
            boolean _isRead = StringUtils.isRead(attr);
            if (_isRead) {
                CharSequence _readAttributeMethodHL = this._pythonUtils.readAttributeMethodHL(cls, attr);
                _builder.append((Object)_readAttributeMethodHL, "");
                _builder.newLineIfNotEmpty();
            }
            if (_isWrite = StringUtils.isWrite(attr)) {
                CharSequence _writeAttributeMethodHL = this._pythonUtils.writeAttributeMethodHL(cls, attr);
                _builder.append((Object)_writeAttributeMethodHL, "");
                _builder.newLineIfNotEmpty();
            }
            boolean _or = false;
            EList<String> _readExcludedStates = attr.getReadExcludedStates();
            boolean _isEmpty = _readExcludedStates.isEmpty();
            boolean bl = _not = !_isEmpty;
            _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_writeExcludedStates = attr.getWriteExcludedStates()).isEmpty()));
            if (!_or) continue;
            CharSequence _attributeMethodStateMachineHL = this._pythonUtils.attributeMethodStateMachineHL(cls, attr);
            _builder.append((Object)_attributeMethodStateMachineHL, "");
            _builder.newLineIfNotEmpty();
        }
        EList<Attribute> _dynamicAttributes_1 = cls.getDynamicAttributes();
        boolean _isEmpty_2 = _dynamicAttributes_1.isEmpty();
        boolean bl = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append("def initialize_dynamic_attributes(self):");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("self.debug_stream(\"In initialize_dynamic_attributes()\")");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("#   Example to add dynamic attributes");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("#   Copy inside the folowing protected area to instanciate at startup.");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            EList<Attribute> _dynamicAttributes_2 = cls.getDynamicAttributes();
            for (Attribute attr_1 : _dynamicAttributes_2) {
                _builder.append("    ");
                _builder.append("\"\"\"   For Attribute ");
                String _name = attr_1.getName();
                _builder.append((Object)_name, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                CharSequence _dynamicAttributeCreationExample = this._pythonUtils.dynamicAttributeCreationExample(attr_1);
                _builder.append((Object)_dynamicAttributeCreationExample, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                CharSequence _dynamicAttributeSetMemorizedExample = this._pythonUtils.dynamicAttributeSetMemorizedExample(attr_1);
                _builder.append((Object)_dynamicAttributeSetMemorizedExample, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                CharSequence _dynamicAttributeDefaultValueExample = this._pythonUtils.dynamicAttributeDefaultValueExample(cls, attr_1);
                _builder.append((Object)_dynamicAttributeDefaultValueExample, "    ");
                _builder.append("\"\"\"");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence pythonDynamicAttributesClass(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def dyn_attr(self, dev_list):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("\"\"\"Invoked to create dynamic attributes for the given devices.");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Default implementation calls");
        _builder.newLine();
        _builder.append("    ");
        _builder.append(":meth:`");
        String _name = cls.getName();
        _builder.append((Object)_name, "    ");
        _builder.append(".initialize_dynamic_attributes` for each device");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append(":param dev_list: list of devices");
        _builder.newLine();
        _builder.append("    ");
        _builder.append(":type dev_list: :class:`PyTango.DeviceImpl`\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("for dev in dev_list:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("try:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("dev.initialize_dynamic_attributes()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("except:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("import traceback");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("dev.warn_stream(\"Failed to initialize dynamic attributes\")");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("dev.debug_stream(\"Details: \" + traceback.format_exc())");
        _builder.newLine();
        return _builder;
    }

    public CharSequence pythonForwardedAttributeDefinitions(PogoDeviceClass cls) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        EList<ForwardedAttribute> _forwardedAttributes = cls.getForwardedAttributes();
        boolean _isEmpty = _forwardedAttributes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<ForwardedAttribute> _forwardedAttributes_1 = cls.getForwardedAttributes();
            for (ForwardedAttribute attr : _forwardedAttributes_1) {
                _builder.append("    ");
                CharSequence _pythonForwardedAttributeClassHL = this._pythonUtils.pythonForwardedAttributeClassHL(attr);
                _builder.append((Object)_pythonForwardedAttributeClassHL, "");
            }
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonPipes(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Pipe> _pipes = cls.getPipes();
        for (Pipe pip : _pipes) {
            EList<String> _writeExcludedStates;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            _builder.append("    ");
            CharSequence _readPipeMethodHL = this._pythonUtils.readPipeMethodHL(cls, pip);
            _builder.append((Object)_readPipeMethodHL, "");
            _builder.newLineIfNotEmpty();
            String _rwType = pip.getRwType();
            boolean _contains = _rwType.contains("WRITE");
            if (_contains) {
                _builder.append("    ");
                CharSequence _writePipeMethodHL = this._pythonUtils.writePipeMethodHL(cls, pip);
                _builder.append((Object)_writePipeMethodHL, "");
            }
            _builder.newLineIfNotEmpty();
            boolean _or = false;
            EList<String> _readExcludedStates = pip.getReadExcludedStates();
            boolean _isEmpty = _readExcludedStates.isEmpty();
            boolean bl = _not = !_isEmpty;
            _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_writeExcludedStates = pip.getWriteExcludedStates()).isEmpty()));
            if (_or) {
                _builder.append("    ");
                CharSequence _pipeMethodStateMachineHL = this._pythonUtils.pipeMethodStateMachineHL(cls, pip);
                _builder.append((Object)_pipeMethodStateMachineHL, "");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence pythonCommands(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Command> _commands = cls.getCommands();
        for (Command cmd : _commands) {
            boolean _not;
            InheritanceStatus _status = cmd.getStatus();
            String _concreteHere = _status.getConcreteHere();
            boolean _isTrue = StringUtils.isTrue(_concreteHere);
            if (!_isTrue) continue;
            CharSequence _commandExecutionHL = this._pythonUtils.commandExecutionHL(cls, cmd);
            _builder.append((Object)_commandExecutionHL, "");
            _builder.newLineIfNotEmpty();
            EList<String> _excludedStates = cmd.getExcludedStates();
            boolean _isEmpty = _excludedStates.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            _builder.append("    ");
            CharSequence _commandMethodStateMachineHL = this._pythonUtils.commandMethodStateMachineHL(cls, cmd);
            _builder.append((Object)_commandMethodStateMachineHL, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonClassProperties(PogoDeviceClass cls) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        EList<Property> _classProperties = cls.getClassProperties();
        boolean _isEmpty = _classProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<Property> _classProperties_1 = cls.getClassProperties();
            for (Property prop : _classProperties_1) {
                InheritanceStatus _status = prop.getStatus();
                String _concreteHere = _status.getConcreteHere();
                boolean _isTrue = StringUtils.isTrue(_concreteHere);
                if (!_isTrue) continue;
                _builder.append("    ");
                CharSequence _pythonPropertyClassHL = this._pythonUtils.pythonPropertyClassHL(prop);
                _builder.append((Object)_pythonPropertyClassHL, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence pythonDeviceProperties(PogoDeviceClass cls) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        boolean _isEmpty = _deviceProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<Property> _deviceProperties_1 = cls.getDeviceProperties();
            for (Property prop : _deviceProperties_1) {
                InheritanceStatus _status = prop.getStatus();
                String _concreteHere = _status.getConcreteHere();
                boolean _isTrue = StringUtils.isTrue(_concreteHere);
                if (!_isTrue) continue;
                _builder.append("    ");
                CharSequence _pythonPropertyDeviceHL = this._pythonUtils.pythonPropertyDeviceHL(prop);
                _builder.append((Object)_pythonPropertyDeviceHL, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence pythonDevicePipes(PogoDeviceClass cls) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        EList<Pipe> _pipes = cls.getPipes();
        boolean _isEmpty = _pipes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<Pipe> _pipes_1 = cls.getPipes();
            for (Pipe pip : _pipes_1) {
                _builder.append("    ");
                CharSequence _pythonPipeClassHL = this._pythonUtils.pythonPipeClassHL(pip);
                _builder.append((Object)_pythonPipeClassHL, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence pythonMainMethodHL(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# ----------");
        _builder.newLine();
        _builder.append("# Run server");
        _builder.newLine();
        _builder.append("# ----------");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("def main(args=None, **kwargs):");
        _builder.newLine();
        _builder.append("    ");
        ClassDescription _description = cls.getDescription();
        String _filestogenerate = _description.getFilestogenerate();
        String _lowerCase = _filestogenerate.toLowerCase();
        boolean _contains = _lowerCase.contains("protected regions");
        if (_contains) {
            String _name = cls.getName();
            String _plus = "from PyTango.server import run\nreturn run((" + _name;
            String _plus_1 = String.valueOf(_plus) + ",), args=args, **kwargs)";
            String _protectedAreaHL = this._protectedAreaHL.protectedAreaHL(cls, "main", _plus_1, false);
            _builder.append((Object)_protectedAreaHL, "    ");
        } else {
            _builder.append("from PyTango.server import run");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return run((");
            String _name_1 = cls.getName();
            _builder.append((Object)_name_1, "    ");
            _builder.append(",), args=args, **kwargs)");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("if __name__ == '__main__':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("main()");
        _builder.newLine();
        return _builder;
    }
}

