/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Attributes;
import fr.esrf.tango.pogo.generator.cpp.utils.Commands;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Properties;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class DeviceClassSource {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private Attributes _attributes;
    @Inject
    @Extension
    private Commands _commands;
    @Inject
    @Extension
    private Properties _properties;
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;
    @Inject
    @Extension
    private StringUtils _stringUtils;

    public CharSequence generateDeviceClassSourceFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _fileHeader = this.fileHeader(cls);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("namespace ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("_ns");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        CharSequence _constructors = this.constructors(cls);
        _builder.append((Object)_constructors, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//===================================================================");
        _builder.newLine();
        _builder.append("//\tCommand execution method calls");
        _builder.newLine();
        _builder.append("//===================================================================");
        _builder.newLine();
        CharSequence _commandRelatedMethods = this.commandRelatedMethods(cls);
        _builder.append((Object)_commandRelatedMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//===================================================================");
        _builder.newLine();
        _builder.append("//\tProperties management");
        _builder.newLine();
        _builder.append("//===================================================================");
        _builder.newLine();
        CharSequence _propertyRelatedMethod = this._properties.propertyRelatedMethod(cls);
        _builder.append((Object)_propertyRelatedMethod, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//===================================================================");
        _builder.newLine();
        _builder.append("//\tFactory methods");
        _builder.newLine();
        _builder.append("//===================================================================");
        _builder.newLine();
        CharSequence _deviceFactory = this.deviceFactory(cls);
        _builder.append((Object)_deviceFactory, "");
        _builder.newLineIfNotEmpty();
        CharSequence _attributeFactory = this.attributeFactory(cls);
        _builder.append((Object)_attributeFactory, "");
        _builder.newLineIfNotEmpty();
        CharSequence _pipeFactory = this.pipeFactory(cls);
        _builder.append((Object)_pipeFactory, "");
        _builder.newLineIfNotEmpty();
        CharSequence _commandFactory = this.commandFactory(cls);
        _builder.append((Object)_commandFactory, "");
        _builder.newLineIfNotEmpty();
        CharSequence _dynamicAttributeMethods = this.dynamicAttributeMethods(cls);
        _builder.append((Object)_dynamicAttributeMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "Additional Methods");
        _builder.append((Object)_protectedAreaClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("} //\tnamespace");
        _builder.newLine();
        return _builder;
    }

    public CharSequence fileHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _deviceClassSourceFileHeader = this._headers.deviceClassSourceFileHeader(cls);
        String _plus = String.valueOf(_deviceClassSourceFileHeader) + "\n\n";
        String _plus_1 = String.valueOf(_plus) + "#include <";
        String _name = cls.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        String _plus_3 = String.valueOf(_plus_2) + "Class.h>";
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, ".cpp", _plus_3, false);
        _builder.append((Object)_protectedAreaClass, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//-------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tCreate ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append("Class singleton and");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*\treturn it in a C function for Python usage");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//-------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("extern \"C\" {");
        _builder.newLine();
        _builder.append("#ifdef _TG_WINDOWS_");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__declspec(dllexport)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DeviceClass *_create_");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("_class(const char *name) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "\t\t");
        _builder.append("_ns::");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append("Class::init(name);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence commandRelatedMethods(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Command> _commands = cls.getCommands();
        int _size = _commands.size();
        boolean bl = _greaterThan = _size > 2;
        if (_greaterThan) {
            EList<Command> _commands_1 = cls.getCommands();
            for (Command command : _commands_1) {
                String _name_1;
                boolean _equals_2;
                boolean _equals_3;
                boolean _equals_1;
                boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(command);
                if (!_isConcreteHere) continue;
                boolean _and = false;
                String _name = command.getName();
                boolean _equals = _name.equals("State");
                boolean bl2 = _equals_1 = !_equals;
                _and = !_equals_1 ? false : (_equals_3 = !(_equals_2 = (_name_1 = command.getName()).equals("Status")));
                if (!_and) continue;
                CharSequence _classExecuteMethod = this._commands.classExecuteMethod(cls, command);
                _builder.append((Object)_classExecuteMethod, "");
                _builder.newLineIfNotEmpty();
            }
        }
        EList<Command> _dynamicCommands = cls.getDynamicCommands();
        for (Command command_1 : _dynamicCommands) {
            CharSequence _classExecuteMethod_1 = this._commands.classExecuteMethod(cls, command_1);
            _builder.append((Object)_classExecuteMethod_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence pipeFactory(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "pipe_factory", "Create the pipe object(s)\nand store them in the pipe list");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::pipe_factory()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "pipe_factory_before", "Add your own code", true);
        _builder.append((Object)_protectedAreaClass, "\t");
        _builder.newLineIfNotEmpty();
        EList<Pipe> _pipes = cls.getPipes();
        int _size = _pipes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("Tango::UserDefaultPipeProp udpp;");
            _builder.newLine();
            EList<Pipe> _pipes_1 = cls.getPipes();
            for (Pipe pipe : _pipes_1) {
                _builder.append("\t");
                String _name_1 = pipe.getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append("Class\t*p");
                String _name_2 = pipe.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append(" = new ");
                String _name_3 = pipe.getName();
                _builder.append((Object)_name_3, "\t");
                _builder.append("Class(\"");
                String _name_4 = pipe.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append("\",Tango::");
                String _displayLevel = pipe.getDisplayLevel();
                _builder.append((Object)_displayLevel, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("udpp.set_description(\"");
                String _description = pipe.getDescription();
                String _oneLineString = this._stringUtils.oneLineString(_description);
                _builder.append((Object)_oneLineString, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("udpp.set_label(\"");
                String _label = pipe.getLabel();
                _builder.append((Object)_label, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("p");
                String _name_5 = pipe.getName();
                _builder.append((Object)_name_5, "\t");
                _builder.append("->set_default_properties(udpp);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("pipe_list.push_back(p");
                String _name_6 = pipe.getName();
                _builder.append((Object)_name_6, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        _builder.append("\t");
        String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "pipe_factory_after", "Add your own code", true);
        _builder.append((Object)_protectedAreaClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributeFactory(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "attribute_factory", "Create the attribute object(s)\nand store them in the attribute list");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::attribute_factory(vector<Tango::Attr *> &att_list)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "attribute_factory_before", "Add your own code", true);
        _builder.append((Object)_protectedAreaClass, "\t");
        _builder.newLineIfNotEmpty();
        boolean _hasInheritanceClass = this._inheritanceUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            _builder.append("\t");
            _builder.append("//\tCall atribute_factory for inherited class");
            _builder.newLine();
            _builder.append("\t");
            String _inheritedClassNameForDeviceClass = this._inheritanceUtils.inheritedClassNameForDeviceClass(cls);
            _builder.append((Object)_inheritedClassNameForDeviceClass, "\t");
            _builder.append("::attribute_factory(att_list);");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attribute : _attributes) {
            boolean _isInherited = this._inheritanceUtils.isInherited(attribute);
            if (_isInherited) {
                _builder.append("\t");
                _builder.append("//\tAttribute : ");
                String _name_1 = attribute.getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append(" - Check if not concrete in inherited class");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("Tango::Attr *");
                String _name_2 = attribute.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append("Attr = get_attr_object_by_name(att_list, \"");
                String _name_3 = attribute.getName();
                _builder.append((Object)_name_3, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if (");
                String _name_4 = attribute.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append("Attr == NULL)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _attributeFactory = this._attributes.attributeFactory(attribute);
                _builder.append((Object)_attributeFactory, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            } else {
                _builder.append("\t");
                CharSequence _attributeFactory_1 = this._attributes.attributeFactory(attribute);
                _builder.append((Object)_attributeFactory_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
        }
        EList<ForwardedAttribute> _forwardedAttributes = cls.getForwardedAttributes();
        for (ForwardedAttribute attribute_1 : _forwardedAttributes) {
            _builder.append("\t");
            CharSequence _forwardedAttributeFactory = this.forwardedAttributeFactory(attribute_1);
            _builder.append((Object)_forwardedAttributeFactory, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isConcreteClass = this._inheritanceUtils.isConcreteClass(cls);
        if (_isConcreteClass) {
            _builder.append("\t");
            _builder.append("//\tCreate a list of static attributes");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("create_static_attribute_list(get_class_attr()->get_attr_list());");
            _builder.newLine();
        }
        _builder.append("\t");
        String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "attribute_factory_after", "Add your own code", true);
        _builder.append((Object)_protectedAreaClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence forwardedAttributeFactory(ForwardedAttribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("//\tForwarded attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, "");
        _builder.newLineIfNotEmpty();
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("Attrib *");
        String _name_2 = attribute.getName();
        String _lowerCase = _name_2.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append(" = new ");
        String _name_3 = attribute.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("Attrib(\"");
        String _name_4 = attribute.getName();
        _builder.append((Object)_name_4, "");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("Tango::UserDefaultFwdAttrProp  ");
        String _name_5 = attribute.getName();
        String _lowerCase_1 = _name_5.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append("_prop;");
        _builder.newLineIfNotEmpty();
        String _name_6 = attribute.getName();
        String _lowerCase_2 = _name_6.toLowerCase();
        _builder.append((Object)_lowerCase_2, "");
        _builder.append("_prop.set_label(\"");
        String _label = attribute.getLabel();
        _builder.append((Object)_label, "");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        String _name_7 = attribute.getName();
        String _lowerCase_3 = _name_7.toLowerCase();
        _builder.append((Object)_lowerCase_3, "");
        _builder.append("->set_default_properties(");
        String _name_8 = attribute.getName();
        String _lowerCase_4 = _name_8.toLowerCase();
        _builder.append((Object)_lowerCase_4, "");
        _builder.append("_prop);");
        _builder.newLineIfNotEmpty();
        _builder.append("att_list.push_back(");
        String _name_9 = attribute.getName();
        String _lowerCase_5 = _name_9.toLowerCase();
        _builder.append((Object)_lowerCase_5, "");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence commandFactory(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "command_factory", "Create the command object(s)\nand store them in the command list");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::command_factory()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "command_factory_before", "Add your own code", true);
        _builder.append((Object)_protectedAreaClass, "\t");
        _builder.newLineIfNotEmpty();
        boolean _hasInheritanceClass = this._inheritanceUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            _builder.append("\t");
            _builder.append("//\tCall command_factory for inherited class");
            _builder.newLine();
            _builder.append("\t");
            String _inheritedClassNameForDeviceClass = this._inheritanceUtils.inheritedClassNameForDeviceClass(cls);
            _builder.append((Object)_inheritedClassNameForDeviceClass, "\t");
            _builder.append("::command_factory();");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        EList<Command> _commands = cls.getCommands();
        for (Command command : _commands) {
            String _name_2;
            boolean _equals_2;
            boolean _equals_3;
            String _name_1;
            boolean _equals;
            boolean _equals_1;
            boolean _and = false;
            boolean _and_1 = false;
            boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(command);
            _and_1 = !_isConcreteHere ? false : (_equals_1 = !(_equals = (_name_1 = command.getName()).equals("State")));
            _and = !_and_1 ? false : (_equals_3 = !(_equals_2 = (_name_2 = command.getName()).equals("Status")));
            if (_and) {
                boolean _isInherited = this._inheritanceUtils.isInherited(command);
                if (_isInherited) {
                    _builder.append("\t");
                    _builder.append("//\tGet inherited Command object ");
                    String _name_3 = command.getName();
                    _builder.append((Object)_name_3, "\t");
                    _builder.append(" if already created");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("try");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("get_cmd_by_name(\"");
                    String _name_4 = command.getName();
                    _builder.append((Object)_name_4, "\t\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("catch (Tango::DevFailed &e)");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("//\tCreate ");
                    String _name_5 = command.getName();
                    _builder.append((Object)_name_5, "\t\t");
                    _builder.append(" command object");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _commandFactory = this._commands.commandFactory(command);
                    _builder.append((Object)_commandFactory, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("//\tCommand ");
                    String _name_6 = command.getName();
                    _builder.append((Object)_name_6, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    CharSequence _commandFactory_1 = this._commands.commandFactory(command);
                    _builder.append((Object)_commandFactory_1, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.newLine();
            boolean _or = false;
            String _name_7 = command.getName();
            boolean _equals_4 = _name_7.equals("State");
            if (_equals_4) {
                _or = true;
            } else {
                boolean _equals_5;
                String _name_8 = command.getName();
                _or = _equals_5 = _name_8.equals("Status");
            }
            if (!_or) continue;
            _builder.append("\t");
            CharSequence _checkStateStatusPolling = this._commands.checkStateStatusPolling(command);
            _builder.append((Object)_checkStateStatusPolling, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "command_factory_after", "Add your own code", true);
        _builder.append((Object)_protectedAreaClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence deviceFactory(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "device_factory", "Create the device object(s)\nand store them in the device list");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::device_factory(const Tango::DevVarStringArray *devlist_ptr)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        String _name_1 = cls.getName();
        String _lowerCase = _name_1.toLowerCase();
        boolean _equals = _lowerCase.equals("database");
        if (_equals) {
            _builder.append("device_list.push_back(new DataBase(this, DataBase::db_name.c_str(),");
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t\t\t\t");
            _builder.append("\"TANGO database device server\"));");
            _builder.newLine();
            _builder.append("export_device(device_list[0],\"database\");");
            _builder.newLine();
        } else {
            boolean _isConcreteClass = this._inheritanceUtils.isConcreteClass(cls);
            if (_isConcreteClass) {
                boolean _greaterThan;
                _builder.append("\t");
                String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "device_factory_before", "Add your own code", true);
                _builder.append((Object)_protectedAreaClass, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("//\tCreate devices and add it into the device list");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("cout4 << \"Device name : \" << (*devlist_ptr)[i].in() << endl;");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("device_list.push_back(new ");
                String _name_2 = cls.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append("(this, (*devlist_ptr)[i]));");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("//\tManage dynamic attributes if any");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("erase_dynamic_attributes(devlist_ptr, get_class_attr()->get_attr_list());");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("//\tExport devices to the outside world");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("for (unsigned long i=1 ; i<=devlist_ptr->length() ; i++)");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("//\tAdd dynamic attributes if any");
                _builder.newLine();
                _builder.append("\t\t");
                String _name_3 = cls.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append(" *dev = static_cast<");
                String _name_4 = cls.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append(" *>(device_list[device_list.size()-i]);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("dev->add_dynamic_attributes();");
                _builder.newLine();
                EList<Command> _dynamicCommands = cls.getDynamicCommands();
                int _size = _dynamicCommands.size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    _builder.append("\t\t");
                    _builder.append("dev->add_dynamic_commands();");
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("//\tCheck before if database used.");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("export_device(dev);");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("else");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("export_device(dev, dev->get_name().c_str());");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t");
                String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "device_factory_after", "Add your own code", true);
                _builder.append((Object)_protectedAreaClass_1, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("//\tThis class is not concrete and cannot implement devices");
                _builder.newLine();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dynamicAttributeMethods(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        boolean _isConcreteClass = this._inheritanceUtils.isConcreteClass(cls);
        if (_isConcreteClass) {
            _builder.append("//===================================================================");
            _builder.newLine();
            _builder.append("//\tDynamic attributes related methods");
            _builder.newLine();
            _builder.append("//===================================================================");
            _builder.newLine();
            _builder.newLine();
            _builder.append("//--------------------------------------------------------");
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* method : \t\t");
            String _name = cls.getName();
            _builder.append((Object)_name, " ");
            _builder.append("Class::create_static_attribute_list");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* description : \tCreate the a list of static attributes");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param\tatt_list\tthe ceated attribute list");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("//--------------------------------------------------------");
            _builder.newLine();
            _builder.append("void ");
            String _name_1 = cls.getName();
            _builder.append((Object)_name_1, "");
            _builder.append("Class::create_static_attribute_list(vector<Tango::Attr *> &att_list)");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for (unsigned long i=0 ; i<att_list.size() ; i++)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("string att_name(att_list[i]->get_name());");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("transform(att_name.begin(), att_name.end(), att_name.begin(), ::tolower);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("defaultAttList.push_back(att_name);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("cout2 << defaultAttList.size() << \" attributes in default list\" << endl;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "create_static_att_list");
            _builder.append((Object)_protectedAreaClass, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.newLine();
            _builder.append("//--------------------------------------------------------");
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* method : \t\t");
            String _name_2 = cls.getName();
            _builder.append((Object)_name_2, " ");
            _builder.append("Class::erase_dynamic_attributes");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* description : \tdelete the dynamic attributes if any.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param\tdevlist_ptr\tthe device list pointer");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param\tlist of all attributes");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("//--------------------------------------------------------");
            _builder.newLine();
            _builder.append("void ");
            String _name_3 = cls.getName();
            _builder.append((Object)_name_3, "");
            _builder.append("Class::erase_dynamic_attributes(const Tango::DevVarStringArray *devlist_ptr, vector<Tango::Attr *> &att_list)");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("Tango::Util *tg = Tango::Util::instance();");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("Tango::DeviceImpl *dev_impl = tg->get_device_by_name(((string)(*devlist_ptr)[i]).c_str());");
            _builder.newLine();
            _builder.append("\t\t");
            String _name_4 = cls.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append(" *dev = static_cast<");
            String _name_5 = cls.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append(" *> (dev_impl);");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("vector<Tango::Attribute *> &dev_att_list = dev->get_device_attr()->get_attribute_list();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("vector<Tango::Attribute *>::iterator ite_att;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (ite_att=dev_att_list.begin() ; ite_att != dev_att_list.end() ; ++ite_att)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("string att_name((*ite_att)->get_name_lower());");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if ((att_name == \"state\") || (att_name == \"status\"))");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("continue;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("vector<string>::iterator ite_str = find(defaultAttList.begin(), defaultAttList.end(), att_name);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (ite_str == defaultAttList.end())");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("cout2 << att_name << \" is a UNWANTED dynamic attribute for device \" << (*devlist_ptr)[i] << endl;");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("Tango::Attribute &att = dev->get_device_attr()->get_attr_by_name(att_name.c_str());");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("dev->remove_attribute(att_list[att.get_attr_idx()], true, false);");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("--ite_att;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "erase_dynamic_attributes");
            _builder.append((Object)_protectedAreaClass_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "get_attr_by_name", "returns Tango::Attr * object found by name");
            _builder.append((Object)_simpleMethodHeaderClass, "");
            _builder.newLineIfNotEmpty();
            _builder.append("Tango::Attr *");
            String _name_6 = cls.getName();
            _builder.append((Object)_name_6, "");
            _builder.append("Class::get_attr_object_by_name(vector<Tango::Attr *> &att_list, string attname)");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("vector<Tango::Attr *>::iterator it;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for (it=att_list.begin() ; it<att_list.end() ; ++it)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if ((*it)->get_name()==attname)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("return (*it);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tAttr does not exist");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return NULL;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence constructors(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//===================================================================");
        _builder.newLine();
        _builder.append("//\tInitialize pointer for singleton pattern");
        _builder.newLine();
        _builder.append("//===================================================================");
        _builder.newLine();
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class *");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("Class::_instance = NULL;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* method : \t\t");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, " ");
        _builder.append("Class::");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, " ");
        _builder.append("Class(string &s)");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* description : \tconstructor for the ");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, " ");
        _builder.append("Class");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param s\tThe class name");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _name_5 = cls.getName();
        _builder.append((Object)_name_5, "");
        _builder.append("Class::");
        String _name_6 = cls.getName();
        _builder.append((Object)_name_6, "");
        _builder.append("Class(string &s):");
        String _inheritedClassNameForDeviceClass = this._inheritanceUtils.inheritedClassNameForDeviceClass(cls);
        _builder.append((Object)_inheritedClassNameForDeviceClass, "");
        _builder.append("(s)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cout2 << \"Entering ");
        String _name_7 = cls.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append("Class constructor\" << endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("set_default_property();");
        _builder.newLine();
        EList<Property> _classProperties = cls.getClassProperties();
        int _size = _classProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("get_class_property();");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("write_class_property();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "constructor");
        _builder.append((Object)_protectedAreaClass, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cout2 << \"Leaving ");
        String _name_8 = cls.getName();
        _builder.append((Object)_name_8, "\t");
        _builder.append("Class constructor\" << endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* method : \t\t");
        String _name_9 = cls.getName();
        _builder.append((Object)_name_9, " ");
        _builder.append("Class::~");
        String _name_10 = cls.getName();
        _builder.append((Object)_name_10, " ");
        _builder.append("Class()");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* description : \tdestructor for the ");
        String _name_11 = cls.getName();
        _builder.append((Object)_name_11, " ");
        _builder.append("Class");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _name_12 = cls.getName();
        _builder.append((Object)_name_12, "");
        _builder.append("Class::~");
        String _name_13 = cls.getName();
        _builder.append((Object)_name_13, "");
        _builder.append("Class()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "destructor");
        _builder.append((Object)_protectedAreaClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("_instance = NULL;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* method : \t\t");
        String _name_14 = cls.getName();
        _builder.append((Object)_name_14, " ");
        _builder.append("Class::init");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* description : \tCreate the object if not already done.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*                  Otherwise, just return a pointer to the object");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param\tname\tThe class name");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _name_15 = cls.getName();
        _builder.append((Object)_name_15, "");
        _builder.append("Class *");
        String _name_16 = cls.getName();
        _builder.append((Object)_name_16, "");
        _builder.append("Class::init(const char *name)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (_instance == NULL)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("string s(name);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("_instance = new ");
        String _name_17 = cls.getName();
        _builder.append((Object)_name_17, "\t\t\t");
        _builder.append("Class(s);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("catch (bad_alloc &)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return _instance;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* method : \t\t");
        String _name_18 = cls.getName();
        _builder.append((Object)_name_18, " ");
        _builder.append("Class::instance");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* description : \tCheck if object already created,");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*                  and return a pointer to the object");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _name_19 = cls.getName();
        _builder.append((Object)_name_19, "");
        _builder.append("Class *");
        String _name_20 = cls.getName();
        _builder.append((Object)_name_20, "");
        _builder.append("Class::instance()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (_instance == NULL)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cerr << \"Class is not initialised !!\" << endl;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("exit(-1);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return _instance;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

