/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPipeNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelAlias
extends TreePanel {
    String aliasFilterString = "*";
    Pattern aliasPattern = null;

    public TreePanelAlias(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    public void applyFilter(String string) {
        this.aliasFilterString = string;
        if (string.equals("*")) {
            this.aliasPattern = null;
        } else if (string.length() == 0) {
            this.aliasPattern = null;
        } else {
            try {
                String string2 = this.filterToRegExp(this.aliasFilterString);
                this.aliasPattern = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.invoker, patternSyntaxException.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.aliasFilterString;
    }

    class AliasNode
    extends TangoNode {
        private String aliasName = null;
        private String devName = null;

        AliasNode(String string) {
            this.aliasName = string;
        }

        @Override
        void populateNode() throws DevFailed {
            this.devName = TreePanelAlias.this.db.get_alias_device(this.aliasName);
            this.add(new TaskDevicePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskPipeNode(TreePanelAlias.this.db, this.devName));
            this.add(new AttributeNode(this.devName));
            this.add(new TaskLoggingNode(TreePanelAlias.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.aliasName;
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        public int[] getAction() {
            return new int[]{11, 13, 3};
        }

        public void goToDeviceNode() {
            try {
                if (this.devName == null) {
                    this.devName = TreePanelAlias.this.db.get_alias_device(this.aliasName);
                }
                TreePanelAlias.this.invoker.goToDeviceNode(this.devName);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        @Override
        public void execAction(int n) {
            switch (n) {
                case 3: {
                    int n2 = JOptionPane.showConfirmDialog(TreePanelAlias.this.invoker, "Delete alias " + this.aliasName + " ?", "Confirm delete", 0);
                    if (n2 != 0) break;
                    try {
                        TreePanelAlias.this.db.delete_device_alias(this.aliasName);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelAlias.this.refresh();
                    break;
                }
                case 11: {
                    TreePanelAlias.this.testDevice(this.aliasName);
                    break;
                }
                case 13: {
                    this.goToDeviceNode();
                }
            }
        }

        @Override
        String getValue() {
            if (this.devName == null) {
                try {
                    this.devName = TreePanelAlias.this.db.get_alias_device(this.aliasName);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
            }
            return TreePanelAlias.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }
    }

    class AttributeNode
    extends TangoNode {
        private String devName;

        AttributeNode(String string) {
            this.devName = string;
        }

        @Override
        void populateNode() throws DevFailed {
            int n;
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{};
            String[] stringArray3 = new String[]{};
            int n2 = 0;
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            try {
                stringArray2 = deviceProxy.get_attribute_list();
                n2 = deviceProxy.get_idl_version();
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            stringArray3 = TreePanelAlias.this.db.get_device_attribute_list(this.devName);
            JiveUtils.sortList(stringArray);
            for (n = 0; n < stringArray2.length; ++n) {
                this.add(new TaskDeviceAttributePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName, stringArray2[n], n2, false));
            }
            for (n = 0; n < stringArray3.length; ++n) {
                if (JiveUtils.contains(stringArray2, stringArray3[n])) continue;
                this.add(new TaskDeviceAttributePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName, stringArray3[n], n2, true));
            }
        }

        @Override
        public String toString() {
            return "Attribute properties";
        }

        @Override
        public int[] getAction() {
            return new int[]{30};
        }

        @Override
        public void execAction(int n) {
            switch (n) {
                case 30: {
                    TreePanelAlias.this.createEmptyAttributeProperty(this.devName);
                }
            }
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelAlias.this.db.get_device_alias_list("*");
            for (int i = 0; i < stringArray.length; ++i) {
                if (TreePanelAlias.this.aliasPattern != null) {
                    Matcher matcher = TreePanelAlias.this.aliasPattern.matcher(stringArray[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != stringArray[i].length()) continue;
                    this.add(new AliasNode(stringArray[i]));
                    continue;
                }
                this.add(new AliasNode(stringArray[i]));
            }
        }

        @Override
        public String toString() {
            return "Alias:";
        }
    }
}

