/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.TaskPipeNode;

public class DevicePipePanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable displayTable;
    private DefaultTableModel displayModel;
    private JTable descriptionTable;
    private DefaultTableModel descriptionModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JPopupMenu tableMenu;
    private JMenuItem resetMenuItem;
    private JMenuItem resetLMenuItem;
    private JMenuItem resetULMenuItem;
    private JMenuItem resetCULMenuItem;
    private JMenuItem labelMenuItem;
    private JMenuItem descriptionMenuItem;
    private JTable selectedTable;
    private int[] selectedRows;
    private TaskPipeNode[] source = null;

    DevicePipePanel() {
        this.setLayout(new BorderLayout());
        this.displayModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DevicePipePanel.this.source.length;
                    int n4 = 0;
                    if (DevicePipePanel.this.source.length > 1) {
                        String string = (String)DevicePipePanel.this.displayModel.getValueAt(n, 0);
                        Vector<String> vector = new Vector<String>();
                        switch (n2) {
                            case 1: {
                                vector.add("label");
                            }
                        }
                        vector.add((String)object);
                        if (!MultiChangeConfirmDlg.confirmChange(vector, DevicePipePanel.this.source.length, " for attribute " + string)) {
                            DevicePipePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating label");
                            }
                            for (int i = 0; i < DevicePipePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DevicePipePanel.this.source[i].getName() + "/label", ++n4 * 100 / n3);
                                DevicePipePanel.this.source[i].setLabel(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DevicePipePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.displayTable = new JTable(this.displayModel);
        this.displayTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.displayTable);
        this.descriptionModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DevicePipePanel.this.source.length;
                    int n4 = 0;
                    if (DevicePipePanel.this.source.length > 1) {
                        String string = (String)DevicePipePanel.this.descriptionModel.getValueAt(n, 0);
                        Vector<String> vector = new Vector<String>();
                        switch (n2) {
                            case 1: {
                                vector.add("description");
                            }
                        }
                        vector.add((String)object);
                        if (!MultiChangeConfirmDlg.confirmChange(vector, DevicePipePanel.this.source.length, " for attribute " + string)) {
                            DevicePipePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating description");
                            }
                            for (int i = 0; i < DevicePipePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DevicePipePanel.this.source[i].getName() + "/description", ++n4 * 100 / n3);
                                DevicePipePanel.this.source[i].setDescription(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DevicePipePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.descriptionTable = new JTable(this.descriptionModel);
        this.descriptionTable.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.descriptionTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Label", jScrollPane);
        this.tabPane.add("Description", jScrollPane2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(titledBorder);
        this.add((Component)this.tabPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        jPanel.add(this.applyButton);
        this.add((Component)jPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.resetMenuItem = new JMenuItem("Reset to default value");
        this.resetMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetMenuItem);
        this.resetLMenuItem = new JMenuItem("Return to lib default value");
        this.resetLMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetLMenuItem);
        this.resetULMenuItem = new JMenuItem("Return to code/lib default value");
        this.resetULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetULMenuItem);
        this.resetCULMenuItem = new JMenuItem("Return to class/code/lib default value");
        this.resetCULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetCULMenuItem);
        this.labelMenuItem = new JMenuItem("Set label");
        this.labelMenuItem.addActionListener(this);
        this.tableMenu.add(this.labelMenuItem);
        this.descriptionMenuItem = new JMenuItem("Set description");
        this.descriptionMenuItem.addActionListener(this);
        this.tableMenu.add(this.descriptionMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        this.selectedTable = (JTable)mouseEvent.getSource();
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && !JiveUtils.readOnly && (n = this.getRowForLocation(mouseEvent.getY())) != -1) {
            this.selectedTable.addRowSelectionInterval(n, n);
            this.selectedTable.setColumnSelectionInterval(0, this.selectedTable.getColumnCount() - 1);
            this.selectedRows = this.selectedTable.getSelectedRows();
            this.labelMenuItem.setVisible(false);
            this.descriptionMenuItem.setVisible(false);
            if (this.selectedTable == this.displayTable) {
                this.labelMenuItem.setVisible(true);
            } else if (this.selectedTable == this.descriptionTable) {
                this.descriptionMenuItem.setVisible(true);
            }
            this.resetLMenuItem.setVisible(true);
            this.resetULMenuItem.setVisible(true);
            this.resetCULMenuItem.setVisible(true);
            this.tableMenu.show(this.selectedTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refreshValue();
        } else if (object == this.resetMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n2 = 0;
            if (this.selectedTable == this.displayTable) {
                String string;
                int n3;
                if (this.source.length > 1 && (n3 = JOptionPane.showConfirmDialog(this, string = "You are going to reset label configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n3 = 0; n3 < this.selectedRows.length; ++n3) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n3], 0), ++n2 * 100 / n);
                        this.source[i].resetDisplay(this.selectedRows[n3]);
                    }
                    this.source[i].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n4;
                if (this.source.length > 1 && (n4 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n4 = 0; n4 < this.selectedRows.length; ++n4) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n4], 0), ++n2 * 100 / n);
                        this.source[i].resetDescription(this.selectedRows[n4]);
                    }
                    this.source[i].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.resetLMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n5 = 0;
            if (this.selectedTable == this.displayTable) {
                String string;
                int n6;
                if (this.source.length > 1 && (n6 = JOptionPane.showConfirmDialog(this, string = "You are going to reset label configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n6 = 0; n6 < this.selectedRows.length; ++n6) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n6], 0), ++n5 * 100 / n);
                        this.source[i].resetLDisplay(this.selectedRows[n6]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n7;
                if (this.source.length > 1 && (n7 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n7 = 0; n7 < this.selectedRows.length; ++n7) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n7], 0), ++n5 * 100 / n);
                        this.source[i].resetLDescription(this.selectedRows[n7]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.resetULMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n8 = 0;
            if (this.selectedTable == this.displayTable) {
                String string;
                int n9;
                if (this.source.length > 1 && (n9 = JOptionPane.showConfirmDialog(this, string = "You are going to reset label configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n9 = 0; n9 < this.selectedRows.length; ++n9) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n9], 0), ++n8 * 100 / n);
                        this.source[i].resetULDisplay(this.selectedRows[n9]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n10;
                if (this.source.length > 1 && (n10 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n10 = 0; n10 < this.selectedRows.length; ++n10) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n10], 0), ++n8 * 100 / n);
                        this.source[i].resetULDescription(this.selectedRows[n10]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.resetCULMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n11 = 0;
            if (this.selectedTable == this.displayTable) {
                String string;
                int n12;
                if (this.source.length > 1 && (n12 = JOptionPane.showConfirmDialog(this, string = "You are going to reset label configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n12 = 0; n12 < this.selectedRows.length; ++n12) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n12], 0), ++n11 * 100 / n);
                        this.source[i].resetCULDisplay(this.selectedRows[n12]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n13;
                if (this.source.length > 1 && (n13 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n13 = 0; n13 < this.selectedRows.length; ++n13) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n13], 0), ++n11 * 100 / n);
                        this.source[i].resetCULDescription(this.selectedRows[n13]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.labelMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter label", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n14 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("label");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating label");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[j], 0), ++n14 * 100 / n);
                    this.source[i].setLabel(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.descriptionMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter description", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n15 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("description");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating description");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[j], 0), ++n15 * 100 / n);
                    this.source[i].setDescription(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.applyButton) {
            String string;
            if (this.displayTable.isEditing()) {
                string = ((JTextField)this.displayTable.getEditorComponent()).getText();
                this.displayModel.setValueAt(string, this.displayTable.getEditingRow(), this.displayTable.getEditingColumn());
            }
            if (this.descriptionTable.isEditing()) {
                string = ((JTextField)this.descriptionTable.getEditorComponent()).getText();
                this.descriptionModel.setValueAt(string, this.descriptionTable.getEditingRow(), this.descriptionTable.getEditingColumn());
            }
        }
    }

    void setSource(TaskPipeNode[] taskPipeNodeArray) {
        this.source = taskPipeNodeArray;
        this.refreshValue();
    }

    private int getRowForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.selectedTable.getRowCount() && !bl) {
            bl = n >= n3 && n <= n3 + this.selectedTable.getRowHeight(n2);
            if (bl) continue;
            n3 += this.selectedTable.getRowHeight(n2);
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browsePipeInfo();
            Object[] objectArray = new String[]{"Attribute name", "Label"};
            Object[][] objectArray2 = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray2[i][0] = this.source[0].getAttName(i);
                objectArray2[i][1] = this.source[0].getLabel(i);
            }
            this.displayModel.setDataVector(objectArray2, objectArray);
            this.displayTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            Object[] objectArray3 = new String[]{"Attribute name", "Description"};
            Object[][] objectArray4 = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray4[i][0] = this.source[0].getAttName(i);
                objectArray4[i][1] = this.source[0].getDescription(i);
            }
            this.descriptionModel.setDataVector(objectArray4, objectArray3);
            this.descriptionTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            String string = this.source[0].getTitle();
            string = this.source.length == 1 ? string + " [" + this.source[0].getName() + "]" : string + " [" + this.source.length + " devices selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.tabPane.setBorder(titledBorder);
        }
    }
}

