/*
 * Decompiled with CFR 0.152.
 */
package jive;

import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.Clipboard;
import jive.DevWizard;
import jive.FindInfo;
import jive.JiveMenu;
import jive.RenameDlg;
import jive.ServerDlg;
import jive.TangoTreeNode;
import jive.ThreadDlg;

public class JiveUtils {
    public static int nbAction = 29;
    public static RenameDlg dlg = null;
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    public static String[] att_prop_default = new String[]{"description", "label", "unit", "standard_unit", "display_unit", "format", "min_value", "max_value", "min_alarm", "max_alarm"};
    public static String[] att_prop_default_idl3 = new String[]{"min_warning", "max_warning", "delta_t", "delta_val", "rel_change", "abs_change", "event_period", "archive_abs_change", "archive_rel_change", "archive_period"};
    public static String[] logging_level = new String[]{"OFF", "FATAL", "ERROR", "WARNING", "INFO", "DEBUG"};
    public static Clipboard the_clipboard = new Clipboard();
    public static Frame parent = null;
    public static MainPanel atkdlg = null;
    public static boolean error_report = true;
    public static boolean readOnly = false;
    public static FileWriter resFile = null;
    public static File lastFile = null;
    public static Vector savedClass = new Vector();
    public static Insets noMargin = new Insets(0, 0, 0, 0);
    public static boolean showSystemProperty = false;
    public static int scan_progress;
    public static Stack searchStack;
    public static String searchText;
    public static String searchTextValue;
    public static boolean searchIngoreCase;
    public static int searchValues;
    public static boolean searchAttributes;
    public static boolean searchCommands;
    public static boolean searchUseRegexp;
    public static boolean searchOnlyLeaf;
    public static TreePath searchResult;
    public static TreePath[] searchResults;
    public static ThreadDlg searchDlg;
    public static DeviceProxy hdbManager;
    public static boolean hdbEnabled;

    public static int isInsideArray(String string, String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length && !bl) {
            bl = stringArray[n].equalsIgnoreCase(string);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    public static int isInsideVector(String string, Vector vector) {
        boolean bl = false;
        int n = 0;
        while (n < vector.size() && !bl) {
            bl = ((String)vector.get(n)).equalsIgnoreCase(string);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    public static boolean IsPollCfgItem(String string) {
        if (showSystemProperty) {
            return false;
        }
        return string.equals("is_polled") || string.equals("polling_period") || string.equals("poll_old_factor") || string.equals("poll_ring_depth");
    }

    public static int IsAttCfgItem(String string, int n) {
        if (showSystemProperty) {
            return -1;
        }
        int n2 = JiveUtils.isInsideArray(string, att_prop_default);
        if (n2 < 0 && n >= 3 && (n2 = JiveUtils.isInsideArray(string, att_prop_default_idl3)) >= 0) {
            n2 += att_prop_default.length;
        }
        return n2;
    }

    public static boolean IsSystemItem(String string) {
        if (showSystemProperty) {
            return false;
        }
        return string.equals("polled_cmd") || string.equals("polled_attr") || string.equals("non_auto_polled_cmd") || string.equals("non_auto_polled_attr");
    }

    public static boolean IsLogCfgItem(String string) {
        if (showSystemProperty) {
            return false;
        }
        return string.equals("logging_level") || string.equals("logging_target") || string.equals("current_logging_level") || string.equals("current_logging_target") || string.equals("logging_rft") || string.equals("logging_path");
    }

    public static boolean IsHdbCfgItem(String string) {
        if (showSystemProperty) {
            return false;
        }
        return string.equals("is_archived") || string.equals("archiving_settings");
    }

    public static boolean IsAlarmCfgItem(String string) {
        if (showSystemProperty) {
            return false;
        }
        return string.equals("Alarms");
    }

    public static boolean IsEventCfgItem(String string) {
        if (showSystemProperty) {
            return false;
        }
        return string.equals("Archive Event") || string.equals("Change Event") || string.equals("Periodic Event");
    }

    public static boolean isSavedClass(String string) {
        return JiveUtils.isInsideVector(string, savedClass) >= 0;
    }

    public static void addSavedClass(String string) {
        savedClass.add(string);
    }

    public static void sortList(String[] stringArray) {
        boolean bl = false;
        int n = stringArray.length - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                boolean bl2 = false;
                int n2 = stringArray[i].compareToIgnoreCase(stringArray[i + 1]);
                boolean bl3 = bl2 = n2 > 0;
                if (!bl2) continue;
                String string = stringArray[i + 1];
                stringArray[i + 1] = stringArray[i];
                stringArray[i] = string;
                bl = false;
            }
            --n;
        }
    }

    public static void sortList(String[] stringArray, boolean[] blArray, int n) {
        int n2;
        boolean bl = false;
        int[] nArray = new int[stringArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            nArray[n2] = JiveUtils.IsSystemItem(stringArray[n2]) ? 0 : (JiveUtils.IsPollCfgItem(stringArray[n2]) ? 1 : (JiveUtils.IsAlarmCfgItem(stringArray[n2]) ? 2 : (JiveUtils.IsHdbCfgItem(stringArray[n2]) ? 3 : (JiveUtils.IsLogCfgItem(stringArray[n2]) ? 4 : (JiveUtils.IsAttCfgItem(stringArray[n2], n) >= 0 ? 5 : 6)))));
        }
        n2 = stringArray.length - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n2; ++i) {
                int n3;
                boolean bl2 = false;
                if (nArray[i] > nArray[i + 1]) {
                    bl2 = true;
                } else if (nArray[i] == nArray[i + 1]) {
                    n3 = stringArray[i].compareToIgnoreCase(stringArray[i + 1]);
                    boolean bl3 = bl2 = n3 > 0;
                }
                if (!bl2) continue;
                String string = stringArray[i + 1];
                stringArray[i + 1] = stringArray[i];
                stringArray[i] = string;
                int n4 = nArray[i + 1];
                nArray[i + 1] = nArray[i];
                nArray[i] = n4;
                if (blArray != null) {
                    n3 = blArray[i];
                    blArray[i] = blArray[i + 1];
                    blArray[i + 1] = n3;
                }
                bl = false;
            }
            --n2;
        }
    }

    public static String formatPath(TreePath treePath) {
        String string = "";
        if (treePath == null) {
            return string;
        }
        int n = treePath.getPathCount();
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        block28: for (int i = 1; i < n; ++i) {
            string = string + treePath.getPathComponent(i);
            if (i >= n - 1 && tangoTreeNode.isLeaf()) continue;
            switch (tangoTreeNode.type) {
                case 1: {
                    switch (i - 1) {
                        case 0: {
                            string = string + ":";
                            continue block28;
                        }
                        case 1: {
                            string = string + " ";
                            continue block28;
                        }
                        case 2: {
                            string = string + ":";
                            continue block28;
                        }
                        case 3: {
                            string = string + "/";
                            continue block28;
                        }
                    }
                    string = string + " ";
                    continue block28;
                }
                case 2: {
                    switch (i - 1) {
                        case 0: {
                            string = string + ":";
                            continue block28;
                        }
                        case 1: {
                            string = string + "/";
                            continue block28;
                        }
                        case 2: {
                            string = string + " CLASS:";
                            continue block28;
                        }
                    }
                    string = string + " ";
                    continue block28;
                }
                case 3: {
                    switch (i - 1) {
                        case 0: {
                            string = string + ":";
                            continue block28;
                        }
                        case 1: {
                            string = string + "/";
                            continue block28;
                        }
                        case 2: {
                            string = string + "/";
                            continue block28;
                        }
                        case 3: {
                            string = string + " ";
                            continue block28;
                        }
                        case 4: {
                            string = string + ":";
                            continue block28;
                        }
                        case 5: {
                            string = string + "/";
                            continue block28;
                        }
                    }
                    string = string + " ";
                    continue block28;
                }
                case 4: 
                case 5: {
                    switch (i - 1) {
                        case 0: {
                            string = string + ":";
                            continue block28;
                        }
                    }
                    string = string + " ";
                }
            }
        }
        return string;
    }

    public static boolean contains(String[] stringArray, String string) {
        return JiveUtils.isInsideArray(string, stringArray) >= 0;
    }

    public static boolean contains(int[] nArray, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length && !bl) {
            bl = nArray[n2] == n;
            if (bl) continue;
            ++n2;
        }
        return bl;
    }

    public static String stringArrayToString(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i];
                if (i + 1 >= stringArray.length) continue;
                string = string + "\n";
            }
        }
        return string;
    }

    public static String extractEndValue(String string) {
        int n = string.lastIndexOf(61);
        if (n != -1) {
            return string.substring(n + 2, string.length());
        }
        return "";
    }

    public static String[] extractPollingInfo(String string) {
        String[] stringArray = string.split("\n");
        String[] stringArray2 = new String[5];
        stringArray2[0] = stringArray[0].startsWith("Polled attribute") ? "attribute" : "command";
        stringArray2[1] = JiveUtils.extractEndValue(stringArray[0]);
        stringArray2[2] = JiveUtils.extractEndValue(stringArray[1]);
        stringArray2[3] = JiveUtils.extractEndValue(stringArray[2]);
        String string2 = "";
        for (int i = 3; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i] + "\n";
        }
        stringArray2[4] = string2;
        return stringArray2;
    }

    public static String[] makeStringArray(String string) {
        while (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.split("\n");
    }

    public static DbDatum[] makeDbDatum(String string, String string2) {
        String[] stringArray = JiveUtils.makeStringArray(string2);
        DbDatum[] dbDatumArray = new DbDatum[]{stringArray.length == 1 ? new DbDatum(string, stringArray[0]) : new DbDatum(string, stringArray)};
        return dbDatumArray;
    }

    public static String getPollingStatus(String string, String string2, String string3, int n) {
        String string4;
        block4: {
            string4 = null;
            int n2 = 0;
            try {
                DeviceProxy deviceProxy = new DeviceProxy(string);
                String[] stringArray = deviceProxy.polling_status();
                boolean bl = false;
                String[] stringArray2 = null;
                n2 = 0;
                while (n2 < stringArray.length && !bl) {
                    stringArray2 = JiveUtils.extractPollingInfo(stringArray[n2]);
                    bl = stringArray2[0].equalsIgnoreCase(string3) && stringArray2[1].equalsIgnoreCase(string2);
                    if (bl) continue;
                    ++n2;
                }
                if (!bl) break block4;
                string4 = stringArray2[n];
            }
            catch (DevFailed devFailed) {
                if (n != 4) break block4;
                string4 = "";
                for (n2 = 0; n2 < devFailed.errors.length; ++n2) {
                    string4 = string4 + "Desc -> " + devFailed.errors[n2].desc + "\n";
                    string4 = string4 + "Reason -> " + devFailed.errors[n2].reason + "\n";
                    string4 = string4 + "Origin -> " + devFailed.errors[n2].origin + "\n";
                }
            }
        }
        return string4;
    }

    public static void addPolling(String string, String string2, String string3, String string4) throws DevFailed {
        int n;
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            JiveUtils.showJiveError("Invalid polling period " + string + "/" + string2 + ":" + numberFormatException.toString());
            return;
        }
        DeviceProxy deviceProxy = new DeviceProxy(string);
        if (string3.equalsIgnoreCase("command")) {
            deviceProxy.poll_command(string2, n);
        } else {
            deviceProxy.poll_attribute(string2, n);
        }
    }

    public static void remPolling(String string, String string2, String string3) throws DevFailed {
        DeviceProxy deviceProxy = new DeviceProxy(string);
        if (string3.equalsIgnoreCase("command")) {
            deviceProxy.stop_poll_command(string2);
        } else {
            deviceProxy.stop_poll_attribute(string2);
        }
    }

    public static void copyClassProperties(Database database, String string) {
        try {
            String[] stringArray;
            int n;
            String[] stringArray2 = database.get_class_property_list(string, "*");
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray = database.get_class_property(string, stringArray2[n]).extractStringArray();
                the_clipboard.add(stringArray2[n], JiveUtils.stringArrayToString(stringArray));
            }
            stringArray2 = database.get_class_attribute_list(string, "*");
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray = new String[]{stringArray2[n]};
                DbAttribute[] dbAttributeArray = database.get_class_attribute_property(string, stringArray);
                if (dbAttributeArray.length <= 0) continue;
                String[] stringArray3 = dbAttributeArray[0].get_property_list();
                for (int i = 0; i < stringArray3.length; ++i) {
                    the_clipboard.add(stringArray3[i], stringArray2[n], dbAttributeArray[0].get_string_value(i));
                }
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public static String[] getLoggingStatus(Database database, String string, int n) {
        String[] stringArray = null;
        try {
            DbDevImportInfo dbDevImportInfo = database.import_device(string);
            String string2 = "dserver/" + dbDevImportInfo.server;
            DeviceData deviceData = new DeviceData();
            DeviceProxy deviceProxy = new DeviceProxy(string2);
            switch (n) {
                case 0: {
                    String[] stringArray2 = new String[]{string};
                    deviceData.insert(stringArray2);
                    DeviceData deviceData2 = deviceProxy.command_inout("GetLoggingLevel", deviceData);
                    DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
                    stringArray = new String[]{logging_level[devVarLongStringArray.lvalue[0]]};
                    return stringArray;
                }
                case 1: {
                    deviceData.insert(string);
                    DeviceData deviceData3 = deviceProxy.command_inout("GetLoggingTarget", deviceData);
                    stringArray = deviceData3.extractStringArray();
                    return stringArray;
                }
            }
            return null;
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return null;
        }
    }

    public static boolean setLoggingLevel(Database database, String string, String string2) {
        int n = JiveUtils.isInsideArray(string2, logging_level);
        if (n < 0) {
            String string3 = "Possible value are:";
            for (n = 0; n < logging_level.length; ++n) {
                string3 = string3 + " " + logging_level[n];
            }
            JiveUtils.showJiveError("Invalid logging level value.\n" + string3);
            return false;
        }
        try {
            DbDevImportInfo dbDevImportInfo = database.import_device(string);
            String string4 = "dserver/" + dbDevImportInfo.server;
            DeviceData deviceData = new DeviceData();
            DeviceProxy deviceProxy = new DeviceProxy(string4);
            int[] nArray = new int[1];
            String[] stringArray = new String[1];
            nArray[0] = n;
            stringArray[0] = string;
            DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray(nArray, stringArray);
            deviceData.insert(devVarLongStringArray);
            deviceProxy.command_inout("SetLoggingLevel", deviceData);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return false;
        }
        return true;
    }

    public static boolean setLoggingTarget(Database database, String string, String string2) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String[] stringArray = string2.split("\n");
        try {
            String[] stringArray2;
            int n;
            DbDevImportInfo dbDevImportInfo = database.import_device(string);
            String string3 = "dserver/" + dbDevImportInfo.server;
            DeviceProxy deviceProxy = new DeviceProxy(string3);
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = deviceProxy.command_inout("GetLoggingTarget", deviceData);
            String[] stringArray3 = deviceData2.extractStringArray();
            for (n = 0; n < stringArray3.length; ++n) {
                if (JiveUtils.contains(stringArray, stringArray3[n])) continue;
                vector2.add(stringArray3[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (JiveUtils.contains(stringArray3, stringArray[n]) || stringArray[n].length() <= 0) continue;
                vector.add(stringArray[n]);
            }
            if (vector2.size() > 0) {
                stringArray2 = new String[vector2.size() * 2];
                for (n = 0; n < vector2.size(); ++n) {
                    stringArray2[2 * n] = string;
                    stringArray2[2 * n + 1] = (String)vector2.get(n);
                }
                deviceData = new DeviceData();
                deviceData.insert(stringArray2);
                deviceProxy.command_inout("RemoveLoggingTarget", deviceData);
            }
            if (vector.size() > 0) {
                stringArray2 = new String[vector.size() * 2];
                for (n = 0; n < vector.size(); ++n) {
                    stringArray2[2 * n] = string;
                    stringArray2[2 * n + 1] = (String)vector.get(n);
                }
                deviceData = new DeviceData();
                deviceData.insert(stringArray2);
                deviceProxy.command_inout("AddLoggingTarget", deviceData);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return false;
        }
        return true;
    }

    public static boolean removeClassProperties(Database database, String string) {
        String string2 = "%";
        try {
            int n;
            String[] stringArray = database.get_class_property_list(string, "*");
            for (n = 0; n < stringArray.length; ++n) {
                database.delete_class_property(string, JiveUtils.makeDbDatum(stringArray[n], string2));
            }
            stringArray = database.get_class_attribute_list(string, "*");
            for (n = 0; n < stringArray.length; ++n) {
                String[] stringArray2 = new String[]{stringArray[n]};
                DbAttribute[] dbAttributeArray = database.get_class_attribute_property(string, stringArray2);
                if (dbAttributeArray.length <= 0) continue;
                String[] stringArray3 = dbAttributeArray[0].get_property_list();
                for (int i = 0; i < stringArray3.length; ++i) {
                    System.out.println("Removing: " + string + " ATT " + stringArray[n] + " PROP " + stringArray3[i]);
                    database.delete_class_attribute_property(string, stringArray[n], stringArray3[i]);
                }
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return false;
        }
        return true;
    }

    public static void copyDeviceProperties(Database database, String string) {
        try {
            String[] stringArray;
            int n;
            String[] stringArray2 = database.get_device_property_list(string, "*");
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray = database.get_device_property(string, stringArray2[n]).extractStringArray();
                the_clipboard.add(stringArray2[n], JiveUtils.stringArrayToString(stringArray));
            }
            stringArray2 = database.get_device_attribute_list(string);
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray = new String[]{stringArray2[n]};
                DbAttribute[] dbAttributeArray = database.get_device_attribute_property(string, stringArray);
                if (dbAttributeArray == null || dbAttributeArray.length <= 0) continue;
                String[] stringArray3 = dbAttributeArray[0].get_property_list();
                for (int i = 0; i < stringArray3.length; ++i) {
                    the_clipboard.add(stringArray3[i], stringArray2[n], dbAttributeArray[0].get_string_value(i));
                }
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public static boolean removeDeviceProperties(Database database, String string) {
        String string2 = "%";
        try {
            int n;
            String[] stringArray = database.get_device_property_list(string, "*");
            for (n = 0; n < stringArray.length; ++n) {
                database.delete_device_property(string, JiveUtils.makeDbDatum(stringArray[n], string2));
            }
            stringArray = database.get_device_attribute_list(string);
            for (n = 0; n < stringArray.length; ++n) {
                String[] stringArray2 = new String[]{stringArray[n]};
                DbAttribute[] dbAttributeArray = database.get_device_attribute_property(string, stringArray2);
                if (dbAttributeArray.length <= 0) continue;
                String[] stringArray3 = dbAttributeArray[0].get_property_list();
                for (int i = 0; i < stringArray3.length; ++i) {
                    DbAttribute dbAttribute = new DbAttribute(stringArray[n]);
                    dbAttribute.add(stringArray3[i], string2);
                    database.delete_device_attribute_property(string, dbAttribute);
                }
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return false;
        }
        return true;
    }

    public static String[] getValue(TreePath treePath) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        return tangoTreeNode.getValue();
    }

    public static boolean setValue(TreePath treePath, String string) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        return tangoTreeNode.setValue(string);
    }

    public static void showTangoError(DevFailed devFailed) {
        String string = "";
        if (error_report && devFailed != null) {
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string = string + "Desc -> " + devFailed.errors[i].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[i].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[i].origin + "\n";
            }
            if (string.length() > 0) {
                JOptionPane.showMessageDialog(parent, string, "Tango error", 0);
            }
        }
    }

    public static void printTangoError(DevFailed devFailed) {
        String string = "";
        if (devFailed != null) {
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string = string + " Desc -> " + devFailed.errors[i].desc + "\n";
                string = string + " Reason -> " + devFailed.errors[i].reason + "\n";
                string = string + " Origin -> " + devFailed.errors[i].origin + "\n";
            }
            System.out.println("Tango exception:");
            System.out.print(string);
        }
    }

    public static void showJiveError(String string) {
        if (error_report) {
            JOptionPane.showMessageDialog(parent, string, "Jive error", 0);
        }
    }

    public static void showJiveWarning(String string) {
        JOptionPane.showMessageDialog(parent, string, "Jive warning", 2);
    }

    public static FindInfo propertyExist(String string, DefaultTreeModel defaultTreeModel, TangoTreeNode tangoTreeNode) {
        int n = defaultTreeModel.getChildCount(tangoTreeNode);
        int n2 = 0;
        boolean bl = false;
        TangoTreeNode tangoTreeNode2 = null;
        while (n2 < n && !bl) {
            tangoTreeNode2 = (TangoTreeNode)defaultTreeModel.getChild(tangoTreeNode, n2);
            bl = tangoTreeNode2.toString().compareToIgnoreCase(string) == 0;
            if (bl) continue;
            ++n2;
        }
        return new FindInfo(n2, bl, tangoTreeNode2);
    }

    public static TreePath addProperty(String string, DefaultTreeModel defaultTreeModel, TreePath treePath, String string2, int n) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        FindInfo findInfo = JiveUtils.propertyExist(string, defaultTreeModel, tangoTreeNode);
        if (!findInfo.found) {
            TangoTreeNode tangoTreeNode2 = new TangoTreeNode(tangoTreeNode.level + 1, tangoTreeNode.type, string, tangoTreeNode.getDB(), true);
            defaultTreeModel.insertNodeInto(tangoTreeNode2, tangoTreeNode, n);
            TreePath treePath2 = treePath.pathByAddingChild(tangoTreeNode2);
            JiveUtils.setValue(treePath2, string2);
            return treePath2;
        }
        if (string.toLowerCase().startsWith("new property")) {
            int n2 = 2;
            FindInfo findInfo2 = JiveUtils.propertyExist("New property#" + n2, defaultTreeModel, tangoTreeNode);
            while (findInfo2.found) {
                findInfo2 = JiveUtils.propertyExist("New property#" + ++n2, defaultTreeModel, tangoTreeNode);
            }
            return JiveUtils.addProperty("New property#" + n2, defaultTreeModel, treePath, string2, n);
        }
        return findInfo.nodeFound.getCompletePath();
    }

    public static void removeProperty(DefaultTreeModel defaultTreeModel, TreePath treePath) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        if (JiveUtils.setValue(treePath, "%")) {
            defaultTreeModel.removeNodeFromParent(tangoTreeNode);
        }
    }

    public static TreePath convertOldPath(DefaultTreeModel defaultTreeModel, TangoTreeNode tangoTreeNode, TreePath treePath) {
        TreePath treePath2 = new TreePath(tangoTreeNode);
        if (treePath != null) {
            int n = treePath.getPathCount();
            int n2 = 1;
            boolean bl = false;
            TangoTreeNode tangoTreeNode2 = tangoTreeNode;
            while (!bl && n2 < n) {
                TangoTreeNode tangoTreeNode3 = (TangoTreeNode)treePath.getPathComponent(n2);
                FindInfo findInfo = JiveUtils.propertyExist(tangoTreeNode3.toString(), defaultTreeModel, tangoTreeNode2);
                bl = !findInfo.found;
                if (bl) continue;
                tangoTreeNode2 = (TangoTreeNode)defaultTreeModel.getChild(tangoTreeNode2, findInfo.index);
                treePath2 = treePath2.pathByAddingChild(tangoTreeNode2);
                ++n2;
            }
        }
        return treePath2;
    }

    public static void showServerDlg(ServerDlg serverDlg, TreePath treePath, DefaultTreeModel defaultTreeModel, JTree jTree) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        if (tangoTreeNode.level == 4) {
            treePath = treePath.getParentPath();
            tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        }
    }

    public static Rectangle computeBounds(JTree jTree, TreePath treePath) {
        jTree.scrollPathToVisible(treePath);
        Rectangle rectangle = jTree.getPathBounds(treePath);
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, jTree);
        rectangle.setLocation(point);
        rectangle.width += 20;
        rectangle.height += 2;
        return rectangle;
    }

    public static boolean rename(TreePath treePath, JTree jTree, DefaultTreeModel defaultTreeModel, Rectangle rectangle) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        TreePath treePath2 = null;
        boolean bl = false;
        boolean bl2 = false;
        dlg = new RenameDlg(parent, treePath.getLastPathComponent().toString(), rectangle);
        if (dlg.showDlg()) {
            String string = dlg.getNewName();
            FindInfo findInfo = JiveUtils.propertyExist(string, defaultTreeModel, (TangoTreeNode)tangoTreeNode.getParent());
            FindInfo findInfo2 = JiveUtils.propertyExist(tangoTreeNode.toString(), defaultTreeModel, (TangoTreeNode)tangoTreeNode.getParent());
            if (!findInfo.found || findInfo.index != findInfo2.index) {
                if (findInfo.found && findInfo.index != findInfo2.index) {
                    JiveUtils.showJiveError("Name already exists.");
                } else {
                    if (tangoTreeNode.type == 2 && tangoTreeNode.level == 2) {
                        Serializable serializable;
                        int n;
                        treePath2 = JiveUtils.addProperty(string, defaultTreeModel, treePath.getParentPath(), "", 0);
                        for (n = 0; n < tangoTreeNode.getChildCount(); ++n) {
                            serializable = JiveUtils.addProperty(tangoTreeNode.getChildAt(n).toString(), defaultTreeModel, treePath2, "", n);
                            for (int i = 0; i < tangoTreeNode.getChildAt(n).getChildCount(); ++i) {
                                TreePath treePath3 = JiveUtils.addProperty(tangoTreeNode.getChildAt(n).getChildAt(i).toString(), defaultTreeModel, (TreePath)serializable, "", i);
                                for (int j = 0; j < tangoTreeNode.getChildAt(n).getChildAt(i).getChildCount(); ++j) {
                                    JiveUtils.addProperty(tangoTreeNode.getChildAt(n).getChildAt(i).getChildAt(j).toString(), defaultTreeModel, treePath3, "", j);
                                }
                            }
                        }
                        for (n = 0; n < tangoTreeNode.getChildCount(); ++n) {
                            serializable = (TangoTreeNode)tangoTreeNode.getChildAt(n);
                            ((DefaultMutableTreeNode)serializable).removeAllChildren();
                            JiveUtils.removeProperty(defaultTreeModel, ((TangoTreeNode)serializable).getCompletePath());
                        }
                        JiveUtils.removeProperty(defaultTreeModel, treePath);
                    } else if (tangoTreeNode.type == 2 && tangoTreeNode.level == 3) {
                        Serializable serializable;
                        int n;
                        treePath2 = JiveUtils.addProperty(string, defaultTreeModel, treePath.getParentPath(), "", 0);
                        for (n = 0; n < tangoTreeNode.getChildCount(); ++n) {
                            serializable = JiveUtils.addProperty(tangoTreeNode.getChildAt(n).toString(), defaultTreeModel, treePath2, "", n);
                            for (int i = 0; i < tangoTreeNode.getChildAt(n).getChildCount(); ++i) {
                                JiveUtils.addProperty(tangoTreeNode.getChildAt(n).getChildAt(i).toString(), defaultTreeModel, (TreePath)serializable, "", i);
                            }
                        }
                        for (n = 0; n < tangoTreeNode.getChildCount(); ++n) {
                            serializable = (TangoTreeNode)tangoTreeNode.getChildAt(n);
                            ((DefaultMutableTreeNode)serializable).removeAllChildren();
                            JiveUtils.removeProperty(defaultTreeModel, ((TangoTreeNode)serializable).getCompletePath());
                        }
                        JiveUtils.removeProperty(defaultTreeModel, treePath);
                    } else if (tangoTreeNode.type == 2 && tangoTreeNode.level == 4) {
                        try {
                            DbServer dbServer = new DbServer(tangoTreeNode.getParent().getParent().toString() + "/" + tangoTreeNode.getParent().toString());
                            String[] stringArray = dbServer.get_device_name(tangoTreeNode.toString());
                            treePath2 = JiveUtils.addProperty(dlg.getNewName(), defaultTreeModel, treePath.getParentPath(), "", findInfo2.index);
                            if (treePath2 != null) {
                                for (int i = 0; i < stringArray.length; ++i) {
                                    JiveUtils.addProperty(stringArray[i], defaultTreeModel, treePath2, "", findInfo2.index);
                                }
                            }
                            tangoTreeNode.removeAllChildren();
                            JiveUtils.removeProperty(defaultTreeModel, treePath);
                        }
                        catch (DevFailed devFailed) {
                            JiveUtils.showTangoError(devFailed);
                        }
                    } else if (tangoTreeNode.type == 2 && tangoTreeNode.level == 5) {
                        String string2 = dlg.getNewName();
                        try {
                            DbDevImportInfo dbDevImportInfo = tangoTreeNode.getDB().import_device(string2);
                            JiveUtils.showJiveError("The device " + string2 + " already exits.\nServer: " + dbDevImportInfo.server);
                        }
                        catch (DevFailed devFailed) {
                            try {
                                tangoTreeNode.getDB().add_device(string2, tangoTreeNode.getParent().toString(), tangoTreeNode.getParent().getParent().getParent().toString() + "/" + tangoTreeNode.getParent().getParent().toString());
                                DeviceProxy deviceProxy = null;
                                try {
                                    deviceProxy = new DeviceProxy(tangoTreeNode.toString());
                                    deviceProxy.ping();
                                    bl2 = true;
                                }
                                catch (DevFailed devFailed2) {
                                    // empty catch block
                                }
                                int n = JOptionPane.showConfirmDialog(parent, "Do you want to copy propeties of " + tangoTreeNode.toString() + " to " + string2 + " ?", "Confirm propety move", 0);
                                if (n == 0) {
                                    String[] stringArray;
                                    String[] stringArray2 = tangoTreeNode.getDB().get_device_property_list(tangoTreeNode.toString(), "*");
                                    if (stringArray2.length > 0) {
                                        stringArray = tangoTreeNode.getDB().get_device_property(tangoTreeNode.toString(), stringArray2);
                                        tangoTreeNode.getDB().put_device_property(string2, (DbDatum[])stringArray);
                                    }
                                    if (bl2) {
                                        try {
                                            stringArray = deviceProxy.get_attribute_list();
                                            if (stringArray.length > 0) {
                                                DbAttribute[] dbAttributeArray = tangoTreeNode.getDB().get_device_attribute_property(tangoTreeNode.toString(), stringArray);
                                                tangoTreeNode.getDB().put_device_attribute_property(string2, dbAttributeArray);
                                            }
                                        }
                                        catch (DevFailed devFailed3) {
                                            JiveUtils.showJiveError("Failed to copy attribute properties of " + tangoTreeNode.toString() + "\n" + devFailed3.errors[0].desc);
                                        }
                                    } else {
                                        JiveUtils.showJiveError("Cannot copy attribute properties of " + tangoTreeNode.toString() + "\nThe device is not alive.");
                                    }
                                }
                                if (!bl2) {
                                    JiveUtils.removeProperty(defaultTreeModel, treePath);
                                } else {
                                    JiveUtils.showJiveWarning("The old device " + tangoTreeNode.toString() + " is still alive and should be removed by hand.");
                                }
                                treePath2 = treePath.getParentPath();
                                bl = true;
                            }
                            catch (DevFailed devFailed4) {
                                JiveUtils.showTangoError(devFailed4);
                            }
                        }
                    } else {
                        String string3 = JiveUtils.getValue(treePath)[0];
                        JiveUtils.removeProperty(defaultTreeModel, treePath);
                        treePath2 = JiveUtils.addProperty(dlg.getNewName(), defaultTreeModel, treePath.getParentPath(), string3, findInfo2.index);
                    }
                    if (treePath2 != null) {
                        jTree.setSelectionPath(treePath2);
                        jTree.scrollPathToVisible(treePath2);
                    }
                }
            }
        }
        dlg = null;
        return bl;
    }

    public static void paste(TangoTreeNode tangoTreeNode) {
        try {
            DbAttribute dbAttribute;
            int n;
            String string;
            if (tangoTreeNode.type == 3 && tangoTreeNode.level == 5 && tangoTreeNode.toString().equals("PROPERTY")) {
                string = tangoTreeNode.getDevname(1);
                for (n = 0; n < the_clipboard.getObjectPropertyLength(); ++n) {
                    tangoTreeNode.getDB().put_device_property(string, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(n), the_clipboard.getObjectPropertyValue(n)));
                }
            }
            if (tangoTreeNode.type == 3 && tangoTreeNode.level == 5 && tangoTreeNode.toString().equals("ATTRIBUTE")) {
                string = tangoTreeNode.getDevname(1);
                for (n = 0; n < the_clipboard.getAttPropertyLength(); ++n) {
                    dbAttribute = new DbAttribute(the_clipboard.getAttName(n));
                    dbAttribute.add(the_clipboard.getAttPropertyName(n), the_clipboard.getAttPropertyValue(n));
                    tangoTreeNode.getDB().put_device_attribute_property(string, dbAttribute);
                }
            }
            if (tangoTreeNode.type == 3 && tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                string = tangoTreeNode.getDevname(2);
                for (n = 0; n < the_clipboard.getAttPropertyLength(); ++n) {
                    dbAttribute = new DbAttribute(tangoTreeNode.toString());
                    dbAttribute.add(the_clipboard.getAttPropertyName(n), the_clipboard.getAttPropertyValue(n));
                    tangoTreeNode.getDB().put_device_attribute_property(string, dbAttribute);
                }
            }
            if (tangoTreeNode.type == 1 && tangoTreeNode.level == 3 && tangoTreeNode.toString().equals("PROPERTY")) {
                string = tangoTreeNode.getParent().toString();
                for (n = 0; n < the_clipboard.getObjectPropertyLength(); ++n) {
                    tangoTreeNode.getDB().put_class_property(string, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(n), the_clipboard.getObjectPropertyValue(n)));
                }
            }
            if (tangoTreeNode.type == 4 && tangoTreeNode.level == 2) {
                string = tangoTreeNode.toString();
                for (n = 0; n < the_clipboard.getObjectPropertyLength(); ++n) {
                    tangoTreeNode.getDB().put_property(string, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(n), the_clipboard.getObjectPropertyValue(n)));
                }
            }
            if (tangoTreeNode.type == 1 && tangoTreeNode.level == 3 && tangoTreeNode.toString().equals("ATTRIBUTE")) {
                string = tangoTreeNode.getParent().toString();
                for (n = 0; n < the_clipboard.getAttPropertyLength(); ++n) {
                    dbAttribute = new DbAttribute(the_clipboard.getAttName(n));
                    dbAttribute.add(the_clipboard.getAttPropertyName(n), the_clipboard.getAttPropertyValue(n));
                    tangoTreeNode.getDB().put_class_attribute_property(string, dbAttribute);
                }
            }
            if (tangoTreeNode.type == 3 && tangoTreeNode.level == 4) {
                string = tangoTreeNode.getDevname(0);
                for (n = 0; n < the_clipboard.getObjectPropertyLength(); ++n) {
                    tangoTreeNode.getDB().put_device_property(string, JiveUtils.makeDbDatum(the_clipboard.getObjectPropertyName(n), the_clipboard.getObjectPropertyValue(n)));
                }
                for (n = 0; n < the_clipboard.getAttPropertyLength(); ++n) {
                    dbAttribute = new DbAttribute(the_clipboard.getAttName(n));
                    dbAttribute.add(the_clipboard.getAttPropertyName(n), the_clipboard.getAttPropertyValue(n));
                    tangoTreeNode.getDB().put_device_attribute_property(string, dbAttribute);
                }
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    static boolean execAction(int n, TreePath treePath, JTree jTree, DefaultTreeModel defaultTreeModel, Rectangle rectangle, int n2, int n3) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        TreePath treePath2 = null;
        TangoTreeNode tangoTreeNode2 = null;
        switch (n) {
            case 0: 
            case 1: {
                the_clipboard.clear();
            }
            case 101: {
                String string;
                if (tangoTreeNode.isLeaf() && tangoTreeNode.isCopiableItem()) {
                    string = JiveUtils.getValue(treePath)[0];
                    if (tangoTreeNode.type == 3 && tangoTreeNode.level == 6 || tangoTreeNode.type == 1 && tangoTreeNode.level == 4 || tangoTreeNode.type == 4 && tangoTreeNode.level == 3) {
                        the_clipboard.add(tangoTreeNode.toString(), string);
                    } else if (tangoTreeNode.level == 7 || tangoTreeNode.level == 5) {
                        the_clipboard.add(tangoTreeNode.toString(), tangoTreeNode.getParent().toString(), string);
                    } else if (tangoTreeNode.level == 8) {
                        the_clipboard.add(tangoTreeNode.toString(), tangoTreeNode.getParent().getParent().toString(), string);
                    }
                }
                if (tangoTreeNode.type == 3 && tangoTreeNode.level == 4) {
                    string = tangoTreeNode.getDevname(0);
                    JiveUtils.copyDeviceProperties(tangoTreeNode.getDB(), string);
                }
                if (tangoTreeNode.type == 1 && tangoTreeNode.level == 2) {
                    JiveUtils.copyClassProperties(tangoTreeNode.getDB(), tangoTreeNode.toString());
                }
                if (n != 0) break;
                JiveUtils.removeProperty(defaultTreeModel, treePath);
                break;
            }
            case 2: {
                JiveUtils.paste(tangoTreeNode);
                return true;
            }
            case 3: {
                if (JOptionPane.showConfirmDialog(parent, "Delete selection ?", "Confirm delete", 0) != 0) break;
                tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getParent();
                JiveUtils.removeProperty(defaultTreeModel, treePath);
                jTree.setSelectionPath(tangoTreeNode2.getCompletePath());
                break;
            }
            case 103: {
                JiveUtils.removeProperty(defaultTreeModel, treePath);
                break;
            }
            case 4: {
                String string = JOptionPane.showInputDialog(parent, "Enter device name", "Add device", 3);
                if (string == null || (treePath2 = JiveUtils.addProperty(string, defaultTreeModel, treePath, "", 0)) == null) break;
                jTree.setSelectionPath(treePath2);
                break;
            }
            case 5: {
                return true;
            }
            case 6: {
                Object object;
                if (tangoTreeNode.level == 1) {
                    object = JOptionPane.showInputDialog(parent, "Enter object name", "New property", 3);
                    treePath2 = JiveUtils.addProperty((String)object, defaultTreeModel, treePath, "", 0);
                    if (treePath2 != null) {
                        treePath2 = JiveUtils.addProperty("New property", defaultTreeModel, treePath2, "", 0);
                    }
                } else {
                    treePath2 = JiveUtils.addProperty("New property", defaultTreeModel, treePath, "", 0);
                }
                if (treePath2 == null) break;
                jTree.setSelectionPath(treePath2);
                object = JiveUtils.computeBounds(jTree, treePath2);
                JiveUtils.execAction(9, treePath2, jTree, defaultTreeModel, (Rectangle)object, 0, 1);
                break;
            }
            case 8: {
                return true;
            }
            case 9: {
                return JiveUtils.rename(treePath, jTree, defaultTreeModel, rectangle);
            }
            case 10: {
                String[] stringArray = new String[]{tangoTreeNode.isLeaf() ? tangoTreeNode.toString() : tangoTreeNode.getDevname(0)};
                System.out.println("Running AtkPanel " + stringArray[0]);
                atkdlg = new MainPanel(stringArray[0], false, true, !readOnly);
                break;
            }
            case 11: {
                String string = tangoTreeNode.isLeaf() ? tangoTreeNode.toString() : tangoTreeNode.getDevname(0);
                JiveMenu jiveMenu = new JiveMenu(parent);
                jiveMenu.showDlg(string);
                break;
            }
            case 12: {
                String string;
                if (tangoTreeNode.type == 3 && tangoTreeNode.level == 4) {
                    string = tangoTreeNode.getDevname(0);
                    int n4 = tangoTreeNode.getChildCount();
                    tangoTreeNode = (TangoTreeNode)tangoTreeNode.getChildAt(n4 - 3);
                    tangoTreeNode.editProperties("device:" + string);
                }
                if (tangoTreeNode.type == 3 && tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    string = tangoTreeNode.toString();
                    tangoTreeNode.editAttProperties("attribute:" + string);
                }
                if (tangoTreeNode.type == 1 && tangoTreeNode.level == 2) {
                    string = tangoTreeNode.toString();
                    tangoTreeNode.getChildCount();
                    tangoTreeNode = (TangoTreeNode)tangoTreeNode.getChildAt(0);
                    tangoTreeNode.editProperties("class:" + string);
                }
                if (tangoTreeNode.type == 1 && tangoTreeNode.level == 4 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    string = tangoTreeNode.toString();
                    tangoTreeNode.editProperties("attribute:" + string);
                }
                if (tangoTreeNode.type == 2 && tangoTreeNode.level == 5) {
                    string = tangoTreeNode.toString();
                    TangoTreeNode tangoTreeNode3 = (TangoTreeNode)treePath.getPathComponent(0);
                    TangoTreeNode tangoTreeNode4 = (TangoTreeNode)tangoTreeNode3.getChildAt(2);
                    TangoTreeNode tangoTreeNode5 = JiveUtils.findDeviceNode(tangoTreeNode4, string);
                    if (tangoTreeNode5 != null) {
                        int n5 = tangoTreeNode5.getChildCount();
                        tangoTreeNode5 = (TangoTreeNode)tangoTreeNode5.getChildAt(n5 - 3);
                        tangoTreeNode5.editProperties("device:" + string);
                    }
                }
                if (tangoTreeNode.type != 5 || tangoTreeNode.level != 2) break;
                JiveUtils.showJiveError("Edit properties from alias not yet supported");
                break;
            }
            case 13: {
                String string = "dserver/" + tangoTreeNode.getParent().toString() + "/" + tangoTreeNode.toString();
                JiveMenu jiveMenu = new JiveMenu(parent);
                jiveMenu.showDlg(string);
                break;
            }
            case 14: {
                String string = tangoTreeNode.getParent().toString() + "/" + tangoTreeNode.toString();
                int n6 = JOptionPane.showConfirmDialog(parent, "This will unexport all devices of " + string + "\n Do you want to continue ?", "Confirm unexport device", 0);
                if (n6 != 0) break;
                try {
                    tangoTreeNode.getDB().unexport_server(string);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
                break;
            }
            case 15: 
            case 115: {
                if (resFile == null && n2 == 0) {
                    int n7;
                    JFileChooser jFileChooser = new JFileChooser(".");
                    int n8 = 0;
                    if (lastFile != null) {
                        jFileChooser.setSelectedFile(lastFile);
                    }
                    if ((n7 = jFileChooser.showSaveDialog(parent)) == 0 && (lastFile = jFileChooser.getSelectedFile()) != null) {
                        if (lastFile.exists()) {
                            n8 = JOptionPane.showConfirmDialog(parent, "Do you want to overwrite " + lastFile.getName() + " ?", "Confirm overwrite", 0);
                        }
                        if (n8 == 0) {
                            try {
                                resFile = new FileWriter(lastFile.getAbsolutePath());
                                Date date = new Date(System.currentTimeMillis());
                                resFile.write("#\n# Resource backup , created " + date + "\n#\n\n");
                                savedClass.clear();
                            }
                            catch (IOException iOException) {
                                JiveUtils.showJiveError("Failed to create resource file !\n" + iOException.getMessage());
                            }
                        }
                    }
                }
                if (resFile == null) break;
                try {
                    tangoTreeNode.saveServerData(resFile);
                    if (n2 != n3 - 1) break;
                    resFile.close();
                    resFile = null;
                }
                catch (IOException iOException) {
                    JiveUtils.showJiveError("Failed to save resource file !\n" + iOException.getMessage());
                }
                break;
            }
            case 16: {
                String string;
                String string2 = JOptionPane.showInputDialog(parent, "Enter alias", "Define device alias", 3);
                if (tangoTreeNode.type == 3 && tangoTreeNode.level == 4) {
                    string = tangoTreeNode.getDevname(0);
                    try {
                        tangoTreeNode.getDB().put_device_alias(string, string2);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                }
                if (tangoTreeNode.type != 2 || tangoTreeNode.level != 4) break;
                string = tangoTreeNode.toString();
                try {
                    tangoTreeNode.getDB().put_device_alias(string, string2);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
                break;
            }
            case 17: {
                try {
                    String string = tangoTreeNode.getDevname(0);
                    DbDevImportInfo dbDevImportInfo = tangoTreeNode.getDB().import_device(string);
                    TangoTreeNode tangoTreeNode6 = (TangoTreeNode)treePath.getPathComponent(0);
                    TangoTreeNode tangoTreeNode7 = (TangoTreeNode)tangoTreeNode6.getChildAt(1);
                    TangoTreeNode tangoTreeNode8 = JiveUtils.findServerNode(tangoTreeNode7, dbDevImportInfo.server);
                    if (tangoTreeNode8 == null) break;
                    treePath2 = tangoTreeNode8.getCompletePath();
                    jTree.setSelectionPath(treePath2);
                    jTree.scrollPathToVisible(treePath2);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
                break;
            }
            case 18: {
                String string = tangoTreeNode.toString();
                TangoTreeNode tangoTreeNode9 = (TangoTreeNode)treePath.getPathComponent(0);
                TangoTreeNode tangoTreeNode10 = (TangoTreeNode)tangoTreeNode9.getChildAt(2);
                TangoTreeNode tangoTreeNode11 = JiveUtils.findDeviceNode(tangoTreeNode10, string);
                if (tangoTreeNode11 == null) break;
                treePath2 = tangoTreeNode11.getCompletePath();
                jTree.setSelectionPath(treePath2);
                jTree.scrollPathToVisible(treePath2);
                break;
            }
            case 19: {
                try {
                    String string = tangoTreeNode.type == 2 ? tangoTreeNode.toString() : tangoTreeNode.getDevname(0);
                    DbDevImportInfo dbDevImportInfo = tangoTreeNode.getDB().import_device(string);
                    DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
                    DeviceData deviceData = new DeviceData();
                    deviceData.insert(string);
                    deviceProxy.command_inout("DevRestart", deviceData);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
                return true;
            }
            case 20: {
                try {
                    DbAttribute dbAttribute;
                    String string;
                    if (tangoTreeNode.level == 7) {
                        string = tangoTreeNode.getDevname(3);
                        dbAttribute = new DbAttribute(tangoTreeNode.getParent().toString());
                    } else {
                        string = tangoTreeNode.getDevname(4);
                        dbAttribute = new DbAttribute(tangoTreeNode.getParent().getParent().toString());
                    }
                    dbAttribute.add(tangoTreeNode.toString(), "");
                    tangoTreeNode.getDB().delete_device_attribute_property(string, dbAttribute);
                    DbDevImportInfo dbDevImportInfo = tangoTreeNode.getDB().import_device(string);
                    DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
                    DeviceData deviceData = new DeviceData();
                    deviceData.insert(string);
                    deviceProxy.command_inout("DevRestart", deviceData);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
                return true;
            }
            case 21: {
                try {
                    String string = tangoTreeNode.getDevname(0);
                    DbDevImportInfo dbDevImportInfo = tangoTreeNode.getDB().import_device(string);
                    TangoTreeNode tangoTreeNode12 = (TangoTreeNode)treePath.getPathComponent(0);
                    TangoTreeNode tangoTreeNode13 = (TangoTreeNode)tangoTreeNode12.getChildAt(2);
                    TangoTreeNode tangoTreeNode14 = JiveUtils.findDeviceNode(tangoTreeNode13, "dserver/" + dbDevImportInfo.server);
                    if (tangoTreeNode14 == null) break;
                    treePath2 = tangoTreeNode14.getCompletePath();
                    jTree.setSelectionPath(treePath2);
                    jTree.scrollPathToVisible(treePath2);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                String string = JOptionPane.showInputDialog(parent, "Enter class attribute name", "", 3);
                treePath2 = JiveUtils.addProperty(string, defaultTreeModel, treePath, "", 0);
                if (treePath2 == null) break;
                jTree.setSelectionPath(treePath2);
                break;
            }
            case 24: {
                DevWizard devWizard = new DevWizard(parent);
                devWizard.showWizard(null);
                return true;
            }
            case 25: {
                DevWizard devWizard = new DevWizard(parent);
                devWizard.showClassesWizard(tangoTreeNode.getParent().toString() + "/" + tangoTreeNode.toString());
                return true;
            }
            case 26: {
                DevWizard devWizard = new DevWizard(parent);
                devWizard.showDevicesWizard(tangoTreeNode.getParent().getParent().toString() + "/" + tangoTreeNode.getParent().toString(), tangoTreeNode.toString());
                return true;
            }
            case 27: {
                DevWizard devWizard = new DevWizard(parent);
                devWizard.showDeviceWizard(tangoTreeNode.getParent().getParent().getParent().toString() + "/" + tangoTreeNode.getParent().getParent().toString(), tangoTreeNode.getParent().toString(), tangoTreeNode.toString());
                return true;
            }
        }
        return false;
    }

    public static TangoTreeNode findServerNode(TangoTreeNode tangoTreeNode, String string) {
        TangoTreeNode tangoTreeNode2 = null;
        String[] stringArray = string.split("/");
        if (stringArray.length != 2) {
            JiveUtils.showJiveError("Invalid server name:" + string);
            return null;
        }
        int n = tangoTreeNode.getChildCount();
        int n2 = 0;
        boolean bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            bl = stringArray[0].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            JiveUtils.showJiveError("Server not found:" + string);
            return null;
        }
        tangoTreeNode = tangoTreeNode2;
        n = tangoTreeNode.getChildCount();
        n2 = 0;
        bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            bl = stringArray[1].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            JiveUtils.showJiveError("Server not found:" + string);
            return null;
        }
        return tangoTreeNode2;
    }

    public static TangoTreeNode findDeviceNode(TangoTreeNode tangoTreeNode, String string) {
        TangoTreeNode tangoTreeNode2 = null;
        String[] stringArray = string.split("/");
        if (stringArray.length != 3) {
            JiveUtils.showJiveError("Invalid device name:" + string);
            return null;
        }
        int n = tangoTreeNode.getChildCount();
        int n2 = 0;
        boolean bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            bl = stringArray[0].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            JiveUtils.showJiveError("Device domain not found:" + stringArray[0]);
            return null;
        }
        tangoTreeNode = tangoTreeNode2;
        n = tangoTreeNode.getChildCount();
        n2 = 0;
        bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            bl = stringArray[1].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            JiveUtils.showJiveError("Device family not found:" + stringArray[1]);
            return null;
        }
        tangoTreeNode = tangoTreeNode2;
        n = tangoTreeNode.getChildCount();
        n2 = 0;
        bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            bl = stringArray[2].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            JiveUtils.showJiveError("Device member not found:" + stringArray[2]);
            return null;
        }
        return tangoTreeNode2;
    }

    public static void printFormatedRes(String string, String[] stringArray, FileWriter fileWriter) throws IOException {
        int n;
        Object[] objectArray;
        if (stringArray == null) {
            if (fileWriter != null) {
                fileWriter.write("\"\"");
            } else {
                System.out.print("\"\"");
            }
            return;
        }
        if (stringArray.length == 0) {
            if (fileWriter != null) {
                fileWriter.write("\"\"");
            } else {
                System.out.print("\"\"");
            }
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(10) != -1) {
                objectArray = JiveUtils.makeStringArray(stringArray[i]);
                for (n = 0; n < objectArray.length; ++n) {
                    vector.add(objectArray[n]);
                }
                continue;
            }
            vector.add(stringArray[i]);
        }
        objectArray = vector.toArray();
        int n3 = string.length();
        if (fileWriter != null) {
            fileWriter.write(string, 0, n3);
        } else {
            System.out.print(string);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            String string2 = (String)objectArray[n2];
            if (string2.length() == 0) {
                objectArray[n2] = new String("\"\"");
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n4 = stringBuffer.indexOf("\"");
            while (n4 != -1) {
                stringBuffer.insert(n4, "\\");
                n4 = stringBuffer.indexOf("\"", n4 + 2);
            }
            string2 = stringBuffer.toString();
            if (string2.indexOf(32) != -1 || string2.indexOf(47) != -1 || string2.indexOf(44) != -1 || string2.indexOf(34) != -1) {
                objectArray[n2] = new String("\"" + string2 + "\"");
            }
            for (n = 0; n2 > 0 && n < n3; ++n) {
                if (fileWriter != null) {
                    fileWriter.write(32);
                    continue;
                }
                System.out.print(" ");
            }
            String string3 = n2 < objectArray.length - 1 ? objectArray[n2] + ",\\ \n" : objectArray[n2] + "\n";
            if (fileWriter != null) {
                fileWriter.write(string3, 0, string3.length());
                continue;
            }
            System.out.print(string3.toString());
        }
    }

    public static String convertEventString(String string) {
        int n = string.indexOf(44);
        if (n != -1) {
            String[] stringArray = string.split(",");
            return stringArray[0] + "\n" + stringArray[1];
        }
        return string;
    }

    public static void InitiateSearch(TangoTreeNode tangoTreeNode, String string, String string2, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        searchStack = new Stack();
        searchStack.push(tangoTreeNode);
        searchIngoreCase = bl;
        searchValues = n;
        searchAttributes = bl2;
        searchCommands = bl3;
        searchUseRegexp = bl4;
        searchOnlyLeaf = bl5;
        searchText = string;
        searchTextValue = string2;
    }

    public static TreePath findText() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                searchResult = JiveUtils.findText_sub();
                searchDlg.hideDlg();
            }
        };
        searchResult = null;
        searchDlg = new ThreadDlg(parent, "Searching the database", false, thread);
        searchDlg.showDlg();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        thread = null;
        return searchResult;
    }

    public static TreePath[] findMultipleText() {
        boolean bl = false;
        Vector<TreePath> vector = new Vector<TreePath>();
        while (!bl) {
            searchResult = JiveUtils.findText_sub();
            if (searchResult != null) {
                vector.add(searchResult);
                continue;
            }
            bl = true;
        }
        if (vector.size() > 0 && !ThreadDlg.stopflag) {
            searchResults = new TreePath[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JiveUtils.searchResults[i] = (TreePath)vector.get(i);
            }
        } else {
            searchResults = null;
        }
        return searchResults;
    }

    public static TreePath findText_sub() {
        Pattern pattern = null;
        if (searchUseRegexp) {
            try {
                pattern = Pattern.compile(searchText);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                error_report = true;
                JiveUtils.showJiveError("Invalid regular expression\n" + patternSyntaxException.getDescription());
                return null;
            }
        }
        if (searchStack != null) {
            while (!searchStack.empty() && !ThreadDlg.stopflag) {
                boolean bl;
                TangoTreeNode tangoTreeNode = (TangoTreeNode)searchStack.pop();
                ++scan_progress;
                boolean bl2 = false;
                if (tangoTreeNode.isLeaf() || !searchOnlyLeaf) {
                    String string;
                    String string2;
                    if (searchIngoreCase) {
                        string2 = tangoTreeNode.toStringEx().toLowerCase();
                        string = searchText.toLowerCase();
                    } else {
                        string2 = tangoTreeNode.toStringEx();
                        string = searchText;
                    }
                    if (searchUseRegexp) {
                        bl2 = pattern.matcher(string2).matches();
                    } else {
                        boolean bl3 = bl2 = string2.indexOf(string) != -1;
                    }
                    if (bl2) {
                        if (searchValues == 0) {
                            return tangoTreeNode.getCompletePath();
                        }
                        if (searchIngoreCase) {
                            string2 = JiveUtils.getValue(new TreePath(tangoTreeNode))[0].toLowerCase();
                            string = searchTextValue.toLowerCase();
                        } else {
                            string2 = JiveUtils.getValue(new TreePath(tangoTreeNode))[0];
                            string = searchTextValue;
                        }
                        switch (searchValues) {
                            case 1: {
                                if (string2.compareTo(string) != 0) break;
                                return tangoTreeNode.getCompletePath();
                            }
                            case 2: {
                                if (string2.indexOf(string) == -1) break;
                                return tangoTreeNode.getCompletePath();
                            }
                        }
                    }
                }
                if (!(bl = !(tangoTreeNode.toString().equals("ATTRIBUTE") && !searchAttributes || tangoTreeNode.toString().equals("COMMAND") && !searchCommands))) continue;
                int n = tangoTreeNode.getChildCount();
                for (int i = n - 1; i >= 0; --i) {
                    searchStack.push(tangoTreeNode.getChildAt(i));
                }
            }
        }
        if (ThreadDlg.stopflag) {
            System.out.println("Search interrupted by user.");
        }
        return null;
    }

    public static void printAttInfo(AttributeInfoEx attributeInfoEx) {
        System.out.println("------- Attribute info -------");
        System.out.println("Name             :" + attributeInfoEx.name);
        System.out.println("Data format      :" + attributeInfoEx.data_format.value());
        System.out.println("Data type        :" + attributeInfoEx.data_type);
        System.out.println("Description      :" + attributeInfoEx.description);
        System.out.println("Display unit     :" + attributeInfoEx.display_unit);
        System.out.println("Std unit         :" + attributeInfoEx.standard_unit);
        System.out.println("Unit             :" + attributeInfoEx.unit);
        System.out.println("Format           :" + attributeInfoEx.format);
        System.out.println("Label            :" + attributeInfoEx.label);
        System.out.println("Disp level       :" + attributeInfoEx.level.value());
        System.out.println("Max alarm        :" + attributeInfoEx.max_alarm);
        System.out.println("Min alarm        :" + attributeInfoEx.min_alarm);
        System.out.println("Max value        :" + attributeInfoEx.max_value);
        System.out.println("Min value        :" + attributeInfoEx.min_value);
        System.out.println("Max DimX         :" + attributeInfoEx.max_dim_x);
        System.out.println("Max DimY         :" + attributeInfoEx.max_dim_y);
        System.out.println("Alarms.delta_t   :" + attributeInfoEx.alarms.delta_t);
        System.out.println("Alarms.delta_v   :" + attributeInfoEx.alarms.delta_val);
        System.out.println("Alarms.max       :" + attributeInfoEx.alarms.max_alarm);
        System.out.println("Alarms.min       :" + attributeInfoEx.alarms.min_alarm);
        System.out.println("Alarms.max_w     :" + attributeInfoEx.alarms.max_warning);
        System.out.println("Alarms.min_w     :" + attributeInfoEx.alarms.min_warning);
        System.out.println("ArchEvent.abs_ch :" + attributeInfoEx.events.arch_event.abs_change);
        System.out.println("ArchEvent.rel_ch :" + attributeInfoEx.events.arch_event.rel_change);
        System.out.println("ArchEvent.period :" + attributeInfoEx.events.arch_event.period);
        System.out.println("ChEvent.abs_ch   :" + attributeInfoEx.events.ch_event.abs_change);
        System.out.println("ChEvent.rel_ch   :" + attributeInfoEx.events.ch_event.rel_change);
        System.out.println("PerEvent.abs_ch  :" + attributeInfoEx.events.per_event.period);
    }

    public static boolean[] getAction(TreePath treePath) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        boolean[] blArray = new boolean[nbAction];
        for (int i = 0; i < nbAction; ++i) {
            blArray[i] = false;
        }
        switch (tangoTreeNode.type) {
            case 0: {
                blArray[7] = true;
                return blArray;
            }
            case 1: {
                if (tangoTreeNode.level == 2) {
                    blArray[0] = !readOnly;
                    blArray[1] = !readOnly;
                    blArray[3] = !readOnly;
                    blArray[12] = true;
                }
                if (tangoTreeNode.level == 2 || tangoTreeNode.level == 3) {
                    boolean bl = blArray[2] = !the_clipboard.empty() && !readOnly;
                }
                if (tangoTreeNode.level == 3 && tangoTreeNode.toString().equals("PROPERTY")) {
                    boolean bl = blArray[6] = !readOnly;
                }
                if (tangoTreeNode.level == 3 && tangoTreeNode.toString().equals("ATTRIBUTE")) {
                    boolean bl = blArray[23] = !readOnly;
                }
                if (tangoTreeNode.level == 4 && tangoTreeNode.getParent().toString().equals("PROPERTY")) {
                    blArray[0] = !readOnly;
                    blArray[1] = !readOnly;
                    blArray[3] = !readOnly;
                    boolean bl = blArray[9] = !readOnly;
                }
                if (tangoTreeNode.level == 4 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    blArray[12] = true;
                    boolean bl = blArray[6] = !readOnly;
                }
                if (tangoTreeNode.level != 5 || !tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                blArray[0] = !readOnly;
                blArray[1] = !readOnly;
                blArray[3] = !readOnly;
                blArray[9] = !readOnly;
                break;
            }
            case 2: {
                if (tangoTreeNode.level == 1) {
                    blArray[5] = !readOnly;
                    boolean bl = blArray[24] = !readOnly;
                }
                if (tangoTreeNode.level == 2) {
                    boolean bl = blArray[9] = !readOnly;
                }
                if (tangoTreeNode.level == 3) {
                    blArray[3] = !readOnly;
                    blArray[8] = !readOnly;
                    blArray[9] = !readOnly;
                    blArray[13] = true;
                    blArray[14] = !readOnly;
                    blArray[15] = true;
                    boolean bl = blArray[25] = !readOnly;
                }
                if (tangoTreeNode.level == 4) {
                    blArray[3] = !readOnly;
                    blArray[4] = !readOnly;
                    blArray[9] = !readOnly;
                    boolean bl = blArray[26] = !readOnly;
                }
                if (tangoTreeNode.level != 5) break;
                blArray[3] = !readOnly;
                blArray[9] = !readOnly;
                blArray[10] = true;
                blArray[11] = true;
                blArray[12] = true;
                blArray[16] = !readOnly;
                blArray[18] = true;
                blArray[19] = true;
                blArray[27] = !readOnly;
                break;
            }
            case 3: {
                if (tangoTreeNode.level == 4 || tangoTreeNode.level == 5) {
                    boolean bl = blArray[2] = !the_clipboard.empty() && !readOnly;
                }
                if (tangoTreeNode.level == 4) {
                    blArray[0] = !readOnly;
                    blArray[1] = !readOnly;
                    blArray[3] = !readOnly;
                    blArray[10] = true;
                    blArray[11] = true;
                    blArray[12] = true;
                    blArray[16] = !readOnly;
                    blArray[17] = true;
                    blArray[19] = true;
                    blArray[21] = true;
                }
                if (tangoTreeNode.level == 5 && tangoTreeNode.toString().equals("PROPERTY")) {
                    blArray[6] = !readOnly;
                    boolean bl = blArray[2] = !the_clipboard.empty() && !readOnly;
                }
                if (tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("PROPERTY")) {
                    blArray[0] = !tangoTreeNode.isSystemItem() && !tangoTreeNode.isPollCfgItem() && !readOnly;
                    blArray[1] = !tangoTreeNode.isSystemItem() && !readOnly;
                    blArray[3] = !tangoTreeNode.isSystemItem() && !tangoTreeNode.isPollCfgItem() && !readOnly;
                    boolean bl = blArray[9] = !tangoTreeNode.isSystemItem() && !tangoTreeNode.isPollCfgItem() && !readOnly;
                }
                if (tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    blArray[6] = !readOnly;
                    blArray[12] = true;
                    boolean bl = blArray[2] = !the_clipboard.empty() && !readOnly;
                }
                if (tangoTreeNode.level == 7 && tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE")) {
                    blArray[0] = !tangoTreeNode.isEventCfgItem() && !tangoTreeNode.isAlarmCfgItem() && !tangoTreeNode.isPollCfgItem() && !tangoTreeNode.isAttCfgItem() && !readOnly;
                    blArray[1] = !tangoTreeNode.isEventCfgItem() && !tangoTreeNode.isAlarmCfgItem() && !tangoTreeNode.isPollCfgItem() && !readOnly;
                    blArray[3] = !tangoTreeNode.isEventCfgItem() && !tangoTreeNode.isAlarmCfgItem() && !tangoTreeNode.isPollCfgItem() && !tangoTreeNode.isAttCfgItem() && !readOnly;
                    blArray[9] = !tangoTreeNode.isEventCfgItem() && !tangoTreeNode.isAlarmCfgItem() && !tangoTreeNode.isPollCfgItem() && !tangoTreeNode.isAttCfgItem() && !readOnly;
                    boolean bl = blArray[20] = tangoTreeNode.isAttCfgItem() && !readOnly;
                }
                if (tangoTreeNode.level != 8 || !tangoTreeNode.getParent().getParent().getParent().toString().equals("ATTRIBUTE")) break;
                blArray[1] = !readOnly;
                blArray[20] = tangoTreeNode.isAttCfgItem() && !readOnly;
                break;
            }
            case 4: {
                if (tangoTreeNode.level == 1) {
                    boolean bl = blArray[6] = !readOnly;
                }
                if (tangoTreeNode.level == 2) {
                    blArray[6] = !readOnly;
                    boolean bl = blArray[2] = !the_clipboard.empty() && !readOnly;
                }
                if (tangoTreeNode.level != 3) break;
                blArray[0] = !readOnly;
                blArray[1] = !readOnly;
                blArray[3] = !readOnly;
                blArray[9] = !readOnly;
                break;
            }
            case 5: {
                if (tangoTreeNode.level != 2) break;
                blArray[10] = true;
                blArray[11] = true;
                blArray[12] = true;
            }
        }
        return blArray;
    }

    public static void centerDialog(Dialog dialog, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (dialog.getParent() != null && dialog.getParent().isVisible()) {
            rectangle = dialog.getParent().getBounds();
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle.x = 0;
            rectangle.y = 0;
            rectangle.width = JiveUtils.screenSize.width;
            rectangle.height = JiveUtils.screenSize.height;
        }
        dialog.pack();
        Insets insets = dialog.getInsets();
        int n3 = n + (insets.right + insets.left);
        int n4 = n2 + (insets.bottom + insets.top);
        int n5 = rectangle.x + (rectangle.width - n3) / 2;
        int n6 = rectangle.y + (rectangle.height - n4) / 2;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 + n3 > JiveUtils.screenSize.width) {
            n5 = JiveUtils.screenSize.width - n3;
        }
        if (n6 + n4 > JiveUtils.screenSize.height) {
            n6 = JiveUtils.screenSize.height - n4;
        }
        dialog.setBounds(n5, n6, n3, n4);
    }

    public static void centerDialog(Dialog dialog) {
        dialog.pack();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (dialog.getParent() != null && dialog.getParent().isVisible()) {
            rectangle = dialog.getParent().getBounds();
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle.x = 0;
            rectangle.y = 0;
            rectangle.width = JiveUtils.screenSize.width;
            rectangle.height = JiveUtils.screenSize.height;
        }
        int n = dialog.getPreferredSize().width;
        int n2 = dialog.getPreferredSize().height;
        int n3 = rectangle.x + (rectangle.width - n) / 2;
        int n4 = rectangle.y + (rectangle.height - n2) / 2;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 + n > JiveUtils.screenSize.width) {
            n3 = JiveUtils.screenSize.width - n;
        }
        if (n4 + n2 > JiveUtils.screenSize.height) {
            n4 = JiveUtils.screenSize.height - n2;
        }
        dialog.setBounds(n3, n4, n, n2);
    }

    public static void centerFrameOnScreen(Frame frame) {
        Rectangle rectangle = new Rectangle(0, 0, JiveUtils.screenSize.width, JiveUtils.screenSize.height);
        frame.pack();
        int n = frame.getPreferredSize().width;
        int n2 = frame.getPreferredSize().height;
        int n3 = rectangle.x + (rectangle.width - n) / 2;
        int n4 = rectangle.y + (rectangle.height - n2) / 2;
        frame.setBounds(n3, n4, n, n2);
    }

    public static void centerFrameOnScreen(Frame frame, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, JiveUtils.screenSize.width, JiveUtils.screenSize.height);
        frame.pack();
        int n3 = n;
        int n4 = n2;
        int n5 = rectangle.x + (rectangle.width - n3) / 2;
        int n6 = rectangle.y + (rectangle.height - n4) / 2;
        frame.setBounds(n5, n6, n3, n4);
    }

    public static boolean isDeviceName(String string) {
        boolean bl;
        if (string.length() < 5 || string.contains(" ")) {
            return false;
        }
        String string2 = new String(string);
        if (string2.startsWith("tango:")) {
            string2 = string2.substring(6);
        }
        if (!(bl = Pattern.matches("//[a-zA-Z_0-9]+:[0-9]+/[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+", string2))) {
            bl = Pattern.matches("[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+/[[a-zA-Z_0-9\\.][-]]+", string2);
        }
        if (!bl) {
            bl = Pattern.matches("//[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+:[0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string2);
        }
        return bl;
    }

    public static boolean isFullServerName(String string) {
        return Pattern.matches("[a-zA-Z_0-9\\.[-]]+/[a-zA-Z_0-9\\.[-]]+", string);
    }

    public static String getPathAsText(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer();
        if (treePath == null) {
            stringBuffer.append("null");
        } else {
            for (int i = 0; i < treePath.getPathCount(); ++i) {
                stringBuffer.append(treePath.getPathComponent(i).toString());
                if (i == treePath.getPathCount() - 1) continue;
                stringBuffer.append("/");
            }
        }
        return stringBuffer.toString();
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        searchStack = null;
        hdbManager = null;
        hdbEnabled = false;
    }
}

