/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jive.DevWizard;
import jive.DevicePanel;
import jive.FinishPanel;
import jive.JiveUtils;
import jive.PropertyPanel;
import jive.WizardPanel;

class ClassPanel
extends WizardPanel {
    DeviceProxy adminDev;
    String[] allClasses = new String[0];
    JList classList;
    JScrollPane classView;
    String serverName;

    public ClassPanel(DevWizard devWizard, String string, DeviceProxy deviceProxy) {
        this.setLayout(null);
        this.parent = devWizard;
        this.adminDev = deviceProxy;
        this.serverName = string;
        try {
            DeviceData deviceData = this.adminDev.command_inout("QueryClass");
            this.allClasses = deviceData.extractStringArray();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        this.classList = new JList<String>(this.allClasses);
        this.classList.setBorder(null);
        this.classList.setFont(DevWizard.wizFont);
        this.classView = new JScrollPane(this.classList);
        this.classView.setBounds(0, 0, 350, 95);
        this.add(this.classView);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/class_wz.gif"));
    }

    @Override
    public String getTitle() {
        return "Class Selection";
    }

    @Override
    public String getDescription() {
        if (this.allClasses.length == 0) {
            return "Sorry, but the server has no class...\nThe Wizard cannot continue.";
        }
        return "The server has been succesfully started and has " + Integer.toString(this.allClasses.length) + " class(es) . Keep in mind that modifying exiting class property may affect other running server.\n" + "Click [Edit Class] to edit properties of the selected class\n" + "Click [Declare device] to continue with device declaration.";
    }

    @Override
    public String getSubTitle() {
        String string = "Server:\n" + this.serverName;
        return string;
    }

    @Override
    public boolean getNextState() {
        return this.allClasses.length > 0;
    }

    @Override
    public boolean next() {
        Object object;
        int n = this.classList.getSelectedIndex();
        if (n < 0) {
            JiveUtils.showJiveError("Please select a class first.");
            return false;
        }
        this.removeNextPanel();
        try {
            object = new DeviceData();
            object.insert(this.allClasses[n]);
            DeviceData deviceData = this.adminDev.command_inout("QueryWizardClassProperty", object);
            String[] stringArray = deviceData.extractStringArray();
            for (int i = 0; i < stringArray.length; i += 3) {
                this.parent.addPanel(new PropertyPanel(this.parent, 0, this.serverName, this.allClasses[n], stringArray[i], stringArray[i + 1], stringArray[i + 2], null));
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        object = new DevicePanel(this.parent, this.serverName, this.allClasses[n]);
        this.parent.addPanel((WizardPanel)object);
        this.parent.addPanel(new FinishPanel(this.parent, this.serverName, this, (WizardPanel)object));
        return true;
    }

    @Override
    public boolean getSkipState() {
        return this.allClasses.length > 0;
    }

    @Override
    public boolean skip() {
        int n = this.classList.getSelectedIndex();
        if (n < 0) {
            JiveUtils.showJiveError("Please select a class first.");
            return false;
        }
        this.removeNextPanel();
        DevicePanel devicePanel = new DevicePanel(this.parent, this.serverName, this.allClasses[n]);
        this.parent.addPanel(devicePanel);
        this.parent.addPanel(new FinishPanel(this.parent, this.serverName, this, devicePanel));
        return true;
    }

    @Override
    public String getSkipText() {
        return "Declare device";
    }

    @Override
    public String getNextText() {
        return "Edit Class";
    }

    @Override
    public boolean back() {
        return true;
    }
}

