/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.ValueMapTableModel;
import fr.esrf.tangoatk.widget.util.jdraw.ValueMapTableMouseListener;
import fr.esrf.tangoatk.widget.util.jdraw.ValueMapTableRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

class JDValueMappingPanel
extends JPanel
implements ActionListener {
    JDObject[] allObjects;
    JComponent invoker;
    String propName;
    private JDValueProgram theMapper;
    private JPanel modePanel;
    private JLabel modeLabel;
    private JComboBox modelCombo;
    private JPanel tablePanel;
    private ValueMapTableModel tableModel;
    private JScrollPane tableView;
    private JTable theTable = null;
    private JLabel defaultValueLabel;
    private JTextField defaultValueText;
    private JButton defaultValueBtn;
    private JPanel linearPanel;
    private JLabel maxValueLabel;
    private JTextField maxValueText;
    private JLabel minValueLabel;
    private JTextField minValueText;
    private JButton newEntryBtn;
    private JButton removeEntryBtn;
    private JButton tangoStateBtn;
    private JButton applyBtn;
    private JButton cancelBtn;
    private boolean hasChanged;
    private boolean isUpdating;

    public JDValueMappingPanel(JDObject[] jDObjectArray, JComponent jComponent, String string, int n, JDValueProgram jDValueProgram) {
        this.allObjects = jDObjectArray;
        this.invoker = jComponent;
        this.hasChanged = false;
        this.isUpdating = false;
        this.propName = string;
        this.theMapper = jDValueProgram == null ? new JDValueProgram(n) : jDValueProgram.copy();
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.modePanel = new JPanel();
        this.modePanel.setLayout(null);
        this.modePanel.setBorder(JDUtils.createTitleBorder("Mapping mode for " + string));
        this.modeLabel = JDUtils.createLabel("Mode");
        this.modeLabel.setBounds(10, 20, 100, 25);
        this.modePanel.add(this.modeLabel);
        this.modelCombo = new JComboBox();
        this.modelCombo.setFont(JDUtils.labelFont);
        this.modelCombo.addItem("By table");
        this.modelCombo.addItem("Linear mapping");
        this.modelCombo.addItem("Restore value");
        this.modelCombo.addActionListener(this);
        this.modelCombo.setBounds(115, 20, 170, 25);
        this.modePanel.add(this.modelCombo);
        this.add(this.modePanel);
        this.modePanel.setBounds(5, 10, 295, 55);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(null);
        this.tablePanel.setBorder(JDUtils.createTitleBorder("Correspondence table"));
        this.defaultValueLabel = JDUtils.createLabel("Default mapped value");
        this.defaultValueLabel.setBounds(10, 20, 120, 25);
        this.tablePanel.add(this.defaultValueLabel);
        this.defaultValueText = new JTextField();
        this.defaultValueText.setMargin(JDUtils.zMargin);
        this.defaultValueText.setText(this.theMapper.getDefaultMapping());
        this.defaultValueText.setBounds(140, 20, 115, 25);
        this.defaultValueText.addActionListener(this);
        this.tablePanel.add(this.defaultValueText);
        this.defaultValueBtn = JDUtils.createSetButton(this);
        this.defaultValueBtn.setBounds(260, 20, 25, 25);
        this.tablePanel.add(this.defaultValueBtn);
        if (this.theMapper.getType() == 2) {
            this.defaultValueBtn.setBackground(this.theMapper.getDefaultColorMapping());
        }
        this.tableModel = new ValueMapTableModel(this);
        this.updateRows();
        this.theTable = new JTable(this.tableModel);
        this.theTable.setRowHeight(20);
        TableCellRenderer tableCellRenderer = this.theTable.getDefaultRenderer(JButton.class);
        this.theTable.setDefaultRenderer(JButton.class, new ValueMapTableRenderer(tableCellRenderer, this));
        this.theTable.addMouseListener(new ValueMapTableMouseListener(this));
        this.sizeTable();
        this.tableView = new JScrollPane(this.theTable);
        this.tableView.setBounds(10, 50, 275, 230);
        this.tablePanel.add(this.tableView);
        this.newEntryBtn = new JButton("New entry");
        this.newEntryBtn.setFont(JDUtils.labelFont);
        this.newEntryBtn.setMargin(new Insets(0, 0, 0, 0));
        this.newEntryBtn.setForeground(Color.BLACK);
        this.newEntryBtn.addActionListener(this);
        this.newEntryBtn.setBounds(10, 285, 80, 25);
        this.tablePanel.add(this.newEntryBtn);
        this.removeEntryBtn = new JButton("Remove");
        this.removeEntryBtn.setFont(JDUtils.labelFont);
        this.removeEntryBtn.setMargin(new Insets(0, 0, 0, 0));
        this.removeEntryBtn.setForeground(Color.BLACK);
        this.removeEntryBtn.addActionListener(this);
        this.removeEntryBtn.setBounds(100, 285, 80, 25);
        this.tablePanel.add(this.removeEntryBtn);
        this.tangoStateBtn = new JButton("Tango States");
        this.tangoStateBtn.setFont(JDUtils.labelFont);
        this.tangoStateBtn.setMargin(new Insets(0, 0, 0, 0));
        this.tangoStateBtn.setForeground(Color.BLACK);
        this.tangoStateBtn.addActionListener(this);
        this.tangoStateBtn.setBounds(190, 285, 95, 25);
        this.tablePanel.add(this.tangoStateBtn);
        this.tablePanel.setBounds(5, 75, 295, 320);
        this.add(this.tablePanel);
        this.linearPanel = new JPanel();
        this.linearPanel.setLayout(null);
        this.linearPanel.setBorder(JDUtils.createTitleBorder("Linear Mapping"));
        this.minValueLabel = JDUtils.createLabel("Convert min object value to");
        this.minValueLabel.setBounds(10, 20, 180, 25);
        this.linearPanel.add(this.minValueLabel);
        this.minValueText = new JTextField();
        this.minValueText.setMargin(JDUtils.zMargin);
        this.minValueText.setEditable(true);
        this.minValueText.setFont(JDUtils.labelFont);
        this.minValueText.setBounds(195, 20, 50, 24);
        this.minValueText.addActionListener(this);
        this.linearPanel.add(this.minValueText);
        this.maxValueLabel = JDUtils.createLabel("Convert max object value to");
        this.maxValueLabel.setBounds(10, 45, 180, 25);
        this.linearPanel.add(this.maxValueLabel);
        this.maxValueText = new JTextField();
        this.maxValueText.setMargin(JDUtils.zMargin);
        this.maxValueText.setEditable(true);
        this.maxValueText.setFont(JDUtils.labelFont);
        this.maxValueText.setBounds(195, 45, 50, 24);
        this.maxValueText.addActionListener(this);
        this.linearPanel.add(this.maxValueText);
        this.linearPanel.setBounds(5, 75, 295, 320);
        this.add(this.linearPanel);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setFont(JDUtils.labelFont);
        this.cancelBtn.setMargin(new Insets(0, 0, 0, 0));
        this.cancelBtn.setForeground(Color.BLACK);
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setBounds(217, 400, 80, 25);
        this.add(this.cancelBtn);
        this.applyBtn = new JButton("Apply");
        this.applyBtn.setFont(JDUtils.labelFont);
        this.applyBtn.setMargin(new Insets(0, 0, 0, 0));
        this.applyBtn.setForeground(Color.BLACK);
        this.applyBtn.addActionListener(this);
        this.applyBtn.setBounds(127, 400, 80, 25);
        this.add(this.applyBtn);
        this.refreshControls();
        this.setPreferredSize(new Dimension(304, 430));
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public JDValueProgram getMapper() {
        return this.theMapper;
    }

    public boolean setValueAt(String string, int n) {
        boolean bl = this.theMapper.setValueAt(n, string);
        if (bl) {
            this.updateRows();
            this.hasChanged = true;
        }
        return bl;
    }

    public boolean setMappingAt(String string, int n) {
        boolean bl = this.theMapper.setMappingAt(n, string);
        if (bl) {
            this.updateRows();
            this.hasChanged = true;
        }
        return bl;
    }

    JTable getTable() {
        return this.theTable;
    }

    public String getDescription() {
        return this.propName;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isUpdating) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.newEntryBtn) {
            this.theMapper.addNewEntry();
            this.hasChanged = true;
            this.updateRows();
        } else if (object == this.removeEntryBtn) {
            int n = this.theTable.getSelectedRow();
            if (n >= 0 && n < this.theMapper.getEntryNumber()) {
                this.theMapper.removeEntry(n);
                this.hasChanged = true;
            }
            this.updateRows();
        } else if (object == this.tangoStateBtn) {
            String string = new String();
            for (int i = 0; i < TangoConst.Tango_DevStateName.length; ++i) {
                string = string + Integer.toString(i) + " : " + TangoConst.Tango_DevStateName[i] + "\n";
            }
            JOptionPane.showMessageDialog(this, string, "Values of tango states", 1);
        } else if (object == this.defaultValueBtn) {
            switch (this.theMapper.getType()) {
                case 2: {
                    Color color = JColorChooser.showDialog(this.invoker, "Choose default color", this.theMapper.getDefaultColorMapping());
                    if (color != null) {
                        this.theMapper.setDefaultMapping(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                        this.defaultValueBtn.setBackground(color);
                        this.hasChanged = true;
                    }
                    this.defaultValueText.setText(this.theMapper.getDefaultMapping());
                    break;
                }
                case 3: {
                    boolean bl = this.theMapper.getDefaultBooleanMapping();
                    boolean bl2 = JDUtils.showBooleanDialog(this.invoker, "Choose default value", bl);
                    if (bl2 != bl) {
                        this.theMapper.setDefaultMapping(Boolean.toString(bl2));
                        this.hasChanged = true;
                    }
                    this.defaultValueText.setText(this.theMapper.getDefaultMapping());
                    break;
                }
                case 1: {
                    int n = this.theMapper.getDefaultIntegerMapping();
                    int n2 = JDUtils.showIntegerDialog(this.invoker, "Enter default value", n);
                    if (n2 != n) {
                        this.theMapper.setDefaultMapping(Integer.toString(n2));
                        this.hasChanged = true;
                    }
                    this.defaultValueText.setText(this.theMapper.getDefaultMapping());
                }
            }
        } else if (object == this.defaultValueText) {
            if (!this.theMapper.setDefaultMapping(this.defaultValueText.getText())) {
                JOptionPane.showMessageDialog(this.invoker, "Invalid default value syntax");
            } else {
                this.hasChanged = true;
            }
            this.defaultValueText.setText(this.theMapper.getDefaultMapping());
            this.defaultValueText.setCaretPosition(0);
            if (this.theMapper.getType() == 2) {
                this.defaultValueBtn.setBackground(this.theMapper.getDefaultColorMapping());
            }
        } else if (object == this.modelCombo) {
            int n = this.modelCombo.getSelectedIndex();
            if (n >= 0 && n <= 2) {
                if (this.theMapper.setMode(n)) {
                    this.hasChanged = true;
                } else {
                    JOptionPane.showMessageDialog(this.invoker, "This mode is not allowed for " + this.propName);
                }
            }
            this.refreshControls();
        } else if (object == this.minValueText) {
            try {
                int n = Integer.parseInt(this.minValueText.getText());
                this.theMapper.setMinLinearValue(n);
                this.hasChanged = true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.invoker, "Invalid number syntax for min value.");
            }
            this.refreshControls();
        } else if (object == this.maxValueText) {
            try {
                int n = Integer.parseInt(this.maxValueText.getText());
                this.theMapper.setMaxLinearValue(n);
                this.hasChanged = true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.invoker, "Invalid number syntax for max value.");
            }
            this.refreshControls();
        } else if (object == this.cancelBtn) {
            this.hasChanged = false;
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        } else if (object == this.applyBtn) {
            if (this.theTable.getCellEditor() != null) {
                this.theTable.getCellEditor().stopCellEditing();
            }
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        }
    }

    private void refreshControls() {
        this.isUpdating = true;
        int n = this.theMapper.getMode();
        this.modelCombo.setSelectedIndex(n);
        switch (n) {
            case 0: {
                this.linearPanel.setVisible(false);
                this.tablePanel.setVisible(true);
                break;
            }
            case 1: {
                this.linearPanel.setVisible(true);
                this.tablePanel.setVisible(false);
                this.minValueText.setText(Integer.toString(this.theMapper.getMinLinearMapping()));
                this.maxValueText.setText(Integer.toString(this.theMapper.getMaxLinearMapping()));
                this.minValueText.setCaretPosition(0);
                this.maxValueText.setCaretPosition(0);
                break;
            }
            case 2: {
                this.linearPanel.setVisible(false);
                this.tablePanel.setVisible(false);
            }
        }
        this.isUpdating = false;
    }

    private void sizeTable() {
        if (this.theTable != null) {
            this.theTable.getColumnModel().getColumn(0).setPreferredWidth(60);
            this.theTable.getColumnModel().getColumn(2).setPreferredWidth(30);
            this.theTable.getColumnModel().getColumn(2).setMaxWidth(30);
            this.theTable.setRowHeight(20);
        }
    }

    private void updateRows() {
        Object[][] objectArray = new Object[this.theMapper.getEntryNumber()][3];
        for (int i = 0; i < this.theMapper.getEntryNumber(); ++i) {
            objectArray[i][0] = this.theMapper.getValue(i);
            objectArray[i][1] = this.theMapper.getMapping(i);
            objectArray[i][2] = JDUtils.createSetButton(null);
        }
        this.tableModel.setRows(objectArray);
        this.sizeTable();
    }
}

