/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

class JDGlobalPanel
extends JPanel
implements ActionListener {
    private JLabel backgroundLabel;
    private JButton backgroundButton;
    private JButton dismissBtn;
    private JCheckBox resizeLabelFontCheck;
    private JCheckBox resizeLabelTextCheck;
    JDrawEditor invoker;

    public JDGlobalPanel(JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setForeground(JDUtils.labelColor);
        this.setFont(JDUtils.labelFont);
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(280, 184));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Colors"));
        jPanel.setBounds(5, 5, 270, 55);
        this.backgroundLabel = JDUtils.createLabel("Background");
        this.backgroundLabel.setBounds(10, 20, 180, 24);
        jPanel.add(this.backgroundLabel);
        this.backgroundButton = new JButton("");
        this.backgroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundButton.setBackground(this.invoker.getBackground());
        this.backgroundButton.setForeground(Color.BLACK);
        this.backgroundButton.addActionListener(this);
        this.backgroundButton.setBounds(200, 20, 60, 24);
        jPanel.add(this.backgroundButton);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Editor settings"));
        jPanel2.setBounds(5, 65, 270, 85);
        this.resizeLabelFontCheck = new JCheckBox("Resize label when changing font");
        this.resizeLabelFontCheck.setFont(JDUtils.labelFont);
        this.resizeLabelFontCheck.setForeground(JDUtils.labelColor);
        this.resizeLabelFontCheck.setBounds(10, 20, 250, 25);
        this.resizeLabelFontCheck.setSelected(this.invoker.resizeLabelOnFontChange);
        jPanel2.add(this.resizeLabelFontCheck);
        this.resizeLabelTextCheck = new JCheckBox("Resize label when changing text");
        this.resizeLabelTextCheck.setFont(JDUtils.labelFont);
        this.resizeLabelTextCheck.setForeground(JDUtils.labelColor);
        this.resizeLabelTextCheck.setBounds(10, 50, 250, 25);
        this.resizeLabelTextCheck.setSelected(this.invoker.resizeLabelOnTextChange);
        jPanel2.add(this.resizeLabelTextCheck);
        this.add(jPanel2);
        this.dismissBtn = new JButton("Dismiss");
        this.dismissBtn.setMargin(new Insets(0, 0, 0, 0));
        this.dismissBtn.setFont(JDUtils.labelFont);
        this.dismissBtn.addActionListener(this);
        this.dismissBtn.setBounds(192, 155, 80, 24);
        this.add(this.dismissBtn);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.backgroundButton) {
            Color color = JColorChooser.showDialog(this, "Choose background color", this.invoker.getBackground());
            if (color != null) {
                this.invoker.setBackground(color);
                this.backgroundButton.setBackground(color);
            }
        } else if (object == this.dismissBtn) {
            this.invoker.resizeLabelOnFontChange = this.resizeLabelFontCheck.isSelected();
            this.invoker.resizeLabelOnTextChange = this.resizeLabelTextCheck.isSelected();
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        }
    }
}

