/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.jdraw.JDEntityNode;
import fr.esrf.tangoatk.widget.util.jdraw.JDNode;
import fr.esrf.tangoatk.widget.util.jdraw.RootNode;
import fr.esrf.tangoatk.widget.util.jdraw.TestPanel;
import fr.esrf.tangoatk.widget.util.jdraw.TreeNodeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JDDeviceTree
extends JPanel
implements DragGestureListener,
DragSourceListener {
    public static final int NODE_ATTRIBUTE = 1;
    public static final int NODE_COMMAND = 2;
    static Database db;
    JTree tree;
    JScrollPane treeView;
    DefaultTreeModel treeModel;

    public JDDeviceTree() {
        try {
            db = ApiUtil.get_db_obj();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage(null, "Database", devFailed);
            return;
        }
        this.setLayout(new BorderLayout());
        this.createTree();
        this.add((Component)this.treeView, "Center");
    }

    private void createTree() {
        this.treeModel = new DefaultTreeModel(new RootNode());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TreeNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.tree);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 2, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JTree jTree = (JTree)dragGestureEvent.getComponent();
        TreePath treePath = jTree.getSelectionPath();
        if (treePath != null) {
            JDNode jDNode = (JDNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (jDNode.isLeaf()) {
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, (JDEntityNode)jDNode, this);
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 200;
        return dimension;
    }

    public static void main(String[] stringArray) {
        JDDeviceTree jDDeviceTree = new JDDeviceTree();
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        TestPanel testPanel = new TestPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jDDeviceTree, "Center");
        jPanel.add((Component)testPanel, "East");
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(jFrame);
        jFrame.setVisible(true);
    }
}

