/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class JDClipboard {
    private Vector objects = new Vector();
    Clipboard clipboard;
    private Vector clipboardListener = new Vector();
    static JDClipboard theClipboard = null;

    private JDClipboard() {
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    static JDClipboard getInstance() {
        if (theClipboard == null) {
            theClipboard = new JDClipboard();
        }
        return theClipboard;
    }

    public void addChangeListener(JDrawEditorListener jDrawEditorListener) {
        if (!this.clipboardListener.contains(jDrawEditorListener)) {
            this.clipboardListener.add(jDrawEditorListener);
        }
    }

    public void check() {
        this.load(false);
        for (int i = 0; i < this.clipboardListener.size(); ++i) {
            ((JDrawEditorListener)this.clipboardListener.get(i)).clipboardChanged();
        }
    }

    int size() {
        return this.objects.size();
    }

    void send(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JDFile v11 {\n");
        for (int i = 0; i < vector.size(); ++i) {
            ((JDObject)vector.get(i)).recordObject(stringBuffer, 1);
        }
        stringBuffer.append("}\n");
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        try {
            this.clipboard.setContents(stringSelection, null);
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("JDClipboard.send() : " + illegalStateException.getMessage());
            return;
        }
        this.check();
    }

    private void load(boolean bl) {
        block11: {
            String string;
            boolean bl2;
            Transferable transferable;
            this.objects.clear();
            try {
                transferable = this.clipboard.getContents(null);
            }
            catch (IllegalStateException illegalStateException) {
                if (bl) {
                    JOptionPane.showMessageDialog(null, "Clipboard not available.\n" + illegalStateException.getMessage());
                }
                System.out.println(illegalStateException.getMessage());
                return;
            }
            boolean bl3 = bl2 = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (!bl2) {
                return;
            }
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                if (bl) {
                    JOptionPane.showMessageDialog(null, "Invalid clipboard content.\n" + unsupportedFlavorException.getMessage());
                }
                System.out.println(unsupportedFlavorException.getMessage());
                return;
            }
            catch (IOException iOException) {
                if (bl) {
                    JOptionPane.showMessageDialog(null, "Invalid clipboard content.\n" + iOException.getMessage());
                }
                System.out.println(iOException.getMessage());
                return;
            }
            try {
                JDFileLoader jDFileLoader = new JDFileLoader(string.toString());
                this.objects = jDFileLoader.parseFile();
            }
            catch (IOException iOException) {
                if (!bl) break block11;
                JOptionPane.showMessageDialog(null, "Invalid clipboard content.\n" + iOException.getMessage());
            }
        }
    }

    JDObject get(int n) {
        return (JDObject)this.objects.get(n);
    }

    Vector getObjects() {
        return this.objects;
    }
}

