/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetEditorListener;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class NetEditorFrame
extends JFrame
implements NetEditorListener,
ActionListener {
    public static final int FILE_NEW = 1;
    public static final int FILE_LOAD = 2;
    public static final int FILE_SAVE = 3;
    public static final int FILE_SAVEAS = 4;
    public static final int FILE_EXIT = 5;
    public static final int EDIT_UNDO = 1;
    public static final int EDIT_REDO = 2;
    public static final int EDIT_CUT = 3;
    public static final int EDIT_COPY = 4;
    public static final int EDIT_PASTE = 5;
    public static final int EDIT_DELETE = 6;
    public static final int EDIT_SELECT_ALL = 7;
    public static final int EDIT_SELECT_NONE = 8;
    public static final int OPTION_FIT = 1;
    public static final int OPTION_PREF = 2;
    public static final int TOOL_BUBBLE = 1;
    public static final int TOOL_LABEL = 2;
    public static final int TOOL_LINK = 3;
    public static final int TOOL_UNDO = 4;
    public static final int TOOL_REDO = 5;
    private String appRelease = "Network editor";
    private JScrollPane netView;
    private NetEditor netEditor;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemNew;
    private JMenuItem jMenuItemLoad;
    private JMenuItem jMenuItemSave;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemExit;
    private JMenu jMenuEdit;
    private JMenuItem jMenuItemUndo;
    private JMenuItem jMenuItemRedo;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemSelectAll;
    private JMenuItem jMenuItemSelectNone;
    private JMenu jMenuOptions;
    private JMenuItem jMenuItemFit;
    private JMenuItem jMenuItemPref;
    private JToolBar toolBar;
    private JButton bubbleBtn;
    private JButton labelBtn;
    private JButton linkBtn;
    private JButton undoBtn;
    private JButton redoBtn;
    private JLabel helpLabel;
    static final Insets bMargin = new Insets(3, 3, 3, 3);

    public NetEditorFrame() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(this.appRelease);
        this.netEditor = null;
        this.netView = null;
        this.jMenuFile = new JMenu();
        this.jMenuFile.setText("File");
        this.jMenuFile.setMnemonic('F');
        this.jMenuItemNew = NetUtils.createMenuItem("New", 0, 0, this);
        this.jMenuItemLoad = NetUtils.createMenuItem("Load file...", 0, 0, this);
        this.jMenuItemSave = NetUtils.createMenuItem("Save", 83, 2, this);
        this.jMenuItemSaveAs = NetUtils.createMenuItem("Save as...", 0, 0, this);
        this.jMenuItemExit = NetUtils.createMenuItem("Exit", 0, 0, this);
        this.jMenuFile.add(this.jMenuItemNew);
        this.jMenuFile.add(this.jMenuItemLoad);
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuFile.add(new JSeparator());
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuEdit = new JMenu();
        this.jMenuEdit.setText("Edit");
        this.jMenuEdit.setMnemonic('E');
        this.jMenuItemUndo = NetUtils.createMenuItem("Undo", 90, 2, this);
        this.jMenuItemRedo = NetUtils.createMenuItem("Redo", 90, 3, this);
        this.jMenuItemCut = NetUtils.createMenuItem("Cut", 88, 2, this);
        this.jMenuItemCopy = NetUtils.createMenuItem("Copy", 67, 2, this);
        this.jMenuItemPaste = NetUtils.createMenuItem("Paste", 86, 2, this);
        this.jMenuItemDelete = NetUtils.createMenuItem("Delete", 127, 0, this);
        this.jMenuItemSelectAll = NetUtils.createMenuItem("Select All", 65, 2, this);
        this.jMenuItemSelectNone = NetUtils.createMenuItem("Clear selection", 78, 2, this);
        this.jMenuEdit.add(this.jMenuItemUndo);
        this.jMenuEdit.add(this.jMenuItemRedo);
        this.jMenuEdit.add(new JSeparator());
        this.jMenuEdit.add(this.jMenuItemCut);
        this.jMenuEdit.add(this.jMenuItemCopy);
        this.jMenuEdit.add(this.jMenuItemPaste);
        this.jMenuEdit.add(this.jMenuItemDelete);
        this.jMenuEdit.add(new JSeparator());
        this.jMenuEdit.add(this.jMenuItemSelectAll);
        this.jMenuEdit.add(this.jMenuItemSelectNone);
        this.jMenuOptions = new JMenu();
        this.jMenuOptions.setText("Options");
        this.jMenuOptions.setMnemonic('O');
        this.jMenuItemFit = NetUtils.createMenuItem("Fit drawing area to scheme", 0, 0, this);
        this.jMenuItemPref = NetUtils.createMenuItem("Edit preferences ...", 0, 0, this);
        this.jMenuOptions.add(this.jMenuItemFit);
        this.jMenuOptions.add(this.jMenuItemPref);
        this.toolBar = new JToolBar();
        String string = "/fr/esrf/tangoatk/widget/util/interlock/gif/";
        this.bubbleBtn = this.createIconButton(string, "bubble", "Create a bubble object", this);
        this.toolBar.add(this.bubbleBtn);
        this.labelBtn = this.createIconButton(string, "label", "Create a label object", this);
        this.toolBar.add(this.labelBtn);
        this.toolBar.add(new JToolBar.Separator());
        this.linkBtn = this.createIconButton(string, "link", "Link an object to an other", this);
        this.toolBar.add(this.linkBtn);
        this.toolBar.add(new JToolBar.Separator());
        this.undoBtn = this.createIconButton(string, "undo", "Undo last action", this);
        this.toolBar.add(this.undoBtn);
        this.redoBtn = this.createIconButton(string, "redo", "Redo last action", this);
        this.toolBar.add(this.redoBtn);
        this.toolBar.setOrientation(1);
        this.helpLabel = new JLabel();
        this.helpLabel.setFont(new Font("Dialog", 0, 12));
        this.helpLabel.setText("");
        this.helpLabel.setPreferredSize(new Dimension(0, 16));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.jMenuFile);
        jMenuBar.add(this.jMenuEdit);
        jMenuBar.add(this.jMenuOptions);
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add((Component)this.toolBar, "West");
        this.getContentPane().add((Component)this.helpLabel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NetEditorFrame.this.exitApp();
            }
        });
    }

    public void setEditor(NetEditor netEditor) {
        this.netEditor = netEditor;
        this.netEditor.addEditorListener(this);
        this.netView = new JScrollPane(this.netEditor);
        this.netView.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().add((Component)this.netView, "Center");
        this.valueChanged(this.netEditor);
    }

    public void setAppTitle(String string) {
        this.appRelease = string;
    }

    public JMenu getFileMenu() {
        return this.jMenuFile;
    }

    public JMenuItem getFileMenuItem(int n) {
        switch (n) {
            case 1: {
                return this.jMenuItemNew;
            }
            case 2: {
                return this.jMenuItemLoad;
            }
            case 3: {
                return this.jMenuItemSave;
            }
            case 4: {
                return this.jMenuItemSaveAs;
            }
            case 5: {
                return this.jMenuItemExit;
            }
        }
        return null;
    }

    public JMenu getEditMenu() {
        return this.jMenuEdit;
    }

    public JMenuItem getEditMenuItem(int n) {
        switch (n) {
            case 1: {
                return this.jMenuItemUndo;
            }
            case 2: {
                return this.jMenuItemRedo;
            }
            case 3: {
                return this.jMenuItemCut;
            }
            case 4: {
                return this.jMenuItemCopy;
            }
            case 5: {
                return this.jMenuItemPaste;
            }
            case 6: {
                return this.jMenuItemDelete;
            }
            case 7: {
                return this.jMenuItemSelectAll;
            }
            case 8: {
                return this.jMenuItemSelectNone;
            }
        }
        return null;
    }

    public JMenu getOptionMenu() {
        return this.jMenuOptions;
    }

    public JMenuItem getOptionMenuItem(int n) {
        switch (n) {
            case 1: {
                return this.jMenuItemFit;
            }
            case 2: {
                return this.jMenuItemPref;
            }
        }
        return null;
    }

    public JToolBar getToolbar() {
        return this.toolBar;
    }

    public JButton getToobarButton(int n) {
        switch (n) {
            case 1: {
                return this.bubbleBtn;
            }
            case 2: {
                return this.labelBtn;
            }
            case 3: {
                return this.linkBtn;
            }
            case 4: {
                return this.undoBtn;
            }
            case 5: {
                return this.redoBtn;
            }
        }
        return null;
    }

    public void loadFile(String string) {
        try {
            this.netEditor.loadFile(string);
        }
        catch (IOException iOException) {
            this.netEditor.error("Error during reading file:" + string + "\n" + iOException.getMessage());
            this.netEditor.fireValueChanged();
        }
    }

    public JLabel getHelpLabel() {
        return this.helpLabel;
    }

    public JScrollPane getScrollPane() {
        return this.netView;
    }

    public void exitApp() {
        if (this.netEditor.getNeedToSaveState() && JOptionPane.showConfirmDialog(this, "Save before closing ?", "Exiting", 0) == 0) {
            this.netEditor.saveCurrent(".");
        }
        System.exit(0);
    }

    public JButton createIconButton(String string, String string2, String string3, ActionListener actionListener) {
        JButton jButton = new JButton();
        jButton.setIcon(new ImageIcon(this.getClass().getResource(string + string2 + "_btn_up.gif")));
        jButton.setPressedIcon(new ImageIcon(this.getClass().getResource(string + string2 + "_btn_down.gif")));
        jButton.setDisabledIcon(new ImageIcon(this.getClass().getResource(string + string2 + "_btn_dis.gif")));
        jButton.setMargin(bMargin);
        jButton.setBorder(null);
        jButton.setToolTipText(string3);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    @Override
    public void valueChanged(NetEditor netEditor) {
        String string = this.appRelease;
        if (netEditor.getFileName().length() > 0) {
            string = string + " [" + netEditor.getFileName() + "]";
        }
        if (netEditor.getNeedToSaveState()) {
            this.setTitle(string + "*");
        } else {
            this.setTitle(string);
        }
        this.jMenuItemUndo.setEnabled(netEditor.canUndo());
        this.undoBtn.setEnabled(netEditor.canUndo());
        this.jMenuItemUndo.setText("Undo " + netEditor.getUndoActionName());
        this.jMenuItemRedo.setEnabled(netEditor.canRedo());
        this.redoBtn.setEnabled(netEditor.canRedo());
        this.jMenuItemRedo.setText("Redo " + netEditor.getRedoActionName());
    }

    @Override
    public void objectClicked(NetEditor netEditor, NetObject netObject, MouseEvent mouseEvent) {
    }

    @Override
    public void linkClicked(NetEditor netEditor, NetObject netObject, int n, MouseEvent mouseEvent) {
    }

    @Override
    public void sizeChanged(NetEditor netEditor, Dimension dimension) {
        this.netView.revalidate();
        this.repaint();
    }

    @Override
    public void cancelCreate(NetEditor netEditor) {
        this.helpLabel.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jMenuItemNew) {
            this.netEditor.newAll();
        } else if (object == this.jMenuItemLoad) {
            this.netEditor.showOpenFileDialog(".", null);
        } else if (object == this.jMenuItemSave) {
            this.netEditor.saveCurrent(".");
        } else if (object == this.jMenuItemSaveAs) {
            this.netEditor.showSaveFileDialog(".", null);
        } else if (object == this.bubbleBtn) {
            this.netEditor.setCreateMode(1);
            this.helpLabel.setText("Bubble creation: Left click to create a bubble object, right click to cancel.");
        } else if (object == this.labelBtn) {
            this.netEditor.setCreateMode(3);
            this.helpLabel.setText("Label creation: Left click to create a label object, right click to cancel.");
        } else if (object == this.linkBtn) {
            this.netEditor.setCreateMode(4);
            this.helpLabel.setText("Link creation: Left click on fisrt object and drag the cursor up to the second object, right click to cancel.");
        } else if (object == this.jMenuItemDelete) {
            this.netEditor.deleteSelection();
        } else if (object == this.jMenuItemCopy) {
            this.netEditor.copySelection();
        } else if (object == this.jMenuItemPaste) {
            this.netEditor.pasteSelection();
        } else if (object == this.jMenuItemCut) {
            this.netEditor.cutSelection();
        } else if (object == this.jMenuItemSelectAll) {
            this.netEditor.selectAll();
            this.netEditor.repaint();
        } else if (object == this.jMenuItemSelectNone) {
            this.netEditor.unselectAll();
            this.netEditor.repaint();
        } else if (object == this.jMenuItemUndo || object == this.undoBtn) {
            this.netEditor.undo();
        } else if (object == this.jMenuItemRedo || object == this.redoBtn) {
            this.netEditor.redo();
        } else if (object == this.jMenuItemFit) {
            this.netEditor.computePreferredSize();
        } else if (object == this.jMenuItemPref) {
            this.netEditor.showOptionDialog();
        } else if (object == this.jMenuItemExit) {
            this.exitApp();
        }
    }

    public static void main(String[] stringArray) {
        NetEditorFrame netEditorFrame = new NetEditorFrame();
        NetEditor netEditor = new NetEditor(netEditorFrame);
        netEditorFrame.setEditor(netEditor);
        NetUtils.centerFrameOnScreen(netEditorFrame);
        netEditorFrame.setVisible(true);
    }
}

