/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import java.awt.Font;

public class StateStatusViewer
extends JAutoScrolledText
implements IDevStateScalarListener,
IStringScalarListener {
    private IDevStateScalar stateModel = null;
    private IStringScalar statusModel = null;
    private String currentState = new String("UNKNOWN");
    private String currentStatus = new String("UNKNOWN");

    public StateStatusViewer() {
        this.setBackground(ATKConstant.getColor4State(this.currentState));
        this.setOpaque(true);
        this.setText(this.currentStatus);
        this.setFont(new Font("Dialog", 0, 14));
    }

    public void setStateModel(IDevStateScalar iDevStateScalar) {
        if (this.stateModel != null) {
            this.stateModel.removeDevStateScalarListener((IDevStateScalarListener)this);
            this.stateModel = null;
            this.setToolTipText(null);
        }
        if (iDevStateScalar == null) {
            return;
        }
        this.stateModel = iDevStateScalar;
        iDevStateScalar.addDevStateScalarListener((IDevStateScalarListener)this);
        this.setToolTipText(iDevStateScalar.getName());
        this.setCurrentState(iDevStateScalar.getDeviceValue());
    }

    public IDevStateScalar getStateModel() {
        return this.stateModel;
    }

    public void setStatusModel(IStringScalar iStringScalar) {
        if (this.statusModel != null) {
            this.statusModel.removeStringScalarListener((IStringScalarListener)this);
            this.statusModel = null;
        }
        if (iStringScalar == null) {
            return;
        }
        this.statusModel = iStringScalar;
        this.statusModel.addStringScalarListener((IStringScalarListener)this);
        this.currentStatus = new String(this.statusModel.getStringDeviceValue());
        this.setText(this.currentStatus);
    }

    public IStringScalar getStatusModel() {
        return this.statusModel;
    }

    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        this.setCurrentState(devStateScalarEvent.getValue());
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.stateModel) {
            this.setCurrentState("UNKNOWN");
            return;
        }
        if (!this.currentStatus.equals("UNKNOWN")) {
            this.currentStatus = new String("UNKNOWN");
            this.setText(this.currentStatus);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void stringScalarChange(StringScalarEvent stringScalarEvent) {
        String string = stringScalarEvent.getValue();
        if (!string.equals(this.currentStatus)) {
            this.currentStatus = new String(string);
            this.setText(this.currentStatus);
        }
    }

    private void setCurrentState(String string) {
        if (!this.currentState.equals(string)) {
            this.currentState = new String(string);
            this.setBackground(ATKConstant.getColor4State(this.currentState));
        }
    }
}

