/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.DevStateScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.EnumScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleStateViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class ScalarListViewer
extends JPanel
implements JAutoScrolledTextListener {
    public static final String BOOLEAN_DEFAULT_SETTER = "None";
    public static final String BOOLEAN_COMBO_SETTER = "BooleanComboEditor";
    protected Vector<IAttribute> listModel = null;
    protected Vector<LabelViewer> scalarLabels = null;
    protected Vector<JComponent> scalarViewers = null;
    protected Vector<JComponent> scalarSetters = null;
    protected Vector<JButton> scalarPropButtons = null;
    protected SimplePropertyFrame propFrame = new SimplePropertyFrame();
    protected Font theFont = new Font("Dialog", 0, 12);
    private boolean labelVisible = true;
    private boolean setterVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String booleanSetterType = "None";
    private Color arrowColor = null;
    private String toolTipDisplay = "None";
    private boolean setterEnabled = true;
    private boolean noBorder = false;
    private String numberSetterType = "deprecated";
    private String stringSetterType = "deprecated";
    public static final String NUMBER_DEFAULT_SETTER = "WheelEditor";
    public static final String NUMBER_COMBO_SETTER = "ComboEditor";
    public static final String STRING_DEFAULT_SETTER = "StringScalarEditor";
    public static final String STRING_COMBO_SETTER = "StringComboEditor";
    public static final String TOOLTIP_DISPLAY_NONE = "None";
    public static final String TOOLTIP_DISPLAY_NAME_ONLY = "Name";
    public static final String TOOLTIP_DISPLAY_ALL = "All";

    public ScalarListViewer() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList attributeList) {
        if (this.listModel != null) {
            this.removeComponents();
            this.listModel = null;
        }
        if (attributeList == null) {
            return;
        }
        int n = attributeList.getSize();
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar) && !(object instanceof IStringScalar) && !(object instanceof IBooleanScalar) && !(object instanceof IEnumScalar) && !(object instanceof IDevStateScalar)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.initComponents(attributeList);
        this.setVisible(true);
    }

    protected void removeComponents() {
        IAttribute iAttribute = null;
        JComponent jComponent = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        SimpleEnumScalarViewer simpleEnumScalarViewer = null;
        SimpleStateViewer simpleStateViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        BooleanScalarComboEditor booleanScalarComboEditor = null;
        EnumScalarComboEditor enumScalarComboEditor = null;
        DevStateScalarComboEditor devStateScalarComboEditor = null;
        Object var22_15 = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            try {
                INumberScalar iNumberScalar = null;
                IStringScalar iStringScalar = null;
                IBooleanScalar iBooleanScalar = null;
                IEnumScalar iEnumScalar = null;
                IDevStateScalar iDevStateScalar = null;
                iAttribute = this.listModel.get(i);
                if (iAttribute instanceof INumberScalar) {
                    iNumberScalar = (INumberScalar)iAttribute;
                } else if (iAttribute instanceof IStringScalar) {
                    iStringScalar = (IStringScalar)iAttribute;
                } else if (iAttribute instanceof IBooleanScalar) {
                    iBooleanScalar = (IBooleanScalar)iAttribute;
                } else if (iAttribute instanceof IEnumScalar) {
                    iEnumScalar = (IEnumScalar)iAttribute;
                } else if (iAttribute instanceof IDevStateScalar) {
                    iDevStateScalar = (IDevStateScalar)iAttribute;
                }
                if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null && iEnumScalar == null && iDevStateScalar == null) continue;
                labelViewer = this.scalarLabels.get(i);
                labelViewer.setModel(null);
                jComponent = this.scalarViewers.get(i);
                if (jComponent instanceof SimpleScalarViewer) {
                    simpleScalarViewer = (SimpleScalarViewer)jComponent;
                    simpleScalarViewer.clearModel();
                } else if (jComponent instanceof BooleanScalarCheckBoxViewer) {
                    booleanScalarCheckBoxViewer = (BooleanScalarCheckBoxViewer)jComponent;
                    booleanScalarCheckBoxViewer.clearModel();
                } else if (jComponent instanceof SimpleEnumScalarViewer) {
                    simpleEnumScalarViewer = (SimpleEnumScalarViewer)jComponent;
                    simpleEnumScalarViewer.clearModel();
                } else if (jComponent instanceof SimpleStateViewer) {
                    simpleStateViewer = (SimpleStateViewer)jComponent;
                    simpleStateViewer.clearModel();
                }
                jComponent = this.scalarSetters.get(i);
                if (jComponent == null) continue;
                if (jComponent instanceof NumberScalarWheelEditor) {
                    numberScalarWheelEditor = (NumberScalarWheelEditor)jComponent;
                    if (iNumberScalar == null || !iNumberScalar.isWritable()) continue;
                    numberScalarWheelEditor.setModel(null);
                    continue;
                }
                if (jComponent instanceof NumberScalarComboEditor) {
                    numberScalarComboEditor = (NumberScalarComboEditor)jComponent;
                    if (iNumberScalar == null || !iNumberScalar.isWritable()) continue;
                    numberScalarComboEditor.setNumberModel(null);
                    continue;
                }
                if (jComponent instanceof StringScalarEditor) {
                    stringScalarEditor = (StringScalarEditor)jComponent;
                    if (iStringScalar == null || !iStringScalar.isWritable()) continue;
                    stringScalarEditor.setModel(null);
                    continue;
                }
                if (jComponent instanceof StringScalarComboEditor) {
                    stringScalarComboEditor = (StringScalarComboEditor)jComponent;
                    if (iStringScalar == null || !iStringScalar.isWritable()) continue;
                    stringScalarComboEditor.setStringModel(null);
                    continue;
                }
                if (jComponent instanceof BooleanScalarComboEditor) {
                    booleanScalarComboEditor = (BooleanScalarComboEditor)jComponent;
                    if (iBooleanScalar == null || !iBooleanScalar.isWritable()) continue;
                    booleanScalarComboEditor.setAttModel(null);
                    continue;
                }
                if (jComponent instanceof EnumScalarComboEditor) {
                    enumScalarComboEditor = (EnumScalarComboEditor)jComponent;
                    if (iEnumScalar == null || !iEnumScalar.isWritable()) continue;
                    enumScalarComboEditor.setEnumModel(null);
                    continue;
                }
                if (!(jComponent instanceof DevStateScalarComboEditor)) continue;
                devStateScalarComboEditor = (DevStateScalarComboEditor)jComponent;
                if (iDevStateScalar == null || !iDevStateScalar.isWritable()) continue;
                devStateScalarComboEditor.clearModel();
                continue;
            }
            catch (Exception exception) {
                System.out.println("ScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
            }
        }
        this.scalarLabels.removeAllElements();
        this.scalarViewers.removeAllElements();
        this.scalarSetters.removeAllElements();
        this.scalarPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.scalarLabels = null;
        this.scalarViewers = null;
        this.scalarSetters = null;
        this.scalarPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        LabelViewer labelViewer = null;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        JButton jButton = null;
        if (font != null) {
            this.theFont = font;
            if (this.listModel != null) {
                int n = this.listModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        labelViewer = this.scalarLabels.get(i);
                        labelViewer.setFont(this.theFont);
                        jComponent = this.scalarViewers.get(i);
                        if (jComponent != null && (jComponent instanceof SimpleScalarViewer || jComponent instanceof BooleanScalarCheckBoxViewer || jComponent instanceof SimpleEnumScalarViewer || jComponent instanceof SimpleStateViewer)) {
                            jComponent.setFont(this.theFont);
                        }
                        if ((jComponent2 = this.scalarSetters.get(i)) != null && (jComponent2 instanceof NumberScalarWheelEditor || jComponent2 instanceof NumberScalarComboEditor || jComponent2 instanceof StringScalarEditor || jComponent2 instanceof StringScalarComboEditor || jComponent2 instanceof BooleanScalarComboEditor || jComponent2 instanceof EnumScalarComboEditor || jComponent2 instanceof DevStateScalarComboEditor)) {
                            jComponent2.setFont(this.theFont);
                        }
                        jButton = this.scalarPropButtons.get(i);
                        jButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        if (this.labelVisible != bl) {
            this.labelVisible = bl;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        LabelViewer labelViewer = null;
        if (this.scalarLabels != null) {
            int n = this.scalarLabels.size();
            for (int i = 0; i < n; ++i) {
                try {
                    labelViewer = this.scalarLabels.get(i);
                    labelViewer.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeLabelVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getSetterVisible() {
        return this.setterVisible;
    }

    public void setSetterVisible(boolean bl) {
        if (this.setterVisible != bl) {
            this.setterVisible = bl;
            this.changeSetterVisibility();
        }
    }

    private void changeSetterVisibility() {
        JComponent jComponent = null;
        if (this.scalarSetters != null) {
            int n = this.scalarSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.scalarSetters.get(i);
                    if (jComponent == null || !(jComponent instanceof NumberScalarWheelEditor) && !(jComponent instanceof NumberScalarComboEditor) && !(jComponent instanceof StringScalarEditor) && !(jComponent instanceof StringScalarComboEditor) && !(jComponent instanceof BooleanScalarComboEditor) && !(jComponent instanceof EnumScalarComboEditor) && !(jComponent instanceof DevStateScalarComboEditor)) continue;
                    jComponent.setVisible(this.setterVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeSetterVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getSetterEnabled() {
        return this.setterEnabled;
    }

    public void setSetterEnabled(boolean bl) {
        int n;
        int n2;
        JComponent jComponent = null;
        if (this.setterEnabled == bl) {
            return;
        }
        this.setterEnabled = bl;
        if (this.scalarSetters != null) {
            n2 = this.scalarSetters.size();
            for (n = 0; n < n2; ++n) {
                try {
                    jComponent = this.scalarSetters.get(n);
                    if (jComponent == null || !(jComponent instanceof NumberScalarWheelEditor) && !(jComponent instanceof NumberScalarComboEditor) && !(jComponent instanceof StringScalarEditor) && !(jComponent instanceof StringScalarComboEditor) && !(jComponent instanceof BooleanScalarComboEditor) && !(jComponent instanceof EnumScalarComboEditor) && !(jComponent instanceof DevStateScalarComboEditor)) continue;
                    jComponent.setEnabled(bl);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : setSetterEnabled : Caught exception  " + exception.getMessage());
                }
            }
        }
        if (this.scalarViewers != null) {
            n2 = this.scalarViewers.size();
            for (n = 0; n < n2; ++n) {
                try {
                    jComponent = this.scalarViewers.get(n);
                    if (jComponent == null || !(jComponent instanceof BooleanScalarCheckBoxViewer)) continue;
                    jComponent.setEnabled(bl);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : setSetterEnabled : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean bl) {
        if (this.propertyButtonVisible != bl) {
            this.propertyButtonVisible = bl;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        JButton jButton = null;
        if (this.scalarPropButtons != null) {
            int n = this.scalarPropButtons.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jButton = this.scalarPropButtons.get(i);
                    jButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changePropButtonVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.unitVisible = bl;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        JComponent jComponent = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.scalarViewers.get(i);
                    if (jComponent instanceof SimpleScalarViewer) {
                        simpleScalarViewer = (SimpleScalarViewer)jComponent;
                        simpleScalarViewer.setUnitVisible(this.unitVisible);
                    }
                    if ((jComponent = this.scalarSetters.get(i)) == null || !(jComponent instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = (NumberScalarComboEditor)jComponent;
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeUnitVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getNoBorder() {
        return this.noBorder;
    }

    public void setNoBorder(boolean bl) {
        if (this.noBorder != bl) {
            this.noBorder = bl;
            this.changeBorder();
        }
    }

    private void changeBorder() {
        JComponent jComponent = null;
        SimpleScalarViewer simpleScalarViewer = null;
        Object var5_3 = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.scalarViewers.get(i);
                    if (!(jComponent instanceof SimpleScalarViewer)) continue;
                    simpleScalarViewer = (SimpleScalarViewer)jComponent;
                    if (this.noBorder) {
                        simpleScalarViewer.setBorder(BorderFactory.createEmptyBorder());
                        continue;
                    }
                    simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeBorder : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public String getBooleanSetterType() {
        return this.booleanSetterType;
    }

    public void setBooleanSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.booleanSetterType = string.equalsIgnoreCase("None") ? "None" : (string.equalsIgnoreCase(BOOLEAN_COMBO_SETTER) ? BOOLEAN_COMBO_SETTER : "None");
    }

    public String getToolTipDisplay() {
        return this.toolTipDisplay;
    }

    public void setToolTipDisplay(String string) {
        if (this.listModel != null) {
            return;
        }
        this.toolTipDisplay = string.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL) ? TOOLTIP_DISPLAY_ALL : (string.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY) ? TOOLTIP_DISPLAY_NAME_ONLY : "None");
    }

    public String getNumberSetterType() {
        return this.numberSetterType;
    }

    public void setNumberSetterType(String string) {
    }

    public String getStringSetterType() {
        return this.stringSetterType;
    }

    public void setStringSetterType(String string) {
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        if (color == this.arrowColor) {
            return;
        }
        this.changeArrowColors(color);
        this.arrowColor = color;
    }

    private void changeArrowColors(Color color) {
        JComponent jComponent = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        if (this.scalarSetters != null) {
            int n = this.scalarSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.scalarSetters.get(i);
                    if (!(jComponent instanceof NumberScalarWheelEditor)) continue;
                    numberScalarWheelEditor = (NumberScalarWheelEditor)jComponent;
                    if (color == null) {
                        numberScalarWheelEditor.setButtonColor(numberScalarWheelEditor.getBackground());
                        continue;
                    }
                    numberScalarWheelEditor.setButtonColor(color);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeArrowColors : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    @Override
    public void textExceedBounds(JAutoScrolledText jAutoScrolledText) {
        this.revalidate();
    }

    public void setCheckBoxStrings(IBooleanScalar iBooleanScalar, String string, String string2) {
        int n = -1;
        JComponent jComponent = null;
        if (iBooleanScalar == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        n = this.listModel.indexOf(iBooleanScalar);
        if (n < 0) {
            return;
        }
        jComponent = this.scalarViewers.get(n);
        if (jComponent == null) {
            return;
        }
        if (!(jComponent instanceof BooleanScalarCheckBoxViewer)) {
            return;
        }
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = (BooleanScalarCheckBoxViewer)jComponent;
        if (string == null) {
            booleanScalarCheckBoxViewer.setTrueLabel(new String());
        } else {
            booleanScalarCheckBoxViewer.setTrueLabel(string);
        }
        if (string2 == null) {
            booleanScalarCheckBoxViewer.setFalseLabel(new String());
        } else {
            booleanScalarCheckBoxViewer.setFalseLabel(string2);
        }
        this.revalidate();
    }

    protected void initComponents(AttributeList attributeList) {
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        SimpleEnumScalarViewer simpleEnumScalarViewer = null;
        SimpleStateViewer simpleStateViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        BooleanScalarComboEditor booleanScalarComboEditor = null;
        EnumScalarComboEditor enumScalarComboEditor = null;
        DevStateScalarComboEditor devStateScalarComboEditor = null;
        Object var26_14 = null;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        JButton jButton = null;
        this.listModel = new Vector();
        this.scalarLabels = new Vector();
        this.scalarViewers = new Vector();
        this.scalarSetters = new Vector();
        this.scalarPropButtons = new Vector();
        int n = 0;
        int n2 = attributeList.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Insets insets;
            int n4;
            Serializable serializable;
            labelViewer = null;
            jComponent = null;
            booleanScalarCheckBoxViewer = null;
            booleanScalarComboEditor = null;
            simpleEnumScalarViewer = null;
            enumScalarComboEditor = null;
            simpleScalarViewer = null;
            simpleStateViewer = null;
            numberScalarWheelEditor = null;
            numberScalarComboEditor = null;
            jComponent2 = null;
            stringScalarEditor = null;
            stringScalarComboEditor = null;
            enumScalarComboEditor = null;
            devStateScalarComboEditor = null;
            jButton = null;
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar) && !(object instanceof IBooleanScalar) && !(object instanceof IEnumScalar) && !(object instanceof IDevStateScalar) && !(object instanceof IStringScalar)) continue;
            INumberScalar iNumberScalar = null;
            IStringScalar iStringScalar = null;
            IBooleanScalar iBooleanScalar = null;
            IEnumScalar iEnumScalar = null;
            IDevStateScalar iDevStateScalar = null;
            if (object instanceof INumberScalar) {
                simpleScalarViewer = new SimpleScalarViewer();
                serializable = simpleScalarViewer.getMargin();
                ((Insets)serializable).left += 2;
                ((Insets)serializable).right += 2;
                simpleScalarViewer.setMargin((Insets)serializable);
                jComponent = simpleScalarViewer;
                iNumberScalar = (INumberScalar)object;
                boolean bl = false;
                if (iNumberScalar.getPossibleValues() != null && iNumberScalar.getPossibleValues().length > 0) {
                    bl = true;
                }
                if (bl) {
                    numberScalarComboEditor = new NumberScalarComboEditor();
                    numberScalarComboEditor.setFont(this.theFont);
                    numberScalarComboEditor.setBackground(this.getBackground());
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    if (iNumberScalar.isWritable()) {
                        numberScalarComboEditor.setNumberModel(iNumberScalar);
                        numberScalarComboEditor.setVisible(this.setterVisible);
                        numberScalarComboEditor.setEnabled(this.setterEnabled);
                        jComponent2 = numberScalarComboEditor;
                    } else {
                        jComponent2 = null;
                    }
                    this.scalarSetters.add(jComponent2);
                } else {
                    numberScalarWheelEditor = new NumberScalarWheelEditor();
                    numberScalarWheelEditor.setFont(this.theFont);
                    numberScalarWheelEditor.setBackground(this.getBackground());
                    if (iNumberScalar.isWritable()) {
                        numberScalarWheelEditor.setModel(iNumberScalar);
                        numberScalarWheelEditor.setVisible(this.setterVisible);
                        numberScalarWheelEditor.setEnabled(this.setterEnabled);
                        jComponent2 = numberScalarWheelEditor;
                    } else {
                        jComponent2 = null;
                    }
                    this.scalarSetters.add(jComponent2);
                }
            } else if (object instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)object;
                booleanScalarCheckBoxViewer = new BooleanScalarCheckBoxViewer();
                booleanScalarCheckBoxViewer.setTrueLabel(new String());
                booleanScalarCheckBoxViewer.setFalseLabel(new String());
                booleanScalarCheckBoxViewer.setEnabled(this.setterEnabled);
                jComponent = booleanScalarCheckBoxViewer;
                if (iBooleanScalar.isWritable()) {
                    if (this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) {
                        booleanScalarComboEditor = new BooleanScalarComboEditor();
                        booleanScalarComboEditor.setFont(this.theFont);
                        booleanScalarComboEditor.setBackground(this.getBackground());
                        booleanScalarComboEditor.setAttModel(iBooleanScalar);
                        booleanScalarComboEditor.setVisible(this.setterVisible);
                        booleanScalarComboEditor.setEnabled(this.setterEnabled);
                        jComponent2 = booleanScalarComboEditor;
                    } else {
                        jComponent2 = null;
                    }
                } else {
                    jComponent2 = null;
                }
                this.scalarSetters.add(jComponent2);
            } else if (object instanceof IEnumScalar) {
                iEnumScalar = (IEnumScalar)object;
                simpleEnumScalarViewer = new SimpleEnumScalarViewer();
                jComponent = simpleEnumScalarViewer;
                if (iEnumScalar.isWritable()) {
                    enumScalarComboEditor = new EnumScalarComboEditor();
                    enumScalarComboEditor.setFont(this.theFont);
                    enumScalarComboEditor.setBackground(this.getBackground());
                    enumScalarComboEditor.setEnumModel(iEnumScalar);
                    enumScalarComboEditor.setVisible(this.setterVisible);
                    enumScalarComboEditor.setEnabled(this.setterEnabled);
                    jComponent2 = enumScalarComboEditor;
                } else {
                    jComponent2 = null;
                }
                this.scalarSetters.add(jComponent2);
            } else if (object instanceof IDevStateScalar) {
                iDevStateScalar = (IDevStateScalar)object;
                simpleStateViewer = new SimpleStateViewer();
                jComponent = simpleStateViewer;
                if (iDevStateScalar.isWritable()) {
                    devStateScalarComboEditor = new DevStateScalarComboEditor();
                    devStateScalarComboEditor.setFont(this.theFont);
                    devStateScalarComboEditor.setBackground(this.getBackground());
                    devStateScalarComboEditor.setStateModel(iDevStateScalar);
                    devStateScalarComboEditor.setVisible(this.setterVisible);
                    devStateScalarComboEditor.setEnabled(this.setterEnabled);
                    jComponent2 = devStateScalarComboEditor;
                } else {
                    jComponent2 = null;
                }
                this.scalarSetters.add(jComponent2);
            } else {
                simpleScalarViewer = new SimpleScalarViewer();
                serializable = simpleScalarViewer.getMargin();
                ((Insets)serializable).left += 2;
                ((Insets)serializable).right += 2;
                simpleScalarViewer.setMargin((Insets)serializable);
                jComponent = simpleScalarViewer;
                iStringScalar = (IStringScalar)object;
                boolean bl = false;
                if (iStringScalar.getPossibleValues() != null && iStringScalar.getPossibleValues().length > 0) {
                    bl = true;
                }
                if (bl) {
                    stringScalarComboEditor = new StringScalarComboEditor();
                    stringScalarComboEditor.setFont(this.theFont);
                    stringScalarComboEditor.setEnabled(this.setterEnabled);
                    if (iStringScalar.isWritable()) {
                        stringScalarComboEditor.setStringModel(iStringScalar);
                        stringScalarComboEditor.setVisible(this.setterVisible);
                    } else {
                        stringScalarComboEditor.setVisible(false);
                    }
                    this.scalarSetters.add(stringScalarComboEditor);
                    jComponent2 = stringScalarComboEditor;
                } else {
                    stringScalarEditor = new StringScalarEditor();
                    stringScalarEditor.setFont(this.theFont);
                    stringScalarEditor.setEnabled(this.setterEnabled);
                    if (iStringScalar.isWritable()) {
                        stringScalarEditor.setModel(iStringScalar);
                        stringScalarEditor.setVisible(this.setterVisible);
                    } else {
                        stringScalarEditor.setVisible(false);
                    }
                    this.scalarSetters.add(stringScalarEditor);
                    jComponent2 = stringScalarEditor;
                }
            }
            labelViewer = new LabelViewer();
            jButton = new JButton();
            labelViewer.setFont(this.theFont);
            labelViewer.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            labelViewer.setBackground(this.getBackground());
            if (iNumberScalar != null) {
                labelViewer.setModel((IAttribute)iNumberScalar);
            } else if (iStringScalar != null) {
                labelViewer.setModel((IAttribute)iStringScalar);
            } else if (iBooleanScalar != null) {
                labelViewer.setModel((IAttribute)iBooleanScalar);
            } else if (iEnumScalar != null) {
                labelViewer.setModel((IAttribute)iEnumScalar);
            } else if (iDevStateScalar != null) {
                labelViewer.setModel((IAttribute)iDevStateScalar);
            }
            if (simpleScalarViewer != null) {
                if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL)) {
                    simpleScalarViewer.setHasToolTip(true);
                    simpleScalarViewer.setQualityInTooltip(true);
                } else if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                    simpleScalarViewer.setHasToolTip(true);
                    simpleScalarViewer.setQualityInTooltip(false);
                } else {
                    simpleScalarViewer.setHasToolTip(false);
                    simpleScalarViewer.setQualityInTooltip(false);
                }
                simpleScalarViewer.setFont(this.theFont);
                simpleScalarViewer.setUnitVisible(this.unitVisible);
                simpleScalarViewer.setBackgroundColor(this.getBackground());
                if (this.noBorder) {
                    simpleScalarViewer.setBorder(BorderFactory.createEmptyBorder());
                } else {
                    simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                }
                simpleScalarViewer.setAlarmEnabled(true);
                simpleScalarViewer.addTextListener(this);
                if (iNumberScalar != null) {
                    simpleScalarViewer.setModel(iNumberScalar);
                } else {
                    simpleScalarViewer.setModel(iStringScalar);
                }
            } else if (booleanScalarCheckBoxViewer != null) {
                if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL) || this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                    booleanScalarCheckBoxViewer.setHasToolTip(true);
                } else {
                    booleanScalarCheckBoxViewer.setHasToolTip(false);
                }
                booleanScalarCheckBoxViewer.setAttModel(iBooleanScalar);
                booleanScalarCheckBoxViewer.setBackground(this.getBackground());
            } else if (simpleEnumScalarViewer != null) {
                if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL)) {
                    simpleEnumScalarViewer.setHasToolTip(true);
                    simpleEnumScalarViewer.setQualityInTooltip(true);
                } else if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                    simpleEnumScalarViewer.setHasToolTip(true);
                    simpleEnumScalarViewer.setQualityInTooltip(false);
                } else {
                    simpleEnumScalarViewer.setHasToolTip(false);
                    simpleEnumScalarViewer.setQualityInTooltip(false);
                }
                simpleEnumScalarViewer.setFont(this.theFont);
                simpleEnumScalarViewer.setBackgroundColor(this.getBackground());
                simpleEnumScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                simpleEnumScalarViewer.setAlarmEnabled(true);
                simpleEnumScalarViewer.addTextListener(this);
                simpleEnumScalarViewer.setModel(iEnumScalar);
            } else if (simpleStateViewer != null) {
                simpleStateViewer.setFont(this.theFont);
                simpleStateViewer.setText("    ");
                simpleStateViewer.setStateClickable(false);
                simpleStateViewer.setModel(iDevStateScalar);
            }
            jButton.setFont(this.theFont);
            jButton.setBackground(this.getBackground());
            jButton.setText(" ... ");
            jButton.setMargin(new Insets(-3, 0, 3, 0));
            jButton.setToolTipText("Attribute Properties");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScalarListViewer.this.propertyButtonActionPerformed(actionEvent);
                }
            });
            labelViewer.setVisible(this.labelVisible);
            jButton.setVisible(this.propertyButtonVisible);
            if (iNumberScalar != null) {
                iNumberScalar.refresh();
            } else if (iStringScalar != null) {
                iStringScalar.refresh();
            } else if (iBooleanScalar != null) {
                iBooleanScalar.refresh();
            } else if (iEnumScalar != null) {
                iEnumScalar.refresh();
            } else if (iDevStateScalar != null) {
                iDevStateScalar.refresh();
            }
            n3 = 0;
            int n5 = labelViewer.getPreferredSize().height + 4;
            if (n5 > n3) {
                n3 = n5;
            }
            if ((n5 = jComponent.getPreferredSize().height + 4) > n3) {
                n3 = n5;
            }
            if (jComponent2 != null && jComponent2.isVisible() && (n5 = jComponent2.getPreferredSize().height + 4) > n3) {
                n3 = n5;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 6, 2, 1);
            this.add((Component)labelViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            if (jComponent instanceof SimpleStateViewer || jComponent instanceof BooleanScalarCheckBoxViewer) {
                gridBagConstraints.anchor = 17;
            } else {
                gridBagConstraints.fill = 2;
            }
            gridBagConstraints.insets = new Insets(2, 3, 2, 1);
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 1;
            if (jComponent2 != null) {
                if (iNumberScalar != null) {
                    gridBagConstraints.insets = new Insets(1, 3, 1, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iStringScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iBooleanScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iEnumScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iDevStateScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                }
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n;
            gridBagConstraints.insets = new Insets(2, 3, 2, 6);
            this.add((Component)jButton, gridBagConstraints);
            if (iNumberScalar != null) {
                this.listModel.add((IAttribute)iNumberScalar);
            } else if (iStringScalar != null) {
                this.listModel.add((IAttribute)iStringScalar);
            } else if (iBooleanScalar != null) {
                this.listModel.add((IAttribute)iBooleanScalar);
            } else if (iEnumScalar != null) {
                this.listModel.add((IAttribute)iEnumScalar);
            } else if (iDevStateScalar != null) {
                this.listModel.add((IAttribute)iDevStateScalar);
            }
            this.scalarLabels.add(labelViewer);
            this.scalarViewers.add(jComponent);
            this.scalarPropButtons.add(jButton);
            if (jComponent instanceof SimpleScalarViewer) {
                serializable = (SimpleScalarViewer)jComponent;
                n5 = jComponent.getPreferredSize().height;
                n4 = n5 < n3 ? (n3 - n5) / 2 : 0;
                insets = ((JAutoScrolledText)serializable).getMargin();
                insets.top += n4;
                insets.bottom += n4;
                insets.left += 2;
                insets.right += 2;
                ((JAutoScrolledText)serializable).setMargin(insets);
            } else if (jComponent instanceof SimpleEnumScalarViewer) {
                serializable = (SimpleEnumScalarViewer)jComponent;
                n5 = jComponent.getPreferredSize().height;
                n4 = n5 < n3 ? (n3 - n5) / 2 : 0;
                insets = ((JAutoScrolledText)serializable).getMargin();
                insets.top += n4;
                insets.bottom += n4;
                insets.left += 2;
                insets.right += 2;
                ((JAutoScrolledText)serializable).setMargin(insets);
            }
            if (jComponent2 instanceof StringScalarEditor && jComponent2.isVisible()) {
                serializable = (StringScalarEditor)jComponent2;
                n5 = jComponent2.getPreferredSize().height;
                n4 = n5 < n3 ? (n3 - n5) / 2 : 0;
                insets = ((JTextComponent)serializable).getMargin();
                insets.top += n4;
                insets.bottom += n4;
                insets.left += 2;
                insets.right += 2;
                ((JTextComponent)serializable).setMargin(insets);
            }
            ++n;
        }
    }

    private void propertyButtonActionPerformed(ActionEvent actionEvent) {
        int n = -1;
        if (this.scalarPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int n2 = this.scalarPropButtons.size();
        for (int i = 0; i < n2; ++i) {
            try {
                JButton jButton = this.scalarPropButtons.get(i);
                if (!jButton.equals(actionEvent.getSource())) continue;
                n = i;
                break;
            }
            catch (Exception exception) {
                System.out.println("ScalarListViewer : propertyButtonActionPerformed : Caught exception  " + exception.getMessage());
                return;
            }
        }
        if (n < 0) {
            return;
        }
        INumberScalar iNumberScalar = null;
        IStringScalar iStringScalar = null;
        IBooleanScalar iBooleanScalar = null;
        IEnumScalar iEnumScalar = null;
        try {
            IAttribute iAttribute = this.listModel.get(n);
            if (iAttribute instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)iAttribute;
            } else if (iAttribute instanceof IStringScalar) {
                iStringScalar = (IStringScalar)iAttribute;
            } else if (iAttribute instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)iAttribute;
            } else if (iAttribute instanceof IEnumScalar) {
                iEnumScalar = (IEnumScalar)iAttribute;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null && iEnumScalar == null) {
            return;
        }
        if (this.propFrame != null) {
            if (iNumberScalar != null) {
                this.propFrame.setModel((IAttribute)iNumberScalar);
            } else if (iStringScalar != null) {
                this.propFrame.setModel((IAttribute)iStringScalar);
            } else if (iBooleanScalar != null) {
                this.propFrame.setModel((IAttribute)iBooleanScalar);
            } else if (iEnumScalar != null) {
                this.propFrame.setModel((IAttribute)iEnumScalar);
            }
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        ScalarListViewer scalarListViewer = new ScalarListViewer();
        scalarListViewer.setTheFont(new Font("Lucida Bright", 0, 18));
        scalarListViewer.setBooleanSetterType(BOOLEAN_COMBO_SETTER);
        try {
            IAttribute iAttribute = (IAttribute)attributeList.add("sys/tg_test/1/double_scalar");
            iAttribute = (IAttribute)attributeList.add("sys/tg_test/1/string_scalar");
            iAttribute = (IAttribute)attributeList.add("sys/tg_test/1/boolean_scalar");
            iAttribute = (IAttribute)attributeList.add("sys/tg_test/1/short_scalar");
            scalarListViewer.setModel(attributeList);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jFrame.getContentPane().add((Component)scalarListViewer, gridBagConstraints);
        JButton jButton = new JButton();
        jButton.setText("Atk Diagnostic");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jFrame.getContentPane().add((Component)jButton, gridBagConstraints);
        attributeList.startRefresher();
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

